model PROVA_INIT_FILE_2
  ThermoPower.Water.SourceMassFlow sourceMassFlow1(T = 273.15 + 50, allowFlowReversal = false, p0 = 10e5, use_T = true, w0 = 300)  annotation(
    Placement(visible = true, transformation(origin = {-76, 6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  ThermoPower.Water.SinkPressure sinkPressure1(T = 273.15 + 50, allowFlowReversal = false, p0 = 10e5, use_T = true)  annotation(
    Placement(visible = true, transformation(origin = {48, 6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner ThermoPower.System system(allowFlowReversal = false, initOpt = ThermoPower.Choices.Init.Options.fixedState) annotation(
    Placement(visible = true, transformation(origin = {-10, 62}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  ThermoPower.Water.Flow1DFV2ph flow1DFV2ph1(A = 3.14 * 0.3 ^ 2, Dhyd = 2 * 0.3, FFtype = ThermoPower.Choices.Flow1D.FFtypes.NoFriction, FluidPhaseStart = ThermoPower.Choices.FluidPhase.FluidPhases.Liquid, HydraulicCapacitance = ThermoPower.Choices.Flow1D.HCtypes.Middle, L = 10, allowFlowReversal = false, hstartin = 2000e3, hstartout = 2010e3, initOpt = system.initOpt, omega = 1e-3, pstart = 10e5, wnom = 300) annotation(
    Placement(visible = true, transformation(origin = {-10, 6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(flow1DFV2ph1.outfl, sinkPressure1.flange) annotation(
    Line(points = {{0, 6}, {38, 6}}, color = {0, 0, 255}));
  connect(sourceMassFlow1.flange, flow1DFV2ph1.infl) annotation(
    Line(points = {{-66, 6}, {-20, 6}}, color = {0, 0, 255}));
  annotation(
    uses(ThermoPower(version = "3.1")));
    end PROVA_INIT_FILE_2;
