﻿package wbEHPTlib "Electric and Hybrid Power train library Rev March 2017"
  package SupportModels "Useful addtional models"
    extends Modelica.Icons.Package;
    // extends EHPowerTrain.Icons.SupportIcon;

    package MapBasedRelated
      model InertiaTq "Inertia with added torque"
        import SI = Modelica.SIunits;
        Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a "Left flange of shaft" annotation(
          Placement(transformation(extent = {{-110, -10}, {-90, 10}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Interfaces.Flange_b flange_b "Right flange of shaft" annotation(
          Placement(transformation(extent = {{90, -10}, {110, 10}}, rotation = 0)));
        parameter SI.Inertia J(min = 0, start = 1) "Moment of inertia";
        parameter StateSelect stateSelect = StateSelect.default "Priority to use phi and w as states" annotation(
          HideResult = true,
          Dialog(tab = "Advanced"));
        SI.Angle phi(stateSelect = stateSelect) "Absolute rotation angle of component" annotation(
          Dialog(group = "Initialization", showStartAttribute = true));
        SI.AngularVelocity w(stateSelect = stateSelect) "Absolute angular velocity of component (= der(phi))" annotation(
          Dialog(group = "Initialization", showStartAttribute = true));
        SI.AngularAcceleration a "Absolute angular acceleration of component (= der(w))" annotation(
          Dialog(group = "Initialization", showStartAttribute = true));
        Modelica.Blocks.Interfaces.RealInput tau annotation(
          Placement(transformation(extent = {{-20.5, -20}, {20.5, 20}}, rotation = 90, origin = {-54.5, -100})));
      equation
        phi = flange_a.phi;
        phi = flange_b.phi;
        w = der(phi);
        a = der(w);
        J * a = flange_a.tau + flange_b.tau + tau;
        annotation(
          Documentation(info = "<html>
    <p>
    Rotational component with <b>inertia</b> and two rigidly connected flanges.
    </p>

    </HTML>
    "),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics = {Rectangle(extent = {{-100, 10}, {-50, -10}}, lineColor = {0, 0, 0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192, 192, 192}), Rectangle(extent = {{50, 10}, {100, -10}}, lineColor = {0, 0, 0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192, 192, 192}), Line(points = {{-80, -25}, {-60, -25}}, color = {0, 0, 0}), Line(points = {{60, -25}, {80, -25}}, color = {0, 0, 0}), Line(points = {{-70, -25}, {-70, -70}}, color = {0, 0, 0}), Line(points = {{70, -25}, {70, -70}}, color = {0, 0, 0}), Line(points = {{-80, 25}, {-60, 25}}, color = {0, 0, 0}), Line(points = {{60, 25}, {80, 25}}, color = {0, 0, 0}), Line(points = {{-70, 45}, {-70, 25}}, color = {0, 0, 0}), Line(points = {{70, 45}, {70, 25}}, color = {0, 0, 0}), Line(points = {{-70, -70}, {70, -70}}, color = {0, 0, 0}), Rectangle(extent = {{-50, 50}, {50, -50}}, lineColor = {0, 0, 0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192, 192, 192}), Text(extent = {{-150, 100}, {150, 60}}, textString = "%name", lineColor = {0, 0, 255}), Text(extent = {{-150, -80}, {150, -120}}, lineColor = {0, 0, 0}, textString = "J=%J")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics));
      end InertiaTq;

      block EfficiencyT "Determines the electric power from the mechanical considering efficiency map"
        parameter Boolean mapsOnFile = false;
        parameter Modelica.SIunits.Torque tauMax(start = 400) "Maximum machine torque";
        parameter Modelica.SIunits.Power powMax(start = 22000) "Maximum drive power";
        parameter Modelica.SIunits.AngularVelocity wMax(start = 650) "Maximum machine speed";
        parameter String mapsFileName = "NoName" "File where matrix is stored" annotation(
          Dialog(enable = mapsOnFile, loadSelector(filter = "Text files (*.txt)", caption = "Open file in which required tables are")));
        parameter String effTableName = "noName" "name of the on-file maximum torque as a function of speed" annotation(
          Dialog(enable = mapsOnFile));
        parameter Real effTable[:, :] = [0.00, 0.00, 0.25, 0.50, 0.75, 1.00; 0.00, 0.75, 0.80, 0.81, 0.82, 0.83; 0.25, 0.76, 0.81, 0.82, 0.83, 0.84; 0.50, 0.77, 0.82, 0.83, 0.84, 0.85; 0.75, 0.78, 0.83, 0.84, 0.85, 0.87; 1.00, 0.80, 0.84, 0.85, 0.86, 0.88] annotation(
          Dialog(enable = not mapsOnFile));
        //the name is passed because a file can contain efficiency tables for
        //different submodels, e.g. genEfficiency for generator and motEfficiency for motor.
        Modelica.Blocks.Tables.CombiTable2D effTable_(tableOnFile = mapsOnFile, smoothness = Modelica.Blocks.Types.Smoothness.LinearSegments, fileName = mapsFileName, tableName = effTableName, table = effTable) "normalised efficiency" annotation(
          Placement(transformation(extent = {{-14, -14}, {14, 14}}, rotation = 0, origin = {18, -18})));
        Modelica.Blocks.Interfaces.RealInput w annotation(
          Placement(transformation(extent = {{-140, -60}, {-100, -20}}), iconTransformation(extent = {{-140, -60}, {-100, -20}})));
        Modelica.Blocks.Interfaces.RealInput tau annotation(
          Placement(transformation(extent = {{-140, 20}, {-100, 60}}), iconTransformation(extent = {{-140, 20}, {-100, 60}})));
        Modelica.Blocks.Interfaces.RealOutput elePow annotation(
          Placement(transformation(extent = {{96, -10}, {116, 10}})));
        Modelica.Blocks.Math.Abs abs1 annotation(
          Placement(transformation(extent = {{-76, -50}, {-56, -30}})));
        Modelica.Blocks.Math.Abs abs2 annotation(
          Placement(transformation(extent = {{-80, 40}, {-60, 60}})));
        Modelica.Blocks.Math.Gain normalizeTau(k = 1 / tauMax) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-36, 50})));
        wbEHPTlib.SupportModels.MapBasedRelated.Pel applyEta annotation(
          Placement(transformation(extent = {{60, -10}, {84, 12}})));
        Modelica.Blocks.Math.Product PMOT annotation(
          Placement(transformation(extent = {{-72, 0}, {-52, 20}})));
        Modelica.Blocks.Math.Gain normalizeSpeed(k = 1 / wMax) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-34, -40})));
      equation
        connect(tau, abs2.u) annotation(
          Line(points = {{-120, 40}, {-94, 40}, {-94, 50}, {-82, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(w, abs1.u) annotation(
          Line(points = {{-120, -40}, {-78, -40}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(abs2.y, normalizeTau.u) annotation(
          Line(points = {{-59, 50}, {-48, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(normalizeTau.y, effTable_.u1) annotation(
          Line(points = {{-25, 50}, {-7.7, 50}, {-7.7, -9.6}, {1.2, -9.6}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(applyEta.Pel, elePow) annotation(
          Line(points = {{85.2, 1}, {92.48, 1}, {92.48, 0}, {106, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(effTable_.y, applyEta.eta) annotation(
          Line(points = {{33.4, -18}, {46, -18}, {46, -5.6}, {57.6, -5.6}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(PMOT.u1, tau) annotation(
          Line(points = {{-74, 16}, {-84, 16}, {-84, 40}, {-120, 40}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(PMOT.u2, w) annotation(
          Line(points = {{-74, 4}, {-84, 4}, {-84, -40}, {-120, -40}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(PMOT.y, applyEta.P) annotation(
          Line(points = {{-51, 10}, {42, 10}, {42, 7.6}, {57.6, 7.6}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(abs1.y, normalizeSpeed.u) annotation(
          Line(points = {{-55, -40}, {-46, -40}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(normalizeSpeed.y, effTable_.u2) annotation(
          Line(points = {{-23, -40}, {-10, -40}, {-10, -26.4}, {1.2, -26.4}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}})),
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 72}, {100, -72}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-74, -54}, {-74, 58}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-82, -48}, {78, -48}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-74, 38}, {-24, 38}, {-4, 12}, {28, -8}, {60, -22}, {62, -48}}, color = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{-20, 14}, {-40, 24}, {-56, -4}, {-38, -36}, {12, -38}, {26, -28}, {22, -20}, {8, -6}, {-8, 4}, {-20, 14}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-28, 4}, {-38, 2}, {-32, -20}, {0, -32}, {10, -28}, {12, -20}, {-28, 4}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-102, 118}, {100, 78}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Text(extent = {{26, 46}, {76, 4}}, lineColor = {0, 0, 0}, textString = "T")}),
          Documentation(info = "<html>
<p>This block computes the machine and inverter losses from the mechanical input quantities and determines the power to be drawn from the electric circuit. The &QUOT;drawn&QUOT; power can be also a negative numer, meaning that themachine is actually delivering electric power.</p>
<p>The given efficiency map is intended as being built with torques being ratios of actual torques to tauMax and speeds being ratios of w to wMax. In case the user uses, in the given efficiency map, torques in Nm and speeds in rad/s, the block can be used selecting tauTmax=1, wMax=1.</p>
<p>The choice of having normalised efficiency computation allows simulations of machines different in sizes and similar in characteristics to be repeated without having to rebuild the efficiency maps. </p>
<p>Torques are written in the first matrix column, speeds on the first row.</p>
</html>"));
      end EfficiencyT;

      block EfficiencyLF "Determines the electric from the mechanical power considering loss with a formula"
        import wbEHPTlib;
        parameter Modelica.SIunits.Torque tauMax(start = 400) "Maximum machine torque(Nm)";
        parameter Modelica.SIunits.Power powMax(start = 22000) "Maximum drive power";
        parameter Modelica.SIunits.AngularVelocity wMax(start = 650) "Maximum machine speed(rad/s)";
        parameter Real effTable[:, :] = [0.00, 0.00, 0.25, 0.50, 0.75, 1.00; 0.00, 0.75, 0.80, 0.81, 0.82, 0.83; 0.25, 0.76, 0.81, 0.82, 0.83, 0.84; 0.50, 0.77, 0.82, 0.83, 0.84, 0.85; 0.75, 0.78, 0.83, 0.84, 0.85, 0.87; 1.00, 0.80, 0.84, 0.85, 0.86, 0.88];
        Modelica.Blocks.Interfaces.RealInput w annotation(
          Placement(transformation(extent = {{-140, -60}, {-100, -20}}), iconTransformation(extent = {{-140, -60}, {-100, -20}})));
        Modelica.Blocks.Interfaces.RealInput tau annotation(
          Placement(transformation(extent = {{-140, 20}, {-100, 60}}), iconTransformation(extent = {{-140, 20}, {-100, 60}})));
        Modelica.Blocks.Interfaces.RealOutput elePow annotation(
          Placement(transformation(extent = {{96, -10}, {116, 10}})));
        Modelica.Blocks.Math.Abs abs1 annotation(
          Placement(transformation(extent = {{-76, -50}, {-56, -30}})));
        Modelica.Blocks.Math.Abs abs2 annotation(
          Placement(transformation(extent = {{-80, 40}, {-60, 60}})));
        Modelica.Blocks.Math.Gain normalizeTau(k = 1 / tauMax) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-36, 50})));
        Modelica.Blocks.Math.Gain normalizeSpeed(k = 1 / wMax) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-34, -40})));
        wbEHPTlib.SupportModels.MapBasedRelated.AddLossesWT addLosses annotation(
          Placement(transformation(extent = {{10, -10}, {30, 10}})));
      equation
        connect(tau, abs2.u) annotation(
          Line(points = {{-120, 40}, {-94, 40}, {-94, 50}, {-82, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(w, abs1.u) annotation(
          Line(points = {{-120, -40}, {-78, -40}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(abs2.y, normalizeTau.u) annotation(
          Line(points = {{-59, 50}, {-48, 50}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(abs1.y, normalizeSpeed.u) annotation(
          Line(points = {{-55, -40}, {-46, -40}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(addLosses.T, normalizeTau.y) annotation(
          Line(points = {{8.2, 6}, {-18, 6}, {-18, 50}, {-25, 50}}, color = {0, 0, 127}));
        connect(addLosses.W, normalizeSpeed.y) annotation(
          Line(points = {{8.2, -6}, {-18, -6}, {-18, -40}, {-23, -40}}, color = {0, 0, 127}));
        connect(addLosses.y, elePow) annotation(
          Line(points = {{30.6, 0}, {30.6, 0}, {106, 0}}, color = {0, 0, 127}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}})),
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 72}, {100, -72}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-74, -54}, {-74, 58}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-82, -48}, {78, -48}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-74, 38}, {-24, 38}, {-4, 12}, {28, -8}, {60, -22}, {62, -48}}, color = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{-20, 14}, {-40, 24}, {-56, -4}, {-38, -36}, {12, -38}, {26, -28}, {22, -20}, {8, -6}, {-8, 4}, {-20, 14}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-28, 4}, {-38, 2}, {-32, -20}, {0, -32}, {10, -28}, {12, -20}, {-28, 4}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-102, 118}, {100, 78}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Text(extent = {{26, 46}, {76, 4}}, lineColor = {0, 0, 0}, textString = "L")}),
          Documentation(info = "<html>
<p>This block computes the machine and inverter losses from the mechanical input quantities and determines the power to be drawn from the electric circuit. The &QUOT;drawn&QUOT; power can be also a negative numer, meaning that the machine is actually delivering electric power.</p>
<p>The signs ot T and W must be such that their product is positive when mechanical power exits from the machine (electric motor operation)</p>
</html>"));
      end EfficiencyLF;

      block EffiPlot "Utility to plot efficiencies from an effTable"
        import wbEHPTlib;
        parameter Real tauMax(start = 400) "Maximum machine torque(Nm)";
        parameter Real powMax(start = 22000) "Maximum drive power";
        parameter Real wMax(start = 650) "Maximum machine speed(rad/s)";
        parameter Real effTable[:, :] = [0.00, 0.00, 0.25, 0.50, 0.75, 1.00; 0.00, 0.75, 0.80, 0.81, 0.82, 0.83; 0.25, 0.76, 0.81, 0.82, 0.83, 0.84; 0.50, 0.77, 0.82, 0.83, 0.84, 0.85; 0.75, 0.78, 0.83, 0.84, 0.85, 0.87; 1.00, 0.80, 0.84, 0.85, 0.86, 0.88];
        Real tau[size(effs, 1)];
        Real effs[:] = {0.75, 0.775, 0.8, 0.825, 0.85, 0.875};
        Modelica.Blocks.Tables.CombiTable2D effTable_[size(effs, 1)](each tableOnFile = false, each smoothness = Modelica.Blocks.Types.Smoothness.LinearSegments, each table = effTable) "normalised efficiency" annotation(
          Placement(transformation(extent = {{-14, -14}, {14, 14}}, rotation = 0, origin = {-2, 0})));
      equation
        for i in 1:size(effs, 1) loop
          effTable_[i].y = effs[i];
          effTable_[i].u1 = time;
          effTable_[i].u2 = tau[i];
        end for;
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}})),
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 72}, {100, -72}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-74, -54}, {-74, 58}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-82, -48}, {78, -48}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-74, 38}, {-24, 38}, {-4, 12}, {28, -8}, {60, -22}, {62, -48}}, color = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{-20, 14}, {-40, 24}, {-56, -4}, {-38, -36}, {12, -38}, {26, -28}, {22, -20}, {8, -6}, {-8, 4}, {-20, 14}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-28, 4}, {-38, 2}, {-32, -20}, {0, -32}, {10, -28}, {12, -20}, {-28, 4}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-102, 118}, {100, 78}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Text(extent = {{26, 46}, {76, 4}}, lineColor = {0, 0, 0}, textString = "M")}),
          Documentation(info = "<html>
<p>This block computes the machine and inverter losses from the mechanical input quantities and determines the power to be drawn from the electric circuit. The &QUOT;drawn&QUOT; power can be also a negative numer, meaning that themachine is actually delivering electric power.</p>
<p>The given efficiency map is intended as being built with torques being ratios of actual torques to tauMax and speeds being ratios of w to wMax. In case the user uses, in the given efficiency map, torques in Nm and speeds in rad/s, the block can be used selecting tauTmax=1, wMax=1.</p>
<p>The choice of having normalised efficiency computation allows simulations of machines different in sizes and similar in characteristics to be repeated without having to rebuild the efficiency maps. </p>
<p>Torques are written in the first matrix column, speeds on the first row.</p>
</html>"));
      end EffiPlot;

      block EffiPlot2 "Utility to plot efficiencies from an effTable"
        import wbEHPTlib;
        parameter Modelica.SIunits.Torque tauMax(start = 400) "Maximum machine torque(Nm)";
        parameter Modelica.SIunits.Power powMax(start = 22000) "Maximum drive power";
        parameter Modelica.SIunits.AngularVelocity wMax(start = 650) "Maximum machine speed(rad/s)";

        function eff
          input Real A, bT, bS, bP;
          input Real tq "input torque";
          input Real sp "input speed";
          output Real eff;
        protected
          Real pLoss;
        algorithm
          pLoss := A + bT * tq ^ 2 + bS * sp ^ 2 + bP * (tq * sp) ^ 2;
          eff := tq * sp / (tq * sp + pLoss);
        end eff;

        function lossFun
          input Real A, bT, bS, bP;
          input Real tq "input torque";
          input Real sp "input speed";
          output Real pLoss;
        algorithm
          pLoss := A + bT * tq ^ 2 + bS * sp ^ 2 + bP * (tq * sp) ^ 2;
        end lossFun;

        Real tauE[size(effs, 1)];
        Real tauL[size(loss, 1)];
        Real loss[:] = {0.02, 0.04, 0.06, 0.08};
        Real effs[:] = {0.75, 0.8, 0.85, 0.9};
      equation
        for i in 1:size(effs, 1) loop
          effs[i] = eff(0.0005, 0.02, 0.01, 0.025, tauE[i], time);
        end for;
        for i in 1:size(loss, 1) loop
          loss[i] = lossFun(0.0005, 0.02, 0.01, 0.025, tauL[i], time);
        end for;
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}})),
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 72}, {100, -72}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-74, -54}, {-74, 58}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-82, -48}, {78, -48}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-74, 38}, {-24, 38}, {-4, 12}, {28, -8}, {60, -22}, {62, -48}}, color = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{-20, 14}, {-40, 24}, {-56, -4}, {-38, -36}, {12, -38}, {26, -28}, {22, -20}, {8, -6}, {-8, 4}, {-20, 14}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-28, 4}, {-38, 2}, {-32, -20}, {0, -32}, {10, -28}, {12, -20}, {-28, 4}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-102, 118}, {100, 78}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Text(extent = {{26, 46}, {76, 4}}, lineColor = {0, 0, 0}, textString = "M")}),
          Documentation(info = "<html>
<p>Questo modello di ausilio cerca di riprodurre i contour descritti nel file Efficiency.docx.</p>
<p>Nella versione presente ha due difetti fondamentali:</p>
<p>1) non riesce a descrivere curve polidrome a differenza di contour. Questo &egrave; critico in quanto le curve di efficienza sono proprio di questo tipo.</p>
<p>2) non riesce a gestire i casi in cui per un certo vaore della velocit&agrave; non si trova la coppia che da una data perdita. Se ad es. le perdite si cercano a partire da 0.02 dappiako da ecciciency.docx che ha curva delle perdite ha tangente verticale per velocit&agrave; pari a 1.4, ed infatti il modello proposto deve rimanere con 0.02 al di sotto di 1.4, altrimenti non converge.</p>
</html>"),
          experiment(StartTime = 0.1, StopTime = 1.35));
      end EffiPlot2;

      block AddLossesWT "adds drive losses function of W and T"
        parameter Real A = 0.006 "fixed p.u. losses";
        parameter Real bT(unit = "J/(N2.m2)") = 0.1 "torque losses coefficient";
        parameter Real bW(unit = "J/(rad2.s2)") = 0.1 "speed losses coefficient";
        parameter Real bP(unit = "J/W2") = 0.07 "power losses coefficient";
        Modelica.SIunits.Energy losses;
        Modelica.Blocks.Interfaces.RealInput W annotation(
          Placement(transformation(extent = {{-138, -80}, {-98, -40}})));
        Modelica.Blocks.Interfaces.RealOutput y annotation(
          Placement(transformation(extent = {{96, -10}, {116, 10}})));
        Modelica.Blocks.Interfaces.RealInput T annotation(
          Placement(transformation(extent = {{-138, 40}, {-98, 80}})));
      equation
        losses = A + bT * T ^ 2 + bW * W ^ 2 + bP * (T * W) ^ 2;
        y = T * W + losses;
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-20, -22}, {20, -22}, {20, -60}, {40, -60}, {0, -100}, {-40, -60}, {-20, -60}, {-20, -22}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid), Text(extent = {{-100, 75}, {100, 35}}, lineColor = {0, 0, 127}, fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, textString = "%name"), Text(extent = {{-70, 10}, {74, -16}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "W-T")}));
      end AddLossesWT;

      model ConstPg "Constant Power DC Load"
        parameter Real vNom = 100;
        parameter Modelica.SIunits.Time Ti = 0.01 "inner PI follower integral time constant";
        Real v "DC voltage";
        Modelica.Blocks.Math.Feedback feedback1 annotation(
          Placement(visible = true, transformation(origin = {56, -44}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
        Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
          Placement(visible = true, transformation(extent = {{-108, 58}, {-88, 78}}, rotation = 0), iconTransformation(extent = {{-10, 90}, {10, 110}}, rotation = 0)));
        Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
          Placement(visible = true, transformation(extent = {{-108, -74}, {-88, -54}}, rotation = 0), iconTransformation(extent = {{-10, -108}, {10, -88}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealInput Pref "Reference power" annotation(
          Placement(visible = true, transformation(origin = {100, -44}, extent = {{-18, -18}, {18, 18}}, rotation = 180), iconTransformation(origin = {82, 0}, extent = {{-18, -18}, {18, 18}}, rotation = 180)));
        Modelica.Electrical.Analog.Sensors.PowerSensor pSensor annotation(
          Placement(visible = true, transformation(extent = {{-82, 58}, {-62, 78}}, rotation = 0)));
        Modelica.Electrical.Analog.Basic.VariableConductor varCond annotation(
          Placement(visible = true, transformation(origin = {-50, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
        Modelica.Blocks.Continuous.Integrator integrator1(k = 1 / vNom ^ 2 / Ti) annotation(
          Placement(visible = true, transformation(origin = {-2, -44}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
      equation
        connect(integrator1.u, feedback1.y) annotation(
          Line(points = {{10, -44}, {47, -44}}, color = {0, 0, 127}));
        connect(integrator1.y, varCond.G) annotation(
          Line(points = {{-13, -44}, {-28, -44}, {-28, 0}, {-39, 0}}, color = {0, 0, 127}));
        connect(feedback1.u2, pSensor.power) annotation(
          Line(points = {{56, -36}, {56, 42}, {-80, 42}, {-80, 57}}, color = {0, 0, 127}));
        connect(varCond.n, pin_n) annotation(
          Line(points = {{-50, -10}, {-50, -10}, {-50, -64}, {-98, -64}, {-98, -64}}, color = {0, 0, 255}));
        connect(varCond.p, pSensor.nc) annotation(
          Line(points = {{-50, 10}, {-50, 10}, {-50, 68}, {-62, 68}, {-62, 68}}, color = {0, 0, 255}));
        connect(pSensor.pv, pSensor.pc) annotation(
          Line(points = {{-72, 78}, {-82, 78}, {-82, 68}}, color = {0, 0, 255}));
        connect(pSensor.pc, pin_p) annotation(
          Line(points = {{-82, 68}, {-98, 68}}, color = {0, 0, 255}));
        connect(pSensor.nv, pin_n) annotation(
          Line(points = {{-72, 58}, {-72, -64}, {-98, -64}}, color = {0, 0, 255}));
        connect(feedback1.u1, Pref) annotation(
          Line(points = {{64, -44}, {100, -44}}, color = {0, 0, 127}));
        v = pin_p.v - pin_n.v;
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-4, 0}, {70, 0}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{0, 94}, {0, -88}, {-2, -90}}, color = {0, 0, 255}, smooth = Smooth.None), Rectangle(extent = {{-28, 68}, {28, -52}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{42, 58}, {78, 22}}, lineColor = {255, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "P")}),
          Documentation(info = "<html>
    <p>Questo componente simula, mediante inseguimento di un riferimento esterno, un carico a potenza costante.</p>
    <p>I parametri k e T sono i parametri del regolatore PI che insegue l&apos;input. TIpicamente si potr&agrave; utilizzare k=1 e T di un ordine di grandezza pi&ugrave; piccolo delle costanti di tempo del segnale di ingresso di potenza</p>
    </html>"));
      end ConstPg;

      block LimTau "Torque limiter"
        Modelica.Blocks.Interfaces.RealInput w annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}}), iconTransformation(extent = {{-140, -20}, {-100, 20}})));
        Modelica.Blocks.Interfaces.RealOutput yH annotation(
          Placement(transformation(extent = {{100, 50}, {120, 70}})));
        parameter Modelica.SIunits.Power powMax = 50000 "Maximum mechanical power";
        parameter Modelica.SIunits.Torque tauMax = 400 "Maximum torque ";
        parameter Modelica.SIunits.AngularVelocity wMax(min = powMax / tauMax) = 1500 "Maximum speed";
        Integer state "=0 below base speed; =1 before wMax; =2 in w limit, =3 above wMax";
        //0 or 1 if tauMax or powMax is delivered; =2 or 3 if w>wMax
      protected
        parameter Real alpha = 0.10 "fraction of wMax over which the torque is to be brought to zero";
      public
        Modelica.Blocks.Interfaces.RealOutput yL annotation(
          Placement(transformation(extent = {{100, -70}, {120, -50}})));
      algorithm
        if w < powMax / tauMax then
          state := 0;
          yH := tauMax;
        else
          state := 1;
          yH := powMax / w;
        end if;
//over wMax the torque max is to be rapidly brought to zero
        if w > wMax then
          if w < (1 + alpha) * wMax then
            state := 2;
            yH := powMax / wMax * (1 - (w - wMax) / (alpha * wMax));
          else
            state := 3;
            yH := 0;
          end if;
        end if;
        yL := -yH;
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Text(extent = {{-98, 126}, {96, 90}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name
          "), Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-100, 90}, {100, -88}}), Line(points = {{-72, 80}, {-72, -80}}, arrow = {Arrow.Filled, Arrow.None}, arrowSize = 2), Text(lineColor = {0, 0, 255}, extent = {{-98, 54}, {-84, 48}}, textString = "T"), Line(points = {{92, -2}, {-74, -2}}, arrow = {Arrow.Filled, Arrow.None}, arrowSize = 2), Text(lineColor = {0, 0, 255}, extent = {{72, -22}, {86, -28}}, textString = "W"), Line(points = {{-72, 54}, {-12, 54}, {-2, 40}, {16, 26}, {30, 18}, {44, 14}}), Line(points = {{-72, -58}, {-12, -58}, {-2, -44}, {16, -30}, {30, -22}, {42, -18}})}),
          Documentation(info = "<html>
      <p>Gives the maximum output torque as a function of the input speed.</p>
      <p>When w&LT;wMax the output is Tmax if Tmax*w&LT;Pnom, othersise it is Pnom/w</p>
      <p>But if w is over wMax Tmax is rapidly falling to zero (reaches zero when speed overcomes wMax by 10&percnt;).</p>
      <p>Torques and powers are in SI units</p>
      </html>"));
      end LimTau;

      block Pel "Outputs a power signal computed from the given efficiency and input power"
        Modelica.Blocks.Interfaces.RealInput eta "efficiency" annotation(
          Placement(transformation(extent = {{-140, -80}, {-100, -40}}), iconTransformation(extent = {{-140, -80}, {-100, -40}})));
        Modelica.Blocks.Interfaces.RealInput P "Delivered Mechanical Power" annotation(
          Placement(transformation(extent = {{-140, 40}, {-100, 80}}), iconTransformation(extent = {{-140, 40}, {-100, 80}})));
        Modelica.Blocks.Interfaces.RealOutput Pel "Absorbed Electrical power" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}})));
      algorithm
        if noEvent(P <= 0) then
          Pel := P * eta;
        else
          Pel := P / eta;
        end if;
        annotation(
          Icon(graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 127}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-78, 82}, {70, -92}}, lineColor = {0, 0, 127}, fillColor = {170, 255, 255}, fillPattern = FillPattern.Solid, textString = "Pmecc
to
Pel")}),
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics),
          Documentation(info = "<html>
<pre><span style=\"font-family: Courier New,courier;\">Outputs&nbsp;a power signal computed from the&nbsp;given&nbsp;efficiency&nbsp;and&nbsp;input&nbsp;power</span></pre>
</html>"));
      end Pel;
    end MapBasedRelated;

    package Miscellaneous
      block Greater "Output y is true, if input u1 is greater than input u2"
        extends PartialBooleanComparison;
      equation
        y = u1 > u2;
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1), graphics = {Ellipse(lineColor = {0, 0, 127}, extent = {{32, 10}, {52, -10}}, endAngle = 360), Line(points = {{-100, -80}, {42, -80}, {42, 0}}, color = {0, 0, 127}), Line(points = {{-54, 22}, {-8, 2}, {-54, -18}}, thickness = 0.5), Text(origin = {-20, 133}, lineColor = {0, 0, 255}, extent = {{-96, 25}, {122, -19}}, textString = "%name")}),
          Documentation(info = "<html>
<p>
The output is <b>true</b> if Real input u1 is greater than
Real input u2, otherwise the output is <b>false</b>.
</p>
</html>"));
      end Greater;

      partial block PartialBooleanComparison "Partial block with 2 Real input and 1 Boolean output signal (the result of a comparison of the two Real inputs)"
        Modelica.Blocks.Interfaces.RealInput u1 "Connector of first Real input signal" annotation(
          Placement(transformation(extent = {{-140, -20}, {-100, 20}})));
        Modelica.Blocks.Interfaces.RealInput u2 "Connector of second Real input signal" annotation(
          Placement(transformation(extent = {{-140, -100}, {-100, -60}})));
        Modelica.Blocks.Interfaces.BooleanOutput y "Connector of Boolean output signal" annotation(
          Placement(transformation(extent = {{100, -10}, {120, 10}})));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, lineThickness = 0.5, fillColor = {210, 210, 210}, fillPattern = FillPattern.Solid, borderPattern = BorderPattern.Raised), Ellipse(extent = {{73, 7}, {87, -7}}, lineColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillColor = DynamicSelect({235, 235, 235}, if y > 0.5 then {0, 255, 0} else {235, 235, 235}), fillPattern = FillPattern.Solid), Ellipse(extent = {{32, 10}, {52, -10}}, lineColor = {0, 0, 127}), Line(points = {{-100, -80}, {42, -80}, {42, 0}}, color = {0, 0, 127})}),
          Documentation(info = "<html>
<p>
Block has two continuous Real input and one continuous Boolean output signal
as a result of the comparison of the two input signals. The block
has a 3D icon (e.g., used in Blocks.Logical library).
</p>
</html>"));
      end PartialBooleanComparison;

      model DragForce "Vehicle rolling and aerodinamical drag force"
        import Modelica.Constants.g_n;
        extends Modelica.Mechanics.Translational.Interfaces.PartialElementaryOneFlangeAndSupport2;
        extends Modelica.Mechanics.Translational.Interfaces.PartialFriction;
        Modelica.SIunits.Force f "Total drag force";
        Modelica.SIunits.Velocity v "vehicle velocity";
        Modelica.SIunits.Acceleration a "Absolute acceleration of flange";
        Real Sign;
        parameter Modelica.SIunits.Mass m "vehicle mass";
        parameter Modelica.SIunits.Density rho = 1.226 "air density";
        parameter Modelica.SIunits.Area S "vehicle cross area";
        parameter Real fc(start = 0.01) "rolling friction coefficient";
        parameter Real Cx "aerodinamic drag coefficient";
      protected
        parameter Real A = fc * m * g_n;
        parameter Real B = 1 / 2 * rho * S * Cx;
      equation
//  s = flange.s;
        v = der(s);
        a = der(v);
// Le seguenti definizioni seguono l'ordine e le richieste del modello "PartialFriction" di
// Modelica.Mechanics.Translational.Interfaces"
        v_relfric = v;
        a_relfric = a;
        f0 = A "force at 0 speed 0 but with slip";
        f0_max = A "max force at 0 speed without slip";
        free = false "in principle should become true whenthe wheel loose contact with road";
// Now the computation of f, and its attribution to the flange:
        flange.f - f = 0;
// friction force
        if v > 0 then
          Sign = 1;
        else
          Sign = -1;
        end if;
//The following equation equates dragForce to the force applied when looocked)true, otherwise term A.
        f - B * v ^ 2 * Sign = if locked then sa * unitForce else f0 * (if startForward then Modelica.Math.tempInterpol1(v, [0, 1], 2) else if startBackward then -Modelica.Math.tempInterpol1(-v, [0, 1], 2) else if pre(mode) == Forward then Modelica.Math.tempInterpol1(v, [0, 1], 2) else -Modelica.Math.tempInterpol1(-v, [0, 1], 2));
        annotation(
          Documentation(info = "<html>
<p>This component models the total (rolling and aerodynamic) vehicle drag resistance: </p>
<p>F=fc*m*g+(1/2)*rho*Cx*S*v^2 </p>
<p>It models reliably the stuck phase. Based on Modelica-Intrerfaces.PartialFriction model </p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-98, 10}, {22, 10}, {22, 41}, {92, 0}, {22, -41}, {22, -10}, {-98, -10}, {-98, 10}}, lineColor = {0, 127, 0}, fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid), Line(points = {{-42, -50}, {87, -50}}, color = {0, 0, 0}), Polygon(points = {{-72, -50}, {-41, -40}, {-41, -60}, {-72, -50}}, lineColor = {0, 0, 0}, fillColor = {128, 128, 128}, fillPattern = FillPattern.Solid), Line(points = {{-90, -90}, {-70, -88}, {-50, -82}, {-30, -72}, {-10, -58}, {10, -40}, {30, -18}, {50, 8}, {70, 38}, {90, 72}, {110, 110}}, color = {0, 0, 255}, thickness = 0.5), Text(extent = {{-82, 90}, {80, 50}}, lineColor = {0, 0, 255}, textString = "%name")}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics));
      end DragForce;

      block PropDriver "Simple Proportional controller driver"
        parameter String CycleFileName = "cycleName.txt" "Drive Cycle Name ex: \"sort1.txt\"";
        parameter Real k "Controller gain";
        parameter Real yMax = 1.e6 "Max output value (absolute)";
        parameter Modelica.Blocks.Types.Extrapolation extrapolation = Modelica.Blocks.Types.Extrapolation.LastTwoPoints "Extrapolation of data outside the definition range";
        Modelica.Blocks.Interfaces.RealInput V annotation(
          Placement(visible = true, transformation(origin = {0, -66}, extent = {{-14, -14}, {14, 14}}, rotation = 90), iconTransformation(origin = {0, -112}, extent = {{-12, -12}, {12, 12}}, rotation = 90)));
        Modelica.Blocks.Math.UnitConversions.From_kmh from_kmh annotation(
          Placement(visible = true, transformation(extent = {{-42, -10}, {-22, 10}}, rotation = 0)));
        Modelica.Blocks.Sources.CombiTimeTable driveCyc(columns = {2}, extrapolation = extrapolation, fileName = CycleFileName, tableName = "Cycle", tableOnFile = true) annotation(
          Placement(visible = true, transformation(extent = {{-80, -10}, {-60, 10}}, rotation = 0)));
        Modelica.Blocks.Math.Feedback feedback annotation(
          Placement(visible = true, transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0)));
        Modelica.Blocks.Math.Gain gain(k = k) annotation(
          Placement(visible = true, transformation(extent = {{14, -10}, {34, 10}}, rotation = 0)));
        Modelica.Blocks.Nonlinear.Limiter limAcc(uMax = yMax, uMin = 0) annotation(
          Placement(visible = true, transformation(origin = {2, 40}, extent = {{52, -10}, {72, 10}}, rotation = 0)));
        Modelica.Blocks.Nonlinear.Limiter limBrak(uMax = 0, uMin = -yMax) annotation(
          Placement(visible = true, transformation(origin = {0, -40}, extent = {{52, -10}, {72, 10}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput tauRef(unit = "N.m") annotation(
          Placement(visible = true, transformation(extent = {{100, -10}, {120, 10}}, rotation = 0), iconTransformation(extent = {{100, -10}, {120, 10}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput accelTau annotation(
          Placement(visible = true, transformation(origin = {110, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(extent = {{100, 52}, {120, 72}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealOutput brakeTau annotation(
          Placement(visible = true, transformation(origin = {110, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(extent = {{100, -70}, {120, -50}}, rotation = 0)));
      equation
        connect(V, feedback.u2) annotation(
          Line(points = {{0, -66}, {0, -66}, {0, -8}, {0, -8}}, color = {0, 0, 127}));
        connect(from_kmh.u, driveCyc.y[1]) annotation(
          Line(points = {{-44, 0}, {-59, 0}}, color = {0, 0, 127}));
        connect(from_kmh.y, feedback.u1) annotation(
          Line(points = {{-21, 0}, {-8, 0}}, color = {0, 0, 127}));
        connect(feedback.y, gain.u) annotation(
          Line(points = {{9, 0}, {12, 0}}, color = {0, 0, 127}));
        connect(limBrak.y, brakeTau) annotation(
          Line(points = {{73, -40}, {104, -40}, {104, -40}, {110, -40}}, color = {0, 0, 127}));
        connect(limAcc.y, accelTau) annotation(
          Line(points = {{75, 40}, {102, 40}, {102, 40}, {110, 40}}, color = {0, 0, 127}));
        connect(limBrak.u, gain.y) annotation(
          Line(points = {{50, -40}, {40, -40}, {40, 0}, {35, 0}, {35, 0}}, color = {0, 0, 127}));
        connect(limAcc.u, gain.y) annotation(
          Line(points = {{52, 40}, {40, 40}, {40, 0}, {35, 0}, {35, 0}}, color = {0, 0, 127}));
        connect(gain.y, tauRef) annotation(
          Line(points = {{35, 0}, {110, 0}, {110, 0}}, color = {0, 0, 127}));
        annotation(
          Documentation(info = "<html><head></head><body><p>Simple driver model.</p><p>It reads a reference cycle from a file then controls speed with a simple proportional feedback law.</p>
            </body></html>"),
          Icon(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1), graphics = {Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-100, 100}, {100, -100}}), Ellipse(fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, extent = {{-23, 22}, {-12, -4}}, endAngle = 360), Text(origin = {2, -0.1894}, lineColor = {0, 0, 255}, extent = {{-104, 142.189}, {98, 104}}, textString = "%name"), Polygon(fillColor = {215, 215, 215}, pattern = LinePattern.None, fillPattern = FillPattern.Solid, points = {{-22, -60}, {-42, -88}, {-16, -88}, {16, -88}, {-22, -60}}), Polygon(fillColor = {135, 135, 135}, pattern = LinePattern.None, fillPattern = FillPattern.Solid, points = {{-32, 40}, {-62, -52}, {-30, -52}, {-30, -52}, {-32, 40}}, smooth = Smooth.Bezier), Polygon(fillColor = {135, 135, 135}, pattern = LinePattern.None, fillPattern = FillPattern.Solid, points = {{-68, -36}, {-14, -90}, {10, -50}, {0, -50}, {-68, -36}}, smooth = Smooth.Bezier), Polygon(fillColor = {175, 175, 175}, fillPattern = FillPattern.Solid, points = {{-22, 10}, {-30, 6}, {-40, -48}, {2, -46}, {2, -34}, {0, 2}, {-22, 10}}, smooth = Smooth.Bezier), Ellipse(fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, extent = {{-30, 44}, {-3, 10}}, endAngle = 360), Polygon(pattern = LinePattern.None, fillPattern = FillPattern.Solid, points = {{-38, 34}, {-16, 50}, {-2, 36}, {4, 36}, {6, 36}, {-38, 34}}, smooth = Smooth.Bezier), Polygon(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, points = {{30, -44}, {-32, -28}, {-36, -44}, {-24, -58}, {30, -44}}, smooth = Smooth.Bezier), Polygon(fillPattern = FillPattern.Solid, points = {{42, -70}, {36, -84}, {48, -78}, {52, -72}, {50, -68}, {42, -70}}, smooth = Smooth.Bezier), Line(points = {{48, -14}, {26, 0}, {26, 0}}, thickness = 0.5), Line(points = {{20, -10}, {34, 10}, {34, 10}}, thickness = 0.5), Polygon(fillColor = {255, 213, 170}, fillPattern = FillPattern.Solid, points = {{28, 4}, {32, 8}, {28, 2}, {34, 6}, {30, 2}, {34, 4}, {30, 0}, {26, 2}, {34, 0}, {26, 0}, {26, 2}, {28, 4}, {28, 4}, {26, 2}, {26, 2}, {26, 2}, {28, 8}, {28, 6}, {28, 4}}, smooth = Smooth.Bezier), Polygon(fillColor = {175, 175, 175}, fillPattern = FillPattern.Solid, points = {{-18, 0}, {28, 6}, {26, -2}, {-16, -16}, {-20, -16}, {-24, -6}, {-18, 0}}, smooth = Smooth.Bezier), Polygon(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, points = {{72, -6}, {48, -6}, {36, -26}, {58, -86}, {72, -86}, {72, -6}}), Polygon(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, points = {{49, -94}, {17, -40}, {7, -44}, {-1, -50}, {49, -94}}, smooth = Smooth.Bezier), Line(points = {{-7, 31}, {-3, 29}}), Line(points = {{-9, 18}, {-5, 18}}), Line(points = {{-7, 31}, {-3, 31}}), Text(lineColor = {238, 46, 47}, extent = {{-100, 90}, {100, 58}}, textString = "%CycleFileName")}),
          Diagram(coordinateSystem(extent = {{-100, -60}, {100, 60}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2})));
      end PropDriver;

      model Batt1 "Battery model based on one R-C block in its electric circuit"
        parameter Modelica.SIunits.ElectricCharge QCellNom(min = 0) = 10 * 3600.0 "Nominal electric charge" annotation(
          Dialog(tab = "Cell data"));
        parameter Modelica.SIunits.Voltage ECellMin(min = 0) = 3.3 "Minimum open source voltage" annotation(
          Dialog(tab = "Cell data"));
        parameter Modelica.SIunits.Voltage ECellMax(min = 0.0001) = 4.15 "Maximum open source voltage" annotation(
          Dialog(tab = "Cell data"));
        parameter Real SOCMin(min = 0, max = 1) = 0 "Minimum state of charge" annotation(
          Dialog(group = "SOC parameters"));
        parameter Real SOCMax(min = 0, max = 1) = 1 "Maximum state of charge" annotation(
          Dialog(group = "SOC parameters"));
        parameter Real SOCInit(min = 0, max = 1) = 0.5 "Initial state of charge" annotation(
          Dialog(group = "SOC parameters"));
        parameter Modelica.SIunits.Current ICellMax(min = 0) = 10 * QCellNom / 3600.0 "Maximum admissible current" annotation(
          Dialog(tab = "Cell data"));
        parameter Modelica.SIunits.Resistance R0Cell(min = 0) = 0.05 * ECellMax / ICellMax "Serial resistance \"R0\"" annotation(
          Dialog(tab = "Cell data", group = "Electric circuit parameters"));
        parameter Modelica.SIunits.Resistance R1Cell(min = 0) = R0Cell "Serial resistance \"R1\"" annotation(
          Dialog(tab = "Cell data", group = "Electric circuit parameters"));
        parameter Modelica.SIunits.Capacitance C1Cell(min = 0) = 60 / R1Cell "Capacitance in parallel with R1" annotation(
          Dialog(tab = "Cell data", group = "Electric circuit parameters"));
        parameter Real efficiency(min = 0, max = 0.9999) = 0.85 "Overall charging/discharging energy efficiency" annotation(
          Dialog(group = "Parameters related to losses"));
        parameter Modelica.SIunits.Current iCellEfficiency(min = 0) = 0.5 * ICellMax "Charging/discharging current the efficiency refers to" annotation(
          Dialog(group = "Parameters related to losses"));
        parameter Integer ns = 1 "Number of serial connected cells per string" annotation(
          Dialog(tab = "Battery pack data", group = "Size of the package"));
        parameter Integer np = 1 "Number of parallel connected strings" annotation(
          Dialog(tab = "Battery pack data", group = "Size of the package"));
        Modelica.SIunits.Voltage Ubat(start = EBatteryMin + SOCInit * (EBatteryMax - EBatteryMin), fixed = true);
        Modelica.SIunits.Power powerLoss;
        Modelica.Electrical.Analog.Basic.Capacitor cBattery(final C = CBattery) annotation(
          Placement(transformation(origin = {-60, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Electrical.Analog.Basic.Resistor R0(final R = R0Battery) annotation(
          Placement(transformation(origin = {20, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
        Modelica.Electrical.Analog.Sources.SignalCurrent Ip annotation(
          Placement(transformation(origin = {-6, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Electrical.Analog.Interfaces.Pin p annotation(
          Placement(transformation(extent = {{90, 50}, {110, 70}}), iconTransformation(extent = {{90, 50}, {110, 70}})));
        Modelica.Electrical.Analog.Interfaces.NegativePin n annotation(
          Placement(transformation(extent = {{90, -70}, {110, -50}}), iconTransformation(extent = {{91, -70}, {111, -50}})));
        Modelica.Electrical.Analog.Basic.Resistor R1(final R = R1Battery) annotation(
          Placement(transformation(origin = {-37, 74}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
        Modelica.Electrical.Analog.Basic.Capacitor C1(C = C1Battery) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 180, origin = {-37, 50})));
        Modelica.Blocks.Interfaces.RealOutput SOC annotation(
          Placement(visible = true, transformation(origin = {-90, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180), iconTransformation(origin = {-110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
        Modelica.Electrical.Analog.Basic.Capacitor cDummy(C = C1Battery / 10000) annotation(
          Placement(visible = true, transformation(origin = {88, 0}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
      protected
        parameter Real efficiencyMax = (EBatteryMin + EBatteryMax - 2 * Rtot * iCellEfficiency) / (EBatteryMin + EBatteryMax + 2 * Rtot * iCellEfficiency);
        parameter Modelica.SIunits.Capacitance C = QCellNom / (ECellMax - ECellMin) "Cell capacitance";
        // determine fraction of drain current with respect to the total package current
        parameter Real k = ((1 - efficiency) * (EBatteryMax + EBatteryMin) - 2 * (1 + efficiency) * Rtot * iCellEfficiency) / ((1 + efficiency) * (EBatteryMax + EBatteryMin) - 2 * (1 - efficiency) * Rtot * iCellEfficiency);
        parameter Modelica.SIunits.Current IBatteryMax = ICellMax * np "Maximum battery current";
        parameter Modelica.SIunits.Voltage EBatteryMin = ECellMin * ns "Minimum battery voltage";
        parameter Modelica.SIunits.Voltage EBatteryMax = ECellMax * ns "Maximum battery voltage";
        parameter Modelica.SIunits.ElectricCharge QBatteryNominal = QCellNom * np "Battery admissible electric charge";
        parameter Modelica.SIunits.Capacitance CBattery = C * np / ns "Battery capacitance";
        parameter Modelica.SIunits.Resistance R0Battery = R0Cell * ns / np "Serial inner resistance R0 of cell package";
        parameter Modelica.SIunits.Resistance R1Battery = R1Cell * ns / np "Serial inner resistance R1 of cell package";
        parameter Modelica.SIunits.Resistance Rtot = R0Battery + R1Battery;
        parameter Modelica.SIunits.Capacitance C1Battery = C1Cell * np / ns "Battery series inner capacitance C1";
      protected
        Modelica.SIunits.Voltage ECell "Cell e.m.f.";
        Modelica.SIunits.Current iCellStray "Cell stray current";
        Modelica.SIunits.Voltage EBattery(start = EBatteryMin + SOCInit * (EBatteryMax - EBatteryMin), fixed = true) "Battery e.m.f.";
        Modelica.SIunits.Current iBatteryStray "Cell parasitic current";
        Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor annotation(
          Placement(transformation(extent = {{60, 50}, {80, 70}}, rotation = 0)));
        Modelica.Blocks.Math.Gain gain(k = k) annotation(
          Placement(transformation(origin = {52, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
        Modelica.Blocks.Math.Abs abs1 annotation(
          Placement(transformation(extent = {{34, -10}, {14, 10}}, rotation = 0)));
      equation
        connect(cDummy.n, n) annotation(
          Line(points = {{88, -10}, {88, -10}, {88, -60}, {100, -60}, {100, -60}}, color = {0, 0, 255}));
        connect(cDummy.p, currentSensor.n) annotation(
          Line(points = {{88, 10}, {88, 10}, {88, 60}, {80, 60}, {80, 60}}, color = {0, 0, 255}));
        assert(SOCMin >= 0, "SOCMin must be greater than, or equal to 0");
        assert(SOCMax <= 1, "SOCMax must be smaller than, or equal to 1");
        assert(efficiency <= efficiencyMax, "Overall charging/discharging energy efficiency is too big with respect to the actual serial resistance (EfficiencyMax =" + String(efficiencyMax) + ")");
        assert(SOCMin < SOCMax, "SOCMax(=" + String(SOCMax) + ") must be greater than SOCMin(=" + String(SOCMin) + ")");
        assert(SOCInit >= SOCMin, "SOCInit(=" + String(SOCInit) + ") must be greater than, or equal to SOCMin(=" + String(SOCMin) + ")");
        assert(SOCInit <= SOCMax, "SOCInit(=" + String(SOCInit) + ") must be smaller than, or equal to SOCMax(=" + String(SOCMax) + ")");
        iBatteryStray = Ip.i;
        iCellStray = iBatteryStray / np;
        EBattery = cBattery.v;
//Solo per dare maggiore chiarezza all'utente con un nome significativo
        Ubat = p.v - n.v;
        powerLoss = R0.LossPower + R1.LossPower + Ip.v * Ip.i;
        ECell = EBattery / ns;
        assert(abs(p.i / np) < ICellMax, "Battery cell current i=" + String(abs(p.i / np)) + "\n exceeds max admissable ICellMax (=" + String(ICellMax) + "A)");
        SOC = (EBattery - EBatteryMin) / (EBatteryMax - EBatteryMin);
//*(SOCMax-SOCMin)+SOCMin);
        assert(SOC <= SOCMax, "Battery is fully charged: State of charge reached maximum limit (=" + String(SOCMax) + ")");
        assert(SOCMin <= SOC, "Battery is fully discharged: State of charge reached minimum limit (=" + String(SOCMin) + ")");
        connect(R0.p, currentSensor.p) annotation(
          Line(points = {{30, 60}, {60, 60}}, color = {0, 0, 255}));
        connect(Ip.p, R0.n) annotation(
          Line(points = {{-6, 10}, {-6, 60}, {10, 60}}, color = {0, 0, 255}));
        connect(currentSensor.i, gain.u) annotation(
          Line(points = {{70, 50}, {70, -1.46958e-015}, {64, -1.46958e-015}}, color = {0, 0, 127}));
        connect(abs1.u, gain.y) annotation(
          Line(points = {{36, 0}, {39.5, 0}, {39.5, 1.34711e-015}, {41, 1.34711e-015}}, color = {0, 0, 127}));
        connect(abs1.y, Ip.i) annotation(
          Line(points = {{13, 0}, {7, 0}, {7, -1.28588e-015}, {1, -1.28588e-015}}, color = {0, 0, 127}));
        connect(currentSensor.n, p) annotation(
          Line(points = {{80, 60}, {80, 60}, {100, 60}}, color = {0, 0, 255}));
        connect(Ip.n, n) annotation(
          Line(points = {{-6, -10}, {-6, -60}, {100, -60}}, color = {0, 0, 255}));
        connect(n, cBattery.n) annotation(
          Line(points = {{100, -60}, {-60, -60}, {-60, -10}}, color = {0, 0, 255}));
        connect(R1.n, cBattery.p) annotation(
          Line(points = {{-47, 74}, {-60, 74}, {-60, 10}}, color = {0, 0, 255}, smooth = Smooth.None));
        connect(C1.n, cBattery.p) annotation(
          Line(points = {{-47, 50}, {-60, 50}, {-60, 10}}, color = {0, 0, 255}, smooth = Smooth.None));
        connect(R1.p, C1.p) annotation(
          Line(points = {{-27, 74}, {-18, 74}, {-18, 50}, {-27, 50}}, color = {0, 0, 255}, smooth = Smooth.None));
        connect(R1.p, R0.n) annotation(
          Line(points = {{-27, 74}, {-18, 74}, {-18, 60}, {10, 60}}, color = {0, 0, 255}, smooth = Smooth.None));
        annotation(
          Documentation(info = "<html>
<p>Battery model with non-unity coulombic efficiency. </p>
<p>The main cell branch contains an e.m.f. that is linearly increasing with SOC, simulated through an equivalent capacitor, the resistance R0 and a parallel R-C couple. </p>
<p>The full battery is composed by np rows in parallel, each of them containing ns cells in series.</p>
</html>", revisions = "<html><table border=\"1\" rules=\"groups\">
    <thead>
    <tr><td>Version</td>  <td>Date</td>  <td>Comment</td></tr>
    </thead>
    <tbody>
    <tr><td>1.0.0</td>  <td>2006-01-12</td>  <td> </td></tr>
    <tr><td>1.0.3</td>  <td>2006-08-31</td>  <td> Improved assert statements </td></tr>
    <tr><td>1.0.6</td>  <td>2007-05-14</td>  <td> The documentation changed slightly </td></tr>
    </tbody>
    </table>
    </html>"),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics),
          Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(lineColor = {95, 95, 95}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-100, 100}, {78, -100}}), Line(origin = {2, -2}, points = {{-92, 7}, {-56, 7}}, color = {0, 0, 255}), Rectangle(lineColor = {0, 0, 255}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, extent = {{-82, -3}, {-65, -10}}), Line(points = {{-73, 63}, {98, 64}}, color = {0, 0, 255}), Rectangle(lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{38, 69}, {68, 57}}), Rectangle(lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-37.5, 68}, {-6.5, 56}}), Line(points = {{-19.5, 49}, {-19.5, 32}}, color = {0, 0, 255}), Line(points = {{-54.5, 63}, {-54.5, 41}, {-25.5, 41}}, color = {0, 0, 255}), Line(points = {{9.5, 62}, {9.5, 40}, {-19.5, 40}}, color = {0, 0, 255}), Line(points = {{-73, 63}, {-73, 5}}, color = {0, 0, 255}), Line(points = {{-73, -6}, {-73, -60}, {96, -60}}, color = {0, 0, 255}), Line(points = {{26, 63}, {26, -61}}, color = {0, 0, 255}), Line(points = {{-25.5, 49}, {-25.5, 32}}, color = {0, 0, 255}), Polygon(lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, points = {{26, 22}, {14, 4}, {26, -14}, {38, 4}, {26, 22}}), Line(points = {{20, 4}, {32, 4}}, color = {0, 0, 255}), Polygon(lineColor = {0, 0, 255}, points = {{22, -20}, {30, -20}, {26, -32}, {22, -20}}), Text(lineColor = {0, 0, 255}, extent = {{-100, 150}, {100, 110}}, textString = "%name")}));
      end Batt1;

      model Batt1Conn "Battery model based on Batt0 but with electric dynamics order = 1"
        Real powDeliv "battery power (positive when delivered)";
        Real SOC "State Of Charge";
        parameter Modelica.SIunits.ElectricCharge QCellNom(min = 0) = 10 * 3.6e3 "Nominal admissible electric charge per cell" annotation(
          Dialog(tab = "Cell data"));
        parameter Modelica.SIunits.Voltage ECellMin(min = 0) = 3.3 "Minimum open source voltage per cell" annotation(
          Dialog(tab = "Cell data"));
        parameter Modelica.SIunits.Voltage ECellMax(min = 0.0001) = 4.15 "Maximum open source voltage per cell" annotation(
          Dialog(tab = "Cell data"));
        parameter Real SOCMin(min = 0, max = 1) = 0 "Minimum state of charge" annotation(
          Dialog(group = "SOC parameters"));
        parameter Real SOCMax(min = 0, max = 1) = 1 "Maximum state of charge" annotation(
          Dialog(group = "SOC parameters"));
        parameter Real SOCInit(min = 0, max = 1) = 0.5 "Initial state of charge" annotation(
          Dialog(group = "SOC parameters"));
        parameter Modelica.SIunits.Current ICellMax(min = 0) = 10 * QCellNom / 3.6e3 "Maximum admissible current" annotation(
          Dialog(tab = "Cell data"));
        parameter Modelica.SIunits.Resistance R0Cell(min = 0) = 0.05 * ECellMax / ICellMax "Series resistance \"R0\"" annotation(
          Dialog(tab = "Cell data", group = "Electric circuit parameters"));
        parameter Modelica.SIunits.Resistance R1Cell(min = 0) = R0Cell "Series resistance \"R1\"" annotation(
          Dialog(tab = "Cell data", group = "Electric circuit parameters"));
        parameter Modelica.SIunits.Capacitance C1Cell(min = 0) = 60 / R1Cell "Capacitance in parallel with R1" annotation(
          Dialog(tab = "Cell data", group = "Electric circuit parameters"));
        parameter Real efficiency(min = 0, max = 0.9999) = 0.85 "Overall charging/discharging energy efficiency" annotation(
          Dialog(group = "Parameters related to losses"));
        parameter Modelica.SIunits.Current iCellEfficiency(min = 0) = 0.5 * ICellMax "Cell charging/discharging current the efficiency refers to" annotation(
          Dialog(group = "Parameters related to losses"));
        parameter Integer ns = 1 "Number of serial connected cells" annotation(
          Dialog(tab = "Battery Pack data", group = "Size of the package"));
        parameter Integer np = 1 "Number of parallel connected cells" annotation(
          Dialog(tab = "Battery Pack data", group = "Size of the package"));
        // determine fraction of drain current with respect to the total package current
        Modelica.Electrical.Analog.Basic.Capacitor cBattery(final C = CBattery) annotation(
          Placement(transformation(origin = {-60, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Electrical.Analog.Basic.Resistor R0(final R = R0Battery) annotation(
          Placement(transformation(origin = {20, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
        Modelica.Electrical.Analog.Sources.SignalCurrent Ip annotation(
          Placement(transformation(origin = {-6, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Electrical.Analog.Interfaces.Pin p annotation(
          Placement(transformation(extent = {{90, 50}, {110, 70}}), iconTransformation(extent = {{90, 52}, {110, 72}})));
        Modelica.Electrical.Analog.Interfaces.NegativePin n annotation(
          Placement(transformation(extent = {{90, -70}, {110, -50}}), iconTransformation(extent = {{91, -70}, {111, -50}})));
        Modelica.Electrical.Analog.Basic.Capacitor C1(C = C1Battery) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 180, origin = {-37, 50})));
        wbEHPTlib.SupportModels.ConnectorRelated.Conn conn annotation(
          Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {-100, -2})));
        Modelica.Blocks.Sources.RealExpression SOCs(y = SOC) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {-80, 30})));
        Modelica.Blocks.Sources.RealExpression outPow(y = (p.v - n.v) * n.i) annotation(
          Placement(transformation(extent = {{10, -10}, {-10, 10}}, rotation = -90, origin = {-80, -26})));
        Modelica.Electrical.Analog.Basic.Resistor R1(final R = R1Battery) annotation(
          Placement(visible = true, transformation(origin = {-37, 72}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
      protected
        parameter Real k = ((1 - efficiency) * (eBattMax + eBattMin) - 2 * (1 + efficiency) * Rtot * iCellEfficiency) / ((1 + efficiency) * (eBattMax + eBattMin) - 2 * (1 - efficiency) * Rtot * iCellEfficiency);
        parameter Real efficiencyMax = (eBattMin + eBattMax - 2 * Rtot * iCellEfficiency) / (eBattMin + eBattMax + 2 * Rtot * iCellEfficiency);
        final parameter Modelica.SIunits.Capacitance C = QCellNom / (ECellMax - ECellMin) "Cell capacitance";
        parameter Modelica.SIunits.Current IBatteryMax = ICellMax * np "Maximum battery current";
        parameter Modelica.SIunits.Voltage eBattMin = ECellMin * ns "Minimum battery voltage";
        parameter Modelica.SIunits.Voltage eBattMax = ECellMax * ns "Maximum battery voltage";
        parameter Modelica.SIunits.ElectricCharge QBatteryNominal = QCellNom * np "Battery admissible electric charge";
        parameter Modelica.SIunits.Capacitance CBattery = C * np / ns "Battery capacitance";
        parameter Modelica.SIunits.Resistance R0Battery = R0Cell * ns / np "Series inner resistance R0 of cell package";
        parameter Modelica.SIunits.Resistance R1Battery = R1Cell * ns / np "Series inner resistance R1 of cell package";
        parameter Modelica.SIunits.Resistance Rtot = R0Battery + R1Battery;
        parameter Modelica.SIunits.Capacitance C1Battery = C1Cell * np / ns "Battery series inner capacitance C1";
        Modelica.SIunits.Voltage ECell "Cell e.m.f.";
        Modelica.SIunits.Current iCellStray "Cell stray current";
        Modelica.SIunits.Voltage eBatt(start = eBattMin + SOCInit * (eBattMax - eBattMin), fixed = true) "Battery e.m.f.";
        Modelica.SIunits.Current iBatteryStray "Cell parasitic current";
        Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor annotation(
          Placement(transformation(extent = {{70, 50}, {90, 70}}, rotation = 0)));
        Modelica.Blocks.Math.Gain gain(k = k) annotation(
          Placement(transformation(origin = {60, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
        Modelica.Blocks.Math.Abs abs1 annotation(
          Placement(transformation(extent = {{34, -10}, {14, 10}}, rotation = 0)));
      equation
        connect(R1.p, R0.n) annotation(
          Line(points = {{-27, 72}, {-18, 72}, {-18, 60}, {10, 60}}, color = {0, 0, 255}));
        connect(R1.p, C1.p) annotation(
          Line(points = {{-27, 72}, {-18, 72}, {-18, 50}, {-27, 50}}, color = {0, 0, 255}));
        connect(R1.n, cBattery.p) annotation(
          Line(points = {{-47, 72}, {-60, 72}, {-60, 10}}, color = {0, 0, 255}));
        assert(SOCMin >= 0, "SOCMin must be greater than, or equal to 0");
        assert(SOCMax <= 1, "SOCMax must be smaller than, or equal to 1");
        assert(efficiency <= efficiencyMax, "Overall charging/discharging energy efficiency is too big with respect to the actual serial resistance (EfficiencyMax =" + String(efficiencyMax) + ")");
        assert(SOCMin < SOCMax, "SOCMax(=" + String(SOCMax) + ") must be greater than SOCMin(=" + String(SOCMin) + ")");
        assert(SOCInit >= SOCMin, "SOCInit(=" + String(SOCInit) + ") must be greater than, or equal to SOCMin(=" + String(SOCMin) + ")");
        assert(SOCInit <= SOCMax, "SOCInit(=" + String(SOCInit) + ") must be smaller than, or equal to SOCMax(=" + String(SOCMax) + ")");
        iBatteryStray = Ip.i;
        iCellStray = iBatteryStray / np;
        eBatt = cBattery.v;
//Solo per dare maggiore chiarezza all'utente con un nome significativo
        ECell = eBatt / ns;
        powDeliv = (p.v - n.v) * n.i;
        assert(abs(p.i / np) < ICellMax, "Battery cell current i=" + String(abs(p.i / np)) + "\n exceeds max admissable ICellMax (=" + String(ICellMax) + "A)");
        SOC = (eBatt - eBattMin) / (eBattMax - eBattMin);
//*(SOCMax-SOCMin)+SOCMin);
        assert(SOC <= SOCMax, "Battery is fully charged: State of charge reached maximum limit (=" + String(SOCMax) + ")");
        assert(SOCMin <= SOC, "Battery is fully discharged: State of charge reached minimum limit (=" + String(SOCMin) + ")");
        connect(R0.p, currentSensor.p) annotation(
          Line(points = {{30, 60}, {70, 60}}, color = {0, 0, 255}));
        connect(Ip.p, R0.n) annotation(
          Line(points = {{-6, 10}, {-6, 60}, {10, 60}}, color = {0, 0, 255}));
        connect(currentSensor.i, gain.u) annotation(
          Line(points = {{80, 50}, {80, -1.46958e-015}, {72, -1.46958e-015}}, color = {0, 0, 127}));
        connect(abs1.u, gain.y) annotation(
          Line(points = {{36, 0}, {39.5, 0}, {39.5, 1.33227e-015}, {49, 1.33227e-015}}, color = {0, 0, 127}));
        connect(abs1.y, Ip.i) annotation(
          Line(points = {{13, 0}, {7, 0}, {7, -1.28588e-015}, {1, -1.28588e-015}}, color = {0, 0, 127}));
        connect(currentSensor.n, p) annotation(
          Line(points = {{90, 60}, {90, 60}, {100, 60}}, color = {0, 0, 255}));
        connect(Ip.n, n) annotation(
          Line(points = {{-6, -10}, {-6, -60}, {100, -60}}, color = {0, 0, 255}));
        connect(n, cBattery.n) annotation(
          Line(points = {{100, -60}, {-60, -60}, {-60, -10}}, color = {0, 0, 255}));
        connect(C1.n, cBattery.p) annotation(
          Line(points = {{-47, 50}, {-60, 50}, {-60, 10}}, color = {0, 0, 255}, smooth = Smooth.None));
        connect(conn.batSOC, SOCs.y) annotation(
          Line(points = {{-100, -2}, {-100, 8.5}, {-80, 8.5}, {-80, 19}}, color = {255, 204, 51}, thickness = 0.5, smooth = Smooth.None),
          Text(string = "%first", index = -1, extent = {{-6, 3}, {-6, 3}}));
        connect(outPow.y, conn.batPowDel) annotation(
          Line(points = {{-80, -15}, {-80, -2}, {-100, -2}}, color = {0, 0, 127}, smooth = Smooth.None),
          Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
        annotation(
          Documentation(info = "<html>
<p>Battery model with non-unity coulombic efficiency. </p>
<p>The main cell branch contains an e.m.f. that is linearly increasing with SOC, simulated through an equivalent capacitor, the resistance R0 and a parallel R-C couple. </p>
<p>The full battery is composed by np rows in parallel, each of them containing ns cells in series.</p>
<p>It interfaces with monitoring systems tohrough an expandable connector. Output signals:</p>
<p>- state-of-charge &QUOT;batSOC&QUOT;</p>
<p>- outputted power &QUOT;batPowDel&QUOT;.</p>
</html>", revisions = "<html><table border=\"1\" rules=\"groups\">
    <thead>
    <tr><td>Version</td>  <td>Date</td>  <td>Comment</td></tr>
    </thead>
    <tbody>
    <tr><td>1.0.0</td>  <td>2006-01-12</td>  <td> </td></tr>
    <tr><td>1.0.3</td>  <td>2006-08-31</td>  <td> Improved assert statements </td></tr>
    <tr><td>1.0.6</td>  <td>2007-05-14</td>  <td> The documentation changed slightly </td></tr>
    </tbody>
    </table>
    </html>"),
          Diagram(coordinateSystem(extent = {{-100, -80}, {100, 80}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics),
          Icon(coordinateSystem(extent = {{-100, -80}, {100, 80}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(lineColor = {95, 95, 95}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-100, 80}, {80, -82}}), Line(points = {{-92, 6}, {-52, 6}}, color = {0, 0, 255}), Rectangle(lineColor = {0, 0, 255}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, extent = {{-82, -3}, {-65, -10}}), Line(points = {{-73, 63}, {98, 64}}, color = {0, 0, 255}), Rectangle(lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{38, 69}, {68, 57}}), Rectangle(lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-37.5, 68}, {-6.5, 56}}), Line(points = {{-19.5, 49}, {-19.5, 32}}, color = {0, 0, 255}), Line(points = {{-54.5, 63}, {-54.5, 41}, {-25.5, 41}}, color = {0, 0, 255}), Line(points = {{9.5, 62}, {9.5, 40}, {-19.5, 40}}, color = {0, 0, 255}), Line(points = {{-73, 63}, {-73, 5}}, color = {0, 0, 255}), Line(points = {{-73, -6}, {-73, -60}, {96, -60}}, color = {0, 0, 255}), Line(points = {{26, 63}, {26, -61}}, color = {0, 0, 255}), Line(points = {{-25.5, 49}, {-25.5, 32}}, color = {0, 0, 255}), Polygon(lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, points = {{26, 22}, {14, 4}, {26, -14}, {38, 4}, {26, 22}}), Line(points = {{20, 4}, {32, 4}}, color = {0, 0, 255}), Polygon(lineColor = {0, 0, 255}, points = {{22, -20}, {30, -20}, {26, -32}, {22, -20}}), Text(origin = {-4, -22}, lineColor = {0, 0, 255}, extent = {{-100, 150}, {100, 110}}, textString = "%name")}));
      end Batt1Conn;

      model DragForceAngle "Vehicle rolling and aerodinamical drag force"
        import Modelica.Constants.g_n;
        extends Modelica.Mechanics.Translational.Interfaces.PartialElementaryOneFlangeAndSupport2;
        extends Modelica.Mechanics.Translational.Interfaces.PartialFriction;
        parameter Modelica.SIunits.Mass m "vehicle mass";
        parameter Modelica.SIunits.Density rho(start = 1.226) "air density";
        parameter Modelica.SIunits.Area S "vehicle cross area";
        parameter Real fc(start = 0.01) "rolling friction coefficient";
        parameter Real Cx "aerodinamic drag coefficient";
        Modelica.SIunits.Force dragForce "Total drag force";
        Modelica.SIunits.Velocity v "vehicle velocity";
        Modelica.SIunits.Acceleration a "Absolute acceleration of flange";
        parameter String DataFileName = "DataName.txt" "Name of file with angles function of s (rad) ex: \"Angle.txt\"";
        final parameter Real A = fc * m * g_n;
        final parameter Real A1 = m * g_n;
        final parameter Real B = 1 / 2 * rho * S * Cx;
        final parameter Real mu[:, 2] = [0, 1];
        Real angle = sToAngle.y[1], Sign;
        Modelica.SIunits.Length altimetry;
        Real debug = dragForce - B * v ^ 2 * Sign;
        // Constant auxiliary variable
        Modelica.Blocks.Tables.CombiTable1Ds sToAngle(tableOnFile = true, fileName = DataFileName, tableName = "Angle") annotation(
          Placement(transformation(extent = {{28, -10}, {8, 10}})));
      equation
        der(altimetry) = v * sin(sToAngle.y[1]);
// Let us connect the table which determines angles:
        sToAngle.u = flange.s;
//  s = flange.s;
        v = der(s);
        a = der(v);
// Le seguenti definizioni seguono l'ordine e le richieste del modello "PartialFriction" di
// Modelica.Mechanics.Translational.Interfaces"
        v_relfric = v;
        a_relfric = a;
        f0 = A * cos(angle) + A1 * sin(angle) "Friction force for v_relfric=0 and forward sliding";
        f0_max = A "Maximum friction force for v_relfric=0 and locked";
        free = false "true when there is not wheel-road contact (never!)";
// Ora il calcolo di dragForce, e la sua attribuzione alla flangia:
        flange.f - dragForce = 0;
// friction force
        if v > 0 then
          Sign = 1;
        else
          Sign = -1;
        end if;
//La seguente equzione uguaglia la  dragForce alla forza applicata se siamo in locked, altrimenti al termine A
        dragForce - B * v ^ 2 * Sign = if locked then sa * unitForce else f0 * (if startForward then Modelica.Math.Vectors.interpolate(mu[:, 1], mu[:, 2], v) else if startBackward then -Modelica.Math.Vectors.interpolate(mu[:, 1], mu[:, 2], -v) else if pre(mode) == Forward then Modelica.Math.Vectors.interpolate(mu[:, 1], mu[:, 2], v) else -Modelica.Math.Vectors.interpolate(mu[:, 1], mu[:, 2], -v));
        annotation(
          Documentation(info = "<html>
            <p>This component modesl the total (rolling and aerodynamic vehicle drag resistance: </p>
            <p>F=fc*m*g+(1/2)*rho*Cx*S*v^2</p>
            <p>It models reliably the stuck phase. Based on Modelica-Intrerfaces.PartialFriction model</p>
            </html>"),
          Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-98, 10}, {22, 10}, {22, 41}, {92, 0}, {22, -41}, {22, -10}, {-98, -10}, {-98, 10}}, lineColor = {0, 127, 0}, fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid), Line(points = {{-90, -90}, {-70, -88}, {-50, -82}, {-30, -72}, {-10, -58}, {10, -40}, {30, -18}, {50, 8}, {70, 38}, {90, 72}}, color = {0, 0, 255}, thickness = 0.5), Text(extent = {{-82, 90}, {80, 50}}, lineColor = {0, 0, 255}, textString = "%name"), Line(points = {{32, 48}, {-62, -38}, {64, -40}}, color = {238, 46, 47}, thickness = 0.5), Polygon(points = {{-20, 0}, {-8, -10}, {0, -26}, {2, -38}, {-62, -38}, {-20, 0}}, lineColor = {238, 46, 47}, fillColor = {128, 128, 128}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 60}}), graphics = {Text(extent = {{-58, -30}, {68, -48}}, lineColor = {0, 0, 0}, lineThickness = 0.5, fillColor = {128, 128, 128}, fillPattern = FillPattern.Solid, textString = "Connections of sToAngle made internally")}));
      end DragForceAngle;
    end Miscellaneous;

    package ConnectorRelated
      model ToConnIceTauRef "Signal adaptor to send iceTauRef to a connector"
        Modelica.Blocks.Interfaces.RealInput u annotation(
          Placement(transformation(extent = {{-94, -20}, {-54, 20}}), iconTransformation(extent = {{-94, -20}, {-54, 20}})));
        Conn conn annotation(
          Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = -90, origin = {60, 0}), iconTransformation(extent = {{-20, -20}, {20, 20}}, rotation = -90, origin = {60, 0})));
      equation
        connect(u, conn.iceTauRef) annotation(
          Line(points = {{-74, 0}, {60, 0}}, color = {0, 0, 127}, smooth = Smooth.None),
          Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-60, -60}, {60, 60}}), graphics = {Rectangle(extent = {{-60, 40}, {60, -40}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-38, 0}, {30, 0}}, color = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{42, 0}, {22, 8}, {22, -8}, {42, 0}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-60, -60}, {60, 60}}), graphics),
          Documentation(info = "<html>
<p><span style=\"font-family: MS Shell Dlg 2;\">Adapter for an input signal into &QUOT;iceTauRef&QUOT; signal in the library connector.</span></p>
</html>"));
      end ToConnIceTauRef;

      model ToConnGenTauRef "Signal adaptor to send genTauRef to a connector"
        Modelica.Blocks.Interfaces.RealInput u annotation(
          Placement(transformation(extent = {{-90, -20}, {-50, 20}}), iconTransformation(extent = {{-90, -20}, {-50, 20}})));
        Conn conn annotation(
          Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = -90, origin = {58, 0}), iconTransformation(extent = {{-20, -20}, {20, 20}}, rotation = -90, origin = {58, 0})));
      equation
        connect(u, conn.genTauRef) annotation(
          Line(points = {{-70, 0}, {58, 0}}, color = {0, 0, 127}, smooth = Smooth.None),
          Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-60, -60}, {60, 60}}), graphics = {Rectangle(extent = {{-60, 40}, {60, -40}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-40, 0}, {32, 0}}, color = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{42, 0}, {22, 8}, {22, -8}, {42, 0}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-60, -60}, {60, 60}}), graphics),
          Documentation(info = "<html>
<p><span style=\"font-family: MS Shell Dlg 2;\">Adapter for an input signal into &QUOT;genTauRef&QUOT; signal in the library connector.</span></p>
</html>"));
      end ToConnGenTauRef;

      model ToConnIcePowRef "Signal adaptor to send icePowRef to a connector"
        Modelica.Blocks.Interfaces.RealInput u annotation(
          Placement(transformation(extent = {{-94, -20}, {-54, 20}}), iconTransformation(extent = {{-94, -20}, {-54, 20}})));
        Conn conn annotation(
          Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = -90, origin = {60, 0}), iconTransformation(extent = {{-20, -20}, {20, 20}}, rotation = -90, origin = {60, 0})));
      equation
        connect(u, conn.icePowRef) annotation(
          Line(points = {{-74, 0}, {60, 0}, {60, 0}}, color = {0, 0, 127}),
          Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
        annotation(
          Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-60, -60}, {60, 60}}), graphics = {Rectangle(extent = {{-60, 40}, {60, -40}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-38, 0}, {30, 0}}, color = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{42, 0}, {22, 8}, {22, -8}, {42, 0}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid)}),
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-60, -60}, {60, 60}})),
          Documentation(info = "<html>
<p><span style=\"font-family: MS Shell Dlg 2;\">Adapter for an input signal into &QUOT;icePowRef&QUOT; signal in the library connector.</span></p>
</html>"));
      end ToConnIcePowRef;

      expandable connector Conn "Control bus that is adapted to the signals connected to it"
        extends Modelica.Icons.SignalBus;
        annotation(
          Diagram(graphics));
      end Conn;
    end ConnectorRelated;
    annotation(
      Icon(graphics = {Ellipse(extent = {{-36, 40}, {40, -36}}, lineColor = {0, 0, 0}), Line(points = {{4, 82}, {-6, 82}, {-10, 72}, {-24, 68}, {-34, 78}, {-46, 70}, {-42, 58}, {-54, 46}, {-66, 50}, {-74, 36}, {-66, 30}, {-68, 16}, {-78, 12}, {-78, 2}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{4, -78}, {-6, -78}, {-10, -68}, {-24, -64}, {-34, -74}, {-46, -66}, {-42, -54}, {-54, -42}, {-66, -46}, {-74, -32}, {-66, -26}, {-68, -12}, {-78, -8}, {-78, 2}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{2, -78}, {12, -78}, {16, -68}, {30, -64}, {40, -74}, {52, -66}, {48, -54}, {60, -42}, {72, -46}, {80, -32}, {72, -26}, {74, -12}, {84, -8}, {84, 2}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{2, 82}, {12, 82}, {16, 72}, {30, 68}, {40, 78}, {52, 70}, {48, 58}, {60, 46}, {72, 50}, {80, 36}, {72, 30}, {74, 16}, {84, 12}, {84, 2}}, color = {0, 0, 0}, smooth = Smooth.None)}));
  end SupportModels;

  //Symbol to force Dymola to use UTF: €
  //package Propulsion
  extends Modelica.Icons.Package;
  //end Propulsion;

  package MapBased "Contains map-based models of Internal combustion engines and electric drives"
    extends Modelica.Icons.Package;

    class Information
      extends Modelica.Icons.Information;
      annotation(
        Documentation(info = "<html>
<p>The map-based folder contains simple model whose only dynamics is due to their mechanical inertia.</p>
<p>The ice model, since implements an Internal Combustion Engine, can just deliver (never absorb) power, while the other two (&QUOT;oneFlange&QUOT; and &QUOT;twoFlange&QUOT;) simulate electric drive trains, i.e. the assembly of an electric machine and the corresponding AC/DC converter, and therefore can absorb or deliver power.</p>
<p>The input torque of the ice model is in Newton-metres, while in the other cases it is normalised: it is between -1 and +1, where -1 means maximum available torque to be absorbed, +1 to be delivered.</p>
<p>Some of the models have a special &QUOT;Conn&QUOT; version that allows interfacing with the exterior by means of an expandable connector.</p>
<p>Note that usage of expandable connectors requires to give special names to the connector&apos;s variables, and therefore the models are more specific than their Modelica.Blocks.Connectors counterparts. Therefore here the models have receives specifi names such as &QUOT;PsdGenConn&QUOT; as a replacement of OneFlange: this is aone flance component to which we added a connector and spfcific signal names.</p>
<p><br><u>Names and meaning </u>of the pre-defined quantities circulating through the connection bus in the model versions having &QUOT;Conn&QUOT; in their names.</p>
<p>The detailed meaning of different quantities are to be read in the corresponding Table in the accompanying document &QUOT;webBookCeraolo&QUOT; in its section PSD-HEV.</p>
</html>"),
        uses(Modelica(version = "3.2.1")));
    end Information;

    model IceT "Simple  map-based ice model with connector"
      import Modelica.Constants.*;
      extends Partial.PartialIce;
      parameter Modelica.SIunits.AngularVelocity wIceStart = 167;
      // rad/s
      Modelica.Blocks.Interfaces.RealInput tauRef "torque request (positive when motor)" annotation(
        Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {-60, -100}), iconTransformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {-60, -100})));
      Modelica.Blocks.Interfaces.RealOutput fuelCons "Fuel consumption (g/h)" annotation(
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {60, -90})));
      Modelica.Blocks.Nonlinear.Limiter limiter(uMin = 0, uMax = 1e99) annotation(
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {-60, -16})));
      Modelica.Blocks.Math.Min min annotation(
        Placement(transformation(extent = {{-48, 50}, {-28, 70}})));
    equation
      connect(toG_perHour.y, fuelCons) annotation(
        Line(points = {{30, -61}, {30, -61}, {26, -61}, {60, -61}, {60, -90}}, color = {0, 0, 127}, smooth = Smooth.None));
      connect(limiter.u, tauRef) annotation(
        Line(points = {{-60, -28}, {-60, -100}}, color = {0, 0, 127}, smooth = Smooth.None));
      connect(min.u1, toLimTau.y[1]) annotation(
        Line(points = {{-50, 66}, {-58, 66}, {-61, 66}}, color = {0, 0, 127}));
      connect(min.u2, limiter.y) annotation(
        Line(points = {{-50, 54}, {-60, 54}, {-60, -5}}, color = {0, 0, 127}));
      connect(min.y, Tice.tau) annotation(
        Line(points = {{-27, 60}, {-21.5, 60}, {-14, 60}}, color = {0, 0, 127}));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}})),
        experiment(StopTime = 200, __Dymola_NumberOfIntervals = 1000, __Dymola_Algorithm = "Lsodar"),
        __Dymola_experimentSetupOutput,
        Documentation(info = "<html>
<p>This model belongs to the map-based models of power train components.</p>
<p>It models an Internal Combustion Engine, neglecting any dynamics except that related with its rotor inertia.</p>
<p>The input signal is the torque request (Nm). </p>
<p>The generated torque is the minimum between this signal (negative values are transformed to 0) and the maximum deliverable torque at the actual engine speed, defined by means of a table.</p>
<p>From the generated torque and speed the fuel consumption is computed.</p>
<p>Compare ICE input tau and internal Tice.tau.</p>
</html>"),
        Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Text(extent = {{-100, -44}, {-22, -72}}, lineColor = {0, 0, 127}, textString = "Nm")}));
    end IceT;

    model IceT01 "Simple  map-based ice model with connector"
      import Modelica.Constants.*;
      extends Partial.PartialIce(toLimTau(table = maxIceTau, tableOnFile = tablesOnFile, tableName = "maxIceTau", fileName = mapsFileName), toSpecCons(tableOnFile = tablesOnFile, fileName = mapsFileName, tableName = "specificCons"));
      parameter Modelica.SIunits.AngularVelocity wIceStart = 167;
      Modelica.Blocks.Interfaces.RealInput nTauRef "normalized torque request" annotation(
        Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {-60, -100}), iconTransformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {-60, -100})));
      Modelica.Blocks.Interfaces.RealOutput fuelCons "Fuel consumption (g/h)" annotation(
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {60, -90})));
      Modelica.Blocks.Nonlinear.Limiter limiter(uMin = 0, uMax = 1) annotation(
        Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {-60, -16})));
      Modelica.Blocks.Math.Product product annotation(
        Placement(transformation(extent = {{-48, 50}, {-28, 70}})));
    equation
      connect(toG_perHour.y, fuelCons) annotation(
        Line(points = {{30, -61}, {30, -62}, {30, -62}, {30, -62}, {30, -70}, {60, -70}, {60, -90}}, color = {0, 0, 127}, smooth = Smooth.None));
      connect(limiter.u, nTauRef) annotation(
        Line(points = {{-60, -28}, {-60, -100}}, color = {0, 0, 127}, smooth = Smooth.None));
      connect(Tice.tau, product.y) annotation(
        Line(points = {{-14, 60}, {-27, 60}}, color = {0, 0, 127}));
      connect(product.u2, limiter.y) annotation(
        Line(points = {{-50, 54}, {-60, 54}, {-60, 52}, {-60, -5}}, color = {0, 0, 127}));
      connect(product.u1, toLimTau.y[1]) annotation(
        Line(points = {{-50, 66}, {-58, 66}, {-58, 66}, {-61, 66}}, color = {0, 0, 127}));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}})),
        experiment(StopTime = 200, __Dymola_NumberOfIntervals = 1000, __Dymola_Algorithm = "Lsodar"),
        __Dymola_experimentSetupOutput,
        Documentation(info = "<html>
<p>This model belongs to the map-based models of power train components.</p>
<p>It models an Internal Combustion Engine, neglecting any dynamics except that related with its rotor inertia.</p>
<p>The input signal is a normalised request (0..1). </p>
<p>The generated torque is the product of the maximum deliverable torque at the actual engine speed, defined by means of a table, and the normalised input signal</p>
<p>From the generated torque and speed the fuel consumption is computed.</p>
</html>"),
        Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Text(extent = {{-100, -40}, {-20, -70}}, lineColor = {0, 0, 127}, textString = "0..1")}));
    end IceT01;

    model OneFlange "Simple map-based model of an electric drive"
      extends Partial.PartialOneFlange;
      Modelica.Blocks.Interfaces.RealInput tauRef "(positive when motor peration)" annotation(
        Placement(visible = true, transformation(origin = {-118, -66}, extent = {{-18, -18}, {18, 18}}, rotation = 0), iconTransformation(origin = {-114, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
    equation
      connect(variableLimiter.u, tauRef) annotation(
        Line(points = {{-2, 30}, {14, 30}, {14, -66}, {-118, -66}}, color = {0, 0, 127}));
      annotation(
        Documentation(info = "<html>
<p>This is a model that models an electric drive: electornic converter + electric machine.</p>
<p>The only model dynamics is its inertia. </p>
<p>The input signal is a torque request (Nm). The requested torque is applied to a mechanical inertia. </p>
<p>The maximum available torque is internally computed considering a direct torque maximum (tauMax) and a power maximum (powMax) </p>
<p>The model then computes the inner losses and absorbs the total power from the DC input.</p>
<p>Note that to evaluate the inner losses the model uses an efficiency map (i.e. a table), in which torques are ratios of actual torques to tauMax and speeds are ratios of w to wMax. Because of this wMax must be supplied as a parameter.</p>
</html>"),
        Diagram(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1)),
        Icon(coordinateSystem(extent = {{-100, -80}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1)));
    end OneFlange;

    model TwoFlange "Simple map-based two-flange electric drive model"
      extends Partial.PartialTwoFlange;
      Modelica.Blocks.Interfaces.RealInput tauRef annotation(
        Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {0, -114}), iconTransformation(extent = {{-20, -20}, {20, 20}}, rotation = 90, origin = {0, -92})));
    equation
      connect(tauRef, limTau.tau) annotation(
        Line(points = {{0, -114}, {0, -114}, {0, -60}, {0, -58}, {-60, -58}, {-60, -9.6}, {-54.2, -9.6}}, color = {0, 0, 127}));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
        Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-100, 10}, {-66, -10}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{66, 8}, {100, -12}}), Rectangle(origin = {-25, 2}, extent = {{-75, 74}, {125, -74}}), Line(origin = {20, -2}, points = {{-60, 94}, {-60, 76}}, color = {0, 0, 255}), Line(origin = {-20, -2}, points = {{60, 94}, {60, 76}}, color = {0, 0, 255})}),
        Documentation(info = "<html>
<p>This is a model that models an electric drive: electornic converter + electric machine.</p>
<p>The only model dynamics is its inertia. </p>
<p>The input signal is a torque request (Nm). The requested torque is applied to a mechanical inertia. </p>
<p><span style=\"font-family: MS Shell Dlg 2;\">The model receives from the input connector the torque request and tries to &QUOT;deliver&QUOT; it. Delivering means adding a torque to the system so that the torque exiting from flange B equals the one entering from flange A plus the one requested from the input connector.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">This simulates a two-flange electrical machine, where the added torque is the torque produced by the machine magnetic field stator-rotor interaction.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">However, before delivering the requested torque, the model limits it considering the maximum deliverable torque and power. In addition, it computes and considers inner losses as determined by means of a map. </span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">The maximum available torque is internally computed considering a direct torque maximum (tauMax) and a power maximum (powMax) </span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">The requested torque is applied to a mechancal inertia. The inertia is interfaced by means of two flanges with the exterior.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">The model then computes the inner losses and absorbs the total power from the DC input.</span></p>
</html>"));
    end TwoFlange;

    model TwoFlangeConn "Simple map-based two-flange electric drive model"
      import wbEHPTlib;
      extends wbEHPTlib.MapBased.Partial.PartialTwoFlange;
      SupportModels.ConnectorRelated.Conn conn1 annotation(
        Placement(visible = true, transformation(extent = {{-112, -58}, {-72, -98}}, rotation = 0), iconTransformation(extent = {{-112, -58}, {-72, -98}}, rotation = 0)));
    equation
      connect(outBPow_.power, conn1.motPowDelB) annotation(
        Line(points = {{64, 39}, {64, -78}, {-92, -78}, {-92, -78}}, color = {0, 0, 127}, smooth = Smooth.None),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
      connect(speedRing.w, conn1.motW) annotation(
        Line(points = {{-80, 29}, {-86, 29}, {-86, 28}, {-92, 28}, {-92, -78}}, color = {0, 0, 127}, smooth = Smooth.None),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
      connect(add.y, conn1.motPowDelAB) annotation(
        Line(points = {{32, -1}, {32, -22}, {78, -22}, {78, -78}, {-92, -78}}, color = {0, 0, 127}, smooth = Smooth.None),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
      connect(torqueLimiter.u, conn1.motTauRef) annotation(
        Line(points = {{-18, 2}, {-26, 2}, {-26, -56}, {-92, -56}, {-92, -78}}, color = {0, 0, 127}),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
        Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-100, 10}, {-66, -10}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{66, 8}, {100, -12}}), Rectangle(origin = {-25, 2}, extent = {{-75, 74}, {125, -74}}), Line(origin = {20, -2}, points = {{-60, 94}, {-60, 76}}, color = {0, 0, 255}), Line(origin = {-20, -2}, points = {{60, 94}, {60, 76}}, color = {0, 0, 255})}),
        Documentation(info = "<html>
<p><b><span style=\"font-family: MS Shell Dlg 2;\">Simple map-based ICE model for power-split power trains - with connector</b> </span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">This is a &QUOT;connector&QUOT; version of MBice.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">For a general descritiption see the info of MBice.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">Signals connected to the connector:</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- icePowRef (input) is the power request (W). Negative values are internally converted to zero</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- iceW (output) is the measured ICE speed (rad/s)</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- icePowDel (output) delivered power (W)</span></p>
</html>"));
    end TwoFlangeConn;

    model Genset "GenSet GMS+GEN+SEngine"
      import Modelica.Constants.inf;
      import Modelica.Constants.pi;
      parameter Modelica.SIunits.Time OptiTime "Time parameter of the PI OptiSpeed controller";
      parameter String mapsFileName = "maps.txt" "Name of the file containing data maps (names: maxIceTau, specificCons, optiSpeed)";
      parameter Modelica.SIunits.AngularVelocity wIceStart = 167;
      parameter Modelica.SIunits.AngularVelocity maxGenW = 1e6;
      parameter Modelica.SIunits.Torque maxTau = 200 "Max mechanical torque";
      parameter Modelica.SIunits.Power maxPow = 20e3 "Max mechanical power";
      Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor annotation(
        Placement(transformation(extent = {{-8, -8}, {8, 8}}, rotation = 180, origin = {-24, -20})));
      Modelica.Mechanics.Rotational.Sensors.PowerSensor IcePow annotation(
        Placement(transformation(extent = {{24, -2}, {42, 16}})));
      Modelica.Blocks.Interfaces.RealInput powRef(unit = "W") "Reference genset power" annotation(
        Placement(transformation(extent = {{15, -15}, {-15, 15}}, rotation = 90, origin = {61, 115})));
      Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
        Placement(transformation(extent = {{90, 50}, {110, 70}})));
      Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
        Placement(transformation(extent = {{92, -70}, {112, -50}})));
      Modelica.Blocks.Nonlinear.Limiter limiter(uMax = inf, uMin = 0) annotation(
        Placement(transformation(extent = {{10, -10}, {-10, 10}}, rotation = 90, origin = {-80, 54})));
      ECUs.GMS myGMS(mapsFileName = mapsFileName) annotation(
        Placement(transformation(extent = {{-70, 10}, {-50, 30}})));
      OneFlange gen(wMax = maxGenW, mapsFileName = mapsFileName, mapsOnFile = true, powMax = maxPow, tauMax = maxTau, effTableName = "gensetDriveEffTable") annotation(
        Placement(transformation(extent = {{68, 16}, {48, -4}})));
      IceT01 mBiceT(tablesOnFile = true, mapsFileName = mapsFileName, wIceStart = wIceStart) annotation(
        Placement(transformation(extent = {{-34, -2}, {-14, 18}})));
      Modelica.Blocks.Math.Gain gain(k = -1) annotation(
        Placement(transformation(extent = {{-14, 30}, {6, 50}})));
      Modelica.Blocks.Math.Gain gain1(k = 1) annotation(
        Placement(visible = true, transformation(origin = {-60, -8}, extent = {{-6, -6}, {6, 6}}, rotation = 90)));
      Modelica.Blocks.Continuous.Integrator toGrams(k = 1 / 3600) annotation(
        Placement(transformation(extent = {{18, -42}, {38, -22}})));
    equation
      connect(gain1.u, speedSensor.w) annotation(
        Line(points = {{-60, -15.2}, {-60, -20}, {-32.8, -20}}, color = {0, 0, 127}));
      connect(myGMS.Wmecc, gain1.y) annotation(
        Line(points = {{-59.9, 8.5}, {-60, 8.5}, {-60, -1.4}}, color = {0, 0, 127}));
      connect(limiter.u, powRef) annotation(
        Line(points = {{-80, 66}, {-80, 80}, {61, 80}, {61, 115}}, color = {0, 0, 127}, smooth = Smooth.None));
      connect(limiter.y, myGMS.pRef) annotation(
        Line(points = {{-80, 43}, {-80, 20}, {-72, 20}}, color = {0, 0, 127}, smooth = Smooth.None));
      connect(IcePow.flange_b, gen.flange_a) annotation(
        Line(points = {{42, 7}, {46, 7}, {46, 7.11111}, {48, 7.11111}}, color = {0, 0, 0}));
      connect(gen.pin_n, pin_p) annotation(
        Line(points = {{68, 11.5556}, {80, 11.5556}, {80, 60}, {100, 60}}, color = {0, 0, 255}));
      connect(gen.pin_p, pin_n) annotation(
        Line(points = {{68, 2.66667}, {78, 2.66667}, {78, -60}, {102, -60}}, color = {0, 0, 255}));
      connect(mBiceT.nTauRef, myGMS.throttle) annotation(
        Line(points = {{-30, -2}, {-30, -6}, {-49, -6}, {-49, 14}}, color = {0, 0, 127}));
      connect(IcePow.flange_a, mBiceT.flange_a) annotation(
        Line(points = {{24, 7}, {6, 7}, {6, 10}, {-14, 10}}, color = {0, 0, 0}));
      connect(speedSensor.flange, mBiceT.flange_a) annotation(
        Line(points = {{-16, -20}, {-6, -20}, {-6, 10}, {-14, 10}}, color = {0, 0, 0}));
      connect(gain.u, myGMS.tRef) annotation(
        Line(points = {{-16, 40}, {-40, 40}, {-40, 26}, {-49, 26}}, color = {0, 0, 127}));
      connect(gain.y, gen.tauRef) annotation(
        Line(points = {{7, 40}, {69.4, 40}, {69.4, 7.11111}}, color = {0, 0, 127}));
      connect(toGrams.u, mBiceT.fuelCons) annotation(
        Line(points = {{16, -32}, {12, -32}, {8, -32}, {8, -6}, {-18, -6}, {-18, -1}}, color = {0, 0, 127}));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -60}, {100, 100}})),
        experiment(StopTime = 20, Interval = 0.01),
        experimentSetupOutput,
        Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-98, 94}, {78, 68}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-20, 0}, {26, -14}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-44, 30}, {-14, -44}}), Line(points = {{-72, 30}, {-72, 6}}), Polygon(points = {{-72, -2}, {-78, 8}, {-66, 8}, {-72, -2}}), Rectangle(extent = {{-96, 38}, {-50, -48}}), Rectangle(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, extent = {{-96, -6}, {-50, -24}}), Rectangle(fillColor = {135, 135, 135}, fillPattern = FillPattern.Solid, extent = {{-78, -24}, {-68, -44}}), Polygon(points = {{-72, 34}, {-78, 24}, {-66, 24}, {-72, 34}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{6, 30}, {62, -44}}), Line(points = {{94, 60}, {74, 60}, {74, 18}, {62, 18}}, color = {0, 0, 255}), Line(points = {{100, -60}, {74, -60}, {74, -28}, {62, -28}}, color = {0, 0, 255})}),
        Documentation(info = "<html>
<p>Generator set containing Internal Combustion Engine, Electric generator (with DC output), and the related control.</p>
<p>The control logic tends to deliver at the DC port the input power, using the optimal generator speed.</p>
</html>"));
    end Genset;

    model GensetOO "GenSet GMS+GEN+SEngine with On/Off"
      import Modelica.Constants.inf;
      import Modelica.Constants.pi;
      parameter Real gsRatio = 2 "IdealGear speed reduction factor";
      parameter Boolean mapsOnFile = false;
      parameter String mapsFileName = "maps.txt" "Name of the file containing data maps (names: maxIceTau, specificCons, optiSpeed)";
      parameter Modelica.SIunits.Torque iceTauMaxReq = 1e4 "Maximum torque ems requests from ICE";
      parameter Modelica.SIunits.Torque maxGensetTau = 200 "Max mechanical torque";
      parameter Modelica.SIunits.Power maxPow = 20e3 "Max mechanical power";
      parameter Modelica.SIunits.AngularVelocity maxGenW = 1e6;
      parameter Real maxIceTau[:, :] = [0, 80; 100, 80; 350, 95; 500, 95] "First column: speed, 2nd column: torque" annotation(
        Dialog(enable = not mapsOnFile));
      parameter Real specConsumption[:, :] = [0.0, 100, 200, 300, 400, 500; 10, 630, 580, 550, 580, 630; 20, 430, 420, 400, 400, 450; 30, 320, 325, 330, 340, 350; 40, 285, 285, 288, 290, 300; 50, 270, 265, 265, 270, 275; 60, 255, 248, 250, 255, 258; 70, 245, 237, 238, 243, 246; 80, 245, 230, 233, 237, 240; 90, 235, 230, 228, 233, 235] "first row: speed, 1st column: torque, body: sp. consumption" annotation(
        Dialog(enable = not mapsOnFile));
      parameter Real optiTable[:, :] = [0, 800; 20000, 850; 40000, 1100; 60000, 1250; 80000, 1280; 100000, 1340; 120000, 1400; 140000, 1650; 160000, 2130] "first row: speed, 1st column: torque, body: sp. consumption" annotation(
        Dialog(enable = not mapsOnFile));
      parameter Modelica.SIunits.AngularVelocity wIceStart = 300;
      Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor annotation(
        Placement(visible = true, transformation(origin = {-26, -40}, extent = {{-8, -8}, {8, 8}}, rotation = 180)));
      Modelica.Mechanics.Rotational.Components.IdealGear idealGear(ratio = gsRatio) annotation(
        Placement(visible = true, transformation(extent = {{0, -18}, {18, 0}}, rotation = 0)));
      Modelica.Blocks.Interfaces.BooleanInput ON "when true engine is ON" annotation(
        Placement(visible = true, transformation(origin = {-55, 69}, extent = {{15, -15}, {-15, 15}}, rotation = 90), iconTransformation(origin = {-60, 116}, extent = {{15, -15}, {-15, 15}}, rotation = 90)));
      Modelica.Mechanics.Rotational.Sensors.PowerSensor IcePow annotation(
        Placement(visible = true, transformation(extent = {{22, -18}, {40, 0}}, rotation = 0)));
      Modelica.Blocks.Interfaces.RealInput powRef(unit = "W") "Reference genset power" annotation(
        Placement(visible = true, transformation(origin = {59, 71}, extent = {{15, -15}, {-15, 15}}, rotation = 90), iconTransformation(extent = {{15, -15}, {-15, 15}}, rotation = 90, origin = {60, 116})));
      Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
        Placement(visible = true, transformation(extent = {{88, 30}, {108, 50}}, rotation = 0), iconTransformation(extent = {{90, 50}, {110, 70}}, rotation = 0)));
      Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
        Placement(visible = true, transformation(extent = {{88, -50}, {108, -30}}, rotation = 0), iconTransformation(extent = {{92, -70}, {112, -50}}, rotation = 0)));
      Modelica.Blocks.Nonlinear.Limiter limiter(uMax = inf, uMin = 0) annotation(
        Placement(visible = true, transformation(origin = {-82, 36}, extent = {{10, -10}, {-10, 10}}, rotation = 90)));
      ECUs.GMSoo gms(tauMax = iceTauMaxReq, mapsFileName = mapsFileName, throttlePerWerr = 0.1, tablesOnFile = true) annotation(
        Placement(visible = true, transformation(extent = {{-72, -10}, {-52, 10}}, rotation = 0)));
      OneFlange gen(wMax = maxGenW, mapsFileName = mapsFileName, mapsOnFile = true, powMax = maxPow, tauMax = maxGensetTau, effTableName = "gensetDriveEffTable") annotation(
        Placement(visible = true, transformation(extent = {{68, 2}, {48, -18}}, rotation = 0)));
      IceT01 mbIce(wIceStart = wIceStart, mapsFileName = mapsFileName, iceJ = 10, tablesOnFile = true) annotation(
        Placement(visible = true, transformation(extent = {{-36, -22}, {-16, -2}}, rotation = 0)));
      Modelica.Blocks.Math.Gain revGain(k = -0.9 * gsRatio) annotation(
        Placement(visible = true, transformation(extent = {{-10, 10}, {10, 30}}, rotation = 0)));
      Modelica.Blocks.Continuous.Integrator toGrams(k = 1 / 3600) annotation(
        Placement(transformation(extent = {{18, -48}, {38, -28}})));
    equation
      connect(revGain.y, gen.tauRef) annotation(
        Line(points = {{11, 20}, {69.4, 20}, {69.4, -6.88889}}, color = {0, 0, 127}));
      connect(gen.pin_p, pin_n) annotation(
        Line(points = {{68, -11.3333}, {76, -11.3333}, {76, -40}, {98, -40}}, color = {0, 0, 255}));
      connect(gen.pin_n, pin_p) annotation(
        Line(points = {{68, -2.44444}, {78, -2.44444}, {78, 40}, {98, 40}}, color = {0, 0, 255}));
      connect(IcePow.flange_b, gen.flange_a) annotation(
        Line(points = {{40, -9}, {44, -9}, {44, -8.88889}, {45.875, -8.88889}, {45.875, -6.88889}, {48, -6.88889}}));
      connect(IcePow.flange_a, idealGear.flange_b) annotation(
        Line(points = {{22, -9}, {18, -9}}));
      connect(revGain.u, gms.tRef) annotation(
        Line(points = {{-12, 20}, {-38, 20}, {-38, 6}, {-51, 6}}, color = {0, 0, 127}));
      connect(mbIce.flange_a, idealGear.flange_a) annotation(
        Line(points = {{-16, -10}, {-12, -10}, {-6, -10}, {-6, -9}, {0, -9}}));
      connect(mbIce.nTauRef, gms.throttle) annotation(
        Line(points = {{-32, -22}, {-32, -26}, {-51, -26}, {-51, -6}}, color = {0, 0, 127}));
      connect(ON, gms.on) annotation(
        Line(points = {{-55, 69}, {-55, 18}, {-73.8, 18}, {-73.8, 6}}, color = {255, 0, 255}));
      connect(limiter.y, gms.pRef) annotation(
        Line(points = {{-82, 25}, {-82, 0}, {-74, 0}}, color = {0, 0, 127}));
      connect(speedSensor.w, gms.Wmecc) annotation(
        Line(points = {{-34.8, -40}, {-61.9, -40}, {-61.9, -11.5}}, color = {0, 0, 127}));
      connect(limiter.u, powRef) annotation(
        Line(points = {{-82, 48}, {-82, 52}, {59, 52}, {59, 71}}, color = {0, 0, 127}));
      connect(speedSensor.flange, idealGear.flange_a) annotation(
        Line(points = {{-18, -40}, {-6, -40}, {-6, -9}, {0, -9}}));
      connect(toGrams.u, mbIce.fuelCons) annotation(
        Line(points = {{16, -38}, {2, -38}, {2, -30}, {-20, -30}, {-20, -21}}, color = {0, 0, 127}));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -60}, {100, 60}})),
        experiment(StopTime = 20, Interval = 0.01),
        experimentSetupOutput,
        Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-98, 94}, {78, 68}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-20, 0}, {26, -14}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-44, 30}, {-14, -44}}), Line(points = {{-72, 30}, {-72, 6}}), Polygon(points = {{-72, -2}, {-78, 8}, {-66, 8}, {-72, -2}}), Rectangle(extent = {{-96, 38}, {-50, -48}}), Rectangle(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, extent = {{-96, -6}, {-50, -24}}), Rectangle(fillColor = {135, 135, 135}, fillPattern = FillPattern.Solid, extent = {{-78, -24}, {-68, -44}}), Polygon(points = {{-72, 34}, {-78, 24}, {-66, 24}, {-72, 34}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{6, 30}, {62, -44}}), Line(points = {{94, 60}, {74, 60}, {74, 18}, {62, 18}}, color = {0, 0, 255}), Line(points = {{100, -60}, {74, -60}, {74, -28}, {62, -28}}, color = {0, 0, 255})}),
        Documentation(info = "<html>
<p>Generator set containing Internal Combustion Engine, Electric generator (with DC output), and the related control.</p>
<p>The control logic tends to deliver at the DC port the input power, using the optimal generator speed.</p>
<p>In addition, it switches ON or OFF depending on the input boolean control signal.</p>
</html>"),
        __OpenModelica_commandLineOptions = "");
    end GensetOO;

    model IceConnPOO "Simple map-based ice model with connector; follows power request with ON-OFF"
      extends Partial.PartialIceP(toGramsPerkWh(fileName = mapsFileName));
      import Modelica.Constants.*;
      // rad/s
      parameter String mapsFileName = "maps.txt" "Name of the file containing data maps (names: maxIceTau, specificCons, optiSpeed)";
      SupportModels.ConnectorRelated.Conn conn annotation(
        Placement(visible = true, transformation(extent = {{-20, -78}, {20, -118}}, rotation = 0), iconTransformation(extent = {{-20, -78}, {20, -118}}, rotation = 0)));
      Modelica.Blocks.Continuous.Integrator tokgFuel(k = 1 / 3.6e6) annotation(
        Placement(visible = true, transformation(origin = {38, -76}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
      Modelica.Blocks.Logical.Switch switch1 annotation(
        Placement(visible = true, transformation(origin = {2, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      Modelica.Blocks.Sources.Constant zero(k = 0) annotation(
        Placement(visible = true, transformation(extent = {{-46, -74}, {-26, -54}}, rotation = 0)));
      Modelica.Blocks.Math.Product toG_perHour annotation(
        Placement(visible = true, transformation(origin = {38, -42}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
    equation
      connect(toG_perHour.u1, toGramsPerkWh.y) annotation(
        Line(points = {{44, -30}, {42, -30}, {42, -13}, {42, -13}}, color = {0, 0, 127}));
      connect(switch1.y, toG_perHour.u2) annotation(
        Line(points = {{13, -46}, {20, -46}, {20, -22}, {32, -22}, {32, -30}, {32, -30}}, color = {0, 0, 127}));
      connect(toG_perHour.y, tokgFuel.u) annotation(
        Line(points = {{38, -53}, {38, -53}, {38, -64}, {38, -64}}, color = {0, 0, 127}));
      connect(tokW.y, switch1.u1) annotation(
        Line(points = {{-18, -29}, {-18, -29}, {-18, -38}, {-10, -38}, {-10, -38}}, color = {0, 0, 127}));
      connect(switch1.u3, zero.y) annotation(
        Line(points = {{-10, -54}, {-18.5, -54}, {-18.5, -64}, {-25, -64}}, color = {0, 0, 127}));
      connect(switch1.u2, conn.iceON) annotation(
        Line(points = {{-10, -46}, {-60, -46}, {-60, -82}, {0, -82}, {0, -98}}, color = {255, 0, 255}));
      connect(feedback.u1, conn.icePowRef) annotation(
        Line(points = {{-88, 52}, {-88, 52}, {-88, -98}, {0, -98}}, color = {0, 0, 127}),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
      connect(Pice.power, conn.icePowDel) annotation(
        Line(points = {{68, 63}, {68, 63}, {68, 6}, {78, 6}, {78, -98}, {0, -98}}, color = {0, 0, 127}),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
      connect(w.w, conn.iceW) annotation(
        Line(points = {{58, 25}, {58, 25}, {58, 6}, {58, -98}, {0, -98}}, color = {0, 0, 127}),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1, extent = {{-100, -100}, {100, 100}})),
        experiment(StopTime = 200, __Dymola_NumberOfIntervals = 1000, __Dymola_Algorithm = "Lsodar"),
        __Dymola_experimentSetupOutput,
        Documentation(info = "<html>
<p><b><span style=\"font-family: MS Shell Dlg 2;\">Simple map-based ICE model for power-split power trains - with connector</span></b> </p>
<p><span style=\"font-family: MS Shell Dlg 2;\">This is an evolution of IceConnP: ON/OFF control is added though an hysteresis block. </span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">For its general operation see the description of IceConnP.</span></p>
</html>"),
        Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Text(origin = {34, -1}, lineColor = {255, 255, 255}, extent = {{32, -19}, {-48, 29}}, textString = "OO")}));
    end IceConnPOO;

    model OneFlangeConn "Simple map-based one-flange electric drive"
      extends Partial.PartialOneFlange;
      SupportModels.ConnectorRelated.Conn conn annotation(
        Placement(visible = true, transformation(extent = {{-18, -62}, {22, -102}}, rotation = 0), iconTransformation(extent = {{80, -58}, {120, -98}}, rotation = 0)));
      Modelica.Blocks.Sources.RealExpression mechPow(y = powSensor.power) annotation(
        Placement(transformation(extent = {{38, -56}, {18, -36}})));
    equation
      connect(wSensor.w, conn.genW) annotation(
        Line(points = {{78, 35.2}, {78, -72}, {2, -72}, {2, -82}}, color = {0, 0, 127}, smooth = Smooth.None),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
      connect(mechPow.y, conn.genPowDel) annotation(
        Line(points = {{17, -46}, {2, -46}, {2, -82}}, color = {0, 0, 127}),
        Text(string = "%second", index = 1, extent = {{-6, 3}, {-6, 3}}, horizontalAlignment = TextAlignment.Right));
      connect(variableLimiter.u, conn.genTauRef) annotation(
        Line(points = {{-2, 30}, {6, 30}, {6, -32}, {2, -32}, {2, -82}}, color = {0, 0, 127}),
        Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}, horizontalAlignment = TextAlignment.Left));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2})),
        Icon(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2})),
        Documentation(info = "<html>
<p>The input signal is interpreted as a <u>normalised</u> torque request (0 means null torque, 1 maximum availabile torque).</p>
<p>The maximum available torque is internally computed considering a direct torque maximum (tauMax) and a power maximum (powMax) </p>
<p>The requested torque is applied to a mechancal inertia. The inertia is interfaced by means ot two flanges with the exterior.</p>
<p>The model then computes the inner losses and absorbs the total power from the DC input.</p>
<p><br><u>Signals connected to the bus connecto</u>r (the names are chosen from the examples FullVehicles.PSecu1 and PSecu2 where the one-flange machine is called &QUOT;gen&QUOT;):</p>
<p>- genTauRef (input) is the torque request (Nm)</p>
<p>- genPowDel (output) is the delivered mechanical power (W)</p>
<p>- genTauLim (output) maximum available torque at the given machine rotational speed (Nm)</p>
</html>"));
    end OneFlangeConn;

    package Partial
      partial model PartialTwoFlange "Simple map-based two-flange electric drive model"
        parameter Modelica.SIunits.Power powMax = 50000 "Maximum Mechanical drive power";
        parameter Modelica.SIunits.Torque tauMax = 400 "Maximum drive Torque";
        parameter Modelica.SIunits.AngularVelocity wMax = 650 "Maximum drive speed";
        parameter Modelica.SIunits.MomentOfInertia J = 0.59 "Moment of Inertia";
        parameter Boolean mapsOnFile = false "= true, if tables are taken from a txt file";
        parameter String mapsFileName = "noName" "File where matrix is stored" annotation(
          Dialog(enable = mapsOnFile, loadSelector(filter = "Text files (*.txt)", caption = "Open file in which required tables are")));
        parameter String effTableName = "noName" "Name of the on-file maximum torque as a function of speed" annotation(
          Dialog(enable = mapsOnFile));
        parameter Real effTable[:, :] = [0,0,1;0,1,1;1,1,1] annotation(
          Dialog(enable = not mapsOnFile));
        SupportModels.MapBasedRelated.LimTau limTau(tauMax = tauMax, wMax = wMax, powMax = powMax) annotation(
          Placement(transformation(extent = {{-58, -8}, {-36, 14}})));
        SupportModels.MapBasedRelated.InertiaTq inertia(w(displayUnit = "rad/s", start = 0), J = J) annotation(
          Placement(transformation(extent = {{8, 40}, {28, 60}})));
        Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedRing annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 270, origin = {-80, 40})));
        SupportModels.MapBasedRelated.EfficiencyT effMap(tauMax = tauMax, wMax = wMax, powMax = powMax, mapsOnFile = mapsOnFile, mapsFileName = mapsFileName, effTableName = effTableName, effTable = effTable) annotation(
          Placement(transformation(extent = {{20, -46}, {40, -26}})));
        SupportModels.MapBasedRelated.ConstPg constPDC annotation(
          Placement(transformation(extent = {{-10, 10}, {10, -10}}, rotation = -90, origin = {0, 100})));
        Modelica.Mechanics.Rotational.Sensors.PowerSensor outBPow_ annotation(
          Placement(transformation(extent = {{62, 40}, {82, 60}})));
        Modelica.Mechanics.Rotational.Sensors.PowerSensor outAPow_ annotation(
          Placement(transformation(extent = {{-18, 40}, {-38, 60}})));
        Modelica.Blocks.Math.Add add annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {32, 10})));
        Modelica.Mechanics.Rotational.Interfaces.Flange_b flange_b "Right flange of shaft" annotation(
          Placement(visible = true, transformation(extent = {{90, 40}, {110, 60}}, rotation = 0), iconTransformation(extent = {{90, -12}, {110, 8}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a "Left flange of shaft" annotation(
          Placement(visible = true, transformation(extent = {{-110, 40}, {-90, 60}}, rotation = 0), iconTransformation(extent = {{-110, -10}, {-90, 10}}, rotation = 0)));
        Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
          Placement(visible = true, transformation(extent = {{-70, 90}, {-50, 110}}, rotation = 0), iconTransformation(extent = {{-50, 88}, {-30, 108}}, rotation = 0)));
        Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
          Placement(visible = true, transformation(extent = {{30, 90}, {50, 110}}, rotation = 0), iconTransformation(extent = {{30, 90}, {50, 110}}, rotation = 0)));
        Modelica.Blocks.Nonlinear.VariableLimiter torqueLimiter annotation(
          Placement(transformation(extent = {{-16, -8}, {4, 12}})));
      equation
        connect(flange_a, speedRing.flange) annotation(
          Line(points = {{-100, 50}, {-80, 50}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(effMap.w, speedRing.w) annotation(
          Line(points = {{18, -40}, {-80, -40}, {-80, 29}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(pin_p, constPDC.pin_p) annotation(
          Line(points = {{-60, 100}, {-10, 100}}, color = {0, 0, 255}, smooth = Smooth.None));
        connect(pin_n, constPDC.pin_n) annotation(
          Line(points = {{40, 100}, {9.8, 100}}, color = {0, 0, 255}, smooth = Smooth.None));
        connect(effMap.elePow, constPDC.Pref) annotation(
          Line(points = {{40.6, -36}, {52, -36}, {52, 80}, {0, 80}, {0, 91.8}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(flange_b, outBPow_.flange_b) annotation(
          Line(points = {{100, 50}, {82, 50}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(inertia.flange_b, outBPow_.flange_a) annotation(
          Line(points = {{28, 50}, {62, 50}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(inertia.flange_a, outAPow_.flange_a) annotation(
          Line(points = {{8, 50}, {-18, 50}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(outAPow_.flange_b, speedRing.flange) annotation(
          Line(points = {{-38, 50}, {-80, 50}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(add.u1, outBPow_.power) annotation(
          Line(points = {{38, 22}, {38, 28}, {64, 28}, {64, 39}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(add.u2, outAPow_.power) annotation(
          Line(points = {{26, 22}, {26, 28}, {-20, 28}, {-20, 39}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(torqueLimiter.limit1, limTau.yH) annotation(
          Line(points = {{-18, 10}, {-28, 10}, {-28, 9.6}, {-34.9, 9.6}}, color = {0, 0, 127}));
        connect(torqueLimiter.limit2, limTau.yL) annotation(
          Line(points = {{-18, -6}, {-28, -6}, {-28, -3.6}, {-34.9, -3.6}}, color = {0, 0, 127}));
        connect(torqueLimiter.y, inertia.tau) annotation(
          Line(points = {{5, 2}, {12.55, 2}, {12.55, 40}}, color = {0, 0, 127}));
        connect(effMap.tau, torqueLimiter.y) annotation(
          Line(points = {{18, -32}, {12, -32}, {12, 2}, {5, 2}}, color = {0, 0, 127}));
        connect(limTau.w, speedRing.w) annotation(
          Line(points = {{-60.2, 3}, {-80, 3}, {-80, 29}}, color = {0, 0, 127}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
          Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(origin = {-25, 2}, extent = {{-75, 74}, {125, -74}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(origin = {4, -6}, lineColor = {0, 0, 255}, extent = {{-110, 84}, {100, 44}}, textString = "%name"), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-64, 38}, {64, -42}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-100, 10}, {-64, -10}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{64, 8}, {100, -12}}), Line(origin = {20, 0}, points = {{-60, 94}, {-60, 76}}, color = {0, 0, 255}), Line(origin = {-20, 0}, points = {{60, 94}, {60, 76}}, color = {0, 0, 255}), Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-58, 14}, {58, -18}}), Text(origin = {-0.07637, 48.3161}, extent = {{-51.9236, -36.3161}, {48.0764, -66.3161}}, textString = "J=%J")}),
          Documentation(info = "<html>
<p>This model receives from the connector the torque request (variable MotTauInt) and trieds to deliver it.</p>
<p>Howeve,r before delivering the requested torque, the model limits it considering the maximum deliverable torque and power. In addition it computes and considers inner losses as determined by means of a map. </p>
</html>"));
      end PartialTwoFlange;

      partial model PartialIce "Simple  map-based Internal Combustion Engine model"
        import Modelica.Constants.*;
        parameter Modelica.SIunits.AngularVelocity wIceStart = 167;
        // rad/s
        parameter Modelica.SIunits.MomentOfInertia iceJ = 0.5 "ICE moment of inertia";
        parameter Boolean tablesOnFile = false "= true, if tables are got from a file";
        parameter String mapsFileName = "NoName" "File where matrix is stored" annotation(
          Dialog(enable = tablesOnFile, loadSelector(filter = "Text files (*.txt)", caption = "Open file in which required tables are")));
        parameter Real maxIceTau[:, :] = [0, 80; 100, 80; 350, 95; 500, 95] "First column: speed (rad/s); first column: maximum ICE torque (Nm)" annotation(
          Dialog(enable = not tablesOnFile));
        Modelica.Mechanics.Rotational.Sensors.SpeedSensor w annotation(
          Placement(visible = true, transformation(origin = {52, 44}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a annotation(
          Placement(visible = true, transformation(extent = {{90, 10}, {110, 30}}, rotation = 0), iconTransformation(extent = {{90, 10}, {110, 30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sensors.PowerSensor icePow annotation(
          Placement(visible = true, transformation(extent = {{66, 50}, {86, 70}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque Tice annotation(
          Placement(visible = true, transformation(extent = {{-12, 50}, {8, 70}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia ICE(w(fixed = true, start = wIceStart, displayUnit = "rpm"), J = iceJ) annotation(
          Placement(visible = true, transformation(extent = {{16, 50}, {36, 70}}, rotation = 0)));
        Modelica.Blocks.Math.Product toPowW annotation(
          Placement(visible = true, transformation(origin = {0, 12}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
        Modelica.Blocks.Math.Product toG_perHour annotation(
          Placement(visible = true, transformation(origin = {30, -50}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
        //  Modelica.Blocks.Continuous.Integrator toGrams(k = 1 / 3600000.0)
        // annotation(Placement(visible = true, transformation(origin = {26, -44},
        //extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Blocks.Tables.CombiTable1D toLimTau(table = maxIceTau) annotation(
          Placement(visible = true, transformation(origin = {-72, 66}, extent = {{10, -10}, {-10, 10}}, rotation = 180)));
        Modelica.Blocks.Sources.RealExpression rotorW(y = w.w) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {-88, 36})));
        Modelica.Blocks.Math.Gain tokW(k = 1e-3) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {0, -18})));
        Modelica.Blocks.Tables.CombiTable2D toSpecCons(tableOnFile = true, fileName = "PSDmaps.txt", tableName = "specificCons") annotation(
          Placement(transformation(extent = {{-10, 10}, {10, -10}}, rotation = -90, origin = {40, 0})));
      equation
        connect(toPowW.u1, w.w) annotation(
          Line(points = {{6, 24}, {6, 33}, {52, 33}}, color = {0, 0, 127}));
        connect(w.flange, ICE.flange_b) annotation(
          Line(points = {{52, 54}, {52, 60}, {36, 60}}));
        connect(icePow.flange_a, ICE.flange_b) annotation(
          Line(points = {{66, 60}, {36, 60}}));
        connect(Tice.flange, ICE.flange_a) annotation(
          Line(points = {{8, 60}, {16, 60}}));
        connect(icePow.flange_b, flange_a) annotation(
          Line(points = {{86, 60}, {94, 60}, {94, 20}, {100, 20}}));
        connect(toLimTau.u[1], rotorW.y) annotation(
          Line(points = {{-84, 66}, {-88, 66}, {-88, 47}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(toPowW.y, tokW.u) annotation(
          Line(points = {{-2.22045e-015, 1}, {-2.22045e-015, -2}, {2.22045e-015, -2}, {2.22045e-015, -6}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(toSpecCons.y, toG_perHour.u1) annotation(
          Line(points = {{40, -11}, {40, -24}, {36, -24}, {36, -38}}, color = {0, 0, 127}));
        connect(toG_perHour.u2, tokW.y) annotation(
          Line(points = {{24, -38}, {24, -32}, {0, -32}, {0, -29}}, color = {0, 0, 127}));
        connect(toSpecCons.u2, w.w) annotation(
          Line(points = {{46, 12}, {46, 28}, {52, 28}, {52, 33}}, color = {0, 0, 127}));
        connect(toSpecCons.u1, Tice.tau) annotation(
          Line(points = {{34, 12}, {34, 12}, {34, 38}, {34, 42}, {-22, 42}, {-22, 60}, {-14, 60}}, color = {0, 0, 127}));
        connect(toPowW.u2, Tice.tau) annotation(
          Line(points = {{-6, 24}, {-6, 42}, {-22, 42}, {-22, 60}, {-14, 60}}, color = {0, 0, 127}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}})),
          experiment(StopTime = 200, __Dymola_NumberOfIntervals = 1000, __Dymola_Algorithm = "Lsodar"),
          __Dymola_experimentSetupOutput,
          Documentation(info = "<html>
<h4>Basic map-based ICE model.</h4>
<p>It receives as input the reference torque as a fracton of the maximum deliverable torque at a given speed. It can be approximately thought as a signal proportional to the vehicle&apos;s accelerator pedal position.</p>
<p>The generated torque is the minimum between this signal and the maximum deliverable torque at the actual engine speed (defined by means of a table).</p>
<p>From the generated torque and speed the fuel consumption is computed.</p>
<p>The used maxTorque (toLimTau) and specific fuel consumption (toSpecCons) maps are inspired to public data related to the Toyota Prius&apos; engine </p>
</html>"),
          Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(extent = {{-100, 80}, {100, -80}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-24, 68}, {76, -24}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{76, 30}, {100, 10}}), Text(origin = {0, 30}, lineColor = {0, 0, 255}, extent = {{-140, 100}, {140, 60}}, textString = "%name"), Rectangle(extent = {{-90, 68}, {-32, -26}}), Rectangle(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, extent = {{-90, 22}, {-32, 0}}), Line(points = {{-60, 56}, {-60, 32}}), Polygon(points = {{-60, 66}, {-66, 56}, {-54, 56}, {-60, 66}}), Polygon(points = {{-60, 24}, {-66, 34}, {-54, 34}, {-60, 24}}), Rectangle(fillColor = {135, 135, 135}, fillPattern = FillPattern.Solid, extent = {{-64, 0}, {-54, -20}})}));
      end PartialIce;

      partial model PartialOneFlange2 "Partial map-based one-Flange electric drive model"
        parameter Real powMax = 22000 "Maximum drive power  (W)";
        parameter Real tauMax = 80 "Maximum drive torque (Nm)";
        parameter Real wMax(min = powMax / tauMax) = 3000 "Maximum drive speed (rad/s)";
        parameter Real J = 0.25 "Rotor's moment of inertia (kg.m^2)";
        parameter String mapsFileName "maps.txtName of the txt file where models' maps are stored";
        parameter String effMapName "Name of the efficiency map in mapsFileName";
        //the name is passed because a file can contain efficiency tables for
        //different submodels, e.g. genEfficiency for generator and motEfficiency for motor.
        Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a "Left flange of shaft" annotation(
          Placement(transformation(extent = {{90, -10}, {110, 10}}, rotation = 0), iconTransformation(extent = {{90, -10}, {110, 10}})));
        Modelica.Mechanics.Rotational.Sensors.SpeedSensor wSensor annotation(
          Placement(visible = true, transformation(origin = {80, -2}, extent = {{8, -8}, {-8, 8}}, rotation = 90)));
        Modelica.Blocks.Math.Abs abs1 annotation(
          Placement(transformation(extent = {{60, -30}, {40, -10}})));
        SupportModels.MapBasedRelated.TauLim limTau(tauMax = tauMax, powMax = powMax) annotation(
          Placement(transformation(extent = {{6, -32}, {-14, -10}})));
        SupportModels.MapBasedRelated.EfficiencyT toElePow(tauMax = tauMax, wMax = wMax, powMax = powMax, mapsFileName = mapsFileName, effMapName = effMapName) annotation(
          Placement(transformation(extent = {{10, -10}, {-10, 10}}, rotation = 0, origin = {-40, -54})));
        Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
          Placement(visible = true, transformation(extent = {{-110, 50}, {-90, 70}}, rotation = 0), iconTransformation(extent = {{-110, 50}, {-90, 70}}, rotation = 0)));
        Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
          Placement(visible = true, transformation(origin = {-100, -58}, extent = {{10, -10}, {-10, 10}}, rotation = 0), iconTransformation(origin = {-100, -58}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia(J = J) annotation(
          Placement(transformation(extent = {{22, 10}, {42, 30}})));
        Modelica.Mechanics.Rotational.Sources.Torque torque annotation(
          Placement(transformation(extent = {{-16, 10}, {4, 30}})));
        Modelica.Blocks.Math.Gain gain(k = 1) annotation(
          Placement(transformation(extent = {{10, -10}, {-10, 10}}, rotation = 0, origin = {-64, 0})));
        Modelica.Mechanics.Rotational.Sensors.PowerSensor powSensor annotation(
          Placement(transformation(extent = {{50, 10}, {70, 30}})));
        SupportModels.MapBasedRelated.ConstPg constPg annotation(
          Placement(transformation(extent = {{-98, -10}, {-78, 10}})));
      equation
        connect(abs1.u, wSensor.w) annotation(
          Line(points = {{62, -20}, {80, -20}, {80, -10.8}}, color = {0, 0, 127}));
        connect(toElePow.w, wSensor.w) annotation(
          Line(points = {{-28, -58}, {80, -58}, {80, -10.8}}, color = {0, 0, 127}));
        connect(wSensor.flange, powSensor.flange_b) annotation(
          Line(points = {{80, 6}, {80, 6}, {80, 20}, {70, 20}, {70, 20}}));
        connect(toElePow.elePow, gain.u) annotation(
          Line(points = {{-50.6, -54}, {-58.6, -54}, {-58.6, -26}, {-44, -26}, {-44, 0}, {-52, 0}}, color = {0, 0, 127}));
        assert(wMax >= powMax / tauMax, "\n****\n" + "PARAMETER VERIFICATION ERROR:\nwMax must be not lower than powMax/tauMax" + "\n***\n");
        connect(limTau.w, abs1.y) annotation(
          Line(points = {{8, -14.4}, {28, -14.4}, {28, -20}, {39, -20}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(powSensor.flange_b, flange_a) annotation(
          Line(points = {{70, 20}, {94, 20}, {94, 0}, {100, 0}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(inertia.flange_a, torque.flange) annotation(
          Line(points = {{22, 20}, {4, 20}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(inertia.flange_b, powSensor.flange_a) annotation(
          Line(points = {{42, 20}, {50, 20}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(limTau.y, torque.tau) annotation(
          Line(points = {{-15, -21}, {-34, -21}, {-34, 20}, {-18, 20}}, color = {0, 0, 127}));
        connect(toElePow.tau, torque.tau) annotation(
          Line(points = {{-28, -50}, {-20, -50}, {-20, -32}, {-34, -32}, {-34, 20}, {-18, 20}}, color = {0, 0, 127}));
        connect(gain.y, constPg.Pref) annotation(
          Line(points = {{-75, 0}, {-79.8, 0}}, color = {0, 0, 127}));
        connect(constPg.pin_p, pin_p) annotation(
          Line(points = {{-88, 10}, {-88, 60}, {-100, 60}}, color = {0, 0, 255}));
        connect(constPg.pin_n, pin_n) annotation(
          Line(points = {{-88, -9.8}, {-88, -9.8}, {-88, -58}, {-100, -58}}, color = {0, 0, 255}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1)),
          Icon(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1), graphics = {Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-100, 80}, {100, -80}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{56, 10}, {100, -10}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-72, 50}, {58, -46}}), Line(origin = {2, 122}, rotation = 90, points = {{-72, 62}, {-60, 62}, {-60, 96}}, color = {0, 0, 255}), Text(origin = {-14.9415, 30}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-79.0585, 98}, {112.936, 60}}, textString = "%name"), Line(origin = {-138, -16}, rotation = 90, points = {{-42, -48}, {-42, -76}, {-30, -76}}, color = {0, 0, 255}), Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-66, 14}, {50, -14}}), Text(origin = {-9.8571, 49.1}, extent = {{-54.1429, -35.1}, {61.8571, -61.1}}, textString = "J=%J")}),
          Documentation(info = "<html>
<p>One-flange electric drive.</p>
<p>The input signal is the requested normalised torque (1 means nominal torque)</p>
</html>"));
      end PartialOneFlange2;

      model PartialIceP "Simple map-based ice model with connector and Power request"
        import Modelica.Constants.*;
        parameter Real contrGain = 0.1 "Proportional controller gain (Nm/W)";
        parameter Real wIceStart = 167;
        parameter Real iceJ = 0.5 "ICE moment of Inertia (kg.m^2)";
        // rad/s
        Modelica.Mechanics.Rotational.Components.Inertia inertia(w(fixed = true, start = wIceStart, displayUnit = "rpm"), J = iceJ) annotation(
          Placement(visible = true, transformation(extent = {{30, 42}, {50, 62}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque iceTau annotation(
          Placement(visible = true, transformation(extent = {{4, 42}, {24, 62}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sensors.PowerSensor Pice annotation(
          Placement(transformation(extent = {{66, 62}, {86, 42}})));
        Modelica.Mechanics.Rotational.Sensors.SpeedSensor w annotation(
          Placement(visible = true, transformation(origin = {58, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Blocks.Math.Product toPowW annotation(
          Placement(visible = true, transformation(origin = {-18, 10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
        Modelica.Blocks.Math.Feedback feedback annotation(
          Placement(transformation(extent = {{-90, 62}, {-70, 42}})));
        Modelica.Blocks.Math.Gain gain(k = contrGain) annotation(
          Placement(visible = true, transformation(extent = {{-62, 42}, {-42, 62}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a annotation(
          Placement(transformation(extent = {{90, -10}, {110, 10}}), iconTransformation(extent = {{90, -10}, {110, 10}})));
        Modelica.Blocks.Tables.CombiTable2D toGramsPerkWh(fileName = "PSDmaps.txt", tableName = "iceSpecificCons", tableOnFile = true) annotation(
          Placement(transformation(extent = {{-10, 10}, {10, -10}}, rotation = -90, origin = {42, -2})));
        Modelica.Blocks.Math.Gain tokW(k = 0.001) annotation(
          Placement(visible = true, transformation(origin = {-18, -18}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
        Modelica.Blocks.Nonlinear.Limiter limiter1(uMax = 1e99, uMin = 0) annotation(
          Placement(visible = true, transformation(origin = {-22, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      equation
        connect(toPowW.y, tokW.u) annotation(
          Line(points = {{-18, -1}, {-18, -6}}, color = {0, 0, 127}));
        connect(toPowW.u2, iceTau.tau) annotation(
          Line(points = {{-24, 22}, {-24, 32}, {-6, 32}, {-6, 52}, {2, 52}}, color = {0, 0, 127}));
        connect(iceTau.tau, limiter1.y) annotation(
          Line(points = {{2, 52}, {-10, 52}, {-10, 52}, {-11, 52}}, color = {0, 0, 127}));
        connect(limiter1.u, gain.y) annotation(
          Line(points = {{-34, 52}, {-42, 52}, {-42, 52}, {-41, 52}}, color = {0, 0, 127}));
        connect(toGramsPerkWh.u1, iceTau.tau) annotation(
          Line(points = {{36, 10}, {36, 32}, {-6, 32}, {-6, 52}, {2, 52}}, color = {0, 0, 127}));
        connect(iceTau.flange, inertia.flange_a) annotation(
          Line(points = {{24, 52}, {30, 52}}));
        connect(w.flange, inertia.flange_b) annotation(
          Line(points = {{58, 46}, {58, 52}, {50, 52}}));
        connect(Pice.flange_a, inertia.flange_b) annotation(
          Line(points = {{66, 52}, {50, 52}}));
        connect(toGramsPerkWh.u2, w.w) annotation(
          Line(points = {{48, 10}, {48, 20}, {58, 20}, {58, 25}}, color = {0, 0, 127}));
        connect(toPowW.u1, w.w) annotation(
          Line(points = {{-12, 22}, {-12, 25}, {58, 25}}, color = {0, 0, 127}));
        connect(gain.u, feedback.y) annotation(
          Line(points = {{-64, 52}, {-71, 52}}, color = {0, 0, 127}));
        connect(Pice.flange_b, flange_a) annotation(
          Line(points = {{86, 52}, {94, 52}, {94, 0}, {100, 0}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(feedback.u2, Pice.power) annotation(
          Line(points = {{-80, 60}, {-80, 72}, {68, 72}, {68, 63}}, color = {0, 0, 127}, smooth = Smooth.None));
        annotation(
          Documentation(info = "<html>
<p><b><span style=\"font-family: MS Shell Dlg 2;\">Simple map-based ICE model for power-split power trains - with connector</b> </span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">This is a &QUOT;connector&QUOT; version of MBice.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">For a general descritiption see the info of MBice.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">Signals connected to the connector:</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- icePowRef (input) is the power request (W). Negative values are internally converted to zero</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- iceW (output) is the measured ICE speed (rad/s)</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- icePowDel (output) delivered power (W)</span></p>
</html>"),
          Icon(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1), graphics = {Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-24, 48}, {76, -44}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{76, 10}, {100, -10}}), Text(origin = {-2, 0}, extent = {{-140, -52}, {140, -86}}, textString = "J=%J"), Rectangle(extent = {{-100, 62}, {100, -100}}), Text(origin = {0, 10}, lineColor = {0, 0, 255}, extent = {{-140, 100}, {140, 60}}, textString = "%name"), Rectangle(extent = {{-90, 48}, {-32, -46}}), Rectangle(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, extent = {{-90, 2}, {-32, -20}}), Line(points = {{-60, 36}, {-60, 12}}), Polygon(points = {{-60, 46}, {-66, 36}, {-54, 36}, {-60, 46}}), Polygon(points = {{-60, 4}, {-66, 14}, {-54, 14}, {-60, 4}}), Rectangle(fillColor = {135, 135, 135}, fillPattern = FillPattern.Solid, extent = {{-64, -20}, {-54, -40}})}),
          Diagram(coordinateSystem(extent = {{-100, -80}, {100, 80}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Text(extent = {{-90, 20}, {-46, -16}}, textString = "follows the power
reference \nand computes consumption")}));
      end PartialIceP;

      partial model PartialOneFlange "Partial map-based one-Flange electric drive model"
        parameter Modelica.SIunits.Power powMax = 22000 "Maximum drive power";
        parameter Modelica.SIunits.Torque tauMax = 80 "Maximum drive torque";
        parameter Modelica.SIunits.Voltage uDcNom = 100 "nominal DC voltage";
        parameter Modelica.SIunits.AngularVelocity wMax(min = powMax / tauMax) = 3000 "Maximum drive speed";
        parameter Modelica.SIunits.MomentOfInertia J = 0.25 "Rotor's moment of inertia";
        parameter Boolean mapsOnFile = false "= true, if tables are taken from a txt file";
        parameter String mapsFileName = "noName" "File where matrix is stored" annotation(
          Dialog(enable = mapsOnFile, loadSelector(filter = "Text files (*.txt)", caption = "Open file in which required tables are")));
        parameter String effTableName = "noName" "Name of the on-file maximum torque as a function of speed" annotation(
          Dialog(enable = mapsOnFile));
        parameter Real effTable[:, :] = [0,0,1; 0,1,1; 1,1,1] annotation(
          Dialog(enable = not mapsOnFile));
        Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a "Left flange of shaft" annotation(
          Placement(transformation(extent = {{88, 50}, {108, 70}}, rotation = 0), iconTransformation(extent = {{90, -10}, {110, 10}})));
        Modelica.Mechanics.Rotational.Sensors.SpeedSensor wSensor annotation(
          Placement(transformation(extent = {{8, -8}, {-8, 8}}, rotation = 90, origin = {78, 44})));
        SupportModels.MapBasedRelated.LimTau limTau(tauMax = tauMax, wMax = wMax, powMax = powMax) annotation(
          Placement(transformation(extent = {{40, 18}, {20, 42}})));
        SupportModels.MapBasedRelated.EfficiencyT toElePow(mapsOnFile = mapsOnFile, tauMax = tauMax, powMax = powMax, wMax = wMax, mapsFileName = mapsFileName, effTableName = effTableName, effTable = effTable) annotation(
          Placement(transformation(extent = {{-6, -28}, {-26, -8}})));
        Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
          Placement(transformation(extent = {{-110, 30}, {-90, 50}}), iconTransformation(extent = {{-110, 30}, {-90, 50}})));
        Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
          Placement(transformation(extent = {{-110, -50}, {-90, -30}}), iconTransformation(extent = {{-110, -50}, {-90, -30}})));
        SupportModels.MapBasedRelated.ConstPg constPDC(vNom = uDcNom) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-100, 0})));
        Modelica.Mechanics.Rotational.Components.Inertia inertia(J = J) annotation(
          Placement(transformation(extent = {{22, 50}, {42, 70}})));
        Modelica.Mechanics.Rotational.Sources.Torque torque annotation(
          Placement(transformation(extent = {{-16, 50}, {4, 70}})));
        Modelica.Blocks.Math.Gain gain(k = 1) annotation(
          Placement(transformation(extent = {{-64, -10}, {-84, 10}})));
        Modelica.Mechanics.Rotational.Sensors.PowerSensor powSensor annotation(
          Placement(transformation(extent = {{50, 50}, {70, 70}})));
        Modelica.Blocks.Nonlinear.VariableLimiter variableLimiter annotation(
          Placement(transformation(extent = {{-4, 20}, {-24, 40}})));
      equation
        assert(wMax >= powMax / tauMax, "\n****\n" + "PARAMETER VERIFICATION ERROR:\nwMax must be not lower than powMax/tauMax" + "\n***\n");
        connect(toElePow.w, wSensor.w) annotation(
          Line(points = {{-4, -22}, {78, -22}, {78, 35.2}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(pin_p, constPDC.pin_p) annotation(
          Line(points = {{-100, 40}, {-100, 10}}, color = {0, 0, 255}, smooth = Smooth.None));
        connect(pin_n, constPDC.pin_n) annotation(
          Line(points = {{-100, -40}, {-100, -9.8}}, color = {0, 0, 255}, smooth = Smooth.None));
        connect(constPDC.Pref, gain.y) annotation(
          Line(points = {{-91.8, 0}, {-85, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(powSensor.flange_b, flange_a) annotation(
          Line(points = {{70, 60}, {98, 60}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(wSensor.flange, flange_a) annotation(
          Line(points = {{78, 52}, {78, 60}, {98, 60}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(toElePow.elePow, gain.u) annotation(
          Line(points = {{-26.6, -18}, {-46, -18}, {-46, 0}, {-62, 0}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(inertia.flange_a, torque.flange) annotation(
          Line(points = {{22, 60}, {4, 60}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(inertia.flange_b, powSensor.flange_a) annotation(
          Line(points = {{42, 60}, {50, 60}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(variableLimiter.limit1, limTau.yH) annotation(
          Line(points = {{-2, 38}, {19, 38}, {19, 37.2}}, color = {0, 0, 127}));
        connect(variableLimiter.limit2, limTau.yL) annotation(
          Line(points = {{-2, 22}, {10, 22}, {10, 22.8}, {19, 22.8}}, color = {0, 0, 127}));
        connect(variableLimiter.y, torque.tau) annotation(
          Line(points = {{-25, 30}, {-36, 30}, {-36, 60}, {-18, 60}}, color = {0, 0, 127}));
        connect(toElePow.tau, torque.tau) annotation(
          Line(points = {{-4, -14}, {2, -14}, {2, 12}, {-36, 12}, {-36, 60}, {-18, 60}}, color = {0, 0, 127}));
        connect(limTau.w, wSensor.w) annotation(
          Line(points = {{42, 30}, {78, 30}, {78, 35.2}}, color = {0, 0, 127}));
        annotation(
          Diagram(coordinateSystem(extent = {{-100, -80}, {100, 80}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2})),
          Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(extent = {{-70, 80}, {100, -80}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{62, -7}, {82, -7}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{52, 10}, {100, -10}}), Line(points = {{-98, 40}, {-70, 40}}, color = {0, 0, 255}), Line(points = {{-92, -40}, {-70, -40}}, color = {0, 0, 255}), Text(origin = {0, 20}, lineColor = {0, 0, 255}, extent = {{-70, 98}, {100, 60}}, textString = "%name", fillPattern = FillPattern.Solid, fillColor = {255, 255, 255}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-56, 48}, {76, -48}}), Rectangle(fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, extent = {{-48, 14}, {66, -14}}), Text(origin = {6.1429, 47.1}, extent = {{-54.1429, -35.1}, {61.8571, -61.1}}, textString = "J=%J")}),
          Documentation(info = "<html>
<p>One-flange electric drive.</p>
<p>The input signal is the requested normalised torque (1 means nominal torque)</p>
</html>"));
      end PartialOneFlange;


      partial model PartialMBice "Simple  map-based Internal Combustion Engine model"
        import Modelica.Constants.*;
        parameter Modelica.SIunits.AngularVelocity wIceStart = 167;
        parameter Modelica.SIunits.MomentOfInertia iceJ = 0.5 "ICE moment of inertia";
        parameter Boolean mapsOnFile = false "= true, if tables are taken from a txt file";
        parameter String mapsFileName = "NoName" "File where matrix is stored" annotation(
          Dialog(enable = mapsOnFile, loadSelector(filter = "Text files (*.txt)", caption = "Open file in which required tables are")));
        parameter String maxTauName = "noName" "name of the on-file maximum torque as a function of speed" annotation(
          Dialog(enable = mapsOnFile));
        parameter String specConsName = "noName" "name of the on-file specific consumption variable" annotation(
          Dialog(enable = mapsOnFile));
        parameter Real maxIceTau[:, :] = [0, 80; 100, 80; 350, 95; 500, 95] "First column speed, second column maximum ice torque" annotation(
          Dialog(enable = not mapsOnFile));
        parameter Real specificConsTab[:, :](unit = "g/(kW.h)") = [0., 100, 200, 300, 400, 500; 10, 630, 580, 550, 580, 630; 20, 430, 420, 400, 400, 450; 30, 320, 325, 330, 340, 350; 40, 285, 285, 288, 290, 300; 50, 270, 265, 265, 270, 275; 60, 255, 248, 250, 255, 258; 70, 245, 237, 238, 243, 246; 80, 245, 230, 233, 237, 240; 90, 235, 230, 228, 233, 235] "ICE specific consumption map. First column torque, first row speed" annotation(
          Dialog(enable = not mapsOnFile));
        Modelica.Mechanics.Rotational.Sensors.SpeedSensor w annotation(
          Placement(visible = true, transformation(origin = {52, 44}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a annotation(
          Placement(visible = true, transformation(extent = {{90, 10}, {110, 30}}, rotation = 0), iconTransformation(extent = {{90, 10}, {110, 30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sensors.PowerSensor icePow annotation(
          Placement(visible = true, transformation(extent = {{66, 50}, {86, 70}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque Tice annotation(
          Placement(visible = true, transformation(extent = {{-12, 50}, {8, 70}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia ICE(w(fixed = true, start = wIceStart, displayUnit = "rpm"), J = iceJ) annotation(
          Placement(visible = true, transformation(extent = {{16, 50}, {36, 70}}, rotation = 0)));
        Modelica.Blocks.Math.Product toPow0 annotation(
          Placement(visible = true, transformation(origin = {0, 12}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
        Modelica.Blocks.Math.Product toG_perHour annotation(
          Placement(visible = true, transformation(origin = {30, -50}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
        //  Modelica.Blocks.Continuous.Integrator toGrams(k = 1 / 3600000.0)
        // annotation(Placement(visible = true, transformation(origin = {26, -44},
        //extent = {{-10, -10}, {10, 10}}, rotation = 270)));
        Modelica.Blocks.Tables.CombiTable1D toLimTau(tableOnFile = mapsOnFile, table = maxIceTau, tableName = maxTauName, fileName = mapsFileName) annotation(
          Placement(visible = true, transformation(origin = {-72, 66}, extent = {{10, -10}, {-10, 10}}, rotation = 180)));
        Modelica.Blocks.Sources.RealExpression rotorW(y = w.w) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 90, origin = {-88, 36})));
        Modelica.Blocks.Math.Gain tokW(k = 1e-3) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {0, -18})));
        Modelica.Blocks.Tables.CombiTable2D toSpecCons(tableOnFile = mapsOnFile, table = specificConsTab, tableName = specConsName, fileName = mapsFileName) annotation(
          Placement(transformation(extent = {{-10, 10}, {10, -10}}, rotation = -90, origin = {40, 0})));
      equation
        connect(toPow0.u1, w.w) annotation(
          Line(points = {{6, 24}, {6, 33}, {52, 33}}, color = {0, 0, 127}));
        connect(w.flange, ICE.flange_b) annotation(
          Line(points = {{52, 54}, {52, 60}, {36, 60}}));
        connect(icePow.flange_a, ICE.flange_b) annotation(
          Line(points = {{66, 60}, {36, 60}}));
        connect(Tice.flange, ICE.flange_a) annotation(
          Line(points = {{8, 60}, {16, 60}}));
        connect(icePow.flange_b, flange_a) annotation(
          Line(points = {{86, 60}, {94, 60}, {94, 20}, {100, 20}}));
        connect(toLimTau.u[1], rotorW.y) annotation(
          Line(points = {{-84, 66}, {-88, 66}, {-88, 47}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(toPow0.y, tokW.u) annotation(
          Line(points = {{-2.22045e-015, 1}, {-2.22045e-015, -2}, {2.22045e-015, -2}, {2.22045e-015, -6}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(toSpecCons.y, toG_perHour.u1) annotation(
          Line(points = {{40, -11}, {40, -24}, {36, -24}, {36, -38}}, color = {0, 0, 127}));
        connect(toG_perHour.u2, tokW.y) annotation(
          Line(points = {{24, -38}, {24, -32}, {0, -32}, {0, -29}}, color = {0, 0, 127}));
        connect(toSpecCons.u2, w.w) annotation(
          Line(points = {{46, 12}, {46, 28}, {52, 28}, {52, 33}}, color = {0, 0, 127}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}})),
          experiment(StopTime = 200, __Dymola_NumberOfIntervals = 1000, __Dymola_Algorithm = "Lsodar"),
          __Dymola_experimentSetupOutput,
          Documentation(info = "<html>
<h4>Basic map-based ICE model.</h4>
<p>It receives as input the reference torque as a fracton of the maximum deliverable torque at a given speed. It can be approximately thought as a signal proportional to the accelerator position oF the vehicle.</p>
<p>The generated torque is the minimum between this signal and the maximum deliverable torque at the actual engine speed (defined by means of a table).</p>
<p>From the generated torque and speed the fuel consumption is computed.</p>
<p>The used maxTorque (toLimTau) and specific fuel consumption (toSpecCons) maps are inspired to public data related to the Toyota Prius&apos; engine </p>
</html>"),
          Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(extent = {{-100, 80}, {100, -80}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-24, 68}, {76, -24}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{76, 30}, {100, 10}}), Text(origin = {0, 30}, lineColor = {0, 0, 255}, extent = {{-140, 100}, {140, 60}}, textString = "%name"), Rectangle(extent = {{-90, 68}, {-32, -26}}), Rectangle(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, extent = {{-90, 22}, {-32, 0}}), Line(points = {{-60, 56}, {-60, 32}}), Polygon(points = {{-60, 66}, {-66, 56}, {-54, 56}, {-60, 66}}), Polygon(points = {{-60, 24}, {-66, 34}, {-54, 34}, {-60, 24}}), Rectangle(fillColor = {135, 135, 135}, fillPattern = FillPattern.Solid, extent = {{-64, 0}, {-54, -20}})}));
      end PartialMBice;

      partial model PartialMBiceP "Simple map-based ice model with connector and Power request"
        import Modelica.Constants.*;
        parameter Real contrGain(unit = "N.m/W") = 0.1 "Proportional controller gain ";
        parameter Modelica.SIunits.AngularVelocity wIceStart = 167;
        parameter Modelica.SIunits.MomentOfInertia iceJ = 0.5 "ICE moment of Inertia";
        parameter Boolean mapsOnFile = false "= true, if tables are taken from a txt file";
        parameter String mapsFileName = "NoName" "File where matrix is stored" annotation(
          Dialog(enable = mapsOnFile, loadSelector(filter = "Text files (*.txt)", caption = "Open file in which required tables are")));
        parameter String specConsName = "noName" "name of the on-file specific consumption variable" annotation(
          Dialog(enable = mapsOnFile));
        parameter Real specificCons[:, :](each unit = "g/(kW.h)") = [0.0, 100, 200, 300, 400, 500; 10, 630, 580, 550, 580, 630; 20, 430, 420, 400, 400, 450; 30, 320, 325, 330, 340, 350; 40, 285, 285, 288, 290, 300; 50, 270, 265, 265, 270, 275; 60, 255, 248, 250, 255, 258; 70, 245, 237, 238, 243, 246; 80, 245, 230, 233, 237, 240; 90, 235, 230, 228, 233, 235] "ICE specific consumption map. First column torque, first row speed" annotation(
          Dialog(enable = not mapsOnFile));
        Modelica.Mechanics.Rotational.Components.Inertia ICE(w(fixed = true, start = wIceStart, displayUnit = "rpm"), J = iceJ) annotation(
          Placement(transformation(extent = {{20, 42}, {40, 62}})));
        Modelica.Mechanics.Rotational.Sources.Torque iceTau annotation(
          Placement(transformation(extent = {{-12, 42}, {8, 62}})));
        Modelica.Mechanics.Rotational.Sensors.PowerSensor Pice annotation(
          Placement(transformation(extent = {{66, 62}, {86, 42}})));
        Modelica.Mechanics.Rotational.Sensors.SpeedSensor w annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 270, origin = {52, 36})));
        Modelica.Blocks.Math.Product toPow0 annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {2, 6})));
        Modelica.Blocks.Math.Product toG_perHour annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {24, -50})));
        Modelica.Blocks.Math.Feedback feedback annotation(
          Placement(transformation(extent = {{-90, 62}, {-70, 42}})));
        Modelica.Blocks.Math.Gain gain(k = contrGain) annotation(
          Placement(transformation(extent = {{-58, 42}, {-38, 62}})));
        Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a annotation(
          Placement(transformation(extent = {{90, -10}, {110, 10}}), iconTransformation(extent = {{90, -10}, {110, 10}})));
        Modelica.Blocks.Tables.CombiTable2D toSpecCons(table = specificCons, tableOnFile = mapsOnFile, tableName = specConsName, fileName = mapsFileName) annotation(
          Placement(transformation(extent = {{-10, 10}, {10, -10}}, rotation = -90, origin = {42, -2})));
        Modelica.Blocks.Math.Gain tokW(k = 1e-3) annotation(
          Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = -90, origin = {2, -24})));
      equation
        connect(iceTau.flange, ICE.flange_a) annotation(
          Line(points = {{8, 52}, {20, 52}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(Pice.flange_a, ICE.flange_b) annotation(
          Line(points = {{66, 52}, {40, 52}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(Pice.flange_b, flange_a) annotation(
          Line(points = {{86, 52}, {94, 52}, {94, 0}, {100, 0}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(w.flange, ICE.flange_b) annotation(
          Line(points = {{52, 46}, {52, 52}, {40, 52}}, color = {0, 0, 0}, smooth = Smooth.None));
        connect(toPow0.u1, w.w) annotation(
          Line(points = {{8, 18}, {8, 25}, {52, 25}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(toPow0.u2, iceTau.tau) annotation(
          Line(points = {{-4, 18}, {-4, 22}, {-28, 22}, {-28, 52}, {-14, 52}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(feedback.u2, Pice.power) annotation(
          Line(points = {{-80, 60}, {-80, 72}, {68, 72}, {68, 63}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(gain.y, iceTau.tau) annotation(
          Line(points = {{-37, 52}, {-14, 52}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(gain.u, feedback.y) annotation(
          Line(points = {{-60, 52}, {-71, 52}}, color = {0, 0, 127}, smooth = Smooth.None));
        connect(toSpecCons.y, toG_perHour.u1) annotation(
          Line(points = {{42, -13}, {42, -20}, {30, -20}, {30, -38}}, color = {0, 0, 127}));
        connect(toSpecCons.u2, w.w) annotation(
          Line(points = {{48, 10}, {48, 10}, {48, 16}, {48, 20}, {50, 20}, {52, 20}, {52, 25}}, color = {0, 0, 127}));
        connect(toSpecCons.u1, iceTau.tau) annotation(
          Line(points = {{36, 10}, {36, 32}, {-28, 32}, {-28, 52}, {-14, 52}}, color = {0, 0, 127}));
        connect(tokW.u, toPow0.y) annotation(
          Line(points = {{2, -12}, {2, -5}}, color = {0, 0, 127}));
        connect(tokW.y, toG_perHour.u2) annotation(
          Line(points = {{2, -35}, {10, -35}, {10, -34}, {18, -34}, {18, -38}}, color = {0, 0, 127}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -80}, {100, 80}}, initialScale = 0.1), graphics = {Text(extent = {{-78, 6}, {-38, -16}}, lineColor = {0, 0, 0}, textString = "follows the power
 reference and
 computes consumption")}),
          experiment(StopTime = 200, __Dymola_NumberOfIntervals = 1000, __Dymola_Algorithm = "Lsodar"),
          __Dymola_experimentSetupOutput,
          Documentation(info = "<html>
<p><b><span style=\"font-family: MS Shell Dlg 2;\">Simple map-based ICE model for power-split power trains - with connector</b> </span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">This is a &QUOT;connector&QUOT; version of MBice.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">For a general descritiption see the info of MBice.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">Signals connected to the connector:</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- icePowRef (input) is the power request (W). Negative values are internally converted to zero</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- iceW (output) is the measured ICE speed (rad/s)</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- icePowDel (output) delivered power (W)</span></p>
</html>"),
          Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-24, 48}, {76, -44}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{76, 10}, {100, -10}}), Text(origin = {-2, 0}, extent = {{-140, -52}, {140, -90}}, textString = "J=%J"), Rectangle(extent = {{-100, 62}, {100, -100}}), Text(origin = {0, 10}, lineColor = {0, 0, 255}, extent = {{-140, 100}, {140, 60}}, textString = "%name"), Rectangle(extent = {{-90, 48}, {-32, -46}}), Rectangle(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, extent = {{-90, 2}, {-32, -20}}), Line(points = {{-60, 36}, {-60, 12}}), Polygon(points = {{-60, 46}, {-66, 36}, {-54, 36}, {-60, 46}}), Polygon(points = {{-60, 4}, {-66, 14}, {-54, 14}, {-60, 4}}), Rectangle(fillColor = {135, 135, 135}, fillPattern = FillPattern.Solid, extent = {{-64, -20}, {-54, -40}})}));
      end PartialMBiceP;

      model IceConnP "Simple map-based ice model with connector; follows power request"
        extends Partial.PartialMBiceP;
        import Modelica.Constants.*;
        parameter Modelica.SIunits.AngularVelocity wIceStart = 167;
        SupportModels.ConnectorRelated.Conn conn annotation(
          Placement(visible = true, transformation(extent = {{-20, -82}, {20, -122}}, rotation = 0), iconTransformation(extent = {{-20, -82}, {20, -122}}, rotation = 0)));
      equation
        connect(feedback.u1, conn.icePowRef) annotation(
          Line(points = {{-88, 52}, {-88, 52}, {-88, -102}, {0, -102}}, color = {0, 0, 127}),
          Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
        connect(Pice.power, conn.icePowDel) annotation(
          Line(points = {{68, 63}, {68, 63}, {68, 6}, {78, 6}, {78, -102}, {0, -102}}, color = {0, 0, 127}),
          Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
        connect(w.w, conn.iceW) annotation(
          Line(points = {{52, 25}, {58, 25}, {58, 6}, {58, -102}, {0, -102}}, color = {0, 0, 127}),
          Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
        connect(toG_perHour.y, conn.iceGramsPerHour) annotation(
          Line(points = {{24, -61}, {22, -61}, {22, -84}, {0, -84}, {0, -102}, {0, -102}}, color = {0, 0, 127}),
          Text(string = "%second", index = 1, extent = {{6, 3}, {6, 3}}));
        annotation(
          Diagram(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1)),
          experiment(StopTime = 200, __Dymola_NumberOfIntervals = 1000, __Dymola_Algorithm = "Lsodar"),
          __Dymola_experimentSetupOutput,
          Documentation(info = "<html>
<p><b><span style=\"font-family: MS Shell Dlg 2;\">Simple map-based ICE model for power-split power trains - with connector</span></b> </p>
<p><span style=\"font-family: MS Shell Dlg 2;\">This is a &QUOT;connector&QUOT; version of MBiceP.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">For a general descritiption see the info of MBiceP.</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">Signals connected to the connector:</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- icePowRef (input) is the power request (W). Negative values are internally converted to zero</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- iceW (output) is the measured ICE speed (rad/s)</span></p>
<p><span style=\"font-family: MS Shell Dlg 2;\">- icePowDel (output) delivered power (W)</span></p>
</html>"),
          Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = false, initialScale = 0.1, grid = {2, 2})));
      end IceConnP;
    end Partial;

    model GensetImGm "GenSet GMS+GEN+SEngine"
      import Modelica.Constants.inf;
      import Modelica.Constants.pi;
      parameter Modelica.SIunits.Time OptiTime "Time parameter of the PI OptiSpeed controller";
      parameter String mapsFileName = "maps.txt" "Name of the file containing data maps (names: maxIceTau, specificCons, optiSpeed)";
      parameter Modelica.SIunits.AngularVelocity wIceStart = 167;
      parameter Modelica.SIunits.AngularVelocity wGenMax;
      parameter Modelica.SIunits.Torque maxTau = 200 "Max mechanical torque";
      parameter Modelica.SIunits.Power maxPow = 20e3 "Max mechanical power";
      Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor annotation(
        Placement(transformation(extent = {{-8, -8}, {8, 8}}, rotation = 180, origin = {-24, -20})));
      Modelica.Mechanics.Rotational.Sensors.PowerSensor IcePow annotation(
        Placement(transformation(extent = {{24, -2}, {42, 16}})));
      Modelica.Blocks.Interfaces.RealInput powRef(unit = "W") "Reference genset power" annotation(
        Placement(transformation(extent = {{15, -15}, {-15, 15}}, rotation = 90, origin = {61, 115})));
      Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
        Placement(transformation(extent = {{90, 50}, {110, 70}})));
      Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
        Placement(transformation(extent = {{92, -70}, {112, -50}})));
      Modelica.Blocks.Nonlinear.Limiter limiter(uMax = inf, uMin = 0) annotation(
        Placement(transformation(extent = {{10, -10}, {-10, 10}}, rotation = 90, origin = {-80, 54})));
      SHEV.PowerTrain.Gensets.GMS0 myGMS(mapsFileName = mapsFileName) annotation(
        Placement(transformation(extent = {{-70, 10}, {-50, 30}})));
      EHPowerTrain.MapBased.MBOneFlange gen(wMax = wGenMax, mapsFileName = mapsFileName, mapsOnFile = true, powMax = maxPow, tauMax = maxTau, effTableName = "gensetDriveEffTable") annotation(
        Placement(transformation(extent = {{68, 16}, {48, -4}})));
      EHPowerTrain.MapBased.MBiceT01 mBiceT(mapsFileName = mapsFileName, wIceStart = wIceStart, mapsOnFile = true, maxTauName = "maxIceTau", specConsName = "specificCons") annotation(
        Placement(transformation(extent = {{-34, -2}, {-14, 18}})));
      Modelica.Blocks.Math.Gain gain(k = -1) annotation(
        Placement(transformation(extent = {{-14, 30}, {6, 50}})));
      Modelica.Blocks.Math.Gain gain1(k = 1) annotation(
        Placement(visible = true, transformation(origin = {-60, -8}, extent = {{-6, -6}, {6, 6}}, rotation = 90)));
      Modelica.Blocks.Continuous.Integrator toGrams(k = 1 / 3600) annotation(
        Placement(transformation(extent = {{18, -42}, {38, -22}})));
    equation
      connect(gain1.u, speedSensor.w) annotation(
        Line(points = {{-60, -15.2}, {-60, -20}, {-32.8, -20}}, color = {0, 0, 127}));
      connect(myGMS.Wmecc, gain1.y) annotation(
        Line(points = {{-59.9, 8.5}, {-60, 8.5}, {-60, -1.4}}, color = {0, 0, 127}));
      connect(limiter.u, powRef) annotation(
        Line(points = {{-80, 66}, {-80, 80}, {61, 80}, {61, 115}}, color = {0, 0, 127}, smooth = Smooth.None));
      connect(limiter.y, myGMS.pRef) annotation(
        Line(points = {{-80, 43}, {-80, 20}, {-72, 20}}, color = {0, 0, 127}, smooth = Smooth.None));
      connect(IcePow.flange_b, gen.flange_a) annotation(
        Line(points = {{42, 7}, {46, 7}, {46, 6}, {48, 6}}, color = {0, 0, 0}));
      connect(gen.pin_n, pin_p) annotation(
        Line(points = {{68, 10}, {80, 10}, {80, 60}, {100, 60}}, color = {0, 0, 255}));
      connect(gen.pin_p, pin_n) annotation(
        Line(points = {{68, 2}, {78, 2}, {78, -60}, {102, -60}}, color = {0, 0, 255}));
      connect(mBiceT.nTauRef, myGMS.throttle) annotation(
        Line(points = {{-30, -2}, {-30, -6}, {-49, -6}, {-49, 14}}, color = {0, 0, 127}));
      connect(IcePow.flange_a, mBiceT.flange_a) annotation(
        Line(points = {{24, 7}, {6, 7}, {6, 10}, {-14, 10}}, color = {0, 0, 0}));
      connect(speedSensor.flange, mBiceT.flange_a) annotation(
        Line(points = {{-16, -20}, {-6, -20}, {-6, 10}, {-14, 10}}, color = {0, 0, 0}));
      connect(gain.u, myGMS.tRef) annotation(
        Line(points = {{-16, 40}, {-40, 40}, {-40, 26}, {-49, 26}}, color = {0, 0, 127}));
      connect(gain.y, gen.tauRef) annotation(
        Line(points = {{7, 40}, {49, 40}, {49, 14.6}}, color = {0, 0, 127}));
      connect(toGrams.u, mBiceT.fuelCons) annotation(
        Line(points = {{16, -32}, {12, -32}, {8, -32}, {8, -6}, {-18, -6}, {-18, -1}}, color = {0, 0, 127}));
      annotation(
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -60}, {100, 100}})),
        experiment(StopTime = 20, Interval = 0.01),
        experimentSetupOutput,
        Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Text(extent = {{-98, 94}, {78, 68}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-20, 0}, {26, -14}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{-44, 30}, {-14, -44}}), Line(points = {{-72, 30}, {-72, 6}}), Polygon(points = {{-72, -2}, {-78, 8}, {-66, 8}, {-72, -2}}), Rectangle(extent = {{-96, 38}, {-50, -48}}), Rectangle(fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid, extent = {{-96, -6}, {-50, -24}}), Rectangle(fillColor = {135, 135, 135}, fillPattern = FillPattern.Solid, extent = {{-78, -24}, {-68, -44}}), Polygon(points = {{-72, 34}, {-78, 24}, {-66, 24}, {-72, 34}}), Rectangle(fillColor = {192, 192, 192}, fillPattern = FillPattern.HorizontalCylinder, extent = {{6, 30}, {62, -44}}), Line(points = {{94, 60}, {74, 60}, {74, 18}, {62, 18}}, color = {0, 0, 255}), Line(points = {{100, -60}, {74, -60}, {74, -28}, {62, -28}}, color = {0, 0, 255})}),
        Documentation(info = "<html>
<p>Convertitore primario con ICE e generatore</p>

</html>"));
    end GensetImGm;
    annotation(
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Line(points = {{-80, -84}, {-80, 68}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-88, -80}, {78, -80}}, color = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{94, -80}, {78, -74}, {78, -86}, {94, -80}}, lineColor = {0, 0, 0}, smooth = Smooth.None), Polygon(points = {{8, 0}, {-8, 6}, {-8, -6}, {8, 0}}, lineColor = {0, 0, 0}, smooth = Smooth.None, origin = {-80, 76}, rotation = 90), Line(points = {{-84, 40}, {-14, 40}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{-14, 40}, {-4, 2}, {22, -32}, {62, -44}, {62, -80}}, color = {0, 0, 0}, smooth = Smooth.None)}));
  end MapBased;

  package Icons
    model EcuIcon
      SupportModels.ConnectorRelated.Conn conn1 annotation(
        Placement(visible = true, transformation(extent = {{-20, 78}, {20, 118}}, rotation = 0), iconTransformation(extent = {{-20, 80}, {20, 120}}, rotation = 0)));
      Modelica.Blocks.Interfaces.RealInput motTauInt annotation(
        Placement(visible = true, transformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0), iconTransformation(extent = {{-140, -20}, {-100, 20}}, rotation = 0)));
      annotation(
        Icon(graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{-4, -40}, {74, 16}, {74, -6}, {-4, -62}, {-4, -40}}, lineColor = {95, 95, 95}, fillColor = {175, 175, 175}, fillPattern = FillPattern.Solid), Polygon(points = {{8, -38}, {28, -48}, {20, -54}, {0, -44}, {8, -38}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{20, -54}, {28, -48}, {32, -56}, {24, -62}, {20, -54}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{24, -62}, {32, -56}, {32, -78}, {24, -84}, {24, -62}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 127}, fillPattern = FillPattern.Solid), Polygon(points = {{0, -44}, {20, -54}, {24, -62}, {24, -84}, {22, -84}, {22, -62}, {20, -58}, {0, -48}, {0, -44}}, lineColor = {0, 0, 255}, fillColor = {191, 191, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-14, 40}, {-18, 32}, {-10, 38}, {-8, 44}, {-14, 40}}, lineColor = {128, 128, 128}, fillColor = {128, 128, 128}, fillPattern = FillPattern.Solid), Polygon(points = {{-18, 32}, {-10, 38}, {-10, 14}, {-18, 8}, {-18, 32}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 127}, fillPattern = FillPattern.Solid), Polygon(points = {{-20, 10}, {-20, 32}, {-16, 40}, {4, 30}, {4, 26}, {-16, 36}, {-18, 32}, {-18, 8}, {-20, 10}}, lineColor = {0, 0, 255}, fillColor = {191, 191, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-8, 46}, {12, 36}, {4, 30}, {-16, 40}, {-8, 46}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{28, -22}, {48, -32}, {40, -38}, {20, -28}, {28, -22}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{40, -38}, {48, -32}, {52, -40}, {44, -46}, {40, -38}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{44, -46}, {52, -40}, {52, -62}, {44, -68}, {44, -46}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 127}, fillPattern = FillPattern.Solid), Polygon(points = {{20, -28}, {40, -38}, {44, -46}, {44, -68}, {42, -68}, {42, -46}, {40, -42}, {20, -32}, {20, -28}}, lineColor = {0, 0, 255}, fillColor = {191, 191, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{48, -8}, {68, -18}, {60, -24}, {40, -14}, {48, -8}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{60, -24}, {68, -18}, {72, -26}, {64, -32}, {60, -24}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{64, -32}, {72, -26}, {72, -48}, {64, -54}, {64, -32}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 127}, fillPattern = FillPattern.Solid), Polygon(points = {{40, -14}, {60, -24}, {64, -32}, {64, -54}, {62, -54}, {62, -32}, {60, -28}, {40, -18}, {40, -14}}, lineColor = {0, 0, 255}, fillColor = {191, 191, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{68, 6}, {88, -4}, {80, -10}, {60, 0}, {68, 6}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{80, -10}, {88, -4}, {92, -12}, {84, -18}, {80, -10}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{84, -18}, {92, -12}, {92, -34}, {84, -40}, {84, -18}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 127}, fillPattern = FillPattern.Solid), Polygon(points = {{60, 0}, {80, -10}, {84, -18}, {84, -40}, {82, -40}, {82, -18}, {80, -14}, {60, -4}, {60, 0}}, lineColor = {0, 0, 255}, fillColor = {191, 191, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-34, 26}, {-38, 18}, {-30, 24}, {-28, 30}, {-34, 26}}, lineColor = {128, 128, 128}, fillColor = {128, 128, 128}, fillPattern = FillPattern.Solid), Polygon(points = {{-38, 18}, {-30, 24}, {-30, 0}, {-38, -6}, {-38, 18}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 127}, fillPattern = FillPattern.Solid), Polygon(points = {{-40, -4}, {-40, 18}, {-36, 26}, {-16, 16}, {-16, 12}, {-36, 22}, {-38, 18}, {-38, -6}, {-40, -4}}, lineColor = {0, 0, 255}, fillColor = {191, 191, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-28, 32}, {-8, 22}, {-16, 16}, {-36, 26}, {-28, 32}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-54, 12}, {-58, 4}, {-50, 10}, {-48, 16}, {-54, 12}}, lineColor = {128, 128, 128}, fillColor = {128, 128, 128}, fillPattern = FillPattern.Solid), Polygon(points = {{-58, 4}, {-50, 10}, {-50, -14}, {-58, -20}, {-58, 4}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 127}, fillPattern = FillPattern.Solid), Polygon(points = {{-60, -18}, {-60, 4}, {-56, 12}, {-36, 2}, {-36, -2}, {-56, 8}, {-58, 4}, {-58, -20}, {-60, -18}}, lineColor = {0, 0, 255}, fillColor = {191, 191, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-48, 18}, {-28, 8}, {-36, 2}, {-56, 12}, {-48, 18}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-74, -4}, {-78, -12}, {-70, -6}, {-68, 0}, {-74, -4}}, lineColor = {128, 128, 128}, fillColor = {128, 128, 128}, fillPattern = FillPattern.Solid), Polygon(points = {{-78, -12}, {-70, -6}, {-70, -30}, {-78, -36}, {-78, -12}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 127}, fillPattern = FillPattern.Solid), Polygon(points = {{-80, -34}, {-80, -12}, {-76, -4}, {-56, -14}, {-56, -18}, {-76, -8}, {-78, -12}, {-78, -36}, {-80, -34}}, lineColor = {0, 0, 255}, fillColor = {191, 191, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-68, 2}, {-48, -8}, {-56, -14}, {-76, -4}, {-68, 2}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-64, -8}, {-4, -40}, {-4, -62}, {-64, -30}, {-64, -8}}, lineColor = {95, 95, 95}, fillColor = {75, 75, 75}, fillPattern = FillPattern.Solid), Polygon(points = {{-64, -8}, {-4, -40}, {74, 16}, {14, 48}, {-64, -8}}, lineColor = {95, 95, 95}, fillColor = {160, 160, 164}, fillPattern = FillPattern.Solid), Text(origin = {-1, -42}, lineColor = {0, 0, 255}, extent = {{-119, -64}, {119, -104}}, textString = "%name"), Rectangle(extent = {{-98, 92}, {98, 62}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, pattern = LinePattern.None)}),
        Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics));
    end EcuIcon;

    model SupportIcon
      annotation(
        Icon(graphics = {Ellipse(extent = {{-38, 38}, {38, -38}}, lineColor = {0, 0, 0}), Line(points = {{2, 80}, {-8, 80}, {-12, 70}, {-26, 66}, {-36, 76}, {-48, 68}, {-44, 56}, {-56, 44}, {-68, 48}, {-76, 34}, {-68, 28}, {-70, 14}, {-80, 10}, {-80, 0}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{2, -80}, {-8, -80}, {-12, -70}, {-26, -66}, {-36, -76}, {-48, -68}, {-44, -56}, {-56, -44}, {-68, -48}, {-76, -34}, {-68, -28}, {-70, -14}, {-80, -10}, {-80, 0}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{0, -80}, {10, -80}, {14, -70}, {28, -66}, {38, -76}, {50, -68}, {46, -56}, {58, -44}, {70, -48}, {78, -34}, {70, -28}, {72, -14}, {82, -10}, {82, 0}}, color = {0, 0, 0}, smooth = Smooth.None), Line(points = {{0, 80}, {10, 80}, {14, 70}, {28, 66}, {38, 76}, {50, 68}, {46, 56}, {58, 44}, {70, 48}, {78, 34}, {70, 28}, {72, 14}, {82, 10}, {82, 0}}, color = {0, 0, 0}, smooth = Smooth.None)}));
    end SupportIcon;
  end Icons;
  annotation(
    uses(Modelica(version = "3.2.2"), Complex(version = "3.2.2")),
    Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Polygon(points = {{-60, 16}, {78, 16}, {94, 0}, {96, -16}, {-98, -16}, {-90, 0}, {-76, 12}, {-60, 16}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid), Ellipse(extent = {{-70, -4}, {-30, -40}}, lineColor = {95, 95, 95}, fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid), Ellipse(extent = {{34, -6}, {74, -42}}, lineColor = {95, 95, 95}, fillColor = {95, 95, 95}, fillPattern = FillPattern.Solid), Polygon(points = {{-54, 16}, {-18, 46}, {46, 46}, {74, 16}, {-54, 16}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid), Ellipse(extent = {{-86, -6}, {-92, 4}}, lineColor = {0, 0, 0}, fillColor = {255, 255, 0}, fillPattern = FillPattern.Solid), Ellipse(extent = {{98, -10}, {92, -4}}, lineColor = {0, 0, 0}, fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid), Polygon(points = {{-46, 20}, {-20, 42}, {16, 42}, {14, 20}, {-46, 20}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Polygon(points = {{22, 42}, {42, 42}, {60, 20}, {20, 20}, {22, 42}}, lineColor = {0, 0, 0}, smooth = Smooth.None, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Ellipse(extent = {{-60, -12}, {-40, -30}}, lineColor = {95, 95, 95}, fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid), Ellipse(extent = {{44, -14}, {64, -32}}, lineColor = {95, 95, 95}, fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid)}),
    Documentation(info = "<html>
<p>Library containing models of components, subsystems and full vehicle examples for simulation of electric and Hybrid vehicular power trains.</p>
<p>A general description of the library composition and on how to use it effectively is in the compaion paper:</p>
<p>M. Ceraolo &QUOT;Modelica Electric and hybrid power trains library&QUOT; submitted for publication at the 11th International Modelica Conference, 2015, September 21-23, Palais des congr&egrave;s de Versailles, 23-23 September, France</p>
</html>"));
end wbEHPTlib;
