model Stage1
  extends Modelica.Mechanics.MultiBody.Interfaces.PartialOneFrame_a;
  import SI = Modelica.SIunits;
  parameter Integer N = 6 annotation(
    Evaluate = true);
  parameter Real shaft_length = 0.1;
  //
  Modelica.Blocks.Interfaces.RealInput input1 annotation(
    Placement(visible = true, transformation(origin = {-120, 80}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 80}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Joints.Revolute drive( n = {1, 0, 0}, phi(fixed = true), stateSelect = StateSelect.always, useAxisFlange = true, w(start = 100.0)) annotation(
    Placement(visible = true, transformation(origin = {50, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Stage2 stage2(numStage3 = 4) annotation(
    Placement(visible = true, transformation(origin = {90, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Parts.Body dummyMass(I_11 = 1e-10, I_22 = 1e-10, I_33 = 1e-10, animation = false, m = 1e-10, r_CM = {0, 0, 0}) annotation(
    Placement(visible = true, transformation(origin = {88, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Mechanics.MultiBody.Parts.FixedTranslation shaft(r = {shaft_length, 0, 0}) annotation(
    Placement(visible = true, transformation(origin = {14, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Mechanics.Rotational.Sources.Speed speed1(exact = false, phi(fixed = false), useSupport = true) annotation(
    Placement(visible = true, transformation(origin = {0, 54}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(stage2.frame_a, drive.frame_b) annotation(
    Line(points = {{80, 0}, {60, 0}}, color = {95, 95, 95}));
  connect(shaft.frame_a, frame_a) annotation(
    Line(points = {{4, 0}, {-100, 0}, {-100, 0}, {-100, 0}}, color = {95, 95, 95}));
  connect(shaft.frame_b, drive.frame_a) annotation(
    Line(points = {{24, 0}, {40, 0}, {40, 0}, {40, 0}}, color = {95, 95, 95}));
  connect(dummyMass.frame_a, drive.frame_b) annotation(
    Line(points = {{78, 34}, {60, 34}, {60, 0}}, color = {95, 95, 95}));
  connect(speed1.flange, drive.axis) annotation(
    Line(points = {{10, 54}, {50, 54}, {50, 10}, {50, 10}}));
  connect(drive.support, speed1.support) annotation(
    Line(points = {{44, 10}, {0, 10}, {0, 44}, {0, 44}}));
  connect(input1, speed1.w_ref) annotation(
    Line(points = {{-120, 80}, {-12, 80}, {-12, 54}, {-12, 54}}, color = {0, 0, 127}));
end Stage1;