model Stage2
  extends Modelica.Mechanics.MultiBody.Interfaces.PartialOneFrame_a;
  parameter Integer numStage3 = 4 annotation(
    Evaluate = true);
  parameter Real shaft_length = 0.1;
  parameter Real tip_mass = 10.0;
  Modelica.Mechanics.MultiBody.Parts.FixedTranslation tipMassOffset(animation = false, r = {shaft_length, 0, 0}) annotation(
    Placement(visible = true, transformation(origin = {-72, -26}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Mechanics.MultiBody.Parts.PointMass tipMass(animation = false, m = tip_mass, stateSelect = StateSelect.never) annotation(
    Placement(visible = true, transformation(origin = {-72, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Stage3[numStage3] stage3(hub_angle = array(i*360/numStage3 for i in 0:numStage3-1), each shaft_length = shaft_length) annotation(
    Placement(visible = true, transformation(origin = {-8, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  for i in 1:numStage3 loop
    connect(frame_a, stage3[i].frame_a) annotation(
      Line(points = {{-100, 0}, {-18, 0}, {-18, 0}, {-18, 0}}));
  end for;
  connect(tipMassOffset.frame_b, tipMass.frame_a) annotation(
    Line(points = {{-72, -36}, {-72, -50}}, color = {95, 95, 95}));
  connect(tipMassOffset.frame_a, frame_a) annotation(
    Line(points = {{-72, -16}, {-71, -16}, {-71, 0}, {-100, 0}}, color = {95, 95, 95}));
end Stage2;