﻿within BugProtectionAnno.Internal.Interfaces;
connector FluidPortB "Interface for one-dimensional fluid flow"

//////////////////////////// header /////////////////////////////////
// © Bosch Rexroth AG 2019. All rights reserved,                   //
// also regarding any disposal, exploitation, reproduction,        //
// editing, distribution, as well as in the event of applications  //
// for industrial property rights.                                 //
/////////////////////////////////////////////////////////////////////

  flow Modelica.SIunits.MassFlowRate m_flow
    "Mass flow rate from the connection point into the component";

  Modelica.SIunits.AbsolutePressure p
    "Absolute pressure in the connection point";

  annotation (Documentation(info="<html>
<h3>FluidPort</h3>
<p>
This is a port for 1D hydraulic systems transporting the following variables:
<pre>
  p: Absolute pressure of the port in Pa.
  m_flow: mass flow in m3/s. A positive value means the flow is directetd into the port.
</pre>
</p>
</html>"),
    Icon(graphics={Ellipse(
          extent={{-100,100},{100,-100}},
          lineColor={0,128,255},
          fillColor={0,128,255},
          fillPattern=FillPattern.Solid)}),
    Diagram(graphics={            Ellipse(
              extent={{-40,40},{40,-40}},
              fillColor={255,255,255},
              fillPattern=FillPattern.Solid,
          lineColor={0,128,255}),                  Text(
              extent={{0,80},{0,40}},
              lineColor={0,128,255},
          textString="%name")}));
end FluidPortB;
