model CallExternalPythonV3
  input  Integer funChoice(start = 0) "0: multiply. 1. sinus";
  input  Real    A(        start = 1.);
  input  Real    B(        start = 1.);
  output Real    val;

function callingPythonFunction
  input  Integer FChoice;
  input  Real    Aval, Bval;
  output Real    outp;
  
external "C" annotation(Include="
#define PY_SSIZE_T_CLEAN
#define INPSIZE 3
#include <Python.h>
#include <stdio.h>
#include <string.h>

double callingPythonFunction(integer FChoice, double Aval, double Bval)
{
  PyObject *pName, *pModule, *pFunc;
  PyObject *pArgs, *pValue;
  
  const char *PrName = \"functionsV2\";
  const char *FName  = \"call_the_right_function\";

  int i = 0;
  double outp = 0./0.;
  
  Py_Initialize();
  pName = PyUnicode_DecodeFSDefault( PrName );  /*Getting the .py script without the .py extension*/
  /* Error checking of pName left out */

  pModule = PyImport_Import(pName);
  Py_DECREF(pName);

  if (pModule != NULL) {
    pFunc = PyObject_GetAttrString(pModule, FName ); /*looking for the function*/
    /* pFunc is a new reference */

    if (pFunc && PyCallable_Check(pFunc)) {
      fprintf(stderr,\"Function exists and is executable\\n\");
      pArgs  = PyTuple_New(INPSIZE);      
      pValue = PyFloat_FromDouble(Aval);
      PyTuple_SetItem(pArgs, 0, pValue);

      pValue = PyFloat_FromDouble(Bval);  
      PyTuple_SetItem(pArgs, 1, pValue);
      
      pValue = PyLong_FromLong(FChoice);  
      PyTuple_SetItem(pArgs, 2, pValue);

      pValue = PyObject_CallObject(pFunc, pArgs);

      Py_DECREF(pArgs);

      if (pValue != NULL) {
        outp = PyFloat_AsDouble( pValue );
        fprintf(stderr, \"Result of call: %f\\n\", outp);
        Py_DECREF(pValue);
      }
      else {
        Py_DECREF(pFunc);
        Py_DECREF(pModule);
        PyErr_Print();
        fprintf(stderr,\"Call failed\\n\");
        exit(1);
      }
    }
    else {
      if (PyErr_Occurred()) PyErr_Print();
      fprintf(stderr, \"Cannot find function %s\\n\", FName);
    }
    Py_XDECREF(pFunc);
    Py_DECREF(pModule);
  }
  else {
    PyErr_Print();
    fprintf(stderr, \"Failed to load %s\\n\", PrName);
    exit(1);
  }
  /*if (Py_FinalizeEx() < 0) exit(120);  <======== Careful with this, there is no Py_Finalize in this program*/ 
  /*fprintf(stderr, \"==>Everything went right<==\\n\");*/
  return outp;
}");
end callingPythonFunction;

algorithm
  val := callingPythonFunction(Aval=A, Bval=B, FChoice=funChoice);
end CallExternalPythonV3;
