model epid

parameter Real total_pop = 700;

Real infected(start=1);
Real susceptible;
Real removed(start=0);

parameter Real infection_rate = 15;
parameter Real healing_rate = 7;

initial equation
total_pop = infected + susceptible + removed;

equation
der(susceptible) = - infection_rate*infected*susceptible;
der(infected) = infection_rate*infected*susceptible - healing_rate*infected;
der(removed) = healing_rate*infected;

annotation(
    experiment(StartTime = 0, StopTime = 50, Tolerance = 1e-6, Interval = 0.1));
end epid;