model GRID
  Modelica.Electrical.MultiPhase.Sources.SineVoltage HV(V = fill(160000, 3), freqHz = fill(50, 3))  annotation(
    Placement(visible = true, transformation(origin = {6, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Ground ground3 annotation(
    Placement(visible = true, transformation(origin = {24, -42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Star star3 annotation(
    Placement(visible = true, transformation(origin = {24, -16}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.MultiPhase.Basic.Resistor Rg(R = fill(0.829, 3))  annotation(
    Placement(visible = true, transformation(origin = {-20, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Inductor Lg(L = fill(0.016, 3))  annotation(
    Placement(visible = true, transformation(origin = {-52, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Interfaces.PositivePlug PG annotation(
    Placement(visible = true, transformation(origin = {-100, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-100, 6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(HV.plug_n, star3.plug_p) annotation(
    Line(points = {{16, 10}, {24, 10}, {24, -6}, {24, -6}}, color = {0, 0, 255}));
  connect(Rg.plug_n, HV.plug_p) annotation(
    Line(points = {{-10, 10}, {-4, 10}, {-4, 10}, {-4, 10}}, color = {0, 0, 255}));
  connect(Lg.plug_n, Rg.plug_p) annotation(
    Line(points = {{-42, 10}, {-30, 10}, {-30, 10}, {-30, 10}}, color = {0, 0, 255}));
  connect(PG, Lg.plug_p) annotation(
    Line(points = {{-100, 10}, {-62, 10}, {-62, 10}, {-62, 10}}, color = {0, 0, 255}));
  connect(star3.pin_n, ground3.p) annotation(
    Line(points = {{24, -26}, {24, -26}, {24, -32}, {24, -32}}, color = {0, 0, 255}));
  annotation(
    uses(Modelica(version = "3.2.3")),
    Icon(graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}), Text(origin = {-5, 15}, extent = {{-69, 21}, {87, -37}}, textString = "HV grid")}, coordinateSystem(initialScale = 0.1)));
end GRID;
