model dcbusm1
  Modelica.Electrical.Analog.Sources.SignalCurrent Iconv annotation(
    Placement(visible = true, transformation(origin = {-36, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Modelica.Electrical.Analog.Sensors.VoltageSensor voltageSensor annotation(
    Placement(visible = true, transformation(origin = {46, 10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Sources.ConstantVoltage DCBUS(V = 800) annotation(
    Placement(visible = true, transformation(origin = {90, 10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealOutput pdc annotation(
    Placement(visible = true, transformation(origin = {66, -108}, extent = {{-10, -10}, {10, 10}}, rotation = -90), iconTransformation(origin = {58, -110}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Math.Product product annotation(
    Placement(visible = true, transformation(origin = {66, -78}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Inductor inductor(L = 0.00005, i(fixed = false)) annotation(
    Placement(visible = true, transformation(origin = {62, 46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Capacitor capacitor(C = 0.001020, v(fixed = true, start = 800)) annotation(
    Placement(visible = true, transformation(origin = {-6, 10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {-6, -36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Resistor resistor(R = 0.12) annotation(
    Placement(visible = true, transformation(origin = {24, 46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput edc_source annotation(
    Placement(visible = true, transformation(origin = {110, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-50, -110}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealInput Idc annotation(
    Placement(visible = true, transformation(origin = {-108, 10}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {120, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 180)));
equation
  connect(product.y, pdc) annotation(
    Line(points = {{66, -89}, {66, -108}}, color = {0, 0, 127}));
  connect(DCBUS.p, inductor.n) annotation(
    Line(points = {{90, 20}, {90, 46}, {72, 46}}, color = {0, 0, 255}));
  connect(voltageSensor.n, capacitor.n) annotation(
    Line(points = {{46, 0}, {-6, 0}}, color = {0, 0, 255}));
  connect(capacitor.p, voltageSensor.p) annotation(
    Line(points = {{-6, 20}, {46, 20}}, color = {0, 0, 255}));
  connect(resistor.n, inductor.p) annotation(
    Line(points = {{34, 46}, {52, 46}}, color = {0, 0, 255}));
  connect(Iconv.n, resistor.p) annotation(
    Line(points = {{-36, 20}, {-36, 46}, {14, 46}}, color = {0, 0, 255}));
  connect(capacitor.p, resistor.p) annotation(
    Line(points = {{-6, 20}, {-6, 20}, {-6, 46}, {14, 46}, {14, 46}}, color = {0, 0, 255}));
  connect(Iconv.p, ground.p) annotation(
    Line(points = {{-36, 0}, {-36, -26}, {-6, -26}}, color = {0, 0, 255}));
  connect(capacitor.n, ground.p) annotation(
    Line(points = {{-6, 0}, {-6, 0}, {-6, -26}, {-6, -26}}, color = {0, 0, 255}));
  connect(DCBUS.n, ground.p) annotation(
    Line(points = {{90, 0}, {90, -26}, {-6, -26}}, color = {0, 0, 255}));
  connect(voltageSensor.v, product.u1) annotation(
    Line(points = {{36, 10}, {20, 10}, {20, -40}, {72, -40}, {72, -66}}, color = {0, 0, 127}));
  connect(edc_source, voltageSensor.v) annotation(
    Line(points = {{110, -40}, {20, -40}, {20, 10}, {34, 10}, {34, 10}, {36, 10}}, color = {0, 0, 127}));
  connect(Idc, Iconv.i) annotation(
    Line(points = {{-108, 10}, {-48, 10}, {-48, 10}, {-48, 10}}, color = {0, 0, 127}));
  connect(Idc, product.u2) annotation(
    Line(points = {{-108, 10}, {-60, 10}, {-60, -56}, {60, -56}, {60, -66}, {60, -66}}, color = {0, 0, 127}));
  annotation(
    uses(Modelica(version = "3.2.3"), iPSL(version = "1.1.0")));
end dcbusm1;
