model rc
  Modelica.Electrical.Analog.Sources.ConstantVoltage constantVoltage(V = 10)  annotation(
    Placement(visible = true, transformation(origin = {-44, 16}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {-44, -8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Resistor resistor(R = 0.5)  annotation(
    Placement(visible = true, transformation(origin = {-12, 36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Capacitor capacitor(C = 0.1)  annotation(
    Placement(visible = true, transformation(origin = {22, 16}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
equation
  connect(constantVoltage.n, ground.p) annotation(
    Line(points = {{-44, 6}, {-44, 6}, {-44, 2}, {-44, 2}}, color = {0, 0, 255}));
  connect(resistor.p, constantVoltage.p) annotation(
    Line(points = {{-22, 36}, {-44, 36}, {-44, 26}}, color = {0, 0, 255}));
  connect(resistor.n, capacitor.p) annotation(
    Line(points = {{-2, 36}, {22, 36}, {22, 26}}, color = {0, 0, 255}));
  connect(capacitor.n, constantVoltage.n) annotation(
    Line(points = {{22, 6}, {-44, 6}, {-44, 6}, {-44, 6}}, color = {0, 0, 255}));

annotation(
    uses(Modelica(version = "3.2.3")));
end rc;
