class sagv "Generate one sag"
  constant Real pi =  Modelica.Constants.pi;
  parameter Real amplitude=1 "Amplitude of sine wave";
  parameter Modelica.SIunits.Frequency freqHz "Frequency of sine wave";
  parameter Modelica.SIunits.Angle phase"Phase of sine wave";
  parameter Modelica.SIunits.Damping damping(start=1)
    "Damping coefficient of sine wave";
  parameter Real endv = startTime + 1/freqHz;
  extends Modelica.Blocks.Interfaces.SignalSource;
  

algorithm

  
  y := offset + (if time < startTime then 0 else amplitude*Modelica.Math.exp(-
    (time - startTime)*damping)*Modelica.Math.sin(2*pi*freqHz*(time -
    startTime) + phase));
  if time > endv then y := offset;
  end if;

end sagv;
