model testinv_traf
  inverter INV1 annotation(
    Placement(visible = true, transformation(origin = {-100, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inverter INV2 annotation(
    Placement(visible = true, transformation(origin = {-100, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  trafo_three_w T1 "Dy03" annotation(
    Placement(visible = true, transformation(origin = {-44, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sources.SineVoltage sineVoltage(V = fill(3260, 3), freqHz = fill(50, 3))  annotation(
    Placement(visible = true, transformation(origin = {-10, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Star star annotation(
    Placement(visible = true, transformation(origin = {20, -24}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {20, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(T1.in1, INV1.ac) annotation(
    Line(points = {{-54, 16}, {-76, 16}, {-76, 30}, {-90, 30}, {-90, 30}}, color = {0, 0, 255}));
  connect(INV2.ac, T1.in2) annotation(
    Line(points = {{-90, 0}, {-76, 0}, {-76, 12}, {-54, 12}, {-54, 12}, {-54, 12}}, color = {0, 0, 255}));
  connect(star.pin_n, ground.p) annotation(
    Line(points = {{20, -34}, {20, -34}, {20, -40}, {20, -40}}, color = {0, 0, 255}));
  connect(star.plug_p, sineVoltage.plug_n) annotation(
    Line(points = {{20, -14}, {20, -14}, {20, 14}, {0, 14}, {0, 14}}, color = {0, 0, 255}));
  connect(sineVoltage.plug_p, T1.out) annotation(
    Line(points = {{-20, 14}, {-34, 14}, {-34, 14}, {-34, 14}}, color = {0, 0, 255}));

annotation(
    uses(Modelica(version = "3.2.3")));
end testinv_traf;
