model VSC_dc_current_source_gridfault
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {-166, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sensors.CurrentSensor Cs annotation(
    Placement(visible = true, transformation(origin = {-30, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sensors.PotentialSensor Vs annotation(
    Placement(visible = true, transformation(origin = {-56, 8}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.MultiPhase.Basic.PlugToPins_p pp annotation(
    Placement(visible = true, transformation(origin = {-102, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vca annotation(
    Placement(visible = true, transformation(origin = {64, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vcb annotation(
    Placement(visible = true, transformation(origin = {84, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vcc annotation(
    Placement(visible = true, transformation(origin = {108, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  inner_control_pllm inner_control_pllmx annotation(
    Placement(visible = true, transformation(origin = {4, -30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {120, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.PlugToPins_n pp1 annotation(
    Placement(visible = true, transformation(origin = {46, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Resistor Rc(R = fill(0.5, 3)) annotation(
    Placement(visible = true, transformation(origin = {24, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Inductor Lc(L = fill(0.0051, 3)) annotation(
    Placement(visible = true, transformation(origin = {-4, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Pac_Qac_Calculation pac_Qac_Calculation annotation(
    Placement(visible = true, transformation(origin = {-48, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  dcbusm1 dcbus annotation(
    Placement(visible = true, transformation(origin = {70, -92}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  gridchange Vzb1(amplitude1 = 326, amplitude2 = 230, freqHz = 50, phase = -2.0944, t1 = 0.4, t2 = 0.7) annotation(
    Placement(visible = true, transformation(origin = {-197, 29}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  gridchange Vza1(amplitude1 = 326, amplitude2 = 230, freqHz = 50, t1 = 0.4, t2 = 0.7) annotation(
    Placement(visible = true, transformation(origin = {-197, 49}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vzb annotation(
    Placement(visible = true, transformation(origin = {-136, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Basic.Ground ground2 annotation(
    Placement(visible = true, transformation(origin = {-170, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vzc annotation(
    Placement(visible = true, transformation(origin = {-116, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  gridchange Vzc3(amplitude1 = 326, amplitude2 = 230, freqHz = 50, phase = 2.0944, t1 = 0.4, t2 = 0.7) annotation(
    Placement(visible = true, transformation(origin = {-197, 9}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vza annotation(
    Placement(visible = true, transformation(origin = {-154, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.Constant Idref(k = 0)  annotation(
    Placement(visible = true, transformation(origin = {45, -63}, extent = {{-9, -9}, {9, 9}}, rotation = 180)));
  DC_ControlP dC_ControlP annotation(
    Placement(visible = true, transformation(origin = {-62, -100}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.Constant Eref(k = 800) annotation(
    Placement(visible = true, transformation(origin = {-124, -100}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.Constant Idc(k = 10)  annotation(
    Placement(visible = true, transformation(origin = {112, -92}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
equation
  connect(Cs.plug_p, Vs.plug_p) annotation(
    Line(points = {{-40, 40}, {-40, 18}, {-56, 18}}, color = {0, 0, 255}));
  connect(Vs.phi[1], inner_control_pllmx.va) annotation(
    Line(points = {{-56, -3}, {-56, -20}, {-7, -20}}, color = {0, 0, 127}));
  connect(Vs.phi[2], inner_control_pllmx.vb) annotation(
    Line(points = {{-56, -3}, {-56, -24}, {-7, -24}}, color = {0, 0, 127}));
  connect(Vs.phi[3], inner_control_pllmx.vc) annotation(
    Line(points = {{-56, -3}, {-56, -28}, {-7, -28}}, color = {0, 0, 127}));
  connect(Cs.i[1], inner_control_pllmx.ia) annotation(
    Line(points = {{-30, 30}, {-30, -32}, {-7, -32}}, color = {0, 0, 127}));
  connect(Cs.i[2], inner_control_pllmx.ib) annotation(
    Line(points = {{-30, 30}, {-30, -36}, {-7, -36}}, color = {0, 0, 127}));
  connect(Cs.i[3], inner_control_pllmx.ic) annotation(
    Line(points = {{-30, 30}, {-30, -39}, {-7, -39}}, color = {0, 0, 127}));
  connect(Vcc.v, inner_control_pllmx.Vcref) annotation(
    Line(points = {{108, 8}, {108, -38}, {15, -38}}, color = {0, 0, 127}));
  connect(Vca.p, ground1.p) annotation(
    Line(points = {{74, 60}, {120, 60}, {120, 40}}, color = {0, 0, 255}));
  connect(Vcc.p, ground1.p) annotation(
    Line(points = {{118, 20}, {120, 20}, {120, 40}, {120, 40}}, color = {0, 0, 255}));
  connect(Vcb.p, ground1.p) annotation(
    Line(points = {{94, 40}, {120, 40}, {120, 40}, {120, 40}}, color = {0, 0, 255}));
  connect(Vcc.n, pp1.pin_n[3]) annotation(
    Line(points = {{98, 20}, {48, 20}, {48, 40}}, color = {0, 0, 255}));
  connect(Vcb.n, pp1.pin_n[2]) annotation(
    Line(points = {{74, 40}, {48, 40}}, color = {0, 0, 255}));
  connect(Vca.n, pp1.pin_n[1]) annotation(
    Line(points = {{54, 60}, {48, 60}, {48, 40}}, color = {0, 0, 255}));
  connect(pp1.plug_n, Rc.plug_n) annotation(
    Line(points = {{44, 40}, {34, 40}}, color = {0, 0, 255}));
  connect(Lc.plug_p, Cs.plug_n) annotation(
    Line(points = {{-14, 40}, {-20, 40}, {-20, 40}, {-20, 40}}, color = {0, 0, 255}));
  connect(Rc.plug_p, Lc.plug_n) annotation(
    Line(points = {{14, 40}, {6, 40}}, color = {0, 0, 255}));
  connect(inner_control_pllmx.Vbref, Vcb.v) annotation(
    Line(points = {{16, -34}, {84, -34}, {84, 28}, {84, 28}}, color = {0, 0, 127}));
  connect(inner_control_pllmx.Varef, Vca.v) annotation(
    Line(points = {{16, -32}, {64, -32}, {64, 48}, {64, 48}}, color = {0, 0, 127}));
  connect(inner_control_pllmx.theta, pac_Qac_Calculation.theta) annotation(
    Line(points = {{16, -26}, {34, -26}, {34, -12}, {-74, -12}, {-74, -58}, {-60, -58}}, color = {0, 0, 127}));
  connect(inner_control_pllmx.va, pac_Qac_Calculation.Va_grid) annotation(
    Line(points = {{-8, -20}, {-56, -20}, {-56, -46}, {-56, -46}}, color = {0, 0, 127}));
  connect(inner_control_pllmx.vb, pac_Qac_Calculation.Vb_grid) annotation(
    Line(points = {{-8, -24}, {-54, -24}, {-54, -46}, {-54, -46}}, color = {0, 0, 127}));
  connect(inner_control_pllmx.vc, pac_Qac_Calculation.Vc_grid) annotation(
    Line(points = {{-8, -28}, {-50, -28}, {-50, -46}, {-50, -46}}, color = {0, 0, 127}));
  connect(inner_control_pllmx.ia, pac_Qac_Calculation.Ia_grid) annotation(
    Line(points = {{-8, -32}, {-46, -32}, {-46, -46}, {-46, -46}}, color = {0, 0, 127}));
  connect(inner_control_pllmx.ib, pac_Qac_Calculation.Ib_grid) annotation(
    Line(points = {{-8, -36}, {-42, -36}, {-42, -46}, {-42, -46}}, color = {0, 0, 127}));
  connect(inner_control_pllmx.ic, pac_Qac_Calculation.Ic_grid) annotation(
    Line(points = {{-8, -40}, {-40, -40}, {-40, -46}, {-40, -46}}, color = {0, 0, 127}));
  connect(Vzc3.y, Vzc.v) annotation(
    Line(points = {{-190, 10}, {-116, 10}, {-116, 8}, {-116, 8}}, color = {0, 0, 127}));
  connect(Vza1.y, Vza.v) annotation(
    Line(points = {{-190, 50}, {-154, 50}, {-154, 48}, {-154, 48}}, color = {0, 0, 127}));
  connect(Vza.n, ground2.p) annotation(
    Line(points = {{-164, 60}, {-170, 60}, {-170, 10}}, color = {0, 0, 255}));
  connect(Vzb1.y, Vzb.v) annotation(
    Line(points = {{-190, 30}, {-136, 30}, {-136, 28}, {-136, 28}}, color = {0, 0, 127}));
  connect(Vzb.n, ground2.p) annotation(
    Line(points = {{-146, 40}, {-170, 40}, {-170, 10}}, color = {0, 0, 255}));
  connect(Vzc.n, ground2.p) annotation(
    Line(points = {{-126, 20}, {-170, 20}, {-170, 10}}, color = {0, 0, 255}));
  connect(Vza.p, pp.pin_p[1]) annotation(
    Line(points = {{-144, 60}, {-104, 60}, {-104, 40}, {-104, 40}, {-104, 40}}, color = {0, 0, 255}));
  connect(pp.pin_p[2], Vzb.p) annotation(
    Line(points = {{-104, 40}, {-126, 40}, {-126, 40}, {-126, 40}}, color = {0, 0, 255}));
  connect(pp.pin_p[3], Vzc.p) annotation(
    Line(points = {{-104, 40}, {-106, 40}, {-106, 20}, {-106, 20}}, color = {0, 0, 255}));
  connect(Idref.y, inner_control_pllmx.Idref) annotation(
    Line(points = {{35, -63}, {10, -63}, {10, -42}}, color = {0, 0, 127}));
  connect(pp.plug_p, Cs.plug_p) annotation(
    Line(points = {{-100, 40}, {-40, 40}, {-40, 40}, {-40, 40}}, color = {0, 0, 255}));
 
  connect(dC_ControlP.Iq_ref, inner_control_pllmx.Iqref) annotation(
    Line(points = {{-54, -100}, {-2, -100}, {-2, -42}, {-2, -42}}, color = {0, 0, 127}));
  
  
  connect(Idc.y, dcbus.Idc) annotation(
    Line(points = {{102, -92}, {84, -92}, {84, -92}, {82, -92}}, color = {0, 0, 127}));
  connect(dC_ControlP.Pdc, dcbus.pdc) annotation(
    Line(points = {{-58, -92}, {-58, -92}, {-58, -86}, {44, -86}, {44, -118}, {76, -118}, {76, -102}, {76, -102}}, color = {0, 0, 127}));
 connect(Eref.y, dC_ControlP.E_ref) annotation(
    Line(points = {{-112, -100}, {-70, -100}, {-70, -100}, {-70, -100}}, color = {0, 0, 127}));
 connect(dcbus.edc_source, dC_ControlP.E_dcsource) annotation(
    Line(points = {{66, -102}, {64, -102}, {64, -116}, {-68, -116}, {-68, -108}, {-66, -108}}, color = {0, 0, 127}));
 connect(inner_control_pllmx.Vzq, dC_ControlP.Vq_grid) annotation(
    Line(points = {{16, -22}, {28, -22}, {28, -112}, {-58, -112}, {-58, -108}, {-58, -108}}, color = {0, 0, 127}));
protected
  annotation(
    uses(Modelica(version = "3.2.3"), iPSL(version = "1.1.0")),
    Diagram(graphics = {Bitmap(extent = {{-52, -84}, {-52, -84}})}, coordinateSystem(initialScale = 0.1)));
end VSC_dc_current_source_gridfault;
