model NGenPV2
  Modelica.Electrical.MultiPhase.Basic.Star star annotation(
    Placement(visible = true, transformation(origin = {204, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {204, -36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sources.SineVoltage MV(V = fill(35355.34, 3), freqHz = fill(50, 3))  annotation(
    Placement(visible = true, transformation(origin = {190, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Inductor Lg(L = fill(0.00076, 3))  annotation(
    Placement(visible = true, transformation(origin = {142, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Resistor Rg(R = fill(0.005, 3))  annotation(
    Placement(visible = true, transformation(origin = {166, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sensors.PotentialSensor Vpcc annotation(
    Placement(visible = true, transformation(origin = {106, 16}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Modelica.Electrical.MultiPhase.Sensors.CurrentSensor Cpcc annotation(
    Placement(visible = true, transformation(origin = {84, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Pac_Qac_Calculation pac_Qac_Calculation annotation(
    Placement(visible = true, transformation(origin = {136, 80}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Sources.RealExpression Va(y = Vpcc.phi[1])  annotation(
    Placement(visible = true, transformation(origin = {172, 118}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression Vb(y = Vpcc.phi[2])  annotation(
    Placement(visible = true, transformation(origin = {172, 104}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression Vc(y = Vpcc.phi[3])  annotation(
    Placement(visible = true, transformation(origin = {172, 90}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression Ia(y = Cpcc.i[1])  annotation(
    Placement(visible = true, transformation(origin = {172, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression Ib(y = Cpcc.i[2])  annotation(
    Placement(visible = true, transformation(origin = {172, 56}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression Ic(y = Cpcc.i[3])  annotation(
    Placement(visible = true, transformation(origin = {172, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression theta(y = pllmv.theta)  annotation(
    Placement(visible = true, transformation(origin = {154, 136}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Power_Control power_Control annotation(
    Placement(visible = true, transformation(origin = {74, 80}, extent = {{-12, 12}, {12, -12}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression P(y = PTSO.y[1])  annotation(
    Placement(visible = true, transformation(origin = {106, 90}, extent = {{-10, 10}, {10, -10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression Q(y = QTSO.y[1])  annotation(
    Placement(visible = true, transformation(origin = {106, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression Pref(y = PxGen.y)  annotation(
    Placement(visible = true, transformation(origin = {-194, 26}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.RealExpression Qref(y = QxGen.y)  annotation(
    Placement(visible = true, transformation(origin = {-194, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.CombiTimeTable QRref(extrapolation = Modelica.Blocks.Types.Extrapolation.HoldLastPoint, smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments, table = [0, 0; 0.3, -2000000; 0.5, 0; 0.8, 2000000; 0.9, -5000000]) annotation(
    Placement(visible = true, transformation(origin = {40, 108}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.CombiTimeTable PRef(extrapolation = Modelica.Blocks.Types.Extrapolation.HoldLastPoint, smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments, table = [0, -3000000; 0.3, -6000000; 0.5, -1000000; 0.8, -7000000]) annotation(
    Placement(visible = true, transformation(origin = {40, 136}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Math.Division PxGen annotation(
    Placement(visible = true, transformation(origin = {-1, 133}, extent = {{5, -5}, {-5, 5}}, rotation = 0)));
  Modelica.Blocks.Math.Division QxGen annotation(
    Placement(visible = true, transformation(origin = {-1, 105}, extent = {{5, -5}, {-5, 5}}, rotation = 0)));
  Modelica.Blocks.Sources.RealExpression Ngen(y = 10)  annotation(
    Placement(visible = true, transformation(origin = {30, 74}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.CombiTimeTable PTSO(extrapolation = Modelica.Blocks.Types.Extrapolation.HoldLastPoint, smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments, table = [0, -3000 * 4; 0.3, -6000 * 4; 0.5, -1000 * 4; 0.8, -7000 * 4]) annotation(
    Placement(visible = true, transformation(origin = {74, 136}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.CombiTimeTable QTSO(extrapolation = Modelica.Blocks.Types.Extrapolation.HoldLastPoint, smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments, table = [0, 0 * 4; 0.3, -5000 * 4; 0.5, 0 * 4; 0.8, 2000 * 4; 0.9, -7000 * 4]) annotation(
    Placement(visible = true, transformation(origin = {74, 108}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  vsc VSC1 annotation(
    Placement(visible = true, transformation(origin = {-130, 136}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC2 annotation(
    Placement(visible = true, transformation(origin = {-130, 114}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC3 annotation(
    Placement(visible = true, transformation(origin = {-130, 84}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC4 annotation(
    Placement(visible = true, transformation(origin = {-130, 62}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC5 annotation(
    Placement(visible = true, transformation(origin = {-130, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC6 annotation(
    Placement(visible = true, transformation(origin = {-130, 8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC7 annotation(
    Placement(visible = true, transformation(origin = {-130, -22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC9 annotation(
    Placement(visible = true, transformation(origin = {-130, -76}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC10 annotation(
    Placement(visible = true, transformation(origin = {-130, -100}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  vsc VSC8 annotation(
    Placement(visible = true, transformation(origin = {-130, -44}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  trafo_three_w T1 annotation(
    Placement(visible = true, transformation(origin = {-84, 124}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  trafo_three_w T2 annotation(
    Placement(visible = true, transformation(origin = {-84, 72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  trafo_three_w T3 annotation(
    Placement(visible = true, transformation(origin = {-84, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  trafo_three_w T4 annotation(
    Placement(visible = true, transformation(origin = {-84, -88}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  trafo_three_w T5 annotation(
    Placement(visible = true, transformation(origin = {-84, -32}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Interfaces.Plug pcc annotation(
    Placement(visible = true, transformation(origin = {0, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-20, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  PLLMV pllmv annotation(
    Placement(visible = true, transformation(origin = {106, 44}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Line1 line1 annotation(
    Placement(visible = true, transformation(origin = {-56, 124}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Line2 line2 annotation(
    Placement(visible = true, transformation(origin = {-56, 72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Line3 line3 annotation(
    Placement(visible = true, transformation(origin = {-56, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Line4 line4 annotation(
    Placement(visible = true, transformation(origin = {-56, -32}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Line5 line5 annotation(
    Placement(visible = true, transformation(origin = {-56, -88}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(star.pin_n, ground.p) annotation(
    Line(points = {{204, -20}, {204, -26}}, color = {0, 0, 255}));
  connect(star.plug_p, MV.plug_n) annotation(
    Line(points = {{204, 0}, {200, 0}}, color = {0, 0, 255}));
  connect(Lg.plug_n, Rg.plug_p) annotation(
    Line(points = {{152, 0}, {156, 0}}, color = {0, 0, 255}));
  connect(Rg.plug_n, MV.plug_p) annotation(
    Line(points = {{176, 0}, {180, 0}}, color = {0, 0, 255}));
  connect(Va.y, pac_Qac_Calculation.Va_grid) annotation(
    Line(points = {{161, 118}, {150, 118}, {150, 88}, {147, 88}}, color = {0, 0, 127}));
  connect(Vb.y, pac_Qac_Calculation.Vb_grid) annotation(
    Line(points = {{161, 104}, {152, 104}, {152, 86}, {150, 86}, {150, 85}, {147, 85}}, color = {0, 0, 127}));
  connect(Vc.y, pac_Qac_Calculation.Vc_grid) annotation(
    Line(points = {{161, 90}, {154, 90}, {154, 82}, {147, 82}}, color = {0, 0, 127}));
  connect(pac_Qac_Calculation.Ia_grid, Ia.y) annotation(
    Line(points = {{147, 78}, {154, 78}, {154, 70}, {161, 70}}, color = {0, 0, 127}));
  connect(Ic.y, pac_Qac_Calculation.Ic_grid) annotation(
    Line(points = {{161, 42}, {150, 42}, {150, 72}, {147, 72}}, color = {0, 0, 127}));
  connect(Ib.y, pac_Qac_Calculation.Ib_grid) annotation(
    Line(points = {{161, 56}, {152, 56}, {152, 75}, {147, 75}}, color = {0, 0, 127}));
  connect(theta.y, pac_Qac_Calculation.theta) annotation(
    Line(points = {{143, 136}, {136, 136}, {136, 92}}, color = {0, 0, 127}));
  connect(power_Control.Ppvpp, pac_Qac_Calculation.Pac) annotation(
    Line(points = {{88, 84}, {124, 84}, {124, 86}, {124, 86}}, color = {0, 0, 127}));
  connect(pac_Qac_Calculation.Qac, power_Control.Qpvpp) annotation(
    Line(points = {{124, 74}, {124, 74}, {124, 76}, {88, 76}, {88, 76}}, color = {0, 0, 127}));
  connect(P.y, power_Control.PTSO) annotation(
    Line(points = {{94, 90}, {90, 90}, {90, 90}, {88, 90}}, color = {0, 0, 127}));
  connect(Q.y, power_Control.QTSO) annotation(
    Line(points = {{94, 70}, {90, 70}, {90, 70}, {88, 70}}, color = {0, 0, 127}));
  connect(PxGen.u1, PRef.y[1]) annotation(
    Line(points = {{5, 136}, {29, 136}}, color = {0, 0, 127}));
  connect(QxGen.u1, QRref.y[1]) annotation(
    Line(points = {{5, 108}, {29, 108}}, color = {0, 0, 127}));
  connect(Ngen.y, QxGen.u2) annotation(
    Line(points = {{19, 74}, {14, 74}, {14, 102}, {5, 102}}, color = {0, 0, 127}));
  connect(Ngen.y, PxGen.u2) annotation(
    Line(points = {{19, 74}, {14, 74}, {14, 130}, {5, 130}}, color = {0, 0, 127}));
  connect(Lg.plug_p, Cpcc.plug_n) annotation(
    Line(points = {{132, 0}, {94, 0}}, color = {0, 0, 255}));
  connect(Pref.y, VSC1.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, 130}, {-142, 130}, {-142, 130}}, color = {0, 0, 127}));
  connect(Pref.y, VSC2.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, 108}, {-142, 108}, {-142, 108}}, color = {0, 0, 127}));
  connect(Pref.y, VSC3.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, 78}, {-142, 78}, {-142, 78}}, color = {0, 0, 127}));
  connect(Pref.y, VSC4.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, 56}, {-142, 56}, {-142, 56}}, color = {0, 0, 127}));
  connect(Pref.y, VSC5.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, 24}, {-144, 24}, {-144, 24}, {-142, 24}}, color = {0, 0, 127}));
  connect(Pref.y, VSC6.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, 2}, {-142, 2}, {-142, 2}}, color = {0, 0, 127}));
  connect(Pref.y, VSC7.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, -28}, {-142, -28}, {-142, -28}}, color = {0, 0, 127}));
  connect(Pref.y, VSC8.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, -50}, {-142, -50}, {-142, -50}}, color = {0, 0, 127}));
  connect(Pref.y, VSC9.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, -82}, {-142, -82}, {-142, -82}}, color = {0, 0, 127}));
  connect(Pref.y, VSC10.pref) annotation(
    Line(points = {{-182, 26}, {-160, 26}, {-160, -106}, {-142, -106}, {-142, -106}}, color = {0, 0, 127}));
  connect(Qref.y, VSC1.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, 142}, {-142, 142}, {-142, 142}}, color = {0, 0, 127}));
  connect(Qref.y, VSC2.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, 120}, {-142, 120}, {-142, 120}}, color = {0, 0, 127}));
  connect(Qref.y, VSC3.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, 90}, {-142, 90}, {-142, 90}}, color = {0, 0, 127}));
  connect(Qref.y, VSC4.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, 68}, {-142, 68}, {-142, 68}}, color = {0, 0, 127}));
  connect(Qref.y, VSC5.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, 36}, {-142, 36}, {-142, 36}}, color = {0, 0, 127}));
  connect(Qref.y, VSC6.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, 14}, {-144, 14}, {-144, 14}, {-142, 14}}, color = {0, 0, 127}));
  connect(Qref.y, VSC7.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, -16}, {-142, -16}, {-142, -16}}, color = {0, 0, 127}));
  connect(Qref.y, VSC8.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, -38}, {-142, -38}, {-142, -38}}, color = {0, 0, 127}));
  connect(Qref.y, VSC9.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, -70}, {-142, -70}, {-142, -70}}, color = {0, 0, 127}));
  connect(Qref.y, VSC10.qref) annotation(
    Line(points = {{-182, 12}, {-160, 12}, {-160, -94}, {-142, -94}, {-142, -94}}, color = {0, 0, 127}));
  connect(T1.in1, VSC1.plv) annotation(
    Line(points = {{-94, 127}, {-100, 127}, {-100, 136}, {-118, 136}}, color = {0, 0, 255}));
  connect(T1.in2, VSC2.plv) annotation(
    Line(points = {{-94, 121}, {-100, 121}, {-100, 114}, {-118, 114}}, color = {0, 0, 255}));
  connect(T2.in1, VSC3.plv) annotation(
    Line(points = {{-94, 75}, {-100, 75}, {-100, 84}, {-118, 84}}, color = {0, 0, 255}));
  connect(T2.in2, VSC4.plv) annotation(
    Line(points = {{-94, 69}, {-100, 69}, {-100, 62}, {-118, 62}}, color = {0, 0, 255}));
  connect(T3.in1, VSC5.plv) annotation(
    Line(points = {{-94, 23}, {-100, 23}, {-100, 30}, {-118, 30}}, color = {0, 0, 255}));
  connect(T3.in2, VSC6.plv) annotation(
    Line(points = {{-94, 17}, {-100, 17}, {-100, 8}, {-118, 8}}, color = {0, 0, 255}));
  connect(T5.in1, VSC7.plv) annotation(
    Line(points = {{-94, -29}, {-100, -29}, {-100, -22}, {-118, -22}}, color = {0, 0, 255}));
  connect(T5.in2, VSC8.plv) annotation(
    Line(points = {{-94, -35}, {-100, -35}, {-100, -44}, {-118, -44}}, color = {0, 0, 255}));
  connect(T4.in2, VSC10.plv) annotation(
    Line(points = {{-94, -91}, {-100, -91}, {-100, -100}, {-118, -100}}, color = {0, 0, 255}));
  connect(T4.in1, VSC9.plv) annotation(
    Line(points = {{-94, -85}, {-100, -85}, {-100, -76}, {-118, -76}}, color = {0, 0, 255}));
  connect(pllmv.Va_grid, Vpcc.phi[1]) annotation(
    Line(points = {{100, 32}, {100, 32}, {100, 28}, {106, 28}, {106, 28}}, color = {0, 0, 127}));
  connect(Vpcc.phi[2], pllmv.Vb_grid) annotation(
    Line(points = {{106, 28}, {106, 28}, {106, 32}, {106, 32}}, color = {0, 0, 127}));
  connect(Vpcc.phi[3], pllmv.Vc_grid) annotation(
    Line(points = {{106, 28}, {112, 28}, {112, 32}, {112, 32}, {112, 32}}, color = {0, 0, 127}));
  connect(Vpcc.plug_p, Lg.plug_p) annotation(
    Line(points = {{106, 6}, {106, 6}, {106, 0}, {132, 0}, {132, 0}}));
  connect(pcc, Cpcc.plug_p) annotation(
    Line(points = {{0, 0}, {74, 0}, {74, 0}, {74, 0}}, color = {0, 0, 255}));
  connect(T1.out3, line1.p) annotation(
    Line(points = {{-74, 124}, {-66, 124}}));
  connect(line1.n, pcc) annotation(
    Line(points = {{-46, 124}, {-34, 124}, {-34, 0}, {0, 0}, {0, 0}}));
  connect(T2.out3, line2.p) annotation(
    Line(points = {{-74, 72}, {-66, 72}}, color = {0, 0, 255}));
  connect(line2.n, pcc) annotation(
    Line(points = {{-46, 72}, {-34, 72}, {-34, 0}, {0, 0}, {0, 0}}, color = {0, 0, 255}));
  connect(T3.out3, line3.p) annotation(
    Line(points = {{-74, 20}, {-66, 20}}, color = {0, 0, 255}));
  connect(line3.n, pcc) annotation(
    Line(points = {{-46, 20}, {-32, 20}, {-32, 0}, {0, 0}, {0, 0}}, color = {0, 0, 255}));
  connect(T5.out3, line4.p) annotation(
    Line(points = {{-74, -32}, {-66, -32}}, color = {0, 0, 255}));
  connect(line4.n, pcc) annotation(
    Line(points = {{-46, -32}, {-34, -32}, {-34, 0}, {0, 0}, {0, 0}}, color = {0, 0, 255}));
  connect(T4.out3, line5.p) annotation(
    Line(points = {{-74, -88}, {-66, -88}}, color = {0, 0, 255}));
  connect(line5.n, pcc) annotation(
    Line(points = {{-46, -88}, {-32, -88}, {-32, 0}, {0, 0}, {0, 0}}, color = {0, 0, 255}));
  annotation(
    uses(Modelica(version = "3.2.3"), PowerSystems(version = "1.0.0"), iPSL(version = "1.1.0"), OpenIPSL(version = "2.0.0-dev")),
    Diagram(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(origin = {-33, 18}, fillPattern = FillPattern.Solid, extent = {{-1, 106}, {1, -106}}), Rectangle(origin = {173, -108}, extent = {{3, 4}, {-3, -4}})}));
end NGenPV2;
