model cabletest
  Modelica.Electrical.MultiPhase.Basic.Star star annotation(
    Placement(visible = true, transformation(origin = {204, -10}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {204, -36}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sources.SineVoltage MV(V = fill(35355.34, 3), freqHz = fill(50, 3))  annotation(
    Placement(visible = true, transformation(origin = {190, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Inductor Lg(L = fill(0.00076, 3))  annotation(
    Placement(visible = true, transformation(origin = {142, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Resistor Rg(R = fill(0.005, 3))  annotation(
    Placement(visible = true, transformation(origin = {166, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sensors.CurrentSensor Cpcc annotation(
    Placement(visible = true, transformation(origin = {84, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Interfaces.Plug pcc annotation(
    Placement(visible = true, transformation(origin = {0, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-20, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(star.pin_n, ground.p) annotation(
    Line(points = {{204, -20}, {204, -26}}, color = {0, 0, 255}));
  connect(star.plug_p, MV.plug_n) annotation(
    Line(points = {{204, 0}, {200, 0}}, color = {0, 0, 255}));
  connect(Lg.plug_n, Rg.plug_p) annotation(
    Line(points = {{152, 0}, {156, 0}}, color = {0, 0, 255}));
  connect(Rg.plug_n, MV.plug_p) annotation(
    Line(points = {{176, 0}, {180, 0}}, color = {0, 0, 255}));
  connect(Lg.plug_p, Cpcc.plug_n) annotation(
    Line(points = {{132, 0}, {94, 0}}, color = {0, 0, 255}));
  connect(Cpcc.plug_p, pcc) annotation(
    Line(points = {{74, 0}, {0, 0}, {0, 0}, {0, 0}}, color = {0, 0, 255}));
  annotation(
    uses(Modelica(version = "3.2.3"), PowerSystems(version = "1.0.0"), iPSL(version = "1.1.0"), OpenIPSL(version = "2.0.0-dev")),
    Diagram(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(origin = {173, -108}, extent = {{3, 4}, {-3, -4}})}));
end cabletest;
