model MPPTtest
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {-100, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vca annotation(
    Placement(visible = true, transformation(origin = {-80, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vcb annotation(
    Placement(visible = true, transformation(origin = {-60, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vcc annotation(
    Placement(visible = true, transformation(origin = {-40, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.MultiPhase.Basic.PlugToPins_p pp annotation(
    Placement(visible = true, transformation(origin = {-16, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.MultiPhase.Basic.Resistor Rc(R = fill(0.5, 3))  annotation(
    Placement(visible = true, transformation(origin = {14, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Inductor Lc(L = fill(0.0054, 3))  annotation(
    Placement(visible = true, transformation(origin = {46, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sensors.PotentialSensor PPCC annotation(
    Placement(visible = true, transformation(origin = {64, 30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.MultiPhase.Sensors.CurrentSensor Cs annotation(
    Placement(visible = true, transformation(origin = {130, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sources.SineVoltage Vg(V = fill(326, 3), freqHz = fill(50, 3), phase = {0, -2.0944, 2.0944})  annotation(
    Placement(visible = true, transformation(origin = {160, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Star star annotation(
    Placement(visible = true, transformation(origin = {192, 42}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {192, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner_control_pllm3 inner_control_pllm annotation(
    Placement(visible = true, transformation(origin = {39, -45}, extent = {{-15, -15}, {15, 15}}, rotation = 0)));
  inverterMod inverterModd annotation(
    Placement(visible = true, transformation(origin = {-60, -22}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Modelica.Electrical.MultiPhase.Basic.Inductor inductor(L = fill(0.00076, 3)) annotation(
    Placement(visible = true, transformation(origin = {104, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.CombiTimeTable QRref(extrapolation = Modelica.Blocks.Types.Extrapolation.HoldLastPoint, smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments, table = [0, 0]) annotation(
    Placement(visible = true, transformation(origin = {80, -134}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Outer_Control outer_Control annotation(
    Placement(visible = true, transformation(origin = {40, -102}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  Modelica.Blocks.Sources.Ramp Ipv(duration = 1.4, height = -0.5, offset = 32.5) annotation(
    Placement(visible = true, transformation(origin = {-190, -8}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Sources.Ramp Vpv(duration = 1.4, height = 134, offset = 934.4) annotation(
    Placement(visible = true, transformation(origin = {-154, -8}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  PVSystems.Control.MPPTController mPPTController(pkThreshold = 2.3, sampleTime = 0.0166, vrefStart = 932.88, vrefStep = 1.5) annotation(
    Placement(visible = true, transformation(origin = {-174, -62}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Sources.RealExpression va(y = inner_control_pllm.va)  annotation(
    Placement(visible = true, transformation(origin = {204, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression vb(y = inner_control_pllm.vb)  annotation(
    Placement(visible = true, transformation(origin = {204, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression vc(y = inner_control_pllm.vc)  annotation(
    Placement(visible = true, transformation(origin = {204, -70}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression ia(y = inner_control_pllm.ia)  annotation(
    Placement(visible = true, transformation(origin = {204, -90}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression ib(y = inner_control_pllm.ib)  annotation(
    Placement(visible = true, transformation(origin = {204, -104}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression ic(y = inner_control_pllm.ic)  annotation(
    Placement(visible = true, transformation(origin = {204, -118}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Blocks.Sources.RealExpression theta1(y = inner_control_pllm.theta)  annotation(
    Placement(visible = true, transformation(origin = {156, -36}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Pac_Qac_Calculation pac_Qac_Calculation annotation(
    Placement(visible = true, transformation(origin = {156, -80}, extent = {{-14, -14}, {14, 14}}, rotation = -90)));
  Modelica.Blocks.Sources.RealExpression Vref(y = Vpv.y)  annotation(
    Placement(visible = true, transformation(origin = {-92, -70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(Vca.n, ground.p) annotation(
    Line(points = {{-90, 70}, {-100, 70}, {-100, 52}}, color = {0, 0, 255}));
  connect(Vcb.n, ground.p) annotation(
    Line(points = {{-70, 52}, {-100, 52}}, color = {0, 0, 255}));
  connect(Vca.p, pp.pin_p[1]) annotation(
    Line(points = {{-70, 70}, {-18, 70}, {-18, 52}}, color = {0, 0, 255}));
  connect(Vcb.p, pp.pin_p[2]) annotation(
    Line(points = {{-50, 52}, {-18, 52}}, color = {0, 0, 255}));
  connect(Vcc.p, pp.pin_p[3]) annotation(
    Line(points = {{-30, 34}, {-18, 34}, {-18, 52}}, color = {0, 0, 255}));
  connect(pp.plug_p, Rc.plug_p) annotation(
    Line(points = {{-14, 52}, {4, 52}}, color = {0, 0, 255}));
  connect(Rc.plug_n, Lc.plug_p) annotation(
    Line(points = {{24, 52}, {36, 52}}, color = {0, 0, 255}));
  connect(ground.p, Vcc.n) annotation(
    Line(points = {{-100, 52}, {-100, 34}, {-50, 34}}, color = {0, 0, 255}));
  connect(Cs.plug_n, Vg.plug_p) annotation(
    Line(points = {{140, 52}, {150, 52}}, color = {0, 0, 255}));
  connect(Vg.plug_n, star.plug_p) annotation(
    Line(points = {{170, 52}, {192, 52}}, color = {0, 0, 255}));
  connect(star.pin_n, ground1.p) annotation(
    Line(points = {{192, 32}, {192, 24}}, color = {0, 0, 255}));
  connect(PPCC.phi[1], inner_control_pllm.va) annotation(
    Line(points = {{64, 18}, {64, 18}, {64, -32}, {56, -32}, {56, -32}}, color = {0, 0, 127}));
  connect(PPCC.phi[2], inner_control_pllm.vb) annotation(
    Line(points = {{64, 18}, {64, 18}, {64, -36}, {56, -36}, {56, -36}}, color = {0, 0, 127}));
  connect(Cs.i[1], inner_control_pllm.ia) annotation(
    Line(points = {{130, 41}, {130, -48}, {56, -48}, {56, -50}}, color = {0, 0, 127}));
  connect(Cs.i[2], inner_control_pllm.ib) annotation(
    Line(points = {{130, 41}, {130, -54}, {56, -54}}, color = {0, 0, 127}));
  connect(inner_control_pllm.ic, Cs.i[3]) annotation(
    Line(points = {{56, -60}, {130, -60}, {130, 41}}, color = {0, 0, 127}));
  connect(inner_control_pllm.vc, PPCC.phi[3]) annotation(
    Line(points = {{56, -42}, {64, -42}, {64, 18}, {64, 18}}, color = {0, 0, 127}));
  connect(PPCC.plug_p, Lc.plug_n) annotation(
    Line(points = {{64, 40}, {64, 40}, {64, 52}, {56, 52}, {56, 52}}, color = {0, 0, 255}));
  connect(Vcb.v, inverterModd.vb) annotation(
    Line(points = {{-60, 40}, {-60, -11}}, color = {0, 0, 127}));
  connect(inverterModd.va, Vca.v) annotation(
    Line(points = {{-65, -11}, {-65, 18}, {-80, 18}, {-80, 58}}, color = {0, 0, 127}));
  connect(inverterModd.vc, Vcc.v) annotation(
    Line(points = {{-55, -11}, {-55, 18}, {-40, 18}, {-40, 22}}, color = {0, 0, 127}));
  connect(inverterModd.theta, inner_control_pllm.theta) annotation(
    Line(points = {{-48, -22}, {-13, -22}, {-13, -40}, {22, -40}}, color = {0, 0, 127}));
  connect(inner_control_pllm.vd, inverterModd.vdref) annotation(
    Line(points = {{22, -56}, {-54, -56}, {-54, -34}}, color = {0, 0, 127}));
  connect(inner_control_pllm.vq, inverterModd.vqref) annotation(
    Line(points = {{22, -50}, {-66, -50}, {-66, -34}}, color = {0, 0, 127}));
  connect(Lc.plug_n, inductor.plug_p) annotation(
    Line(points = {{56, 52}, {94, 52}, {94, 52}, {94, 52}}, color = {0, 0, 255}));
  connect(inductor.plug_n, Cs.plug_p) annotation(
    Line(points = {{114, 52}, {120, 52}, {120, 52}, {120, 52}}, color = {0, 0, 255}));
  connect(outer_Control.qref, QRref.y[1]) annotation(
    Line(points = {{48, -114}, {48, -134}, {69, -134}}, color = {0, 0, 127}));
  connect(outer_Control.Vzq, inner_control_pllm.Vzq) annotation(
    Line(points = {{42, -114}, {44, -114}, {44, -122}, {12, -122}, {12, -32}, {22, -32}, {22, -32}}, color = {0, 0, 127}));
  connect(outer_Control.idref, inner_control_pllm.idref) annotation(
    Line(points = {{44, -90}, {44, -80}, {48, -80}, {48, -62}}, color = {0, 0, 127}));
  connect(inner_control_pllm.iqref, outer_Control.iqref) annotation(
    Line(points = {{30, -62}, {30, -80}, {36, -80}, {36, -90}}, color = {0, 0, 127}));
  connect(Ipv.y, mPPTController.u2) annotation(
    Line(points = {{-190, -19}, {-190, -16.75}, {-192, -16.75}, {-192, -42}, {-180, -42}, {-180, -50}}, color = {0, 0, 127}));
  connect(Vpv.y, mPPTController.u1) annotation(
    Line(points = {{-154, -19}, {-154, -42}, {-168, -42}, {-168, -50}}, color = {0, 0, 127}));
  connect(outer_Control.Vmppt, mPPTController.y) annotation(
    Line(points = {{32, -114}, {32, -134}, {-174, -134}, {-174, -73}}, color = {0, 0, 127}));
  connect(theta1.y, pac_Qac_Calculation.theta) annotation(
    Line(points = {{156, -46}, {156, -63}}, color = {0, 0, 127}));
  connect(va.y, pac_Qac_Calculation.Va_grid) annotation(
    Line(points = {{194, -40}, {182, -40}, {182, -68}, {172, -68}, {172, -68}}, color = {0, 0, 127}));
  connect(vb.y, pac_Qac_Calculation.Vb_grid) annotation(
    Line(points = {{194, -54}, {184, -54}, {184, -72}, {172, -72}, {172, -72}}, color = {0, 0, 127}));
  connect(pac_Qac_Calculation.Vc_grid, vc.y) annotation(
    Line(points = {{172, -76}, {186, -76}, {186, -70}, {194, -70}, {194, -70}, {194, -70}}, color = {0, 0, 127}));
  connect(ia.y, pac_Qac_Calculation.Ia_grid) annotation(
    Line(points = {{194, -90}, {186, -90}, {186, -82}, {172, -82}, {172, -82}}, color = {0, 0, 127}));
  connect(ib.y, pac_Qac_Calculation.Ib_grid) annotation(
    Line(points = {{194, -104}, {184, -104}, {184, -86}, {172, -86}, {172, -88}}, color = {0, 0, 127}));
  connect(pac_Qac_Calculation.Ic_grid, ic.y) annotation(
    Line(points = {{172, -92}, {182, -92}, {182, -118}, {194, -118}, {194, -118}}, color = {0, 0, 127}));
  connect(Vref.y, inverterModd.u) annotation(
    Line(points = {{-80, -70}, {-60, -70}, {-60, -34}, {-60, -34}}, color = {0, 0, 127}));
  connect(Vpv.y, outer_Control.vdcmeas) annotation(
    Line(points = {{-154, -18}, {-154, -18}, {-154, -126}, {38, -126}, {38, -114}, {38, -114}}, color = {0, 0, 127}));
  annotation(
    uses(iPSL(version = "1.1.0"), PVSystems(version = "0.6.3"), Modelica(version = "3.2.3"), PowerSystems(version = "1.0.0")),
  Diagram);
end MPPTtest;
