model VSC_voltage_source2
  Modelica.Electrical.Analog.Basic.Ground ground annotation(
    Placement(visible = true, transformation(origin = {-138, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sensors.CurrentSensor Cs annotation(
    Placement(visible = true, transformation(origin = {-30, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Sensors.PotentialSensor Vs annotation(
    Placement(visible = true, transformation(origin = {-54, 18}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Sources.SineVoltage Vza(V = 326, freqHz = 50)  annotation(
    Placement(visible = true, transformation(origin = {-122, 56}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SineVoltage Vzb(V = 326, freqHz = 50, phase = -2.0944)  annotation(
    Placement(visible = true, transformation(origin = {-122, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SineVoltage Vzc(V = 326, freqHz = 50, phase = 2.0944)  annotation(
    Placement(visible = true, transformation(origin = {-122, 24}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.PlugToPins_p pp annotation(
    Placement(visible = true, transformation(origin = {-102, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vca annotation(
    Placement(visible = true, transformation(origin = {64, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vcb annotation(
    Placement(visible = true, transformation(origin = {84, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Sources.SignalVoltage Vcc annotation(
    Placement(visible = true, transformation(origin = {108, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  Modelica.Electrical.Analog.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {120, 30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.PlugToPins_n pp1 annotation(
    Placement(visible = true, transformation(origin = {46, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Resistor Rc(R = fill(0.5, 3)) annotation(
    Placement(visible = true, transformation(origin = {24, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.MultiPhase.Basic.Inductor Lc(L = fill(0.0051, 3)) annotation(
    Placement(visible = true, transformation(origin = {-4, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Ref_Computation ref_Computation annotation(
    Placement(visible = true, transformation(origin = {-36, -78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Pac_Qac_Calculation pac_Qac_Calculation annotation(
    Placement(visible = true, transformation(origin = {-46, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.CombiTimeTable PRef(extrapolation = Modelica.Blocks.Types.Extrapolation.HoldLastPoint, smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments, table = [0, -3000; 0.3, -6000; 0.5, -1000; 0.8, -7000])  annotation(
    Placement(visible = true, transformation(origin = {-114, -66}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.CombiTimeTable QRref(extrapolation = Modelica.Blocks.Types.Extrapolation.HoldLastPoint, smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments, table = [0, 0; 0.3, -5000; 0.5, 0; 0.8, 2000; 0.9, -7000])  annotation(
    Placement(visible = true, transformation(origin = {-114, -98}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner_control_pllm2 inner_control_pllm2r annotation(
    Placement(visible = true, transformation(origin = {6, -10}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(Cs.plug_p, Vs.plug_p) annotation(
    Line(points = {{-40, 40}, {-40, 28}, {-54, 28}}, color = {0, 0, 255}));
  connect(Vza.p, ground.p) annotation(
    Line(points = {{-132, 56}, {-138, 56}, {-138, 10}}, color = {0, 0, 255}));
  connect(Vzb.p, ground.p) annotation(
    Line(points = {{-132, 40}, {-138, 40}, {-138, 10}}, color = {0, 0, 255}));
  connect(Vzc.p, ground.p) annotation(
    Line(points = {{-132, 24}, {-138, 24}, {-138, 10}}, color = {0, 0, 255}));
  connect(pp.pin_p[1], Vza.n) annotation(
    Line(points = {{-104, 40}, {-104, 56}, {-112, 56}}, color = {0, 0, 255}));
  connect(pp.pin_p[2], Vzb.n) annotation(
    Line(points = {{-104, 40}, {-112, 40}}, color = {0, 0, 255}));
  connect(pp.pin_p[3], Vzc.n) annotation(
    Line(points = {{-104, 40}, {-104, 24}, {-112, 24}}, color = {0, 0, 255}));
  connect(Vca.p, ground1.p) annotation(
    Line(points = {{74, 60}, {120, 60}, {120, 40}}, color = {0, 0, 255}));
  connect(Vcc.p, ground1.p) annotation(
    Line(points = {{118, 20}, {120, 20}, {120, 40}, {120, 40}}, color = {0, 0, 255}));
  connect(Vcb.p, ground1.p) annotation(
    Line(points = {{94, 40}, {120, 40}, {120, 40}, {120, 40}}, color = {0, 0, 255}));
  connect(Vcc.n, pp1.pin_n[3]) annotation(
    Line(points = {{98, 20}, {48, 20}, {48, 40}}, color = {0, 0, 255}));
  connect(Vcb.n, pp1.pin_n[2]) annotation(
    Line(points = {{74, 40}, {48, 40}}, color = {0, 0, 255}));
  connect(Vca.n, pp1.pin_n[1]) annotation(
    Line(points = {{54, 60}, {48, 60}, {48, 40}}, color = {0, 0, 255}));
  connect(pp1.plug_n, Rc.plug_n) annotation(
    Line(points = {{44, 40}, {34, 40}}, color = {0, 0, 255}));
  connect(Lc.plug_p, Cs.plug_n) annotation(
    Line(points = {{-14, 40}, {-20, 40}, {-20, 40}, {-20, 40}}, color = {0, 0, 255}));
  connect(Rc.plug_p, Lc.plug_n) annotation(
    Line(points = {{14, 40}, {6, 40}}, color = {0, 0, 255}));
  connect(pp.plug_p, Cs.plug_p) annotation(
    Line(points = {{-100, 40}, {-40, 40}, {-40, 40}, {-40, 40}}, color = {0, 0, 255}));
  connect(PRef.y[1], ref_Computation.Pref) annotation(
    Line(points = {{-103, -66}, {-86, -66}, {-86, -78}, {-48, -78}}, color = {0, 0, 127}));
  connect(QRref.y[1], ref_Computation.Qref) annotation(
    Line(points = {{-102, -98}, {-86, -98}, {-86, -86}, {-48, -86}, {-48, -86}}, color = {0, 0, 127}));
  connect(inner_control_pllm2r.Varef, Vca.v) annotation(
    Line(points = {{18, -12}, {64, -12}, {64, 48}, {64, 48}}, color = {0, 0, 127}));
  connect(inner_control_pllm2r.Vbref, Vcb.v) annotation(
    Line(points = {{18, -14}, {84, -14}, {84, 28}, {84, 28}}, color = {0, 0, 127}));
  connect(inner_control_pllm2r.Vcref, Vcc.v) annotation(
    Line(points = {{18, -18}, {108, -18}, {108, 8}, {108, 8}}, color = {0, 0, 127}));
  connect(ref_Computation.iqref, inner_control_pllm2r.iqref) annotation(
    Line(points = {{-24, -82}, {12, -82}, {12, -22}, {12, -22}}, color = {0, 0, 127}));
  connect(ref_Computation.idref, inner_control_pllm2r.idref) annotation(
    Line(points = {{-24, -74}, {0, -74}, {0, -22}, {0, -22}}, color = {0, 0, 127}));
  connect(ref_Computation.Vzq, inner_control_pllm2r.Vzq) annotation(
    Line(points = {{-48, -70}, {-54, -70}, {-54, -62}, {30, -62}, {30, -2}, {18, -2}, {18, -2}}, color = {0, 0, 127}));
  connect(pac_Qac_Calculation.theta, inner_control_pllm2r.theta) annotation(
    Line(points = {{-58, -40}, {-68, -40}, {-68, 14}, {22, 14}, {22, -6}, {18, -6}}, color = {0, 0, 127}));
  connect(Vs.phi[1], pac_Qac_Calculation.Va_grid) annotation(
    Line(points = {{-54, 8}, {-54, 8}, {-54, -28}, {-54, -28}}, color = {0, 0, 127}));
  connect(Vs.phi[2], pac_Qac_Calculation.Vb_grid) annotation(
    Line(points = {{-54, 8}, {-54, 8}, {-54, -26}, {-52, -26}, {-52, -28}, {-52, -28}}, color = {0, 0, 127}));
  connect(Vs.phi[3], pac_Qac_Calculation.Vc_grid) annotation(
    Line(points = {{-54, 8}, {-54, 8}, {-54, -26}, {-48, -26}, {-48, -28}, {-48, -28}}, color = {0, 0, 127}));
  connect(Cs.i[1], pac_Qac_Calculation.Ia_grid) annotation(
    Line(points = {{-30, 30}, {-30, 30}, {-30, -18}, {-44, -18}, {-44, -28}, {-44, -28}}, color = {0, 0, 127}));
  connect(Cs.i[2], pac_Qac_Calculation.Ib_grid) annotation(
    Line(points = {{-30, 30}, {-30, 30}, {-30, -18}, {-40, -18}, {-40, -28}, {-40, -28}}, color = {0, 0, 127}));
  connect(Cs.i[3], pac_Qac_Calculation.Ic_grid) annotation(
    Line(points = {{-30, 30}, {-30, 30}, {-30, -24}, {-38, -24}, {-38, -28}, {-38, -28}}, color = {0, 0, 127}));
  connect(Vs.phi[1], inner_control_pllm2r.va) annotation(
    Line(points = {{-54, 8}, {-54, 8}, {-54, 0}, {-6, 0}, {-6, 0}}, color = {0, 0, 127}));
  connect(Vs.phi[2], inner_control_pllm2r.vb) annotation(
    Line(points = {{-54, 8}, {-54, 8}, {-54, -4}, {-6, -4}, {-6, -4}}, color = {0, 0, 127}));
  connect(Vs.phi[3], inner_control_pllm2r.vc) annotation(
    Line(points = {{-54, 8}, {-54, 8}, {-54, -8}, {-6, -8}, {-6, -8}}, color = {0, 0, 127}));
  connect(Cs.i[1], inner_control_pllm2r.ia) annotation(
    Line(points = {{-30, 30}, {-30, 30}, {-30, -12}, {-6, -12}, {-6, -12}}, color = {0, 0, 127}));
  connect(Cs.i[2], inner_control_pllm2r.ib) annotation(
    Line(points = {{-30, 30}, {-30, 30}, {-30, -16}, {-6, -16}, {-6, -16}}, color = {0, 0, 127}));
  connect(Cs.i[3], inner_control_pllm2r.ic) annotation(
    Line(points = {{-30, 30}, {-30, 30}, {-30, -20}, {-6, -20}, {-6, -20}}, color = {0, 0, 127}));
  annotation(
    uses(Modelica(version = "3.2.3")),
    Diagram(graphics = {Bitmap(extent = {{-52, -84}, {-52, -84}})}, coordinateSystem(initialScale = 0.1)));
end VSC_voltage_source2;
