class VariableFilterWorking
  Real an_nh_naca_v(quantity = "ElectricPotential", unit = "V") "Voltage drop of the two pins (= p_v - n_v)";
  Real an_nh_naca_i(quantity = "ElectricCurrent", unit = "A") "Current flowing from pin p to pin n";
  Real an_nh_naca_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_naca_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real an_nh_naca_n_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_naca_n_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real an_nh_naca_c_sub_c(quantity = "Concentration", unit = "mol/m3");
  Real an_nh_naca_c_sub_rate(quantity = "Concentration", unit = "mol/m3");
  parameter Real an_nh_naca_V_sub = 1.0;
  Real an_nh_naca_sodium_c_in(quantity = "Concentration", unit = "mol/m3") = an_nh_sodium_c_in "concentration inside the cell in mol/m³";
  Real an_nh_naca_sodium_c_ex(quantity = "Concentration", unit = "mol/m3") = an_nh_sodium_c_ex "concentration outside the cell in mol/m³";
  Real an_nh_naca_sodium_p(quantity = "Permeability (fluid mechanics)", unit = "m3/(s_m2)") = an_nh_sodium_p "permeability of membrane for ion in m² (fluid mechanics)";
  Integer an_nh_naca_sodium_z = an_nh_sodium_z "valence of the ion";
  Real an_nh_naca_calcium_c_in(quantity = "Concentration", unit = "mol/m3") = an_nh_calcium_c_in "concentration inside the cell in mol/m³";
  Real an_nh_naca_calcium_c_ex(quantity = "Concentration", unit = "mol/m3") = an_nh_calcium_c_ex "concentration outside the cell in mol/m³";
  Real an_nh_naca_calcium_p(quantity = "Permeability (fluid mechanics)", unit = "m3/(s_m2)") = an_nh_calcium_p "permeability of membrane for ion in m² (fluid mechanics)";
  Integer an_nh_naca_calcium_z = an_nh_calcium_z "valence of the ion";
  parameter Real an_nh_naca_K_c_i(quantity = "Concentration", unit = "mol/m3") = 0.0207 "dissociation constant for channel with Ca++ bound on inside";
  parameter Real an_nh_naca_K_cn_i(quantity = "Concentration", unit = "mol/m3") = 26.44 "dissociation constant for channel with Ca++ and one Na+ bound on inside";
  parameter Real an_nh_naca_K_1n_i(quantity = "Concentration", unit = "mol/m3") = 395.3 "dissociation constant for channel with one Na+ bound on inside";
  parameter Real an_nh_naca_K_2n_i(quantity = "Concentration", unit = "mol/m3") = 2.289 "dissociation constant for channel with two Na+ bound on inside";
  parameter Real an_nh_naca_K_3n_i(quantity = "Concentration", unit = "mol/m3") = 26.44 "dissociation constant for channel with three Na+ bound on inside";
  parameter Real an_nh_naca_K_c_o(quantity = "Concentration", unit = "mol/m3") = 3.663 "dissociation constant for channel with Ca++ bound on outside";
  parameter Real an_nh_naca_K_1n_o(quantity = "Concentration", unit = "mol/m3") = 1628.0 "dissociation constant for channel with one Na+ bound on outside";
  parameter Real an_nh_naca_K_2n_o(quantity = "Concentration", unit = "mol/m3") = 561.4 "dissociation constant for channel with two Na+ bound on outside";
  parameter Real an_nh_naca_K_3n_o(quantity = "Concentration", unit = "mol/m3") = 4.663 "dissociation constant for channel with three Na+ bound on outside";
  parameter Real an_nh_naca_Q_ci = 0.1369 "fractional charge movement during intracellular Ca++ occlusion reaction";
  parameter Real an_nh_naca_Q_co = 0.0 "fractional charge movement during extracellular Ca++ occlusion reaction";
  parameter Real an_nh_naca_Q_n = 0.4315 "fractional charge movement during Na+ occlusion reactions";
  parameter Real an_nh_naca_k_NaCa(quantity = "ElectricCurrent", unit = "A") = 5.92e-09 "scaling factor for Na+/Ca++ exchanger current";
  Real an_nh_naca_di_c = an_nh_naca_c_sub_c / an_nh_naca_K_c_i "relative frequency of E1 states that are occupied by Ca2+ and not occluded";
  Real an_nh_naca_di_cv = an_nh_naca_di_c * exp((-an_nh_naca_Q_ci) * an_nh_naca_v * an_nh_naca_FoRT) "relative frequency of E1 states that are occupied by Ca2+ and occluded";
  Real an_nh_naca_di_cn = an_nh_naca_di_c * an_nh_naca_sodium_c_in / an_nh_naca_K_cn_i "relative frequency of E1 states whose first two binding sites are occupied by Ca2+ and whose last binding site is occupied by Na+";
  Real an_nh_naca_di_1n = an_nh_naca_sodium_c_in / an_nh_naca_K_1n_i "relative frequency of E1 states where only the first Na+ site is occupied by Na+";
  Real an_nh_naca_di_2n = an_nh_naca_di_1n * an_nh_naca_sodium_c_in / an_nh_naca_K_2n_i "relative frequency of E1 states where exactly the first two Na+ sites are occupied by Na+";
  Real an_nh_naca_di_3n = an_nh_naca_di_2n * an_nh_naca_sodium_c_in / an_nh_naca_K_3n_i "relative frequency of E1 states where exactly three Na+ sites are occupied by Na+";
  Real an_nh_naca_di = 1.0 + an_nh_naca_di_c + an_nh_naca_di_cv + an_nh_naca_di_cn + an_nh_naca_di_1n + an_nh_naca_di_2n + an_nh_naca_di_3n "common denominator summing relative frequencies for all E1 substates";
  Real an_nh_naca_do_c = an_nh_naca_calcium_c_ex / an_nh_naca_K_c_o "relative frequency of E2 states that are occupied by Ca2+ and not occluded";
  Real an_nh_naca_do_cv = an_nh_naca_do_c * exp(an_nh_naca_Q_co * an_nh_naca_v * an_nh_naca_FoRT) "relative frequency of E2 states that are occupied by Ca2+ and occluded";
  Real an_nh_naca_do_1n = an_nh_naca_sodium_c_ex / an_nh_naca_K_1n_o "relative frequency of E2 states where only the first Na+ site is occupied by Na+";
  Real an_nh_naca_do_2n = an_nh_naca_do_1n * an_nh_naca_sodium_c_ex / an_nh_naca_K_2n_o "relative frequency of E2 states where exactly the first two Na+ sites are occupied by Na+";
  Real an_nh_naca_do_3n = an_nh_naca_do_2n * an_nh_naca_sodium_c_ex / an_nh_naca_K_3n_o "relative frequency of E2 states where exactly three Na+ sites are occupied by Na+";
  Real an_nh_naca_do = 1.0 + an_nh_naca_do_c + an_nh_naca_do_cv + an_nh_naca_do_1n + an_nh_naca_do_2n + an_nh_naca_do_3n "common denominator summing relative frequencies for all E2 substates";
  Real an_nh_naca_F_c_i = an_nh_naca_di_cv / an_nh_naca_di "fraction of E1 states with occluded Ca ions";
  Real an_nh_naca_F1_2n_i = (an_nh_naca_di_2n + an_nh_naca_di_3n) / an_nh_naca_di "fraction of E1 states whose first two Na+ sites are occupied by Na+";
  Real an_nh_naca_F1_3n_i = an_nh_naca_sodium_c_in / ((1.0 + an_nh_naca_sodium_c_in / an_nh_naca_K_3n_i) * an_nh_naca_K_3n_i) "fraction of E1 states whose first two Na+ sites are occupied by Na+";
  Real an_nh_naca_F_c_o = an_nh_naca_do_cv / an_nh_naca_do "fraction of E2 states with occluded Ca ions";
  Real an_nh_naca_F1_2n_o = (an_nh_naca_do_2n + an_nh_naca_do_3n) / an_nh_naca_do "fraction of E2 states whose first two Na+ sites are occupied by Na+";
  Real an_nh_naca_F1_3n_o = an_nh_naca_sodium_c_ex / ((1.0 + an_nh_naca_sodium_c_ex / an_nh_naca_K_3n_o) * an_nh_naca_K_3n_o) "fraction of E2 states whose first two Na+ sites are occupied by Na+";
  Real an_nh_naca_k_12 = an_nh_naca_F_c_i "rate constant for transition from E1 to E2";
  Real an_nh_naca_k_21 = an_nh_naca_F_c_o "rate constant for transition from E2 to E1";
  Real an_nh_naca_k_23 = an_nh_naca_F1_2n_o / an_nh_naca_na_v "rate constant for transition from E2 to E3";
  Real an_nh_naca_k_32 = an_nh_naca_na_v "rate constant for transition from E3 to E2";
  Real an_nh_naca_k_34 = an_nh_naca_F1_3n_o "rate constant for transition from E3 to E4";
  Real an_nh_naca_k_43 = an_nh_naca_F1_3n_i "rate constant for transition from E4 to E3";
  Real an_nh_naca_k_41 = 1.0 / an_nh_naca_na_v "rate constant for transition from E4 to E1";
  Real an_nh_naca_k_14 = an_nh_naca_F1_2n_i * an_nh_naca_na_v "rate constant for transition from E1 to E4";
  Real an_nh_naca_x1 = an_nh_naca_k_34 * an_nh_naca_k_41 * (an_nh_naca_k_23 + an_nh_naca_k_21) + an_nh_naca_k_21 * an_nh_naca_k_32 * (an_nh_naca_k_43 + an_nh_naca_k_41) "relative frequency of E1 states";
  Real an_nh_naca_x2 = an_nh_naca_k_43 * an_nh_naca_k_32 * (an_nh_naca_k_14 + an_nh_naca_k_12) + an_nh_naca_k_41 * an_nh_naca_k_12 * (an_nh_naca_k_34 + an_nh_naca_k_32) "relative frequency of E2 states";
  Real an_nh_naca_x3 = an_nh_naca_k_43 * an_nh_naca_k_14 * (an_nh_naca_k_23 + an_nh_naca_k_21) + an_nh_naca_k_12 * an_nh_naca_k_23 * (an_nh_naca_k_43 + an_nh_naca_k_41) "relative frequency of E3 states";
  Real an_nh_naca_x4 = an_nh_naca_k_34 * an_nh_naca_k_23 * (an_nh_naca_k_14 + an_nh_naca_k_12) + an_nh_naca_k_21 * an_nh_naca_k_14 * (an_nh_naca_k_34 + an_nh_naca_k_32) "relative frequancy of E4 states";
  Real an_nh_naca_d = an_nh_naca_x1 + an_nh_naca_x2 + an_nh_naca_x3 + an_nh_naca_x4 "common denominator to turn relative frequencies into actual ratios between 0 and 1";
  Real an_nh_naca_E1 = an_nh_naca_x1 / an_nh_naca_d "ratio of exchanger molecules in state E1";
  Real an_nh_naca_E2 = an_nh_naca_x2 / an_nh_naca_d "ratio of exchanger molecules in state E2";
  Real an_nh_naca_E3 = an_nh_naca_x3 / an_nh_naca_d "ratio of exchanger molecules in state E3";
  Real an_nh_naca_E4 = an_nh_naca_x4 / an_nh_naca_d "ratio of exchanger molecules in state E4";
  parameter Real an_nh_naca_FoRT = 11604.52214706721 / an_nh_T;
  Real an_nh_naca_na_v = exp(0.5 * an_nh_naca_Q_n * an_nh_naca_v * an_nh_naca_FoRT);
  Real an_nh_l2_v(quantity = "ElectricPotential", unit = "V") "Voltage drop of the two pins (= p_v - n_v)";
  Real an_nh_l2_i(quantity = "ElectricCurrent", unit = "A") "Current flowing from pin p to pin n";
  Real an_nh_l2_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_l2_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real an_nh_l2_n_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_l2_n_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  parameter Real an_nh_l2_C(quantity = "Permittivity", unit = "F/m", min = 0.0) = 4e-11 "membrane permittivity (i_e. capacitance per m²)";
  parameter Real an_nh_l2_V_init(quantity = "ElectricPotential", unit = "V") = -0.09 "initial potential (from short initial stimulation)";
  parameter Boolean an_nh_l2_use_init = false "determines whether initial value for v is used";
  parameter Real an_nh_T(quantity = "ThermodynamicTemperature", unit = "K", displayUnit = "degC", min = 0.0, start = 288.15, nominal = 300.0) = 310.0;
  Real an_nh_vc_v(quantity = "ElectricPotential", unit = "V") "Voltage drop of the two pins (= p_v - n_v)";
  Real an_nh_vc_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_vc_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real an_nh_vc_n_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_vc_n_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real an_nh_vc_stim_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_vc_stim_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real an_nh_vc_stim_n_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_vc_stim_n_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real an_nh_vc_stim_v(unit = "V") = an_nh_vc_v_stim "Voltage between pin p and n (= p_v - n_v) as input signal";
  Real an_nh_vc_stim_i(quantity = "ElectricCurrent", unit = "A") "Current flowing from pin p to pin n";
  Real an_nh_vc_g_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real an_nh_vc_g_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real an_nh_vc_v_stim(quantity = "ElectricPotential", unit = "V");
  Real an_nh_vc_i(quantity = "ElectricCurrent", unit = "A") = -an_nh_vc_stim_i "measured membrane current";
  Real an_nh_sodium_c_in(quantity = "Concentration", unit = "mol/m3") = 8.0 "concentration inside the cell in mol/m³";
  Real an_nh_sodium_c_ex(quantity = "Concentration", unit = "mol/m3") = 140.0 "concentration outside the cell in mol/m³";
  Real an_nh_sodium_p(quantity = "Permeability (fluid mechanics)", unit = "m3/(s_m2)") = 0.0 "permeability of membrane for ion in m² (fluid mechanics)";
  Integer an_nh_sodium_z = 1 "valence of the ion";
  Real an_nh_calcium_c_in(quantity = "Concentration", unit = "mol/m3") = 0.0 "concentration inside the cell in mol/m³";
  Real an_nh_calcium_c_ex(quantity = "Concentration", unit = "mol/m3") = 2.5 "concentration outside the cell in mol/m³";
  Real an_nh_calcium_p(quantity = "Permeability (fluid mechanics)", unit = "m3/(s_m2)") = 0.0 "permeability of membrane for ion in m² (fluid mechanics)";
  Integer an_nh_calcium_z = 2 "valence of the ion";
  Real an_nh_ca_sub_c_c(quantity = "Concentration", unit = "mol/m3");
  Real an_nh_ca_sub_c_rate(quantity = "Concentration", unit = "mol/m3");
  parameter Real an_nh_ca_sub_c_const(quantity = "Concentration", unit = "mol/m3") = 0.00015;
  parameter Real an_nh_t_ramp_start = 0.05;
  parameter Real an_nh_ramp_duration = 0.25;
  parameter Real an_nh_ramp_start = 0.06;
  parameter Real an_nh_ramp_end = -0.08;
  parameter Real an_nh_v_hold = -0.04;
  Boolean an_nh_ramp = time > an_nh_t_ramp_start and time < an_nh_t_ramp_start + an_nh_ramp_duration;
  parameter Real an_nh_ramp_rate = (an_nh_ramp_end - an_nh_ramp_start) / an_nh_ramp_duration;
  Real n_naca_v(quantity = "ElectricPotential", unit = "V") "Voltage drop of the two pins (= p_v - n_v)";
  Real n_naca_i(quantity = "ElectricCurrent", unit = "A") "Current flowing from pin p to pin n";
  Real n_naca_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_naca_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real n_naca_n_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_naca_n_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real n_naca_c_sub_c(quantity = "Concentration", unit = "mol/m3");
  Real n_naca_c_sub_rate(quantity = "Concentration", unit = "mol/m3");
  parameter Real n_naca_V_sub = 1.0;
  Real n_naca_sodium_c_in(quantity = "Concentration", unit = "mol/m3") = n_sodium_c_in "concentration inside the cell in mol/m³";
  Real n_naca_sodium_c_ex(quantity = "Concentration", unit = "mol/m3") = n_sodium_c_ex "concentration outside the cell in mol/m³";
  Real n_naca_sodium_p(quantity = "Permeability (fluid mechanics)", unit = "m3/(s_m2)") = n_sodium_p "permeability of membrane for ion in m² (fluid mechanics)";
  Integer n_naca_sodium_z = n_sodium_z "valence of the ion";
  Real n_naca_calcium_c_in(quantity = "Concentration", unit = "mol/m3") = n_calcium_c_in "concentration inside the cell in mol/m³";
  Real n_naca_calcium_c_ex(quantity = "Concentration", unit = "mol/m3") = n_calcium_c_ex "concentration outside the cell in mol/m³";
  Real n_naca_calcium_p(quantity = "Permeability (fluid mechanics)", unit = "m3/(s_m2)") = n_calcium_p "permeability of membrane for ion in m² (fluid mechanics)";
  Integer n_naca_calcium_z = n_calcium_z "valence of the ion";
  parameter Real n_naca_K_c_i(quantity = "Concentration", unit = "mol/m3") = 0.0207 "dissociation constant for channel with Ca++ bound on inside";
  parameter Real n_naca_K_cn_i(quantity = "Concentration", unit = "mol/m3") = 26.44 "dissociation constant for channel with Ca++ and one Na+ bound on inside";
  parameter Real n_naca_K_1n_i(quantity = "Concentration", unit = "mol/m3") = 395.3 "dissociation constant for channel with one Na+ bound on inside";
  parameter Real n_naca_K_2n_i(quantity = "Concentration", unit = "mol/m3") = 2.289 "dissociation constant for channel with two Na+ bound on inside";
  parameter Real n_naca_K_3n_i(quantity = "Concentration", unit = "mol/m3") = 26.44 "dissociation constant for channel with three Na+ bound on inside";
  parameter Real n_naca_K_c_o(quantity = "Concentration", unit = "mol/m3") = 3.663 "dissociation constant for channel with Ca++ bound on outside";
  parameter Real n_naca_K_1n_o(quantity = "Concentration", unit = "mol/m3") = 1628.0 "dissociation constant for channel with one Na+ bound on outside";
  parameter Real n_naca_K_2n_o(quantity = "Concentration", unit = "mol/m3") = 561.4 "dissociation constant for channel with two Na+ bound on outside";
  parameter Real n_naca_K_3n_o(quantity = "Concentration", unit = "mol/m3") = 4.663 "dissociation constant for channel with three Na+ bound on outside";
  parameter Real n_naca_Q_ci = 0.1369 "fractional charge movement during intracellular Ca++ occlusion reaction";
  parameter Real n_naca_Q_co = 0.0 "fractional charge movement during extracellular Ca++ occlusion reaction";
  parameter Real n_naca_Q_n = 0.4315 "fractional charge movement during Na+ occlusion reactions";
  parameter Real n_naca_k_NaCa(quantity = "ElectricCurrent", unit = "A") = 2.14e-09 "scaling factor for Na+/Ca++ exchanger current";
  Real n_naca_di_c = n_naca_c_sub_c / n_naca_K_c_i "relative frequency of E1 states that are occupied by Ca2+ and not occluded";
  Real n_naca_di_cv = n_naca_di_c * exp((-n_naca_Q_ci) * n_naca_v * n_naca_FoRT) "relative frequency of E1 states that are occupied by Ca2+ and occluded";
  Real n_naca_di_cn = n_naca_di_c * n_naca_sodium_c_in / n_naca_K_cn_i "relative frequency of E1 states whose first two binding sites are occupied by Ca2+ and whose last binding site is occupied by Na+";
  Real n_naca_di_1n = n_naca_sodium_c_in / n_naca_K_1n_i "relative frequency of E1 states where only the first Na+ site is occupied by Na+";
  Real n_naca_di_2n = n_naca_di_1n * n_naca_sodium_c_in / n_naca_K_2n_i "relative frequency of E1 states where exactly the first two Na+ sites are occupied by Na+";
  Real n_naca_di_3n = n_naca_di_2n * n_naca_sodium_c_in / n_naca_K_3n_i "relative frequency of E1 states where exactly three Na+ sites are occupied by Na+";
  Real n_naca_di = 1.0 + n_naca_di_c + n_naca_di_cv + n_naca_di_cn + n_naca_di_1n + n_naca_di_2n + n_naca_di_3n "common denominator summing relative frequencies for all E1 substates";
  Real n_naca_do_c = n_naca_calcium_c_ex / n_naca_K_c_o "relative frequency of E2 states that are occupied by Ca2+ and not occluded";
  Real n_naca_do_cv = n_naca_do_c * exp(n_naca_Q_co * n_naca_v * n_naca_FoRT) "relative frequency of E2 states that are occupied by Ca2+ and occluded";
  Real n_naca_do_1n = n_naca_sodium_c_ex / n_naca_K_1n_o "relative frequency of E2 states where only the first Na+ site is occupied by Na+";
  Real n_naca_do_2n = n_naca_do_1n * n_naca_sodium_c_ex / n_naca_K_2n_o "relative frequency of E2 states where exactly the first two Na+ sites are occupied by Na+";
  Real n_naca_do_3n = n_naca_do_2n * n_naca_sodium_c_ex / n_naca_K_3n_o "relative frequency of E2 states where exactly three Na+ sites are occupied by Na+";
  Real n_naca_do = 1.0 + n_naca_do_c + n_naca_do_cv + n_naca_do_1n + n_naca_do_2n + n_naca_do_3n "common denominator summing relative frequencies for all E2 substates";
  Real n_naca_F_c_i = n_naca_di_cv / n_naca_di "fraction of E1 states with occluded Ca ions";
  Real n_naca_F1_2n_i = (n_naca_di_2n + n_naca_di_3n) / n_naca_di "fraction of E1 states whose first two Na+ sites are occupied by Na+";
  Real n_naca_F1_3n_i = n_naca_sodium_c_in / ((1.0 + n_naca_sodium_c_in / n_naca_K_3n_i) * n_naca_K_3n_i) "fraction of E1 states whose first two Na+ sites are occupied by Na+";
  Real n_naca_F_c_o = n_naca_do_cv / n_naca_do "fraction of E2 states with occluded Ca ions";
  Real n_naca_F1_2n_o = (n_naca_do_2n + n_naca_do_3n) / n_naca_do "fraction of E2 states whose first two Na+ sites are occupied by Na+";
  Real n_naca_F1_3n_o = n_naca_sodium_c_ex / ((1.0 + n_naca_sodium_c_ex / n_naca_K_3n_o) * n_naca_K_3n_o) "fraction of E2 states whose first two Na+ sites are occupied by Na+";
  Real n_naca_k_12 = n_naca_F_c_i "rate constant for transition from E1 to E2";
  Real n_naca_k_21 = n_naca_F_c_o "rate constant for transition from E2 to E1";
  Real n_naca_k_23 = n_naca_F1_2n_o / n_naca_na_v "rate constant for transition from E2 to E3";
  Real n_naca_k_32 = n_naca_na_v "rate constant for transition from E3 to E2";
  Real n_naca_k_34 = n_naca_F1_3n_o "rate constant for transition from E3 to E4";
  Real n_naca_k_43 = n_naca_F1_3n_i "rate constant for transition from E4 to E3";
  Real n_naca_k_41 = 1.0 / n_naca_na_v "rate constant for transition from E4 to E1";
  Real n_naca_k_14 = n_naca_F1_2n_i * n_naca_na_v "rate constant for transition from E1 to E4";
  Real n_naca_x1 = n_naca_k_34 * n_naca_k_41 * (n_naca_k_23 + n_naca_k_21) + n_naca_k_21 * n_naca_k_32 * (n_naca_k_43 + n_naca_k_41) "relative frequency of E1 states";
  Real n_naca_x2 = n_naca_k_43 * n_naca_k_32 * (n_naca_k_14 + n_naca_k_12) + n_naca_k_41 * n_naca_k_12 * (n_naca_k_34 + n_naca_k_32) "relative frequency of E2 states";
  Real n_naca_x3 = n_naca_k_43 * n_naca_k_14 * (n_naca_k_23 + n_naca_k_21) + n_naca_k_12 * n_naca_k_23 * (n_naca_k_43 + n_naca_k_41) "relative frequency of E3 states";
  Real n_naca_x4 = n_naca_k_34 * n_naca_k_23 * (n_naca_k_14 + n_naca_k_12) + n_naca_k_21 * n_naca_k_14 * (n_naca_k_34 + n_naca_k_32) "relative frequancy of E4 states";
  Real n_naca_d = n_naca_x1 + n_naca_x2 + n_naca_x3 + n_naca_x4 "common denominator to turn relative frequencies into actual ratios between 0 and 1";
  Real n_naca_E1 = n_naca_x1 / n_naca_d "ratio of exchanger molecules in state E1";
  Real n_naca_E2 = n_naca_x2 / n_naca_d "ratio of exchanger molecules in state E2";
  Real n_naca_E3 = n_naca_x3 / n_naca_d "ratio of exchanger molecules in state E3";
  Real n_naca_E4 = n_naca_x4 / n_naca_d "ratio of exchanger molecules in state E4";
  parameter Real n_naca_FoRT = 11604.52214706721 / n_T;
  Real n_naca_na_v = exp(0.5 * n_naca_Q_n * n_naca_v * n_naca_FoRT);
  Real n_l2_v(quantity = "ElectricPotential", unit = "V") "Voltage drop of the two pins (= p_v - n_v)";
  Real n_l2_i(quantity = "ElectricCurrent", unit = "A") "Current flowing from pin p to pin n";
  Real n_l2_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_l2_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real n_l2_n_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_l2_n_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  parameter Real n_l2_C(quantity = "Permittivity", unit = "F/m", min = 0.0) = 2.9e-11 "membrane permittivity (i_e. capacitance per m²)";
  parameter Real n_l2_V_init(quantity = "ElectricPotential", unit = "V") = -0.09 "initial potential (from short initial stimulation)";
  parameter Boolean n_l2_use_init = false "determines whether initial value for v is used";
  parameter Real n_T(quantity = "ThermodynamicTemperature", unit = "K", displayUnit = "degC", min = 0.0, start = 288.15, nominal = 300.0) = 310.0;
  Real n_vc_v(quantity = "ElectricPotential", unit = "V") "Voltage drop of the two pins (= p_v - n_v)";
  Real n_vc_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_vc_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real n_vc_n_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_vc_n_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real n_vc_stim_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_vc_stim_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real n_vc_stim_n_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_vc_stim_n_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real n_vc_stim_v(unit = "V") = n_vc_v_stim "Voltage between pin p and n (= p_v - n_v) as input signal";
  Real n_vc_stim_i(quantity = "ElectricCurrent", unit = "A") "Current flowing from pin p to pin n";
  Real n_vc_g_p_v(quantity = "ElectricPotential", unit = "V") "Potential at the pin";
  Real n_vc_g_p_i(quantity = "ElectricCurrent", unit = "A") "Current flowing into the pin";
  Real n_vc_v_stim(quantity = "ElectricPotential", unit = "V");
  Real n_vc_i(quantity = "ElectricCurrent", unit = "A") = -n_vc_stim_i "measured membrane current";
  Real n_sodium_c_in(quantity = "Concentration", unit = "mol/m3") = 8.0 "concentration inside the cell in mol/m³";
  Real n_sodium_c_ex(quantity = "Concentration", unit = "mol/m3") = 140.0 "concentration outside the cell in mol/m³";
  Real n_sodium_p(quantity = "Permeability (fluid mechanics)", unit = "m3/(s_m2)") = 0.0 "permeability of membrane for ion in m² (fluid mechanics)";
  Integer n_sodium_z = 1 "valence of the ion";
  Real n_calcium_c_in(quantity = "Concentration", unit = "mol/m3") = 0.0 "concentration inside the cell in mol/m³";
  Real n_calcium_c_ex(quantity = "Concentration", unit = "mol/m3") = 2.5 "concentration outside the cell in mol/m³";
  Real n_calcium_p(quantity = "Permeability (fluid mechanics)", unit = "m3/(s_m2)") = 0.0 "permeability of membrane for ion in m² (fluid mechanics)";
  Integer n_calcium_z = 2 "valence of the ion";
  Real n_ca_sub_c_c(quantity = "Concentration", unit = "mol/m3");
  Real n_ca_sub_c_rate(quantity = "Concentration", unit = "mol/m3");
  parameter Real n_ca_sub_c_const(quantity = "Concentration", unit = "mol/m3") = 0.00015;
  parameter Real n_t_ramp_start = 0.05;
  parameter Real n_ramp_duration = 0.25;
  parameter Real n_ramp_start = 0.06;
  parameter Real n_ramp_end = -0.08;
  parameter Real n_v_hold = -0.04;
  Boolean n_ramp = time > n_t_ramp_start and time < n_t_ramp_start + n_ramp_duration;
  parameter Real n_ramp_rate = (n_ramp_end - n_ramp_start) / n_ramp_duration;
equation
  an_nh_naca_i = an_nh_naca_k_NaCa * (an_nh_naca_k_21 * an_nh_naca_E2 - an_nh_naca_k_12 * an_nh_naca_E1);
  an_nh_naca_c_sub_rate = 1.03642695739058e-05 * an_nh_naca_i / an_nh_naca_V_sub;
  an_nh_naca_v = an_nh_naca_p_v - an_nh_naca_n_v;
  0.0 = an_nh_naca_p_i + an_nh_naca_n_i;
  an_nh_naca_i = an_nh_naca_p_i;
  der(an_nh_l2_v) = an_nh_l2_p_i / an_nh_l2_C;
  an_nh_l2_v = an_nh_l2_p_v - an_nh_l2_n_v;
  0.0 = an_nh_l2_p_i + an_nh_l2_n_i;
  an_nh_l2_i = an_nh_l2_p_i;
  an_nh_vc_stim_v = an_nh_vc_stim_p_v - an_nh_vc_stim_n_v;
  0.0 = an_nh_vc_stim_p_i + an_nh_vc_stim_n_i;
  an_nh_vc_stim_i = an_nh_vc_stim_p_i;
  an_nh_vc_g_p_v = 0.0;
  an_nh_vc_v = an_nh_vc_p_v - an_nh_vc_n_v;
  an_nh_ca_sub_c_c = an_nh_ca_sub_c_const;
  if an_nh_ramp then
    an_nh_vc_v_stim = (time - an_nh_t_ramp_start) * an_nh_ramp_rate + an_nh_ramp_start;
  else
    an_nh_vc_v_stim = an_nh_v_hold;
  end if;
  n_naca_i = n_naca_k_NaCa * (n_naca_k_21 * n_naca_E2 - n_naca_k_12 * n_naca_E1);
  n_naca_c_sub_rate = 1.03642695739058e-05 * n_naca_i / n_naca_V_sub;
  n_naca_v = n_naca_p_v - n_naca_n_v;
  0.0 = n_naca_p_i + n_naca_n_i;
  n_naca_i = n_naca_p_i;
  der(n_l2_v) = n_l2_p_i / n_l2_C;
  n_l2_v = n_l2_p_v - n_l2_n_v;
  0.0 = n_l2_p_i + n_l2_n_i;
  n_l2_i = n_l2_p_i;
  n_vc_stim_v = n_vc_stim_p_v - n_vc_stim_n_v;
  0.0 = n_vc_stim_p_i + n_vc_stim_n_i;
  n_vc_stim_i = n_vc_stim_p_i;
  n_vc_g_p_v = 0.0;
  n_vc_v = n_vc_p_v - n_vc_n_v;
  n_ca_sub_c_c = n_ca_sub_c_const;
  if n_ramp then
    n_vc_v_stim = (time - n_t_ramp_start) * n_ramp_rate + n_ramp_start;
  else
    n_vc_v_stim = n_v_hold;
  end if;
  an_nh_l2_p_i + an_nh_vc_p_i + an_nh_naca_p_i = 0.0;
  an_nh_l2_n_i + an_nh_vc_n_i + an_nh_naca_n_i = 0.0;
  (-an_nh_vc_n_i) + an_nh_vc_g_p_i + an_nh_vc_stim_n_i = 0.0;
  (-an_nh_vc_p_i) + an_nh_vc_stim_p_i = 0.0;
  an_nh_vc_p_v = an_nh_vc_stim_p_v;
  an_nh_vc_g_p_v = an_nh_vc_n_v;
  an_nh_vc_g_p_v = an_nh_vc_stim_n_v;
  an_nh_ca_sub_c_rate + an_nh_naca_c_sub_rate = 0.0;
  an_nh_l2_p_v = an_nh_naca_p_v;
  an_nh_l2_p_v = an_nh_vc_p_v;
  an_nh_l2_n_v = an_nh_naca_n_v;
  an_nh_l2_n_v = an_nh_vc_n_v;
  an_nh_ca_sub_c_c = an_nh_naca_c_sub_c;
  n_l2_p_i + n_vc_p_i + n_naca_p_i = 0.0;
  n_l2_n_i + n_vc_n_i + n_naca_n_i = 0.0;
  (-n_vc_n_i) + n_vc_g_p_i + n_vc_stim_n_i = 0.0;
  (-n_vc_p_i) + n_vc_stim_p_i = 0.0;
  n_vc_p_v = n_vc_stim_p_v;
  n_vc_g_p_v = n_vc_n_v;
  n_vc_g_p_v = n_vc_stim_n_v;
  n_ca_sub_c_rate + n_naca_c_sub_rate = 0.0;
  n_l2_p_v = n_naca_p_v;
  n_l2_p_v = n_vc_p_v;
  n_l2_n_v = n_naca_n_v;
  n_l2_n_v = n_vc_n_v;
  n_ca_sub_c_c = n_naca_c_sub_c;
end VariableFilterWorking;
