model test_error
  parameter Integer nr_channels(min = 1) = 3;
  parameter Real f_sample(min = 1) = 6e6;
  parameter Real T_sample = 1 / f_sample;
  TDMclock MpxIndex(nr_channels = nr_channels, period = T_sample) annotation (
    Placement(visible = true, transformation(origin = {-68, 86}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  TDM CryoMultiplexer(nin = nr_channels) annotation (
    Placement(visible = true, transformation(origin = {-32, -18}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.Sine sine1(freqHz = 1e3)  annotation (
    Placement(visible = true, transformation(origin = {-84, 18}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.Sine sine2(freqHz = 1e3, phase = 0.785398) annotation (
    Placement(visible = true, transformation(origin = {-84, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.Cosine cosine(freqHz = 1e3) annotation (
    Placement(visible = true, transformation(origin = {-84, -18}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Continuous.Filter LPfilter(
    analogFilter=Modelica.Blocks.Types.AnalogFilter.CriticalDamping,
    f_cut=2e6,
    filterType=Modelica.Blocks.Types.FilterType.LowPass,
    init=Modelica.Blocks.Types.Init.SteadyState,
    normalized=true,
    order= 1)  annotation (
    Placement(visible = true, transformation(origin={24,-18},    extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(sine1.y, CryoMultiplexer.u[1]) annotation (
    Line(points={{-73,18},{-44,18},{-44,-19.3333}},   color = {0, 0, 127}));
  connect(cosine.y, CryoMultiplexer.u[2]) annotation (
    Line(points = {{-73, -18}, {-44, -18}}, color = {0, 0, 127}));
  connect(sine2.y, CryoMultiplexer.u[3]) annotation (
    Line(points={{-73,-54},{-44,-54},{-44,-16.6667}},   color = {0, 0, 127}));
  connect(MpxIndex.y, CryoMultiplexer.index) annotation (
    Line(points={{-58,86},{-32,86},{-32,-7}},        color = {255, 127, 0}));
  connect(CryoMultiplexer.y, LPfilter.u)
    annotation (Line(points={{-21,-18},{12,-18}}, color={0,0,127}));
  annotation (
    uses(Modelica(version = "3.2.3")),
    experiment(
      StopTime=0.005,
      Interval=1e-08,
      Tolerance=1e-06,
      __Dymola_Algorithm="Dassl"));
end test_error;
