within ElseClauseNonParamter.Tables.Internal;
function readTable2DData "Read table data from text or MATLAB MAT-file"
  extends Modelica.Icons.Function;
  input Modelica.Blocks.Types.ExternalCombiTable2D tableID;
  input Boolean forceRead = false
    "= true: Force reading of table data; = false: Only read, if not yet read.";
  input Boolean verboseRead = true
    "= true: Print info message; = false: No info message";
  output Real readSuccess "Table read success";
  external"C" readSuccess = ModelicaStandardTables_CombiTable2D_read(tableID, forceRead, verboseRead)
    annotation (Library={"ModelicaStandardTables", "ModelicaIO", "ModelicaMatIO", "zlib"});
  annotation(__ModelicaAssociation_Impure=true);
end readTable2DData;
