within ElseClauseNonParamter.Tables.Internal;
function readTimeTableData "Read table data from text or MATLAB MAT-file"
  extends Modelica.Icons.Function;
  input Modelica.Blocks.Types.ExternalCombiTimeTable tableID;
  input Boolean forceRead = false
    "= true: Force reading of table data; = false: Only read, if not yet read.";
  output Real readSuccess "Table read success";
  input Boolean verboseRead = true
    "= true: Print info message; = false: No info message";
  external"C" readSuccess = ModelicaStandardTables_CombiTimeTable_read(tableID, forceRead, verboseRead)
    annotation (Library={"ModelicaStandardTables", "ModelicaIO", "ModelicaMatIO", "zlib"});
  annotation(__ModelicaAssociation_Impure=true);
end readTimeTableData;
