within ElseClauseNonParamter.Mechanics.MultiBody.Joints;

model ConstrainedMotionTableCustom2
constant Integer degreesOfFreedom(min = 1, max = 6) = 2;
  parameter Boolean imposed_motion[degreesOfFreedom] = {false, true};
  parameter Boolean use_fixed_startU[degreesOfFreedom] = not imposed_motion;
  parameter Boolean use_fixed_der_startU[degreesOfFreedom] = use_fixed_startU;
  parameter Real u_start[degreesOfFreedom] = fill(0.0, degreesOfFreedom);
  parameter Real der_u_start[degreesOfFreedom] = fill(0.0, degreesOfFreedom);
  Real u[degreesOfFreedom](each fixed = false) "Lagrangian coordinates";
  Real lambda[degreesOfFreedom](each fixed = false) "Reactions in constraints along constraint allowed direction";

initial equation
  for i in 1:size(imposed_motion, 1) loop
    if not imposed_motion[i] then
      if use_fixed_startU[i] then
        u[i] = u_start[i];
      end if;
      if use_fixed_der_startU[i] then
        der(u[i]) = der_u_start[i];
      end if;
    end if;
  end for;
equation
  for i in 1:size(imposed_motion, 1) loop
    if not imposed_motion[i] then
      lambda[i] = 0;
    end if;
  end for;
  
  lambda[2] = 0;
  u = zeros(2);
  
  annotation(
    Icon,
    experiment(StartTime = 0, StopTime = 5, Tolerance = 1e-6, Interval = 0.01));
end ConstrainedMotionTableCustom2;
