<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  
  


  <head>
    <title>
      DC_Drive.2.mo on Ticket #6287 – Attachment
     – OpenModelica
    </title>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
      <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!--[if IE]><script type="text/javascript">
      if (/^#__msie303:/.test(window.location.hash))
        window.location.replace(window.location.hash.replace(/^#__msie303:/, '#'));
    </script><![endif]-->
        <link rel="search" href="/OpenModelica/search" />
        <link rel="help" href="/OpenModelica/wiki/TracGuide" />
        <link rel="alternate" href="/OpenModelica/raw-attachment/ticket/6287/DC_Drive.2.mo" type="text/x-modelica; charset=utf-8" title="Original Format" />
        <link rel="up" href="/OpenModelica/ticket/6287" title="Ticket #6287" />
        <link rel="start" href="/OpenModelica/wiki" />
        <link rel="stylesheet" href="/OpenModelica/chrome/common/css/trac.css" type="text/css" /><link rel="stylesheet" href="/OpenModelica/pygments/trac.css" type="text/css" /><link rel="stylesheet" href="/OpenModelica/chrome/common/css/code.css" type="text/css" />
        <link rel="shortcut icon" href="/OpenModelica/chrome/site/favicon.ico" type="image/x-icon" />
        <link rel="icon" href="/OpenModelica/chrome/site/favicon.ico" type="image/x-icon" />
    <style id="trac-noscript" type="text/css">.trac-noscript { display: none !important }</style>
      <link type="application/opensearchdescription+xml" rel="search" href="/OpenModelica/search/opensearch" title="Search OpenModelica" />
    <script type="text/javascript">
      var spamreport_comment="Comment";
    </script>
      <script type="text/javascript" charset="utf-8" src="/OpenModelica/chrome/common/js/jquery.js"></script>
      <script type="text/javascript" charset="utf-8" src="/OpenModelica/chrome/common/js/babel.js"></script>
      <script type="text/javascript" charset="utf-8" src="/OpenModelica/chrome/common/js/trac.js"></script>
      <script type="text/javascript" charset="utf-8" src="/OpenModelica/chrome/common/js/search.js"></script>
      <script type="text/javascript" charset="utf-8" src="/OpenModelica/chrome/spamfilter/reportspam.js"></script>
    <script type="text/javascript">
      jQuery("#trac-noscript").remove();
      jQuery(document).ready(function($) {
        $(".trac-autofocus").focus();
        $(".trac-target-new").attr("target", "_blank");
        setTimeout(function() { $(".trac-scroll").scrollToTop() }, 1);
        $(".trac-disable-on-submit").disableOnSubmit();
      });
    </script>
      <script type="text/javascript" src="/OpenModelica/chrome/common/js/folding.js"></script>
      <script type="text/javascript">
        jQuery(document).ready(function($) {
          $('#preview table.code').enableCollapsibleColumns($('#preview table.code thead th.content'));
        });
      </script>
  </head>
  <body>
    <div id="banner">
      <div id="header">
        <a id="logo" href="/OpenModelica"><img src="/OpenModelica/chrome/site/logo.png" alt="OpenModelica Trac" /></a>
      </div>
      <form id="search" action="/OpenModelica/search" method="get">
        <div>
          <label for="proj-search">Search:</label>
          <input type="text" id="proj-search" name="q" size="18" value="" />
          <input type="submit" value="Search" />
        </div>
      </form>
      <div id="metanav" class="nav">
    <ul>
      <li class="first">logged in as casella</li><li><form action="/OpenModelica/logout" class="trac-logout" id="logout" method="post"><div><input type="hidden" name="__FORM_TOKEN" value="905c71c3f12faa78295d54a4" /></div><div><button type="submit" name="logout">Logout</button></div></form></li><li><a href="/OpenModelica/prefs">Preferences</a></li><li><a href="/OpenModelica/wiki/TracGuide">Help/Guide</a></li><li><a href="/OpenModelica/about">About Trac</a></li><li class="last"><a href="/OpenModelica/rpc">API</a></li>
    </ul>
  </div>
    </div>
    <div id="mainnav" class="nav">
    <ul>
      <li class="first"><a href="/OpenModelica/wiki">Wiki</a></li><li><a href="/OpenModelica/timeline">Timeline</a></li><li><a href="/OpenModelica/roadmap">Roadmap</a></li><li><a href="/OpenModelica/browser">Browse Source</a></li><li><a href="/OpenModelica/report">View Tickets</a></li><li><a href="/OpenModelica/newticket">New Ticket</a></li><li><a href="/OpenModelica/search">Search</a></li><li class="last"><a href="/OpenModelica/admin">Admin</a></li>
    </ul>
  </div>
    <div id="main">
      <div id="ctxtnav" class="nav">
        <h2>Context Navigation</h2>
        <ul>
          <li class="first"><a href="/OpenModelica/ticket/6287">Back to Ticket #6287</a></li><li class="last"><a href="/OpenModelica/reportspam?page=%2Fattachment%2Fticket%2F6287%2FDC_Drive.2.mo" id="reportspam">Report spam</a></li>
        </ul>
        <hr />
      </div>
    <div id="content" class="attachment">
        <h1><a href="/OpenModelica/ticket/6287">Ticket #6287</a>: DC_Drive.2.mo</h1>
        <table id="info" summary="Description">
          <tr>
            <th scope="col">File DC_Drive.2.mo, <span title="18115 bytes">17.7 KB</span> (added by ahaumer@gmx.net, <a class="timeline" href="/OpenModelica/timeline?from=2020-12-18T21%3A23%3A05%2B01%3A00&amp;precision=second" title="See timeline at 2020-12-18T21:23:05+01:00">43 hours ago</a>)</th>
          </tr>
          <tr>
            <td class="message searchable">
              <p>
New version of the test library
</p>

            </td>
          </tr>
        </table>
        <div id="preview" class="searchable">
          
  <table class="code"><thead><tr><th class="lineno" title="Line numbers">Line</th><th class="content"> </th></tr></thead><tbody><tr><th id="L1"><a href="#L1">1</a></th><td><span class="kr">within</span> <span class="p">;</span></td></tr><tr><th id="L2"><a href="#L2">2</a></th><td><span class="kr">package</span> <span class="nc">DC_Drive</span> <span class="s2">"Test library of controlled DCPM drives"</span></td></tr><tr><th id="L3"><a href="#L3">3</a></th><td>  <span class="kr">extends</span> Modelica<span class="o">.</span>Icons<span class="o">.</span>Package<span class="p">;</span></td></tr><tr><th id="L4"><a href="#L4">4</a></th><td></td></tr><tr><th id="L5"><a href="#L5">5</a></th><td>  <span class="kr">model</span> <span class="nc">DCPM_CurrentControlled</span> <span class="s2">"Current controlled DCPM drive"</span></td></tr><tr><th id="L6"><a href="#L6">6</a></th><td>    <span class="kr">extends</span> Modelica<span class="o">.</span>Icons<span class="o">.</span>Example<span class="p">;</span></td></tr><tr><th id="L7"><a href="#L7">7</a></th><td>    <span class="kr">import</span> Modelica<span class="o">.</span>Constants<span class="o">.</span>pi<span class="p">;</span></td></tr><tr><th id="L8"><a href="#L8">8</a></th><td>    <span class="kr">parameter</span> DCPM_Utilities<span class="o">.</span>DriveData driveData<span class="p">(</span><span class="kr">redeclare</span></td></tr><tr><th id="L9"><a href="#L9">9</a></th><td>        DC_Drive<span class="o">.</span>DCPM_Utilities<span class="o">.</span>M48V machineData<span class="p">)</span></td></tr><tr><th id="L10"><a href="#L10">10</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">60</span><span class="p">,</span><span class="mi">60</span><span class="p">},{</span><span class="mi">80</span><span class="p">,</span><span class="mi">80</span><span class="p">}})));</span></td></tr><tr><th id="L11"><a href="#L11">11</a></th><td>    DCPM_Utilities<span class="o">.</span>DCPM dcpm<span class="p">(</span></td></tr><tr><th id="L12"><a href="#L12">12</a></th><td>      machineData<span class="o">=</span>driveData<span class="o">.</span>machineData<span class="p">,</span></td></tr><tr><th id="L13"><a href="#L13">13</a></th><td>      iA<span class="p">(</span>fixed<span class="o">=</span><span class="kc">true</span><span class="p">),</span></td></tr><tr><th id="L14"><a href="#L14">14</a></th><td>      phi<span class="p">(</span>fixed<span class="o">=</span><span class="kc">true</span><span class="p">),</span></td></tr><tr><th id="L15"><a href="#L15">15</a></th><td>      w<span class="p">(</span>fixed<span class="o">=</span><span class="kc">true</span><span class="p">))</span></td></tr><tr><th id="L16"><a href="#L16">16</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">80</span><span class="p">},{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}})));</span></td></tr><tr><th id="L17"><a href="#L17">17</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Basic<span class="o">.</span>Ground ground</td></tr><tr><th id="L18"><a href="#L18">18</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span></td></tr><tr><th id="L19"><a href="#L19">19</a></th><td>          transformation<span class="p">(</span></td></tr><tr><th id="L20"><a href="#L20">20</a></th><td>          extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L21"><a href="#L21">21</a></th><td>          rotation<span class="o">=</span><span class="mi">270</span><span class="p">,</span></td></tr><tr><th id="L22"><a href="#L22">22</a></th><td>          origin<span class="o">=</span><span class="p">{</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">})));</span></td></tr><tr><th id="L23"><a href="#L23">23</a></th><td>    Modelica<span class="o">.</span>Blocks<span class="o">.</span>Sources<span class="o">.</span>Step iRef<span class="p">(</span></td></tr><tr><th id="L24"><a href="#L24">24</a></th><td>      height<span class="o">=</span>driveData<span class="o">.</span>machineData<span class="o">.</span>IANominal<span class="p">,</span></td></tr><tr><th id="L25"><a href="#L25">25</a></th><td>      offset<span class="o">=</span><span class="mi">0</span><span class="p">,</span></td></tr><tr><th id="L26"><a href="#L26">26</a></th><td>      startTime<span class="o">=</span><span class="mf">0.1</span><span class="p">)</span></td></tr><tr><th id="L27"><a href="#L27">27</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">40</span><span class="p">,</span><span class="mi">30</span><span class="p">},{</span><span class="o">-</span><span class="mi">20</span><span class="p">,</span><span class="mi">50</span><span class="p">}})));</span></td></tr><tr><th id="L28"><a href="#L28">28</a></th><td>    Modelica<span class="o">.</span>Mechanics<span class="o">.</span>Rotational<span class="o">.</span>Components<span class="o">.</span>Inertia inertiaLoad<span class="p">(</span></td></tr><tr><th id="L29"><a href="#L29">29</a></th><td>      J<span class="o">=</span>driveData<span class="o">.</span>JL<span class="p">,</span></td></tr><tr><th id="L30"><a href="#L30">30</a></th><td>      phi<span class="p">(</span>fixed<span class="o">=</span><span class="kc">false</span><span class="p">),</span></td></tr><tr><th id="L31"><a href="#L31">31</a></th><td>      w<span class="p">(</span>fixed<span class="o">=</span><span class="kc">false</span><span class="p">))</span></td></tr><tr><th id="L32"><a href="#L32">32</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">50</span><span class="p">,</span><span class="o">-</span><span class="mi">80</span><span class="p">},{</span><span class="mi">70</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}})));</span></td></tr><tr><th id="L33"><a href="#L33">33</a></th><td>    Modelica<span class="o">.</span>Mechanics<span class="o">.</span>Rotational<span class="o">.</span>Sources<span class="o">.</span>LinearSpeedDependentTorque torqueLoad<span class="p">(</span></td></tr><tr><th id="L34"><a href="#L34">34</a></th><td>      tau_nominal<span class="o">=-</span>driveData<span class="o">.</span>machineData<span class="o">.</span>tauNominal<span class="p">,</span></td></tr><tr><th id="L35"><a href="#L35">35</a></th><td>      TorqueDirection<span class="o">=</span><span class="kc">false</span><span class="p">,</span></td></tr><tr><th id="L36"><a href="#L36">36</a></th><td>      w_nominal<span class="o">=</span>driveData<span class="o">.</span>machineData<span class="o">.</span>wNominal<span class="p">)</span></td></tr><tr><th id="L37"><a href="#L37">37</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">100</span><span class="p">,</span><span class="o">-</span><span class="mi">80</span><span class="p">},{</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}})));</span></td></tr><tr><th id="L38"><a href="#L38">38</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Sources<span class="o">.</span>SignalVoltage voltageSource</td></tr><tr><th id="L39"><a href="#L39">39</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">20</span><span class="p">},{</span><span class="mi">20</span><span class="p">,</span><span class="mi">0</span><span class="p">}})));</span></td></tr><tr><th id="L40"><a href="#L40">40</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Sensors<span class="o">.</span>CurrentSensor currentSensor</td></tr><tr><th id="L41"><a href="#L41">41</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span></td></tr><tr><th id="L42"><a href="#L42">42</a></th><td>          extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L43"><a href="#L43">43</a></th><td>          rotation<span class="o">=</span><span class="mi">90</span><span class="p">,</span></td></tr><tr><th id="L44"><a href="#L44">44</a></th><td>          origin<span class="o">=</span><span class="p">{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">30</span><span class="p">})));</span></td></tr><tr><th id="L45"><a href="#L45">45</a></th><td>    Modelica<span class="o">.</span>Blocks<span class="o">.</span>Continuous<span class="o">.</span>FirstOrder deadTime<span class="p">(</span></td></tr><tr><th id="L46"><a href="#L46">46</a></th><td>      k<span class="o">=</span><span class="mi">1</span><span class="p">,</span></td></tr><tr><th id="L47"><a href="#L47">47</a></th><td>      T<span class="o">=</span>driveData<span class="o">.</span>Td<span class="p">,</span></td></tr><tr><th id="L48"><a href="#L48">48</a></th><td>      initType<span class="o">=</span>Modelica<span class="o">.</span>Blocks<span class="o">.</span>Types<span class="o">.</span>Init<span class="o">.</span>InitialOutput<span class="p">,</span></td></tr><tr><th id="L49"><a href="#L49">49</a></th><td>      y_start<span class="o">=</span><span class="mi">0</span><span class="p">)</span> <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span></td></tr><tr><th id="L50"><a href="#L50">50</a></th><td>          extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L51"><a href="#L51">51</a></th><td>          rotation<span class="o">=</span><span class="mi">270</span><span class="p">,</span></td></tr><tr><th id="L52"><a href="#L52">52</a></th><td>          origin<span class="o">=</span><span class="p">{</span><span class="mi">30</span><span class="p">,</span><span class="mi">20</span><span class="p">})));</span></td></tr><tr><th id="L53"><a href="#L53">53</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Machines<span class="o">.</span>Examples<span class="o">.</span>ControlledDCDrives<span class="o">.</span>Utilities<span class="o">.</span>LimitedPI currentController<span class="p">(</span></td></tr><tr><th id="L54"><a href="#L54">54</a></th><td>      k<span class="o">=</span>driveData<span class="o">.</span>controllerData<span class="o">.</span>kpI<span class="p">,</span></td></tr><tr><th id="L55"><a href="#L55">55</a></th><td>      Ti<span class="o">=</span>driveData<span class="o">.</span>controllerData<span class="o">.</span>TiI<span class="p">,</span></td></tr><tr><th id="L56"><a href="#L56">56</a></th><td>      useFF<span class="o">=</span><span class="kc">true</span><span class="p">,</span></td></tr><tr><th id="L57"><a href="#L57">57</a></th><td>      KFF<span class="o">=</span>driveData<span class="o">.</span>machineData<span class="o">.</span>kPhi<span class="p">,</span></td></tr><tr><th id="L58"><a href="#L58">58</a></th><td>      yMax<span class="o">=</span>driveData<span class="o">.</span>VBat<span class="p">,</span></td></tr><tr><th id="L59"><a href="#L59">59</a></th><td>      initType<span class="o">=</span>Modelica<span class="o">.</span>Blocks<span class="o">.</span>Types<span class="o">.</span>Init<span class="o">.</span>InitialOutput<span class="p">,</span></td></tr><tr><th id="L60"><a href="#L60">60</a></th><td>      x_start<span class="o">=</span><span class="mi">0</span><span class="p">,</span></td></tr><tr><th id="L61"><a href="#L61">61</a></th><td>      y_start<span class="o">=</span><span class="mi">0</span><span class="p">)</span> <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="mi">30</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">50</span><span class="p">}})));</span></td></tr><tr><th id="L62"><a href="#L62">62</a></th><td>  <span class="kr">equation</span></td></tr><tr><th id="L63"><a href="#L63">63</a></th><td>    <span class="kr">connect</span><span class="p">(</span>dcpm<span class="o">.</span>shaft<span class="p">,</span> inertiaLoad<span class="o">.</span>flange_a<span class="p">)</span></td></tr><tr><th id="L64"><a href="#L64">64</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="mi">50</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">}));</span></td></tr><tr><th id="L65"><a href="#L65">65</a></th><td>    <span class="kr">connect</span><span class="p">(</span>torqueLoad<span class="o">.</span>flange<span class="p">,</span> inertiaLoad<span class="o">.</span>flange_b<span class="p">)</span></td></tr><tr><th id="L66"><a href="#L66">66</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="mi">70</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">}));</span></td></tr><tr><th id="L67"><a href="#L67">67</a></th><td>    <span class="kr">connect</span><span class="p">(</span>ground<span class="o">.</span>p<span class="p">,</span>dcpm<span class="o">.</span> pin_n<span class="p">)</span></td></tr><tr><th id="L68"><a href="#L68">68</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">24</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">24</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}},</span>  color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L69"><a href="#L69">69</a></th><td>    <span class="kr">connect</span><span class="p">(</span>ground<span class="o">.</span>p<span class="p">,</span> currentSensor<span class="o">.</span>p<span class="p">)</span></td></tr><tr><th id="L70"><a href="#L70">70</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">40</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L71"><a href="#L71">71</a></th><td>    <span class="kr">connect</span><span class="p">(</span>currentSensor<span class="o">.</span>n<span class="p">,</span>voltageSource<span class="o">.</span> n<span class="p">)</span></td></tr><tr><th id="L72"><a href="#L72">72</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">20</span><span class="p">},{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L73"><a href="#L73">73</a></th><td>                                                 color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L74"><a href="#L74">74</a></th><td>    <span class="kr">connect</span><span class="p">(</span>voltageSource<span class="o">.</span>p<span class="p">,</span>dcpm<span class="o">.</span> pin_p<span class="p">)</span></td></tr><tr><th id="L75"><a href="#L75">75</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">36</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">36</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}},</span></td></tr><tr><th id="L76"><a href="#L76">76</a></th><td>                                                                   color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L77"><a href="#L77">77</a></th><td>    <span class="kr">connect</span><span class="p">(</span>deadTime<span class="o">.</span>y<span class="p">,</span> voltageSource<span class="o">.</span>v<span class="p">)</span></td></tr><tr><th id="L78"><a href="#L78">78</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">30</span><span class="p">,</span><span class="mi">9</span><span class="p">},{</span><span class="mi">30</span><span class="p">,</span><span class="mi">2</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L79"><a href="#L79">79</a></th><td>    <span class="kr">connect</span><span class="p">(</span>iRef<span class="o">.</span>y<span class="p">,</span> currentController<span class="o">.</span>u<span class="p">)</span></td></tr><tr><th id="L80"><a href="#L80">80</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">19</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="o">-</span><span class="mi">12</span><span class="p">,</span><span class="mi">40</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L81"><a href="#L81">81</a></th><td>    <span class="kr">connect</span><span class="p">(</span>currentSensor<span class="o">.</span>i<span class="p">,</span> currentController<span class="o">.</span>u_m<span class="p">)</span></td></tr><tr><th id="L82"><a href="#L82">82</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">9</span><span class="p">,</span><span class="o">-</span><span class="mi">30</span><span class="p">},{</span><span class="o">-</span><span class="mi">6</span><span class="p">,</span><span class="o">-</span><span class="mi">30</span><span class="p">},{</span><span class="o">-</span><span class="mi">6</span><span class="p">,</span><span class="mi">28</span><span class="p">}},</span>    color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L83"><a href="#L83">83</a></th><td>    <span class="kr">connect</span><span class="p">(</span>dcpm<span class="o">.</span>w<span class="p">,</span> currentController<span class="o">.</span>feedForward<span class="p">)</span></td></tr><tr><th id="L84"><a href="#L84">84</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">19</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="mi">28</span><span class="p">}},</span>    color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L85"><a href="#L85">85</a></th><td>    <span class="kr">connect</span><span class="p">(</span>currentController<span class="o">.</span>y<span class="p">,</span> deadTime<span class="o">.</span>u<span class="p">)</span></td></tr><tr><th id="L86"><a href="#L86">86</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">11</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="mi">30</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="mi">30</span><span class="p">,</span><span class="mi">32</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L87"><a href="#L87">87</a></th><td>    <span class="kr">annotation</span> <span class="p">(</span>experiment<span class="p">(</span></td></tr><tr><th id="L88"><a href="#L88">88</a></th><td>        StopTime<span class="o">=</span><span class="mi">1</span><span class="p">,</span></td></tr><tr><th id="L89"><a href="#L89">89</a></th><td>        Interval<span class="o">=</span><span class="mf">0.0001</span><span class="p">,</span></td></tr><tr><th id="L90"><a href="#L90">90</a></th><td>        Tolerance<span class="o">=</span><span class="mf">1e-06</span><span class="p">),</span> Documentation<span class="p">(</span>info<span class="o">=</span><span class="s2">"</span><span class="p">&lt;</span><span class="nt">html</span><span class="p">&gt;</span></td></tr><tr><th id="L91"><a href="#L91">91</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L92"><a href="#L92">92</a></th><td>Simulates a current controlled DCPM machine. The load applies a linearly speed dependent torque, which in the end causes the drive to operate in nominal operation.</td></tr><tr><th id="L93"><a href="#L93">93</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L94"><a href="#L94">94</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L95"><a href="#L95">95</a></th><td>Additionally, the handling of parameter records can be tested:</td></tr><tr><th id="L96"><a href="#L96">96</a></th><td>By simply redeclaring the machine parameter record instantiated in the drive parameter record, a machine with different parameters can be simulated.</td></tr><tr><th id="L97"><a href="#L97">97</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L98"><a href="#L98">98</a></th><td><span class="p">&lt;/</span><span class="nt">html</span><span class="p">&gt;</span><span class="s2">"</span><span class="p">));</span></td></tr><tr><th id="L99"><a href="#L99">99</a></th><td>  <span class="kr">end</span> <span class="nc">DCPM_CurrentControlled</span><span class="p">;</span></td></tr><tr><th id="L100"><a href="#L100">100</a></th><td></td></tr><tr><th id="L101"><a href="#L101">101</a></th><td>  <span class="kr">model</span> <span class="nc">DCPM_SpeedControlled</span> <span class="s2">"Current controlled DCPM drive"</span></td></tr><tr><th id="L102"><a href="#L102">102</a></th><td>    <span class="kr">extends</span> Modelica<span class="o">.</span>Icons<span class="o">.</span>Example<span class="p">;</span></td></tr><tr><th id="L103"><a href="#L103">103</a></th><td>    <span class="kr">import</span> Modelica<span class="o">.</span>Constants<span class="o">.</span>pi<span class="p">;</span></td></tr><tr><th id="L104"><a href="#L104">104</a></th><td>    <span class="kr">parameter</span> DCPM_Utilities<span class="o">.</span>DriveData driveData<span class="p">(</span><span class="kr">redeclare</span></td></tr><tr><th id="L105"><a href="#L105">105</a></th><td>        DC_Drive<span class="o">.</span>DCPM_Utilities<span class="o">.</span>M48V machineData<span class="p">)</span></td></tr><tr><th id="L106"><a href="#L106">106</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">60</span><span class="p">,</span><span class="mi">60</span><span class="p">},{</span><span class="mi">80</span><span class="p">,</span><span class="mi">80</span><span class="p">}})));</span></td></tr><tr><th id="L107"><a href="#L107">107</a></th><td>    DCPM_Utilities<span class="o">.</span>DCPM dcpm<span class="p">(</span></td></tr><tr><th id="L108"><a href="#L108">108</a></th><td>      machineData<span class="o">=</span>driveData<span class="o">.</span>machineData<span class="p">,</span></td></tr><tr><th id="L109"><a href="#L109">109</a></th><td>      iA<span class="p">(</span>fixed<span class="o">=</span><span class="kc">true</span><span class="p">),</span></td></tr><tr><th id="L110"><a href="#L110">110</a></th><td>      phi<span class="p">(</span>fixed<span class="o">=</span><span class="kc">true</span><span class="p">),</span></td></tr><tr><th id="L111"><a href="#L111">111</a></th><td>      w<span class="p">(</span>fixed<span class="o">=</span><span class="kc">true</span><span class="p">))</span></td></tr><tr><th id="L112"><a href="#L112">112</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">80</span><span class="p">},{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}})));</span></td></tr><tr><th id="L113"><a href="#L113">113</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Basic<span class="o">.</span>Ground ground</td></tr><tr><th id="L114"><a href="#L114">114</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span></td></tr><tr><th id="L115"><a href="#L115">115</a></th><td>          transformation<span class="p">(</span></td></tr><tr><th id="L116"><a href="#L116">116</a></th><td>          extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L117"><a href="#L117">117</a></th><td>          rotation<span class="o">=</span><span class="mi">270</span><span class="p">,</span></td></tr><tr><th id="L118"><a href="#L118">118</a></th><td>          origin<span class="o">=</span><span class="p">{</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">})));</span></td></tr><tr><th id="L119"><a href="#L119">119</a></th><td>    Modelica<span class="o">.</span>Blocks<span class="o">.</span>Sources<span class="o">.</span>Step wRef<span class="p">(</span></td></tr><tr><th id="L120"><a href="#L120">120</a></th><td>      height<span class="o">=</span>driveData<span class="o">.</span>machineData<span class="o">.</span>wNominal<span class="p">,</span></td></tr><tr><th id="L121"><a href="#L121">121</a></th><td>      offset<span class="o">=</span><span class="mi">0</span><span class="p">,</span></td></tr><tr><th id="L122"><a href="#L122">122</a></th><td>      startTime<span class="o">=</span><span class="mf">0.1</span><span class="p">)</span></td></tr><tr><th id="L123"><a href="#L123">123</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">100</span><span class="p">,</span><span class="mi">30</span><span class="p">},{</span><span class="o">-</span><span class="mi">80</span><span class="p">,</span><span class="mi">50</span><span class="p">}})));</span></td></tr><tr><th id="L124"><a href="#L124">124</a></th><td>    Modelica<span class="o">.</span>Mechanics<span class="o">.</span>Rotational<span class="o">.</span>Components<span class="o">.</span>Inertia inertiaLoad<span class="p">(</span></td></tr><tr><th id="L125"><a href="#L125">125</a></th><td>      J<span class="o">=</span>driveData<span class="o">.</span>JL<span class="p">,</span></td></tr><tr><th id="L126"><a href="#L126">126</a></th><td>      phi<span class="p">(</span>fixed<span class="o">=</span><span class="kc">false</span><span class="p">),</span></td></tr><tr><th id="L127"><a href="#L127">127</a></th><td>      w<span class="p">(</span>fixed<span class="o">=</span><span class="kc">false</span><span class="p">))</span></td></tr><tr><th id="L128"><a href="#L128">128</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">50</span><span class="p">,</span><span class="o">-</span><span class="mi">80</span><span class="p">},{</span><span class="mi">70</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}})));</span></td></tr><tr><th id="L129"><a href="#L129">129</a></th><td>    Modelica<span class="o">.</span>Mechanics<span class="o">.</span>Rotational<span class="o">.</span>Sources<span class="o">.</span>TorqueStep                 torqueLoad<span class="p">(</span></td></tr><tr><th id="L130"><a href="#L130">130</a></th><td>      stepTorque<span class="o">=-</span>driveData<span class="o">.</span>machineData<span class="o">.</span>tauNominal<span class="p">,</span></td></tr><tr><th id="L131"><a href="#L131">131</a></th><td>      offsetTorque<span class="o">=</span><span class="mi">0</span><span class="p">,</span></td></tr><tr><th id="L132"><a href="#L132">132</a></th><td>      startTime<span class="o">=</span><span class="mf">0.7</span><span class="p">)</span></td></tr><tr><th id="L133"><a href="#L133">133</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">100</span><span class="p">,</span><span class="o">-</span><span class="mi">80</span><span class="p">},{</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}})));</span></td></tr><tr><th id="L134"><a href="#L134">134</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Sources<span class="o">.</span>SignalVoltage voltageSource</td></tr><tr><th id="L135"><a href="#L135">135</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">20</span><span class="p">},{</span><span class="mi">20</span><span class="p">,</span><span class="mi">0</span><span class="p">}})));</span></td></tr><tr><th id="L136"><a href="#L136">136</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Sensors<span class="o">.</span>CurrentSensor currentSensor</td></tr><tr><th id="L137"><a href="#L137">137</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span></td></tr><tr><th id="L138"><a href="#L138">138</a></th><td>          extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L139"><a href="#L139">139</a></th><td>          rotation<span class="o">=</span><span class="mi">90</span><span class="p">,</span></td></tr><tr><th id="L140"><a href="#L140">140</a></th><td>          origin<span class="o">=</span><span class="p">{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">30</span><span class="p">})));</span></td></tr><tr><th id="L141"><a href="#L141">141</a></th><td>    Modelica<span class="o">.</span>Blocks<span class="o">.</span>Continuous<span class="o">.</span>FirstOrder deadTime<span class="p">(</span></td></tr><tr><th id="L142"><a href="#L142">142</a></th><td>      k<span class="o">=</span><span class="mi">1</span><span class="p">,</span></td></tr><tr><th id="L143"><a href="#L143">143</a></th><td>      T<span class="o">=</span>driveData<span class="o">.</span>Td<span class="p">,</span></td></tr><tr><th id="L144"><a href="#L144">144</a></th><td>      initType<span class="o">=</span>Modelica<span class="o">.</span>Blocks<span class="o">.</span>Types<span class="o">.</span>Init<span class="o">.</span>InitialOutput<span class="p">,</span></td></tr><tr><th id="L145"><a href="#L145">145</a></th><td>      y_start<span class="o">=</span><span class="mi">0</span><span class="p">)</span> <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span></td></tr><tr><th id="L146"><a href="#L146">146</a></th><td>          extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L147"><a href="#L147">147</a></th><td>          rotation<span class="o">=</span><span class="mi">270</span><span class="p">,</span></td></tr><tr><th id="L148"><a href="#L148">148</a></th><td>          origin<span class="o">=</span><span class="p">{</span><span class="mi">30</span><span class="p">,</span><span class="mi">20</span><span class="p">})));</span></td></tr><tr><th id="L149"><a href="#L149">149</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Machines<span class="o">.</span>Examples<span class="o">.</span>ControlledDCDrives<span class="o">.</span>Utilities<span class="o">.</span>LimitedPI currentController<span class="p">(</span></td></tr><tr><th id="L150"><a href="#L150">150</a></th><td>      k<span class="o">=</span>driveData<span class="o">.</span>controllerData<span class="o">.</span>kpI<span class="p">,</span></td></tr><tr><th id="L151"><a href="#L151">151</a></th><td>      Ti<span class="o">=</span>driveData<span class="o">.</span>controllerData<span class="o">.</span>TiI<span class="p">,</span></td></tr><tr><th id="L152"><a href="#L152">152</a></th><td>      useFF<span class="o">=</span><span class="kc">true</span><span class="p">,</span></td></tr><tr><th id="L153"><a href="#L153">153</a></th><td>      KFF<span class="o">=</span>driveData<span class="o">.</span>machineData<span class="o">.</span>kPhi<span class="p">,</span></td></tr><tr><th id="L154"><a href="#L154">154</a></th><td>      yMax<span class="o">=</span>driveData<span class="o">.</span>VBat<span class="p">,</span></td></tr><tr><th id="L155"><a href="#L155">155</a></th><td>      initType<span class="o">=</span>Modelica<span class="o">.</span>Blocks<span class="o">.</span>Types<span class="o">.</span>Init<span class="o">.</span>InitialOutput<span class="p">,</span></td></tr><tr><th id="L156"><a href="#L156">156</a></th><td>      x_start<span class="o">=</span><span class="mi">0</span><span class="p">,</span></td></tr><tr><th id="L157"><a href="#L157">157</a></th><td>      y_start<span class="o">=</span><span class="mi">0</span><span class="p">)</span> <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="mi">30</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">50</span><span class="p">}})));</span></td></tr><tr><th id="L158"><a href="#L158">158</a></th><td>    Modelica<span class="o">.</span>Blocks<span class="o">.</span>Continuous<span class="o">.</span>FirstOrder preFilter<span class="p">(</span></td></tr><tr><th id="L159"><a href="#L159">159</a></th><td>      k<span class="o">=</span><span class="mi">1</span><span class="p">,</span></td></tr><tr><th id="L160"><a href="#L160">160</a></th><td>      T<span class="o">=</span>driveData<span class="o">.</span>controllerData<span class="o">.</span>Tiw<span class="p">,</span></td></tr><tr><th id="L161"><a href="#L161">161</a></th><td>      initType<span class="o">=</span>Modelica<span class="o">.</span>Blocks<span class="o">.</span>Types<span class="o">.</span>Init<span class="o">.</span>InitialOutput<span class="p">,</span></td></tr><tr><th id="L162"><a href="#L162">162</a></th><td>      y_start<span class="o">=</span><span class="mi">0</span><span class="p">)</span></td></tr><tr><th id="L163"><a href="#L163">163</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">70</span><span class="p">,</span><span class="mi">30</span><span class="p">},{</span><span class="o">-</span><span class="mi">50</span><span class="p">,</span><span class="mi">50</span><span class="p">}})));</span></td></tr><tr><th id="L164"><a href="#L164">164</a></th><td>    Modelica<span class="o">.</span>Electrical<span class="o">.</span>Machines<span class="o">.</span>Examples<span class="o">.</span>ControlledDCDrives<span class="o">.</span>Utilities<span class="o">.</span>LimitedPI</td></tr><tr><th id="L165"><a href="#L165">165</a></th><td>      speedController<span class="p">(</span></td></tr><tr><th id="L166"><a href="#L166">166</a></th><td>      k<span class="o">=</span>driveData<span class="o">.</span>controllerData<span class="o">.</span>kpw<span class="o">/</span>driveData<span class="o">.</span>machineData<span class="o">.</span>kPhi<span class="p">,</span></td></tr><tr><th id="L167"><a href="#L167">167</a></th><td>      Ti<span class="o">=</span>driveData<span class="o">.</span>controllerData<span class="o">.</span>Tiw<span class="p">,</span></td></tr><tr><th id="L168"><a href="#L168">168</a></th><td>      useFF<span class="o">=</span><span class="kc">false</span><span class="p">,</span></td></tr><tr><th id="L169"><a href="#L169">169</a></th><td>      yMax<span class="o">=</span>driveData<span class="o">.</span>IMax<span class="p">,</span></td></tr><tr><th id="L170"><a href="#L170">170</a></th><td>      initType<span class="o">=</span>Modelica<span class="o">.</span>Blocks<span class="o">.</span>Types<span class="o">.</span>Init<span class="o">.</span>InitialOutput<span class="p">,</span></td></tr><tr><th id="L171"><a href="#L171">171</a></th><td>      x_start<span class="o">=</span><span class="mi">0</span><span class="p">,</span></td></tr><tr><th id="L172"><a href="#L172">172</a></th><td>      y_start<span class="o">=</span><span class="mi">0</span><span class="p">)</span></td></tr><tr><th id="L173"><a href="#L173">173</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">40</span><span class="p">,</span><span class="mi">30</span><span class="p">},{</span><span class="o">-</span><span class="mi">20</span><span class="p">,</span><span class="mi">50</span><span class="p">}})));</span></td></tr><tr><th id="L174"><a href="#L174">174</a></th><td>  <span class="kr">equation</span></td></tr><tr><th id="L175"><a href="#L175">175</a></th><td>    <span class="kr">connect</span><span class="p">(</span>dcpm<span class="o">.</span>shaft<span class="p">,</span> inertiaLoad<span class="o">.</span>flange_a<span class="p">)</span></td></tr><tr><th id="L176"><a href="#L176">176</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="mi">50</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">}));</span></td></tr><tr><th id="L177"><a href="#L177">177</a></th><td>    <span class="kr">connect</span><span class="p">(</span>torqueLoad<span class="o">.</span>flange<span class="p">,</span> inertiaLoad<span class="o">.</span>flange_b<span class="p">)</span></td></tr><tr><th id="L178"><a href="#L178">178</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="mi">70</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">}));</span></td></tr><tr><th id="L179"><a href="#L179">179</a></th><td>    <span class="kr">connect</span><span class="p">(</span>ground<span class="o">.</span>p<span class="p">,</span>dcpm<span class="o">.</span> pin_n<span class="p">)</span></td></tr><tr><th id="L180"><a href="#L180">180</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">24</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">24</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}},</span>  color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L181"><a href="#L181">181</a></th><td>    <span class="kr">connect</span><span class="p">(</span>ground<span class="o">.</span>p<span class="p">,</span> currentSensor<span class="o">.</span>p<span class="p">)</span></td></tr><tr><th id="L182"><a href="#L182">182</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">40</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L183"><a href="#L183">183</a></th><td>    <span class="kr">connect</span><span class="p">(</span>currentSensor<span class="o">.</span>n<span class="p">,</span>voltageSource<span class="o">.</span> n<span class="p">)</span></td></tr><tr><th id="L184"><a href="#L184">184</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">20</span><span class="p">},{</span><span class="mi">20</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L185"><a href="#L185">185</a></th><td>                                                 color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L186"><a href="#L186">186</a></th><td>    <span class="kr">connect</span><span class="p">(</span>voltageSource<span class="o">.</span>p<span class="p">,</span>dcpm<span class="o">.</span> pin_p<span class="p">)</span></td></tr><tr><th id="L187"><a href="#L187">187</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">36</span><span class="p">,</span><span class="o">-</span><span class="mi">50</span><span class="p">},{</span><span class="mi">36</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">}},</span></td></tr><tr><th id="L188"><a href="#L188">188</a></th><td>                                                                   color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L189"><a href="#L189">189</a></th><td>    <span class="kr">connect</span><span class="p">(</span>deadTime<span class="o">.</span>y<span class="p">,</span> voltageSource<span class="o">.</span>v<span class="p">)</span></td></tr><tr><th id="L190"><a href="#L190">190</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">30</span><span class="p">,</span><span class="mi">9</span><span class="p">},{</span><span class="mi">30</span><span class="p">,</span><span class="mi">2</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L191"><a href="#L191">191</a></th><td>    <span class="kr">connect</span><span class="p">(</span>currentSensor<span class="o">.</span>i<span class="p">,</span> currentController<span class="o">.</span>u_m<span class="p">)</span></td></tr><tr><th id="L192"><a href="#L192">192</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">9</span><span class="p">,</span><span class="o">-</span><span class="mi">30</span><span class="p">},{</span><span class="o">-</span><span class="mi">6</span><span class="p">,</span><span class="o">-</span><span class="mi">30</span><span class="p">},{</span><span class="o">-</span><span class="mi">6</span><span class="p">,</span><span class="mi">28</span><span class="p">}},</span>    color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L193"><a href="#L193">193</a></th><td>    <span class="kr">connect</span><span class="p">(</span>dcpm<span class="o">.</span>w<span class="p">,</span> currentController<span class="o">.</span>feedForward<span class="p">)</span></td></tr><tr><th id="L194"><a href="#L194">194</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">19</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="mi">28</span><span class="p">}},</span>    color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L195"><a href="#L195">195</a></th><td>    <span class="kr">connect</span><span class="p">(</span>wRef<span class="o">.</span>y<span class="p">,</span> preFilter<span class="o">.</span>u<span class="p">)</span></td></tr><tr><th id="L196"><a href="#L196">196</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">79</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="o">-</span><span class="mi">72</span><span class="p">,</span><span class="mi">40</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L197"><a href="#L197">197</a></th><td>    <span class="kr">connect</span><span class="p">(</span>currentController<span class="o">.</span>y<span class="p">,</span> deadTime<span class="o">.</span>u<span class="p">)</span></td></tr><tr><th id="L198"><a href="#L198">198</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">11</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="mi">30</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="mi">30</span><span class="p">,</span><span class="mi">32</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L199"><a href="#L199">199</a></th><td>    <span class="kr">connect</span><span class="p">(</span>preFilter<span class="o">.</span>y<span class="p">,</span> speedController<span class="o">.</span>u<span class="p">)</span></td></tr><tr><th id="L200"><a href="#L200">200</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">49</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="o">-</span><span class="mi">42</span><span class="p">,</span><span class="mi">40</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L201"><a href="#L201">201</a></th><td>    <span class="kr">connect</span><span class="p">(</span>speedController<span class="o">.</span>y<span class="p">,</span> currentController<span class="o">.</span>u<span class="p">)</span></td></tr><tr><th id="L202"><a href="#L202">202</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">19</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="o">-</span><span class="mi">12</span><span class="p">,</span><span class="mi">40</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L203"><a href="#L203">203</a></th><td>    <span class="kr">connect</span><span class="p">(</span>dcpm<span class="o">.</span>w<span class="p">,</span> speedController<span class="o">.</span>u_m<span class="p">)</span> <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">19</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span></td></tr><tr><th id="L204"><a href="#L204">204</a></th><td>            <span class="o">-</span><span class="mi">36</span><span class="p">,</span><span class="o">-</span><span class="mi">70</span><span class="p">},{</span><span class="o">-</span><span class="mi">36</span><span class="p">,</span><span class="mi">28</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L205"><a href="#L205">205</a></th><td>    <span class="kr">annotation</span> <span class="p">(</span>experiment<span class="p">(</span></td></tr><tr><th id="L206"><a href="#L206">206</a></th><td>        StopTime<span class="o">=</span><span class="mi">1</span><span class="p">,</span></td></tr><tr><th id="L207"><a href="#L207">207</a></th><td>        Interval<span class="o">=</span><span class="mf">0.0001</span><span class="p">,</span></td></tr><tr><th id="L208"><a href="#L208">208</a></th><td>        Tolerance<span class="o">=</span><span class="mf">1e-06</span><span class="p">),</span> Documentation<span class="p">(</span>info<span class="o">=</span><span class="s2">"</span><span class="p">&lt;</span><span class="nt">html</span><span class="p">&gt;</span></td></tr><tr><th id="L209"><a href="#L209">209</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L210"><a href="#L210">210</a></th><td>Simulates a speed controlled DCPM machine. The load applies a torque step, which in the end causes the drive to operate in nominal operation.</td></tr><tr><th id="L211"><a href="#L211">211</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L212"><a href="#L212">212</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L213"><a href="#L213">213</a></th><td>Additionally, the handling of parameter records can be tested:</td></tr><tr><th id="L214"><a href="#L214">214</a></th><td>By simply redeclaring the machine parameter record instantiated in the drive parameter record, a machine with different parameters can be simulated.</td></tr><tr><th id="L215"><a href="#L215">215</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L216"><a href="#L216">216</a></th><td><span class="p">&lt;/</span><span class="nt">html</span><span class="p">&gt;</span><span class="s2">"</span><span class="p">));</span></td></tr><tr><th id="L217"><a href="#L217">217</a></th><td>  <span class="kr">end</span> <span class="nc">DCPM_SpeedControlled</span><span class="p">;</span></td></tr><tr><th id="L218"><a href="#L218">218</a></th><td></td></tr><tr><th id="L219"><a href="#L219">219</a></th><td>  <span class="kr">package</span> <span class="nc">DCPM_Utilities</span> <span class="s2">"Utilities for DC_Drives"</span></td></tr><tr><th id="L220"><a href="#L220">220</a></th><td>    <span class="kr">extends</span> Modelica<span class="o">.</span>Icons<span class="o">.</span>UtilitiesPackage<span class="p">;</span></td></tr><tr><th id="L221"><a href="#L221">221</a></th><td>    <span class="kr">model</span> <span class="nc">DCPM</span> <span class="s2">"Simple DC PM model"</span></td></tr><tr><th id="L222"><a href="#L222">222</a></th><td>      <span class="kr">extends</span> Modelica<span class="o">.</span>Electrical<span class="o">.</span>Machines<span class="o">.</span>Icons<span class="o">.</span>Machine<span class="p">;</span></td></tr><tr><th id="L223"><a href="#L223">223</a></th><td>      <span class="kr">parameter</span> MachineData machineData</td></tr><tr><th id="L224"><a href="#L224">224</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">60</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="mi">80</span><span class="p">,</span><span class="mi">60</span><span class="p">}})));</span></td></tr><tr><th id="L225"><a href="#L225">225</a></th><td>      <span class="kr">output</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Current iA<span class="p">(</span>start<span class="o">=</span><span class="mi">0</span><span class="p">)</span><span class="o">=</span>resistor<span class="o">.</span>i <span class="s2">"Armature current"</span><span class="p">;</span></td></tr><tr><th id="L226"><a href="#L226">226</a></th><td>      <span class="kr">output</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Angle phi<span class="p">(</span>start<span class="o">=</span><span class="mi">0</span><span class="p">)</span><span class="o">=</span>shaft<span class="o">.</span>phi <span class="s2">"Shaft angle"</span><span class="p">;</span></td></tr><tr><th id="L227"><a href="#L227">227</a></th><td>      Modelica<span class="o">.</span>Blocks<span class="o">.</span>Interfaces<span class="o">.</span>RealOutput w<span class="p">(</span>start<span class="o">=</span><span class="mi">0</span><span class="p">,</span> unit<span class="o">=</span><span class="s2">"rad/s"</span><span class="p">,</span> displayUnit<span class="o">=</span><span class="s2">"1/min"</span><span class="p">)</span></td></tr><tr><th id="L228"><a href="#L228">228</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span></td></tr><tr><th id="L229"><a href="#L229">229</a></th><td>            extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L230"><a href="#L230">230</a></th><td>            rotation<span class="o">=</span><span class="mi">180</span><span class="p">,</span></td></tr><tr><th id="L231"><a href="#L231">231</a></th><td>            origin<span class="o">=</span><span class="p">{</span><span class="o">-</span><span class="mi">110</span><span class="p">,</span><span class="mi">0</span><span class="p">})));</span></td></tr><tr><th id="L232"><a href="#L232">232</a></th><td>      Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Interfaces<span class="o">.</span>PositivePin pin_p <span class="s2">"Positive armature pin"</span></td></tr><tr><th id="L233"><a href="#L233">233</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">50</span><span class="p">,</span><span class="mi">90</span><span class="p">},{</span><span class="mi">70</span><span class="p">,</span><span class="mi">110</span><span class="p">}})));</span></td></tr><tr><th id="L234"><a href="#L234">234</a></th><td>      Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Interfaces<span class="o">.</span>NegativePin pin_n <span class="s2">"Negative armature pin"</span></td></tr><tr><th id="L235"><a href="#L235">235</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">70</span><span class="p">,</span><span class="mi">90</span><span class="p">},{</span><span class="o">-</span><span class="mi">50</span><span class="p">,</span><span class="mi">110</span><span class="p">}})));</span></td></tr><tr><th id="L236"><a href="#L236">236</a></th><td>      Modelica<span class="o">.</span>Mechanics<span class="o">.</span>Rotational<span class="o">.</span>Interfaces<span class="o">.</span>Flange_a shaft <span class="s2">"Shaft"</span></td></tr><tr><th id="L237"><a href="#L237">237</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">90</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">110</span><span class="p">,</span><span class="mi">10</span><span class="p">}})));</span></td></tr><tr><th id="L238"><a href="#L238">238</a></th><td>      Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Basic<span class="o">.</span>Resistor resistor<span class="p">(</span>R<span class="o">=</span>machineData<span class="o">.</span>RA<span class="p">,</span></td></tr><tr><th id="L239"><a href="#L239">239</a></th><td>          T_ref<span class="o">=</span><span class="mf">293.15</span><span class="p">)</span></td></tr><tr><th id="L240"><a href="#L240">240</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L241"><a href="#L241">241</a></th><td>            rotation<span class="o">=</span><span class="mi">270</span><span class="p">,</span></td></tr><tr><th id="L242"><a href="#L242">242</a></th><td>            origin<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">60</span><span class="p">})));</span></td></tr><tr><th id="L243"><a href="#L243">243</a></th><td>      Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Basic<span class="o">.</span>Inductor inductor<span class="p">(</span>L<span class="o">=</span>machineData<span class="o">.</span>LA<span class="p">)</span></td></tr><tr><th id="L244"><a href="#L244">244</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L245"><a href="#L245">245</a></th><td>            rotation<span class="o">=</span><span class="mi">270</span><span class="p">,</span></td></tr><tr><th id="L246"><a href="#L246">246</a></th><td>            origin<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">30</span><span class="p">})));</span></td></tr><tr><th id="L247"><a href="#L247">247</a></th><td>      Modelica<span class="o">.</span>Electrical<span class="o">.</span>Analog<span class="o">.</span>Basic<span class="o">.</span>EMF emf<span class="p">(</span>k<span class="o">=</span>machineData<span class="o">.</span>kPhi<span class="p">)</span></td></tr><tr><th id="L248"><a href="#L248">248</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span></td></tr><tr><th id="L249"><a href="#L249">249</a></th><td>            transformation<span class="p">(</span></td></tr><tr><th id="L250"><a href="#L250">250</a></th><td>            extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L251"><a href="#L251">251</a></th><td>            rotation<span class="o">=</span><span class="mi">0</span><span class="p">,</span></td></tr><tr><th id="L252"><a href="#L252">252</a></th><td>            origin<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">})));</span></td></tr><tr><th id="L253"><a href="#L253">253</a></th><td>      Modelica<span class="o">.</span>Mechanics<span class="o">.</span>Rotational<span class="o">.</span>Components<span class="o">.</span>Inertia inertia<span class="p">(</span>J<span class="o">=</span>machineData<span class="o">.</span>J<span class="p">)</span></td></tr><tr><th id="L254"><a href="#L254">254</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="mi">40</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">60</span><span class="p">,</span><span class="mi">10</span><span class="p">}})));</span></td></tr><tr><th id="L255"><a href="#L255">255</a></th><td>      Modelica<span class="o">.</span>Mechanics<span class="o">.</span>Rotational<span class="o">.</span>Sensors<span class="o">.</span>SpeedSensor speedSensor</td></tr><tr><th id="L256"><a href="#L256">256</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span></td></tr><tr><th id="L257"><a href="#L257">257</a></th><td>            extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span></td></tr><tr><th id="L258"><a href="#L258">258</a></th><td>            rotation<span class="o">=</span><span class="mi">270</span><span class="p">,</span></td></tr><tr><th id="L259"><a href="#L259">259</a></th><td>            origin<span class="o">=</span><span class="p">{</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">30</span><span class="p">})));</span></td></tr><tr><th id="L260"><a href="#L260">260</a></th><td>    <span class="kr">equation</span></td></tr><tr><th id="L261"><a href="#L261">261</a></th><td>      <span class="kr">connect</span><span class="p">(</span>resistor<span class="o">.</span>n<span class="p">,</span> inductor<span class="o">.</span>p<span class="p">)</span></td></tr><tr><th id="L262"><a href="#L262">262</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mf">1.77636e-15</span><span class="p">,</span><span class="mi">50</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="mi">50</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="mi">40</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="mi">40</span><span class="p">}},</span>color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L263"><a href="#L263">263</a></th><td>      <span class="kr">connect</span><span class="p">(</span>inductor<span class="o">.</span>n<span class="p">,</span> emf<span class="o">.</span>p<span class="p">)</span></td></tr><tr><th id="L264"><a href="#L264">264</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mf">1.77636e-15</span><span class="p">,</span><span class="mi">20</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="mi">20</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="mi">10</span><span class="p">}},</span>color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L265"><a href="#L265">265</a></th><td>      <span class="kr">connect</span><span class="p">(</span>emf<span class="o">.</span>flange<span class="p">,</span> inertia<span class="o">.</span>flange_a<span class="p">)</span></td></tr><tr><th id="L266"><a href="#L266">266</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">10</span><span class="p">,</span><span class="mi">0</span><span class="p">},{</span><span class="mi">40</span><span class="p">,</span><span class="mi">0</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">}));</span></td></tr><tr><th id="L267"><a href="#L267">267</a></th><td>      <span class="kr">connect</span><span class="p">(</span>resistor<span class="o">.</span>p<span class="p">,</span> pin_p<span class="p">)</span></td></tr><tr><th id="L268"><a href="#L268">268</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">0</span><span class="p">,</span><span class="mi">70</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="mi">80</span><span class="p">},{</span><span class="mi">60</span><span class="p">,</span><span class="mi">80</span><span class="p">},{</span><span class="mi">60</span><span class="p">,</span><span class="mi">100</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L269"><a href="#L269">269</a></th><td>      <span class="kr">connect</span><span class="p">(</span>emf<span class="o">.</span>n<span class="p">,</span> pin_n<span class="p">)</span></td></tr><tr><th id="L270"><a href="#L270">270</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">0</span><span class="p">,</span><span class="o">-</span><span class="mi">10</span><span class="p">},{</span><span class="mi">0</span><span class="p">,</span><span class="o">-</span><span class="mi">20</span><span class="p">},{</span><span class="o">-</span><span class="mi">60</span><span class="p">,</span><span class="o">-</span><span class="mi">20</span><span class="p">},{</span><span class="o">-</span><span class="mi">60</span><span class="p">,</span><span class="mi">100</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">255</span><span class="p">}));</span></td></tr><tr><th id="L271"><a href="#L271">271</a></th><td>      <span class="kr">connect</span><span class="p">(</span>inertia<span class="o">.</span>flange_b<span class="p">,</span> shaft<span class="p">)</span></td></tr><tr><th id="L272"><a href="#L272">272</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">60</span><span class="p">,</span><span class="mi">0</span><span class="p">},{</span><span class="mi">100</span><span class="p">,</span><span class="mi">0</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">}));</span></td></tr><tr><th id="L273"><a href="#L273">273</a></th><td>      <span class="kr">connect</span><span class="p">(</span>inertia<span class="o">.</span>flange_b<span class="p">,</span> speedSensor<span class="o">.</span>flange<span class="p">)</span></td></tr><tr><th id="L274"><a href="#L274">274</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">60</span><span class="p">,</span><span class="mi">0</span><span class="p">},{</span><span class="mi">80</span><span class="p">,</span><span class="mi">0</span><span class="p">},{</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">20</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">}));</span></td></tr><tr><th id="L275"><a href="#L275">275</a></th><td>      <span class="kr">connect</span><span class="p">(</span>speedSensor<span class="o">.</span>w<span class="p">,</span> w<span class="p">)</span></td></tr><tr><th id="L276"><a href="#L276">276</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Line<span class="p">(</span>points<span class="o">=</span><span class="p">{{</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">41</span><span class="p">},{</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">},{</span><span class="o">-</span><span class="mi">80</span><span class="p">,</span><span class="o">-</span><span class="mi">60</span><span class="p">},</span> <span class="p">{</span><span class="o">-</span><span class="mi">80</span><span class="p">,</span><span class="mi">0</span><span class="p">},{</span><span class="o">-</span><span class="mi">110</span><span class="p">,</span><span class="mi">0</span><span class="p">}},</span> color<span class="o">=</span><span class="p">{</span><span class="mi">0</span><span class="p">,</span><span class="mi">0</span><span class="p">,</span><span class="mi">127</span><span class="p">}));</span></td></tr><tr><th id="L277"><a href="#L277">277</a></th><td>      <span class="kr">annotation</span> <span class="p">(</span></td></tr><tr><th id="L278"><a href="#L278">278</a></th><td>        Icon<span class="p">(</span>graphics<span class="o">=</span><span class="p">{</span>Text<span class="p">(</span></td></tr><tr><th id="L279"><a href="#L279">279</a></th><td>              extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">100</span><span class="p">,</span><span class="o">-</span><span class="mi">100</span><span class="p">},{</span><span class="mi">100</span><span class="p">,</span><span class="o">-</span><span class="mi">140</span><span class="p">}},</span></td></tr><tr><th id="L280"><a href="#L280">280</a></th><td>              lineColor<span class="o">=</span><span class="p">{</span><span class="mi">28</span><span class="p">,</span><span class="mi">108</span><span class="p">,</span><span class="mi">200</span><span class="p">},</span></td></tr><tr><th id="L281"><a href="#L281">281</a></th><td>              textString<span class="o">=</span><span class="s2">"%name"</span><span class="p">)}),</span> Documentation<span class="p">(</span>info<span class="o">=</span><span class="s2">"</span><span class="p">&lt;</span><span class="nt">html</span><span class="p">&gt;</span></td></tr><tr><th id="L282"><a href="#L282">282</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L283"><a href="#L283">283</a></th><td>Simple model of a DC PM machine, comprising armature resistance, armature inductance, emf (including torque generation), inertia and pseed measurement.</td></tr><tr><th id="L284"><a href="#L284">284</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L285"><a href="#L285">285</a></th><td><span class="p">&lt;/</span><span class="nt">html</span><span class="p">&gt;</span><span class="s2">"</span><span class="p">));</span></td></tr><tr><th id="L286"><a href="#L286">286</a></th><td>    <span class="kr">end</span> <span class="nc">DCPM</span><span class="p">;</span></td></tr><tr><th id="L287"><a href="#L287">287</a></th><td></td></tr><tr><th id="L288"><a href="#L288">288</a></th><td>    <span class="kr">record</span> <span class="nc">DriveData</span> <span class="s2">"Parameters of the whole drive"</span></td></tr><tr><th id="L289"><a href="#L289">289</a></th><td>      <span class="kr">extends</span> Modelica<span class="o">.</span>Icons<span class="o">.</span>Record<span class="p">;</span></td></tr><tr><th id="L290"><a href="#L290">290</a></th><td>      <span class="kr">import</span> Modelica<span class="o">.</span>Constants<span class="o">.</span>pi<span class="p">;</span></td></tr><tr><th id="L291"><a href="#L291">291</a></th><td>      <span class="kr">replaceable</span> <span class="kr">parameter</span> DC_Drive<span class="o">.</span>DCPM_Utilities<span class="o">.</span>MachineData machineData</td></tr><tr><th id="L292"><a href="#L292">292</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>choicesAllMatching<span class="o">=</span><span class="kc">true</span><span class="p">,</span> Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="mi">40</span><span class="p">},</span></td></tr><tr><th id="L293"><a href="#L293">293</a></th><td>                <span class="p">{</span><span class="mi">10</span><span class="p">,</span><span class="mi">60</span><span class="p">}})));</span></td></tr><tr><th id="L294"><a href="#L294">294</a></th><td></td></tr><tr><th id="L295"><a href="#L295">295</a></th><td>      <span class="kr">parameter</span> ControllerData controllerData<span class="p">(</span></td></tr><tr><th id="L296"><a href="#L296">296</a></th><td>        kpI<span class="o">=</span>machineData<span class="o">.</span>LA<span class="o">/</span><span class="p">(</span><span class="mi">2</span><span class="o">*</span>Td<span class="p">),</span></td></tr><tr><th id="L297"><a href="#L297">297</a></th><td>        TiI<span class="o">=</span>machineData<span class="o">.</span>LA<span class="o">/</span>machineData<span class="o">.</span>RA<span class="p">,</span></td></tr><tr><th id="L298"><a href="#L298">298</a></th><td>        Tsub<span class="o">=</span><span class="mi">2</span><span class="o">*</span>Td<span class="p">,</span></td></tr><tr><th id="L299"><a href="#L299">299</a></th><td>        kpw<span class="o">=</span><span class="p">(</span>machineData<span class="o">.</span>J <span class="o">+</span> JL<span class="p">)</span><span class="o">/</span><span class="p">(</span><span class="mi">2</span><span class="o">*</span>controllerData<span class="o">.</span>Tsub<span class="p">),</span></td></tr><tr><th id="L300"><a href="#L300">300</a></th><td>        Tiw<span class="o">=</span><span class="mi">4</span><span class="o">*</span>controllerData<span class="o">.</span>Tsub<span class="p">)</span></td></tr><tr><th id="L301"><a href="#L301">301</a></th><td>        <span class="kr">annotation</span> <span class="p">(</span>Placement<span class="p">(</span>transformation<span class="p">(</span>extent<span class="o">=</span><span class="p">{{</span><span class="o">-</span><span class="mi">10</span><span class="p">,</span><span class="mi">0</span><span class="p">},{</span><span class="mi">10</span><span class="p">,</span><span class="mi">20</span><span class="p">}})));</span></td></tr><tr><th id="L302"><a href="#L302">302</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Inertia JL<span class="o">=</span>machineData<span class="o">.</span>J <span class="s2">"Load inertia"</span><span class="p">;</span></td></tr><tr><th id="L303"><a href="#L303">303</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Voltage VBat<span class="o">=</span><span class="mf">1.2</span><span class="o">*</span>machineData<span class="o">.</span>VANominal <span class="s2">"Battery voltage"</span><span class="p">;</span></td></tr><tr><th id="L304"><a href="#L304">304</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Current IMax<span class="o">=</span><span class="mf">1.5</span><span class="o">*</span>machineData<span class="o">.</span>IANominal <span class="s2">"Max. armature current"</span><span class="p">;</span></td></tr><tr><th id="L305"><a href="#L305">305</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Frequency fSwitch<span class="o">=</span><span class="mf">1e3</span> <span class="s2">"Switching frequency"</span><span class="p">;</span></td></tr><tr><th id="L306"><a href="#L306">306</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Time Td<span class="o">=</span><span class="mf">0.5</span><span class="o">/</span>fSwitch <span class="s2">"Dead time of inverter"</span></td></tr><tr><th id="L307"><a href="#L307">307</a></th><td>        <span class="kr">annotation</span><span class="p">(</span>Dialog<span class="p">(</span>enable<span class="o">=</span><span class="kc">false</span><span class="p">));</span></td></tr><tr><th id="L308"><a href="#L308">308</a></th><td>      <span class="kr">annotation</span><span class="p">(</span>defaultComponentPrefixes<span class="o">=</span><span class="s2">"parameter"</span><span class="p">,</span> defaultComponentName<span class="o">=</span><span class="s2">"driveData"</span><span class="p">,</span></td></tr><tr><th id="L309"><a href="#L309">309</a></th><td>        Documentation<span class="p">(</span>info<span class="o">=</span><span class="s2">"</span><span class="p">&lt;</span><span class="nt">html</span><span class="p">&gt;</span></td></tr><tr><th id="L310"><a href="#L310">310</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L311"><a href="#L311">311</a></th><td>The drive parameter record contains the machine parameter record, additional parameters and fills the controller parameter record. </td></tr><tr><th id="L312"><a href="#L312">312</a></th><td>Simulating another machine (with different parameters), the machine parameter record can be redeclared. </td></tr><tr><th id="L313"><a href="#L313">313</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L314"><a href="#L314">314</a></th><td><span class="p">&lt;/</span><span class="nt">html</span><span class="p">&gt;</span><span class="s2">"</span><span class="p">));</span></td></tr><tr><th id="L315"><a href="#L315">315</a></th><td>    <span class="kr">end</span> <span class="nc">DriveData</span><span class="p">;</span></td></tr><tr><th id="L316"><a href="#L316">316</a></th><td></td></tr><tr><th id="L317"><a href="#L317">317</a></th><td>    <span class="kr">record</span> <span class="nc">ControllerData</span> <span class="s2">"Controller parameters"</span></td></tr><tr><th id="L318"><a href="#L318">318</a></th><td>      <span class="kr">extends</span> Modelica<span class="o">.</span>Icons<span class="o">.</span>Record<span class="p">;</span></td></tr><tr><th id="L319"><a href="#L319">319</a></th><td>      <span class="kr">parameter</span> <span class="nb">Real</span> kpI <span class="s2">"Proportional gain of current controller"</span><span class="p">;</span></td></tr><tr><th id="L320"><a href="#L320">320</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Time TiI <span class="s2">"Integral time constant of current controller"</span><span class="p">;</span></td></tr><tr><th id="L321"><a href="#L321">321</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Time Tsub <span class="s2">"Substitute time constant"</span><span class="p">;</span></td></tr><tr><th id="L322"><a href="#L322">322</a></th><td>      <span class="kr">parameter</span> <span class="nb">Real</span> kpw <span class="s2">"Porportional gain of speed controller"</span><span class="p">;</span></td></tr><tr><th id="L323"><a href="#L323">323</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Time Tiw <span class="s2">"Integral time constant of speed controller"</span><span class="p">;</span></td></tr><tr><th id="L324"><a href="#L324">324</a></th><td>      <span class="kr">annotation</span><span class="p">(</span>defaultComponentPrefixes<span class="o">=</span><span class="s2">"parameter"</span><span class="p">,</span> defaultComponentName<span class="o">=</span><span class="s2">"controllerData"</span><span class="p">,</span></td></tr><tr><th id="L325"><a href="#L325">325</a></th><td>        Documentation<span class="p">(</span>info<span class="o">=</span><span class="s2">"</span><span class="p">&lt;</span><span class="nt">html</span><span class="p">&gt;</span></td></tr><tr><th id="L326"><a href="#L326">326</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L327"><a href="#L327">327</a></th><td>The controller parameter record is used in the drive parameters record, and filled in that record (based on the machine parameters).</td></tr><tr><th id="L328"><a href="#L328">328</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L329"><a href="#L329">329</a></th><td><span class="p">&lt;/</span><span class="nt">html</span><span class="p">&gt;</span><span class="s2">"</span><span class="p">));</span></td></tr><tr><th id="L330"><a href="#L330">330</a></th><td>    <span class="kr">end</span> <span class="nc">ControllerData</span><span class="p">;</span></td></tr><tr><th id="L331"><a href="#L331">331</a></th><td></td></tr><tr><th id="L332"><a href="#L332">332</a></th><td>    <span class="kr">record</span> <span class="nc">MachineData</span> <span class="s2">"Standard machine parameters"</span></td></tr><tr><th id="L333"><a href="#L333">333</a></th><td>      <span class="kr">extends</span> Modelica<span class="o">.</span>Icons<span class="o">.</span>Record<span class="p">;</span></td></tr><tr><th id="L334"><a href="#L334">334</a></th><td>      <span class="kr">import</span> Modelica<span class="o">.</span>Constants<span class="o">.</span>pi<span class="p">;</span></td></tr><tr><th id="L335"><a href="#L335">335</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Voltage VANominal<span class="o">=</span><span class="mi">100</span> <span class="s2">"Nominal armature voltage"</span><span class="p">;</span></td></tr><tr><th id="L336"><a href="#L336">336</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Current IANominal<span class="o">=</span><span class="mi">100</span> <span class="s2">"Nominal armature current"</span><span class="p">;</span></td></tr><tr><th id="L337"><a href="#L337">337</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>AngularVelocity wNominal<span class="o">=</span><span class="mi">1425</span><span class="o">*</span>pi<span class="o">/</span><span class="mi">30</span> <span class="s2">"Nominal speed"</span><span class="p">;</span></td></tr><tr><th id="L338"><a href="#L338">338</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Resistance RA<span class="o">=</span><span class="mf">0.05</span> <span class="s2">"Armature resistance"</span><span class="p">;</span></td></tr><tr><th id="L339"><a href="#L339">339</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Inductance LA<span class="o">=</span><span class="mf">0.0015</span> <span class="s2">"Armature inductance"</span><span class="p">;</span></td></tr><tr><th id="L340"><a href="#L340">340</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Voltage ViNominal<span class="o">=</span>VANominal <span class="o">-</span> RA<span class="o">*</span>IANominal <span class="s2">"Nominal induced voltage"</span></td></tr><tr><th id="L341"><a href="#L341">341</a></th><td>        <span class="kr">annotation</span><span class="p">(</span>Dialog<span class="p">(</span>enable<span class="o">=</span><span class="kc">false</span><span class="p">));</span></td></tr><tr><th id="L342"><a href="#L342">342</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>ElectricalTorqueConstant kPhi<span class="o">=</span>ViNominal<span class="o">/</span>wNominal <span class="s2">"Flux constant"</span><span class="p">;</span></td></tr><tr><th id="L343"><a href="#L343">343</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Inertia J<span class="o">=</span><span class="mf">0.29</span> <span class="s2">"Rotor inertia"</span><span class="p">;</span></td></tr><tr><th id="L344"><a href="#L344">344</a></th><td>      <span class="kr">parameter</span> Modelica<span class="o">.</span>SIunits<span class="o">.</span>Torque tauNominal<span class="o">=</span>kPhi<span class="o">*</span>IANominal <span class="s2">"Nominal torque"</span></td></tr><tr><th id="L345"><a href="#L345">345</a></th><td>        <span class="kr">annotation</span><span class="p">(</span>Dialog<span class="p">(</span>enable<span class="o">=</span><span class="kc">false</span><span class="p">));</span></td></tr><tr><th id="L346"><a href="#L346">346</a></th><td>      <span class="kr">annotation</span><span class="p">(</span>defaultComponentPrefixes<span class="o">=</span><span class="s2">"parameter"</span><span class="p">,</span> defaultComponentName<span class="o">=</span><span class="s2">"machineData"</span><span class="p">,</span></td></tr><tr><th id="L347"><a href="#L347">347</a></th><td>        Documentation<span class="p">(</span>info<span class="o">=</span><span class="s2">"</span><span class="p">&lt;</span><span class="nt">html</span><span class="p">&gt;</span></td></tr><tr><th id="L348"><a href="#L348">348</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L349"><a href="#L349">349</a></th><td>The machine parameter record contains all necessary parameters of a DC PM machine. </td></tr><tr><th id="L350"><a href="#L350">350</a></th><td>It is used to parameterize the DCPM model, and it is used in the drive parameter record. </td></tr><tr><th id="L351"><a href="#L351">351</a></th><td>Extending from this record, the parameters of other machines (with different parameters) can be saved.</td></tr><tr><th id="L352"><a href="#L352">352</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L353"><a href="#L353">353</a></th><td><span class="p">&lt;/</span><span class="nt">html</span><span class="p">&gt;</span><span class="s2">"</span><span class="p">));</span></td></tr><tr><th id="L354"><a href="#L354">354</a></th><td>    <span class="kr">end</span> <span class="nc">MachineData</span><span class="p">;</span></td></tr><tr><th id="L355"><a href="#L355">355</a></th><td></td></tr><tr><th id="L356"><a href="#L356">356</a></th><td>    <span class="kr">record</span> <span class="nc">M48V</span> <span class="s2">"Real machine 48 V"</span></td></tr><tr><th id="L357"><a href="#L357">357</a></th><td>      <span class="kr">import</span> Modelica<span class="o">.</span>Constants<span class="o">.</span>pi<span class="p">;</span></td></tr><tr><th id="L358"><a href="#L358">358</a></th><td>      <span class="kr">extends</span> DC_Drive<span class="o">.</span>DCPM_Utilities<span class="o">.</span>MachineData<span class="p">(</span></td></tr><tr><th id="L359"><a href="#L359">359</a></th><td>        VANominal<span class="o">=</span><span class="mi">48</span><span class="p">,</span></td></tr><tr><th id="L360"><a href="#L360">360</a></th><td>        IANominal<span class="o">=</span><span class="mi">25</span><span class="p">,</span></td></tr><tr><th id="L361"><a href="#L361">361</a></th><td>        wNominal<span class="o">=</span><span class="mi">3500</span><span class="o">*</span>pi<span class="o">/</span><span class="mi">30</span><span class="p">,</span></td></tr><tr><th id="L362"><a href="#L362">362</a></th><td>        RA<span class="o">=</span><span class="mf">0.24</span><span class="p">,</span></td></tr><tr><th id="L363"><a href="#L363">363</a></th><td>        LA<span class="o">=</span><span class="mf">0.004</span><span class="p">,</span></td></tr><tr><th id="L364"><a href="#L364">364</a></th><td>        J<span class="o">=</span><span class="mf">0.0008</span><span class="p">);</span></td></tr><tr><th id="L365"><a href="#L365">365</a></th><td>      <span class="kr">annotation</span><span class="p">(</span>defaultComponentPrefixes<span class="o">=</span><span class="s2">"parameter"</span><span class="p">,</span> defaultComponentName<span class="o">=</span><span class="s2">"machineData"</span><span class="p">,</span></td></tr><tr><th id="L366"><a href="#L366">366</a></th><td>        Documentation<span class="p">(</span>info<span class="o">=</span><span class="s2">"</span><span class="p">&lt;</span><span class="nt">html</span><span class="p">&gt;</span></td></tr><tr><th id="L367"><a href="#L367">367</a></th><td><span class="p">&lt;</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L368"><a href="#L368">368</a></th><td>Machine parameters of a real 48 W / 1 kW DCPM machine.</td></tr><tr><th id="L369"><a href="#L369">369</a></th><td><span class="p">&lt;/</span><span class="nt">p</span><span class="p">&gt;</span></td></tr><tr><th id="L370"><a href="#L370">370</a></th><td><span class="p">&lt;/</span><span class="nt">html</span><span class="p">&gt;</span><span class="s2">"</span><span class="p">));</span></td></tr><tr><th id="L371"><a href="#L371">371</a></th><td>    <span class="kr">end</span> <span class="nc">M48V</span><span class="p">;</span></td></tr><tr><th id="L372"><a href="#L372">372</a></th><td>  <span class="kr">end</span> <span class="nc">DCPM_Utilities</span><span class="p">;</span></td></tr><tr><th id="L373"><a href="#L373">373</a></th><td>  <span class="kr">annotation</span> <span class="p">(</span>uses<span class="p">(</span>Modelica<span class="p">(</span>version<span class="o">=</span><span class="s2">"3.2.3"</span><span class="p">)));</span></td></tr><tr><th id="L374"><a href="#L374">374</a></th><td><span class="kr">end</span> <span class="nc">DC_Drive</span><span class="p">;</span></td></tr></tbody></table>

        </div>
          <div style="display:none;"><input type="text" name="sfp_email" value="" /><input type="hidden" name="sfph_mail" value="" /></div><div class="buttons">
            <form method="get" action="">
              <div id="delete">
                <input type="hidden" name="action" value="delete" />
                <input type="submit" value="Delete attachment" />
              </div>
            </form>
          </div>
    </div>
    <div id="altlinks">
      <h3>Download in other formats:</h3>
      <ul>
        <li class="last first">
          <a rel="nofollow" href="/OpenModelica/raw-attachment/ticket/6287/DC_Drive.2.mo">Original Format</a>
        </li>
      </ul>
    </div>
    </div>
    <div id="footer" lang="en" xml:lang="en"><hr />
      <a id="tracpowered" href="http://trac.edgewall.org/"><img src="/OpenModelica/chrome/common/trac_logo_mini.png" height="30" width="107" alt="Trac Powered" /></a>
      <p class="left">Powered by <a href="/OpenModelica/about"><strong>Trac 1.0.9</strong></a><br />
        By <a href="http://www.edgewall.org/">Edgewall Software</a>.</p>
      <p class="right">Visit the Trac open source project at<br /><a href="http://trac.edgewall.org/">http://trac.edgewall.org/</a></p>
    </div>
  </body>
</html>