within Demo2P_modelica.StochasticFlows.Support;
model RandomCar "Elementary EVSE with RESS"
  parameter Real chargePower=22000;
  parameter Real probability=0.1 "probability of arrival at the given minute";
  parameter Modelica.SIunits.Time y_min=600 "durata minima della sosta";
  parameter Modelica.SIunits.Time y_max=1800 "durata massima della sosta";
  Real nextChargeEnd(start=-1);

  Modelica.Blocks.Interfaces.RealOutput y
    annotation (Placement(transformation(extent={{100,-10},{120,10}})));
  Modelica.Blocks.Noise.UniformNoise genArrivals(
    samplePeriod=60,
    useGlobalSeed=true,
    y_min=0,
    y_max=1)
    annotation (Placement(transformation(extent={{-90,-38},{-70,-18}})));
  Modelica.Blocks.Logical.GreaterThreshold toArrivals(threshold=0.9)
    annotation (Placement(transformation(extent={{-58,-38},{-38,-18}})));
  Modelica.Blocks.Noise.UniformNoise genDurations(
    samplePeriod=60,
    useGlobalSeed=true,
    y_min=y_min,
    y_max=y_max)
    annotation (Placement(transformation(extent={{-90,-74},{-70,-54}})));
  Modelica.Blocks.Sources.Constant chargePow(k=chargePower)
    annotation (Placement(transformation(extent={{-20,46},{0,66}})));
  Modelica.Blocks.Logical.Switch switch2
    annotation (Placement(transformation(extent={{14,20},{34,40}})));
  Modelica.Blocks.Sources.Constant const1(k=0)
    annotation (Placement(transformation(extent={{-18,2},{2,22}})));
  Modelica.Blocks.Sources.BooleanExpression charge(y=time < nextChargeEnd)
    annotation (Placement(transformation(extent={{-54,20},{-34,40}})));
equation
  when toArrivals.y then
    if time>nextChargeEnd then
      nextChargeEnd=time+genDurations.y;
    else
      nextChargeEnd=pre(nextChargeEnd);
    end if;
  end when;
  connect(genArrivals.y,toArrivals. u)
    annotation (Line(points={{-69,-28},{-60,-28}}, color={0,0,127}));
  connect(chargePow.y,switch2. u1)
    annotation (Line(points={{1,56},{12,56},{12,38}}, color={0,0,127}));
  connect(switch2.u3,const1. y)
    annotation (Line(points={{12,22},{6,22},{6,12},{3,12}}, color={0,0,127}));
  connect(charge.y, switch2.u2)
    annotation (Line(points={{-33,30},{12,30}}, color={255,0,255}));
  connect(y, switch2.y) annotation (Line(points={{110,0},{60,0},{60,30},{35,30}},
        color={0,0,127}));
  annotation (Icon(coordinateSystem(preserveAspectRatio=false), graphics={
        Line(points={{-152,50}}, color={28,108,200}),
        Text(
          extent={{-100,140},{108,108}},
          lineColor={0,0,255},
          textString="%name"),
        Rectangle(
          extent={{-98,100},{104,-98}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid),
        Line(
          points={{-58,10},{-38,10},{2,72},{42,8},{62,10}},
          color={28,108,200},
          smooth=Smooth.Bezier),
        Ellipse(extent={{-56,-22},{-18,-56}}, lineColor={28,108,200}),
        Ellipse(extent={{30,-22},{68,-56}}, lineColor={28,108,200})}),
                                                                 Diagram(
        coordinateSystem(preserveAspectRatio=false, extent={{-100,-80},{100,80}})),
    Documentation(info="<html>
<p>Scegliamo la scala temporale del minuto. Ogni minuto si estrae se in quel minuto &egrave; arrivata un&apos;auto. </p>
<p>Quando arriva un&apos;auto va scelto quanto tempo resta in carica. In questo modello le durate vengono generate ogni minuto ma selezionate solo all&apos;arrivo dell&apos;auto.</p>
<p>L&apos;energia &egrave; calcolata in questo modello senza considerare la possibilit&agrave; di avere pi&ugrave;auto simultanee</p>
</html>"),
    experiment(
      StopTime=86400,
      Interval=60,
      __Dymola_Algorithm="Dassl"));
end RandomCar;
