within Demo2P_modelica.StochasticFlows;
model GenerateArrivals "Random generation of arrivals"
  inner Modelica.Blocks.Noise.GlobalSeed globalSeed
    annotation (Placement(transformation(extent={{-48,28},{-28,48}})));
  Modelica.Blocks.Noise.UniformNoise uniformNoise(
    samplePeriod=60,
    y_min=0,
    y_max=1) annotation (Placement(transformation(extent={{-58,-22},{-38,-2}})));
  Modelica.Blocks.Logical.GreaterThreshold toArrivals(threshold=0.9)
    annotation (Placement(transformation(extent={{-26,-22},{-6,-2}})));
equation
  connect(uniformNoise.y, toArrivals.u)
    annotation (Line(points={{-37,-12},{-28,-12}}, color={0,0,127}));
  annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false, extent={{-80,-60},{80,60}}),
        graphics={Text(
          extent={{6,4},{46,-6}},
          lineColor={28,108,200},
          textString="v.info")}),
    Documentation(info="<html>
<p>Scegliamo la scala temporale del minuto. Ogni minuto si estrae se in quel minuto &egrave; arrivata un&apos;auto. </p>
<p>Per ora distribuzione uniforme con comparazione dell&apos;uscita ad una soglia</p>
</html>"),
    experiment(StopTime=3600, __Dymola_Algorithm="Dassl"));
end GenerateArrivals;
