within Demo2P_modelica.StochasticFlows.Support;
model RandomCar0 "Elementary EVSE with RESS"
  parameter Real chargePower=22000;
  parameter Real probability=0.1 "probability of arrival at the given minute";
  parameter Modelica.SIunits.Time y_min=600 "durata minima della sosta";
  parameter Modelica.SIunits.Time y_max=1800 "durata massima della sosta";
  Modelica.Blocks.Noise.UniformNoise genArrivals(
    samplePeriod=60,
    y_min=0,
    y_max=1)
    annotation (Placement(transformation(extent={{-94,-38},{-74,-18}})));
  Modelica.Blocks.Logical.GreaterThreshold toArrivals(threshold=1 - probability)
    annotation (Placement(transformation(extent={{-62,-38},{-42,-18}})));
  Modelica.Blocks.Noise.UniformNoise genDurations(
    samplePeriod=60,
    y_min=y_min,
    y_max=y_max)
    annotation (Placement(transformation(extent={{-94,-74},{-74,-54}})));
  Modelica.Blocks.Logical.Switch switch1
    annotation (Placement(transformation(extent={{4,-46},{24,-66}})));
  Modelica.Blocks.Sources.Constant const(k=0)
    annotation (Placement(transformation(extent={{-30,-36},{-10,-16}})));
  Modelica.Blocks.Logical.Timer timer
    annotation (Placement(transformation(extent={{-86,26},{-66,46}})));
  Modelica.Blocks.Logical.Less less
    annotation (Placement(transformation(extent={{-48,26},{-28,46}})));
  Modelica.Blocks.Sources.Constant chargePow(k=chargePower)
    annotation (Placement(transformation(extent={{-18,52},{2,72}})));
  Modelica.Blocks.Logical.Switch switch2
    annotation (Placement(transformation(extent={{16,26},{36,46}})));
  Modelica.Blocks.Sources.Constant const1(k=0)
    annotation (Placement(transformation(extent={{-16,8},{4,28}})));
  Modelica.Blocks.Interfaces.RealOutput y
    annotation (Placement(transformation(extent={{100,-10},{120,10}})));
equation
  connect(genArrivals.y, toArrivals.u)
    annotation (Line(points={{-73,-28},{-64,-28}}, color={0,0,127}));
  connect(toArrivals.y, switch1.u2) annotation (Line(points={{-41,-28},{-36,-28},
          {-36,-56},{2,-56}}, color={255,0,255}));
  connect(switch1.u1, genDurations.y)
    annotation (Line(points={{2,-64},{-73,-64}}, color={0,0,127}));
  connect(const.y, switch1.u3) annotation (Line(points={{-9,-26},{-4,-26},{-4,-48},
          {2,-48}}, color={0,0,127}));
  connect(timer.u, switch1.u2) annotation (Line(points={{-88,36},{-92,36},{-92,-4},
          {-36,-4},{-36,-56},{2,-56}}, color={255,0,255}));
  connect(less.u1, timer.y)
    annotation (Line(points={{-50,36},{-65,36}}, color={0,0,127}));
  connect(less.u2, switch1.y) annotation (Line(points={{-50,28},{-58,28},{-58,2},
          {34,2},{34,-56},{25,-56}}, color={0,0,127}));
  connect(switch2.u2, less.y)
    annotation (Line(points={{14,36},{-27,36}}, color={255,0,255}));
  connect(chargePow.y, switch2.u1)
    annotation (Line(points={{3,62},{14,62},{14,44}}, color={0,0,127}));
  connect(switch2.u3, const1.y)
    annotation (Line(points={{14,28},{8,28},{8,18},{5,18}}, color={0,0,127}));
  connect(switch2.y, y) annotation (Line(points={{37,36},{66,36},{66,0},{110,0}},
        color={0,0,127}));
  annotation (Icon(coordinateSystem(preserveAspectRatio=false), graphics={
        Line(points={{-152,50}}, color={28,108,200}),
        Text(
          extent={{-100,140},{108,108}},
          lineColor={0,0,255},
          textString="%name"),
        Rectangle(
          extent={{-98,100},{104,-98}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid),
        Line(
          points={{-58,10},{-38,10},{2,72},{42,8},{62,10}},
          color={28,108,200},
          smooth=Smooth.Bezier),
        Ellipse(extent={{-56,-22},{-18,-56}}, lineColor={28,108,200}),
        Ellipse(extent={{30,-22},{68,-56}}, lineColor={28,108,200})}),
                                                                 Diagram(
        coordinateSystem(preserveAspectRatio=false, extent={{-100,-80},{100,80}})),
    Documentation(info="<html>
<p>Scegliamo la scala temporale del minuto. Ogni minuto si estrae se in quel minuto &egrave; arrivata un&apos;auto. </p>
<p>Quando arriva un&apos;auto va scelto quanto tempo resta in carica. In questo modello le durate vengono generate ogni minuto ma selezionate solo all&apos;arrivo dell&apos;auto.</p>
<p>L&apos;energia &egrave; calcolata in questo modello senza considerare la possibilit&agrave; di avere pi&ugrave;auto simultanee</p>
</html>"),
    experiment(
      StopTime=86400,
      Interval=60,
      __Dymola_Algorithm="Dassl"));
end RandomCar0;
