within BIL100_Demo.BIL100_Modules;
model ALTVALI "VALI alternator"
  parameter Modelica.SIunits.Power PNA=1500e6 "Alternator nominal power";
  parameter Real eta_mec=0.995746 "Mechanical efficiency";

  Real eta_alt "Alternator efficiency";
  Real eta_elec "Electrical efficiency";
  Real cos_phi;
  Real RP;
  Real eta_elecA "Electrical efficiency for cos_phi=1";
  Real eta_elecB "Electrical efficiency for cos_phi=0.95";
  Real eta_elecC "Electrical efficiency for cos_phi=0.9";

  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal wTOTAL
    annotation (Placement(transformation(
        origin={-102,0},
        extent={{-10,-10},{10,10}},
        rotation=180)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal PACTIVE
    annotation (Placement(transformation(extent={{112,30},{92,50}}, rotation=
            0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal wPERT
    annotation (Placement(transformation(extent={{92,-70},{112,-50}},
          rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal wBRUT
    annotation (Placement(transformation(extent={{92,-30},{112,-10}},
          rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal PREACTIVE
    annotation (Placement(transformation(extent={{110,70},{90,90}}, rotation=
            0)));
equation

  /* Efficiency */
  cos_phi = PACTIVE.signal/sqrt(PACTIVE.signal^2+PREACTIVE.signal^2);
  RP = PACTIVE.signal/PNA;
  eta_elecA = 98.5262+4.1119*RP-7.0141*RP^2+4.8766*RP^3-1.2506*RP^4;
  eta_elecB = 98.1129+6.9255*RP-14.7998*RP^2+13.7177*RP^3-4.8062*RP^4;
  eta_elecC = 97.8771+8.4990*RP-19.1888*RP^2+18.7591*RP^3-6.9481*RP^4;

  if (cos_phi >= 0.95) then
    eta_elec = eta_elecB+(eta_elecA-eta_elecB)*(cos_phi-0.95)/(1-0.95);
  else
    eta_elec = eta_elecB+(eta_elecC-eta_elecB)*(cos_phi-0.95)/(0.9-0.95);
  end if;

  eta_alt = (eta_mec*eta_elec)/100;

  /* Power */
  wBRUT.signal = wTOTAL.signal*eta_alt;
  wPERT.signal = wTOTAL.signal - wBRUT.signal;
  PACTIVE.signal = wBRUT.signal;

  annotation (Diagram(graphics={Rectangle(extent={{-100,100},{100,-100}},
            lineColor={0,0,255}), Text(
          extent={{-67,42},{73,-36}},
          lineColor={0,0,255},
          textString=
               "ALT")}),Icon(graphics={Text(
          extent={{-67,42},{73,-36}},
          lineColor={0,0,255},
          textString=
               "ALT"), Rectangle(extent={{-100,100},{100,-100}}, lineColor={0,
              0,255})}));
end ALTVALI;
