within BIL100_Demo.BIL100_Modules;
model QPURG
   parameter Real CoeffQPURG2=1 "Ratio between QPURG2 and QPURG1";
   parameter Real CoeffQPURG3=1 "Ratio between QPURG3 and QPURG1";
   parameter Real CoeffQPURG4=1 "Ratio between QPURG4 and QPURG1";
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal QPUR2
    annotation (Placement(transformation(extent={{-92,10},{-112,30}},
          rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal QPUR3
    annotation (Placement(transformation(extent={{-92,-30},{-112,-10}},
          rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal QPUR4
    annotation (Placement(transformation(extent={{-92,-70},{-112,-50}},
          rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal QPUR0
    annotation (Placement(transformation(extent={{108,10},{88,-10}}, rotation=
           0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Math.Gain CoeffQPUR2(Gain=
        CoeffQPURG2)
    annotation (Placement(transformation(extent={{20,10},{0,30}}, rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Math.Gain CoeffQPUR3(Gain=
        CoeffQPURG3)
    annotation (Placement(transformation(extent={{20,-30},{0,-10}}, rotation=
            0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Math.Gain CoeffQPUR4(Gain=
        CoeffQPURG4)
    annotation (Placement(transformation(extent={{20,-70},{0,-50}}, rotation=
            0)));
equation
  connect(QPUR0, CoeffQPUR2.u) annotation (Line(points={{98,0},{40,0},{40,20},
          {21,20}}));
  connect(QPUR0, CoeffQPUR4.u) annotation (Line(points={{98,0},{60,0},{60,-60},
          {21,-60}}));
  connect(QPUR0, CoeffQPUR3.u) annotation (Line(points={{98,0},{40,0},{40,-20},
          {21,-20}}));
  connect(CoeffQPUR2.y, QPUR2) annotation (Line(points={{-1,20},{-102,20}}));
  connect(CoeffQPUR3.y, QPUR3) annotation (Line(points={{-1,-20},{-102,-20}}));
  connect(CoeffQPUR4.y, QPUR4) annotation (Line(points={{-1,-60},{-102,-60}}));
  annotation (Diagram(graphics),
                       Icon(graphics={Rectangle(extent={{-100,40},{100,-80}},
            lineColor={0,0,255}), Text(
          extent={{-54,14},{50,-50}},
          lineColor={0,0,255},
          textString="%name")}));
end QPURG;
