within BIL100_Demo;
model GV_Unit_Approximated
  /* WARNING: This model illustrates parts of an industrial use-case but the associated numerical values do not correspond to the reality of the industrial process */
  /* Model parameters */

  parameter Real rho=0;

  parameter Real GV1_CFDP1=1;
  parameter Real GV2_CFDP1=1;
  parameter Real GV3_CFDP1=1;
  parameter Real GV4_CFDP1=1;

  parameter Real VVP_1A_VAPF=0.99986;
  parameter Real VVP_2A_VAPF=0.99999;
  parameter Real VVP_3A_VAPF=0.99995;
  parameter Real VVP_4A_VAPF=0.99999;

  parameter Real DP_GV1_CFDP=1;
  parameter Real DP_GV2_CFDP=1;
  parameter Real DP_GV3_CFDP=1;
  parameter Real DP_GV4_CFDP=1;

  parameter Real DP_BAR1_CFDP=1;
  parameter Real DP_BAR2_CFDP=1;
  parameter Real DP_BAR3_CFDP=1;
  parameter Real DP_BAR4_CFDP=1;

  parameter Real QPUR12=1;
  parameter Real QPUR13=1;
  parameter Real QPUR14=1;

  /* Boundary conditions */
  parameter Real QARE0=2126.272222;
  parameter Real PARE0=7032392.1;
  parameter Real TARE0=500.2497543;

  parameter Real TGRE0=552.6833333;
  parameter Real QGSS0=183.713226;
  parameter Real QGRE0=1922.331218;
  parameter Real QSTR0=0;

  /* Guess values */
  parameter Real QVVP10=530.8138889;
  parameter Real QVVP20=522.2083333;
  parameter Real QVVP30=527.925;
  parameter Real QVVP40=525.0972222;

  Approximated.ApproximatedSplitter4 SEP_ARE
    annotation (Placement(transformation(
        origin={-140,-150},
        extent={{-10,-10},{10,10}},
        rotation=90)));
  BIL100_Modules.SensorAREx sensorARE4
    annotation (Placement(transformation(
        origin={-108,-110},
        extent={{-10,-10},{10,10}},
        rotation=90)));
  BIL100_Modules.SensorAREx sensorARE2
    annotation (Placement(transformation(
        origin={-168,-110},
        extent={{-10,-10},{10,10}},
        rotation=90)));
  BIL100_Modules.Utilities.SinkQ                   sinkQGSS(          Q0=QGSS0, T0=TGRE0,
    mode=0)
    annotation (Placement(transformation(extent={{260,130},{280,150}}, rotation=
           0)));
  BIL100_Modules.SensorARE1 sensorARE1
    annotation (Placement(transformation(
        origin={-188,-110},
        extent={{-10,-10},{10,10}},
        rotation=90)));
  BIL100_Modules.SensorAREx sensorARE3
    annotation (Placement(transformation(
        origin={-128,-110},
        extent={{-10,-10},{10,10}},
        rotation=90)));
  Approximated.ApproximatedSGVALI
                        GV1(
    Qnom_vvp=532,
    DPnom_vvp=2.14,
    CoeffDeltaP_are=GV1_CFDP1,
    x_vvp=VVP_1A_VAPF)   annotation (Placement(transformation(extent={{-190,0},
            {-170,20}}, rotation=0)));
  BIL100_Modules.Utilities.HeatSink2 W_GV1
    annotation (Placement(transformation(extent={{-290,0},{-270,20}}, rotation=
            0)));
  BIL100_Modules.Utilities.Sink                   sinkQPUR1(T0=TARE0, mode=0)
    annotation (Placement(transformation(extent={{-40,-10},{-20,10}}, rotation=
            0)));
  BIL100_Modules.Utilities.HeatSink2 W_GV2
    annotation (Placement(transformation(extent={{-290,-20},{-270,0}}, rotation=
           0)));
  Approximated.ApproximatedSGVALI
                        GV2(
    Qnom_vvp=527,
    DPnom_vvp=2.24,
    CoeffDeltaP_are=GV2_CFDP1,
    x_vvp=VVP_2A_VAPF)   annotation (Placement(transformation(extent={{-170,-20},
            {-150,0}}, rotation=0)));
  BIL100_Modules.Utilities.HeatSink2 W_GV3
    annotation (Placement(transformation(extent={{-290,-40},{-270,-20}},
          rotation=0)));
  Approximated.ApproximatedSGVALI
                        GV3(
    Qnom_vvp=539,
    DPnom_vvp=2.03,
    CoeffDeltaP_are=GV3_CFDP1,
    x_vvp=VVP_3A_VAPF)   annotation (Placement(transformation(extent={{-130,-40},
            {-110,-20}}, rotation=0)));
  BIL100_Modules.Utilities.HeatSink2 W_GV4
    annotation (Placement(transformation(extent={{-290,-60},{-270,-40}},
          rotation=0)));
  Approximated.ApproximatedSGVALI
                        GV4(
    Qnom_vvp=527,
    DPnom_vvp=2.01,
    CoeffDeltaP_are=GV4_CFDP1,
    x_vvp=VVP_4A_VAPF)   annotation (Placement(transformation(extent={{-110,-60},
            {-90,-40}}, rotation=0)));
  BIL100_Modules.Utilities.SinkQ                   sinkQPUR2(T0=TARE0, mode=0)
    annotation (Placement(transformation(extent={{-40,-30},{-20,-10}}, rotation=
           0)));
  BIL100_Modules.Utilities.SinkQ                   sinkQPUR3(T0=TARE0, mode=0)
    annotation (Placement(transformation(extent={{-40,-50},{-20,-30}}, rotation=
           0)));
  BIL100_Modules.Utilities.SinkQ                   sinkQPUR4(T0=TARE0, mode=0)
    annotation (Placement(transformation(extent={{-40,-70},{-20,-50}}, rotation=
           0)));
  Approximated.ApproximatedSingularPressureLossVALI
                                          DP_GV1(
    Qnom=535,
    deltaPnom=0.9e5,
    CoeffDeltaP=DP_GV1_CFDP)
                   annotation (Placement(transformation(extent={{-160,150},{
            -140,170}}, rotation=0)));
  Approximated.ApproximatedSingularPressureLossVALI
                                          DP_GV2(
    Qnom=535,
    deltaPnom=0.9e5,
    CoeffDeltaP=DP_GV2_CFDP)
                   annotation (Placement(transformation(extent={{-140,110},{
            -120,130}}, rotation=0)));
  Approximated.ApproximatedSingularPressureLossVALI
                                          DP_GV3(
    Qnom=535,
    deltaPnom=0.9e5,
    CoeffDeltaP=DP_GV3_CFDP)
                   annotation (Placement(transformation(extent={{-100,70},{-80,
            90}}, rotation=0)));
  Approximated.ApproximatedSingularPressureLossVALI
                                          DP_GV4(
    Qnom=535,
    deltaPnom=0.9e5,
    CoeffDeltaP=DP_GV4_CFDP)
                   annotation (Placement(transformation(extent={{-80,30},{-60,
            50}}, rotation=0)));
  BIL100_Modules.SensorVVP sensorVVP1 annotation (Placement(transformation(
          extent={{-100,158},{-80,178}}, rotation=0)));
  BIL100_Modules.SensorVVP sensorVVP2 annotation (Placement(transformation(
          extent={{-80,118},{-60,138}}, rotation=0)));
  BIL100_Modules.SensorVVP sensorVVP3 annotation (Placement(transformation(
          extent={{-40,78},{-20,98}}, rotation=0)));
  BIL100_Modules.SensorVVP sensorVVP4 annotation (Placement(transformation(
          extent={{-20,38},{0,58}}, rotation=0)));
  Approximated.ApproximatedSingularPressureLossVALI
                                          DP_BAR1(
    Qnom=547,
    CoeffDeltaP=DP_BAR1_CFDP,
    deltaPnom=100000,
    Q(fixed=true, start=QVVP10))
                   annotation (Placement(transformation(extent={{-40,150},{-20,
            170}}, rotation=0)));
  Approximated.ApproximatedSingularPressureLossVALI
                                          DP_BAR2(
    Qnom=541.1,
    CoeffDeltaP=DP_BAR2_CFDP,
    deltaPnom=99000,
    Q(fixed=true, start=QVVP20))
                   annotation (Placement(transformation(extent={{-20,109},{0,
            131}}, rotation=0)));
  Approximated.ApproximatedSingularPressureLossVALI
                                          DP_BAR3(
    Qnom=551.8,
    CoeffDeltaP=DP_BAR3_CFDP,
    deltaPnom=122000,
    Q(fixed=true, start=QVVP30))
                   annotation (Placement(transformation(extent={{20,70},{40,90}},
          rotation=0)));
  Approximated.ApproximatedSingularPressureLossVALI
                                          DP_BAR4(
    Qnom=537.2,
    CoeffDeltaP=DP_BAR4_CFDP,
    deltaPnom=115000,
    Q(fixed=true, start=QVVP40))
                   annotation (Placement(transformation(extent={{40,30},{60,50}},
          rotation=0)));
  Approximated.ApproximatedMixer4 MEL_GCT
    annotation (Placement(transformation(extent={{94,90},{114,110}}, rotation=0)));
  BIL100_Modules.SensorGCT sensorGCT annotation (Placement(transformation(
          extent={{140,98},{160,118}}, rotation=0)));
  BIL100_Modules.Utilities.SourcePQ                   sourcePQARE(
    P0=PARE0,
    Q0=QARE0,
    T0=TARE0)
    annotation (Placement(transformation(extent={{-230,-190},{-210,-170}},
          rotation=0)));
  BIL100_Modules.QPURG QPURG(
    CoeffQPURG2=QPUR12,
    CoeffQPURG3=QPUR13,
    CoeffQPURG4=QPUR14)      annotation (Placement(transformation(extent={{0,
            -40},{40,0}}, rotation=0)));
  ThermoSysPro.WaterSteam.Sensors.SensorQ sensorQPUR1
    annotation (Placement(transformation(extent={{-80,-2},{-60,18}}, rotation=0)));
  BIL100_Modules.BIL100 BIL100 annotation (Placement(transformation(extent={{
            -250,-40},{-210,0}}, rotation=0)));
  BIL100_Modules.Utilities.SinkQ                   sinkQGRE(          Q0=QGRE0, T0=TGRE0,
    mode=0)
    annotation (Placement(transformation(extent={{260,90},{280,110}}, rotation=
            0)));
  BIL100_Modules.Utilities.SinkQ                   sinkQSTR(          Q0=QSTR0, T0=TGRE0,
    mode=0)
    annotation (Placement(transformation(extent={{260,50},{280,70}}, rotation=0)));
  Approximated.ApproximatedSplitter3          SEP_VAP
    annotation (Placement(transformation(extent={{186,90},{206,110}}, rotation=
            0)));
  BIL100_Modules.SensorGRE sensorGRE annotation (Placement(transformation(
          extent={{220,98},{240,118}}, rotation=0)));
  Approximated.ApproximatedSingularPressureLoss
    singularPressureLossGSS(K=0, p_rho=rho)
    annotation (Placement(transformation(extent={{220,130},{240,150}}, rotation=
           0)));
  Approximated.ApproximatedSingularPressureLoss
    singularPressureLossSTR(K=0, p_rho=rho)
    annotation (Placement(transformation(extent={{220,50},{240,70}}, rotation=0)));
  Approximated.ApproximatedSingularPressureLoss
    singularPressureLossARE(K=0, p_rho=rho)
                                 annotation (Placement(transformation(extent={{-180,
            -190},{-160,-170}},      rotation=0)));
equation
  connect(sensorARE1.fluidInletI, SEP_ARE.Cs1)
    annotation (Line(points={{-180,-120},{-180,-146},{-150,-146}}));
  connect(sensorARE2.fluidInletI, SEP_ARE.Cs3)
    annotation (Line(points={{-160,-120},{-160,-140},{-144,-140}}));
  connect(sensorARE3.fluidInletI, SEP_ARE.Cs4)
    annotation (Line(points={{-120,-120},{-120,-140},{-136,-140}}));
  connect(sensorARE4.fluidInletI, SEP_ARE.Cs2)
    annotation (Line(points={{-100,-120},{-100,-146},{-130,-146}}));
  connect(GV1.C1_are, sensorARE1.fluidOutletI)
    annotation (Line(points={{-180,0.2},{-180,-100}}));
  connect(GV2.C1_are, sensorARE2.fluidOutletI)
    annotation (Line(points={{-160,-19.8},{-160,-100}}));
  connect(GV3.C1_are, sensorARE3.fluidOutletI)
    annotation (Line(points={{-120,-39.8},{-120,-100}}));
  connect(GV4.C1_are, sensorARE4.fluidOutletI)
    annotation (Line(points={{-100,-59.8},{-100,-100}}));
  connect(sinkQPUR2.C, GV2.C2_pur)
    annotation (Line(points={{-40,-20},{-60,-20},{-60,-15},{-157,-15}}));
  connect(sinkQPUR3.C, GV3.C2_pur)
    annotation (Line(points={{-40,-40},{-60,-40},{-60,-35},{-117,-35}}));
  connect(sinkQPUR4.C, GV4.C2_pur)
    annotation (Line(points={{-40,-60},{-60,-60},{-60,-55},{-97,-55}}));
  connect(DP_GV1.C1, GV1.C3_vvp)
    annotation (Line(points={{-160,160},{-180,160},{-180,20}}));
  connect(DP_GV2.C1, GV2.C3_vvp)
    annotation (Line(points={{-140,120},{-160,120},{-160,0}}));
  connect(DP_GV3.C1, GV3.C3_vvp)
    annotation (Line(points={{-100,80},{-120,80},{-120,-20}}));
  connect(DP_GV4.C1, GV4.C3_vvp)
    annotation (Line(points={{-80,40},{-100,40},{-100,-40}}));
  connect(sensorVVP1.fluidInletI, DP_GV1.C2)
    annotation (Line(points={{-100,160},{-140,160}}));
  connect(sensorVVP2.fluidInletI, DP_GV2.C2)
    annotation (Line(points={{-80,120},{-120,120}}));
  connect(sensorVVP3.fluidInletI, DP_GV3.C2)
    annotation (Line(points={{-40,80},{-80,80}}));
  connect(sensorVVP4.fluidInletI, DP_GV4.C2)
    annotation (Line(points={{-20,40},{-60,40}}));
  connect(DP_BAR1.C1, sensorVVP1.fluidOutletI)
    annotation (Line(points={{-40,160},{-80,160}}));
  connect(DP_BAR2.C1, sensorVVP2.fluidOutletI)
    annotation (Line(points={{-20,120},{-60,120}}));
  connect(DP_BAR3.C1, sensorVVP3.fluidOutletI)
    annotation (Line(points={{20,80},{-20,80}}));
  connect(DP_BAR4.C1, sensorVVP4.fluidOutletI)
    annotation (Line(points={{40,40},{0,40}}));
  connect(sensorGCT.fluidInletI, MEL_GCT.Cs)
    annotation (Line(points={{140,100},{114,100}}));
  connect(DP_BAR1.C2, MEL_GCT.Ce1) annotation (Line(points={{-20,160},{100,160},
          {100,110}}));
  connect(DP_BAR2.C2, MEL_GCT.Ce3) annotation (Line(points={{0,120},{80,120},{
          80,104},{94,104}}));
  connect(DP_BAR3.C2, MEL_GCT.Ce4) annotation (Line(points={{40,80},{80,80},{80,
          96.2},{94,96.2}}));
  connect(MEL_GCT.Ce2, DP_BAR4.C2)
    annotation (Line(points={{100,90},{100,40},{60,40}}));
  connect(sinkQPUR2.IMassFlow, QPURG.QPUR2)
                                         annotation (Line(points={{-30,-15},{
          -30,-12},{-20,-12},{-20,-16},{-0.4,-16}}));
  connect(sinkQPUR3.IMassFlow, QPURG.QPUR3)
                                         annotation (Line(points={{-30,-35},{
          -30,-28},{-20,-28},{-20,-24},{-0.4,-24}}));
  connect(QPURG.QPUR4, sinkQPUR4.IMassFlow)
                                         annotation (Line(points={{-0.4,-32},{
          -20,-32},{-20,-50},{-30,-50},{-30,-55}}));
  connect(sinkQPUR1.C, sensorQPUR1.C2)
                                    annotation (Line(points={{-40,0},{-50,0},{-59.8,
          0}}));
  connect(sensorQPUR1.C1, GV1.C2_pur)
    annotation (Line(points={{-80,0},{-88,0},{-88,5},{-177,5}}));
  connect(sensorQPUR1.Measure, QPURG.QPUR0)
    annotation (Line(points={{-70,18.2},{-70,22},{80,22},{80,-20},{39.6,-20}}));
  connect(W_GV1.C[1], BIL100.Ce1) annotation (Line(points={{-280,0.2},{-260,0.2},
          {-260,-12},{-250,-12}}, color={191,95,0}));
  connect(BIL100.Ce2, W_GV2.C[1]) annotation (Line(points={{-250,-20},{-264,-20},
          {-264,-19.8},{-280,-19.8}}, color={191,95,0}));
  connect(BIL100.Ce3, W_GV3.C[1]) annotation (Line(points={{-250,-28},{-270,-28},
          {-270,-39.8},{-280,-39.8}}, color={191,95,0}));
  connect(BIL100.Ce4, W_GV4.C[1]) annotation (Line(points={{-250,-36},{-260,-36},
          {-260,-59.8},{-280,-59.8}}, color={191,95,0}));
  connect(GV1.thermalPort, BIL100.Cs1) annotation (Line(points={{-184,14},{-200,
          14},{-200,-12},{-210,-12}}, color={191,95,0}));
  connect(GV2.thermalPort, BIL100.Cs2) annotation (Line(points={{-164,-6},{-190,
          -6},{-190,-20},{-210,-20}}, color={191,95,0}));
  connect(GV3.thermalPort, BIL100.Cs3) annotation (Line(points={{-124,-26},{
          -190,-26},{-190,-28},{-210,-28}}, color={191,95,0}));
  connect(GV4.thermalPort, BIL100.Cs4) annotation (Line(points={{-104,-46},{
          -200,-46},{-200,-36},{-210,-36}}, color={191,95,0}));
  connect(sinkQGRE.C, sensorGRE.fluidOutletI)
    annotation (Line(points={{260,100},{240,100}}));
  connect(sensorGRE.fluidInletI, SEP_VAP.Cs3)
    annotation (Line(points={{220,100},{206,100}}));
  connect(SEP_VAP.Ce, sensorGCT.fluidOutletI)
    annotation (Line(points={{186.2,100},{160,100}}));
  connect(sinkQGSS.C, singularPressureLossGSS.C2)
                                    annotation (Line(points={{260,140},{240,140}}));
  connect(singularPressureLossGSS.C1, SEP_VAP.Cs1)
    annotation (Line(points={{220,140},{200,140},{200,110}}));
  connect(sinkQSTR.C, singularPressureLossSTR.C2)
                                    annotation (Line(points={{260,60},{240,60}}));
  connect(singularPressureLossSTR.C1, SEP_VAP.Cs2)
    annotation (Line(points={{220,60},{200,60},{200,90}}));
  connect(singularPressureLossARE.C1, sourcePQARE.C)
    annotation (Line(points={{-180,-180},{-210,-180}}));
  connect(SEP_ARE.Ce, singularPressureLossARE.C2)
    annotation (Line(points={{-140.2,-160},{-140,-160},{-140,-180},{-160,-180}}));
  annotation (Diagram(coordinateSystem(
        preserveAspectRatio=true,
        extent={{-300,-200},{300,200}},
        initialScale=0.1), graphics),
    Icon(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-300,-200},{300,200}},
        initialScale=0.1), graphics={
        Rectangle(
          extent={{-140,120},{160,-80}},
          lineColor={0,0,255},
          fillColor={255,255,170},
          fillPattern=FillPattern.Solid),
        Text(
          extent={{-115,114},{121,-54}},
          lineColor={0,0,255},
          fillColor={255,255,170},
          fillPattern=FillPattern.Solid,
          textString="%name"),
        Polygon(
          points={{-140,120},{-98,140},{200,140},{160,120},{-140,120}},
          lineColor={0,0,0},
          fillPattern=FillPattern.VerticalCylinder,
          fillColor={255,255,0}),
        Polygon(
          points={{200,140},{200,-60},{160,-80},{160,120},{200,140}},
          lineColor={0,0,0},
          fillPattern=FillPattern.VerticalCylinder,
          fillColor={255,255,85})}));
end GV_Unit_Approximated;
