within BIL100_Demo.BIL100_Modules;
model AHPVALI "Preheater with condensation"
  ThermoSysPro.WaterSteam.Connectors.FluidOutletI Sc
    annotation (Placement(transformation(extent={{30,90},{50,110}}, rotation=
            0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInletI Ev
    annotation (Placement(transformation(extent={{-30,-110},{-10,-90}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInletI Ef
    annotation (Placement(transformation(extent={{90,-10},{110,10}}, rotation=
           0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutletI Sf
    annotation (Placement(transformation(extent={{-110,-10},{-90,10}},
          rotation=0)));
  SingularPressureLossVALI singularPressureLossVALI_AHP(
    Qnom=1100,
    deltaPnom=1.17e5,
    CoeffDeltaP=1) annotation (Placement(transformation(extent={{-60,-10},{
            -80,10}}, rotation=0)));
  ThermoSysPro.WaterSteam.PressureLosses.SingularPressureLoss
    singularPressureLossVALICNDf(K=0)
    annotation (Placement(transformation(
        origin={40,70},
        extent={{-10,-10},{10,10}},
        rotation=90)));
  ThermoSysPro.WaterSteam.PressureLosses.SingularPressureLoss
    singularPressureLossVALISOUT(K=0)
    annotation (Placement(transformation(
        origin={-20,-70},
        extent={{-10,-10},{10,10}},
        rotation=90)));
  ThermoSysPro.WaterSteam.PressureLosses.SingularPressureLoss
    singularPressureLossAHP(K=0) annotation (Placement(transformation(extent=
            {{80,-10},{60,10}}, rotation=0)));
  ThermoSysPro.WaterSteam.HeatExchangers.NTUWaterHeating nTUWaterHeating
    annotation (Placement(transformation(extent={{24,34},{-30,-34}}, rotation=
           0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInletI Ec
    annotation (Placement(transformation(extent={{10,-110},{30,-90}},
          rotation=0)));
  ThermoSysPro.WaterSteam.PressureLosses.SingularPressureLoss
    singularPressureLossVALICNDc(K=0)
    annotation (Placement(transformation(
        origin={20,-70},
        extent={{-10,-10},{10,10}},
        rotation=90)));
equation
  connect(singularPressureLossVALI_AHP.C2, Sf)
    annotation (Line(points={{-80,0},{-100,0}}, color={0,0,255}));
  connect(singularPressureLossVALICNDf.C2, Sc)
    annotation (Line(points={{40,80},{40,100}}, color={0,0,255}));
  connect(Ev, singularPressureLossVALISOUT.C1)
    annotation (Line(points={{-20,-100},{-20,-80}}));
  connect(Ef, singularPressureLossAHP.C1) annotation (Line(points={{100,0},{
          80,0}}));
  connect(singularPressureLossAHP.C2, nTUWaterHeating.Ee)
    annotation (Line(points={{60,0},{24.54,0}}, color={0,0,255}));
  connect(nTUWaterHeating.Se, singularPressureLossVALI_AHP.C1)
    annotation (Line(points={{-30,0},{-60,0}}, color={0,0,255}));
  connect(nTUWaterHeating.Sp, singularPressureLossVALICNDf.C1) annotation (Line(
        points={{13.2,11.22},{13.2,40},{40,40},{40,60}}, color={0,0,255}));
  connect(singularPressureLossVALISOUT.C2, nTUWaterHeating.Ev) annotation (Line(
        points={{-20,-60},{-20,-10.88},{-19.2,-10.88}}, color={0,0,255}));
  connect(singularPressureLossVALICNDc.C2, nTUWaterHeating.Ep) annotation (Line(
        points={{20,-60},{20,-20},{13.2,-20},{13.2,-11.56}}, color={0,0,255}));
  annotation (Diagram(graphics));
end AHPVALI;
