within BIL100_Demo.BIL100_Modules;
model SensorGRE
  ThermoSysPro.WaterSteam.Connectors.FluidInletI fluidInletI
    annotation (Placement(transformation(extent={{-110,-90},{-90,-70}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutletI fluidOutletI
    annotation (Placement(transformation(extent={{90,-90},{110,-70}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Sensors.SensorT N001MT
    annotation (Placement(transformation(extent={{-60,-62},{-40,-42}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Sensors.SensorT N776MT
    annotation (Placement(transformation(extent={{-10,-62},{10,-42}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Sensors.SensorT N777MT
    annotation (Placement(transformation(extent={{40,-62},{60,-42}}, rotation=
           0)));
equation
  connect(fluidInletI, N001MT.C1) annotation (Line(points={{-100,-80},{-80,
          -80},{-80,-60},{-60,-60}}));
  connect(N001MT.C2, N776MT.C1) annotation (Line(points={{-39.8,-60},{-10,-60}},
        color={0,0,255}));
  connect(N776MT.C2, N777MT.C1) annotation (Line(points={{10.2,-60},{40,-60}},
        color={0,0,255}));
  connect(N777MT.C2, fluidOutletI) annotation (Line(points={{60.2,-60},{80,
          -60},{80,-80},{100,-80}}, color={0,0,255}));
  annotation (Diagram(graphics),
                       Icon(graphics={
        Ellipse(
          extent={{-60,90},{60,-30}},
          lineColor={0,0,255},
          fillColor={170,85,255},
          fillPattern=FillPattern.Solid),
        Line(points={{0,-30},{0,-80}}),
        Line(points={{-100,-80},{100,-80}}),
        Text(extent={{-60,58},{60,-2}}, textString=
                                          "P, ...")}));
end SensorGRE;
