within BIL100_Demo.BIL100_Modules;
model StaticDrumTSP "Staic drum"
  parameter Real x=1 "Vapor separation efficiency at the outlet";

public
  Modelica.SIunits.Temperature T "Fluid temperature";
  Modelica.SIunits.AbsolutePressure P(start=10.e5) "Fluid pressure";
  Modelica.SIunits.SpecificEnthalpy hl(start=100000)
    "Liquid phase specific enthalpy";
  Modelica.SIunits.SpecificEnthalpy hv(start=2800000)
    "Gas phase specific enthalpy";
  ThermoSysPro.WaterSteam.Connectors.FluidInlet Ce_eco annotation (Placement(
        transformation(extent={{-50,-104},{-30,-84}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs_eva annotation (Placement(
        transformation(extent={{30,-104},{50,-84}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs_sur annotation (Placement(
        transformation(extent={{28,84},{48,104}}, rotation=0)));
  ThermoSysPro.Properties.WaterSteam.Common.PropThermoSat lsat
    annotation (Placement(transformation(extent={{-104,66},{-78,98}}, rotation=
            0)));
  ThermoSysPro.Properties.WaterSteam.Common.PropThermoSat vsat
    annotation (Placement(transformation(extent={{72,68},{100,100}}, rotation=0)));
  ThermoSysPro.Thermal.Connectors.ThermalPort Cth annotation (Placement(
        transformation(extent={{-10,-10},{10,10}}, rotation=0)));
equation
  /* Unconnected connectors */

  /* Steam input */

  /* Extra input */

  /* Input from evaporator */

  /* Input from the economizer */
  if (cardinality(Ce_eco) == 0) then
    Ce_eco.Q = 0;
    Ce_eco.h = 1.e5;
    Ce_eco.b = true;
  end if;

  /* Output to the evaporator */
  if (cardinality(Cs_eva) == 0) then
    Cs_eva.Q = 0;
    Cs_eva.h = 1.e5;
    Cs_eva.a = true;
  end if;

  /* Extra output */

  /* Extra output  */

  /* Output to reheater */
  if (cardinality(Cs_sur) == 0) then
    Cs_sur.Q = 0;
    Cs_sur.h = 1.e5;
    Cs_sur.a = true;
  end if;

  /* Fluid pressure */
  P = Ce_eco.P;
  P = Cs_eva.P;
  P = Cs_sur.P;

  /* Fluid specific enthalpies at the inlets and outlets */
  Ce_eco.h_vol = hl;

  Cs_eva.h_vol = hl;
  Cs_sur.h_vol = (1 - x)*hl + x*hv;

  /* Mass balance equation */
  Ce_eco.Q - Cs_eva.Q - Cs_sur.Q = 0;

  /* Energy balance equation */
  Ce_eco.Q*Ce_eco.h - Cs_eva.Q*Cs_eva.h - Cs_sur.Q*Cs_sur.h + Cth.W = 0;

  /* Fluid thermodynamic properties */
  (lsat,vsat) = ThermoSysPro.Properties.WaterSteam.IF97.Water_sat_P(P);

  hl = lsat.h;
  hv = vsat.h;
  T = lsat.T;

  Cth.T = T;

  annotation (
    Diagram(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Line(points={{0,90},{0,-100}}),
        Ellipse(
          extent={{-98,96},{98,-96}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Line(
          points={{-86,-44},{86,-44}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-44,-86},{44,-86}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-64,-72},{64,-72}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-78,-58},{76,-58}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Text(extent={{-56,94},{-56,92}}, textString=
                                             "Esteam")}),
    Icon(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Line(points={{0,90},{0,-100}}),
        Ellipse(
          extent={{-98,96},{98,-96}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Line(
          points={{-86,-44},{86,-44}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-44,-86},{44,-86}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-64,-72},{64,-72}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-78,-58},{76,-58}},
          color={0,0,255},
          pattern=LinePattern.Dash)}),
    Window(
      x=0.33,
      y=0.08,
      width=0.66,
      height=0.69),
    Documentation(info="<html>
<p><b>Copyright &copy; EDF 2002 - 2012</b> </p>
<p><b>ThermoSysPro Version 3.0</h4>
<p>This component model is documented in Sect. 14.6 of the <a href=\"https://www.springer.com/us/book/9783030051044\">ThermoSysPro book</a>. </h4>
</html>",
   revisions="<html>
<p><u><b>Authors</b></u> </p>
<ul>
<li>Baligh El Hefni</li>
<li>Daniel Bouskela </li>
</ul>
</html>"));
end StaticDrumTSP;
