﻿within BIL100_Demo.BIL100_Modules.Utilities;
model Sink "Water/steam sink"
  Modelica.SIunits.Temperature T0=290
    "Sink temperature (active if option_temperature=1)";
  Modelica.SIunits.SpecificEnthalpy h0=100000
    "Sink specific enthalpy (active if option_temperature=2)";
  parameter Integer option_temperature=1
    "1:temperature fixed - 2:specific enthalpy fixed";
  parameter Integer mode=1
    "IF97 region. 1:liquid - 2:steam - 4:saturation line - 0:automatic";
  Modelica.SIunits.AbsolutePressure P "Fluid pressure";
  Modelica.SIunits.MassFlowRate Q "Mass flow rate";
  Modelica.SIunits.Temperature T "Fluid temperature";
  Modelica.SIunits.SpecificEnthalpy h "Fluid specific enthalpy";
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal ISpecificEnthalpy annotation (Placement(
        transformation(
        origin={0,-50},
        extent={{10,-10},{-10,10}},
        rotation=270)));
  ThermoSysPro.WaterSteam.Connectors.FluidInlet C
                          annotation (Placement(transformation(extent={{-110,
            -10},{-90,10}}, rotation=0)));
  ThermoSysPro.Properties.WaterSteam.Common.ThermoProperties_ph pro
    "Propriétés de l'eau"                                                                 annotation (Placement(
        transformation(extent={{-100,80},{-80,100}}, rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal
                                                 ITemperature annotation (Placement(
        transformation(
        origin={-20,-50},
        extent={{-10,-10},{10,10}},
        rotation=90)));
equation
  C.P=P;
  C.Q=Q;
  C.h_vol=h;
  if cardinality(ITemperature) == 0 then
    ITemperature.signal=T0;
  end if;
  if cardinality(ISpecificEnthalpy) == 0 then
    ISpecificEnthalpy.signal=h0;
  end if;
  if option_temperature == 1 then
    T=ITemperature.signal;
    h=ThermoSysPro.Properties.WaterSteam.IF97.SpecificEnthalpy_PT(P, T, 0);
  elseif option_temperature == 2 then
    h=ISpecificEnthalpy.signal;
    T=pro.T;
  else
    assert(false, "SinkPressureWaterSteam: incorrect option");
  end if;
  pro=ThermoSysPro.Properties.WaterSteam.IF97.Water_Ph(P, h, mode);
  annotation (                                                                    Diagram(
        coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Rectangle(
          extent={{-40,40},{40,-40}},
          lineColor={0,0,255},
          fillColor={127,255,0},
          fillPattern=FillPattern.Solid),
        Line(points={{-90,0},{-40,0},{-54,10}}),
        Line(points={{-54,-10},{-40,0}}),
        Text(extent={{15,-43},{49,-65}}, textString="T/h")}),                                                                   Icon(
        coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Rectangle(
          extent={{-40,40},{40,-40}},
          lineColor={0,0,255},
          fillColor={127,255,0},
          fillPattern=FillPattern.Solid),
        Line(points={{-90,0},{-40,0},{-54,10}}),
        Line(points={{-54,-10},{-40,0}}),
        Text(extent={{8,-40},{40,-60}}, textString="T/h")}),                                                                     Window(x=0.23, y=0.15, width=0.81, height=0.71), Documentation(info="<html>
<p><b>Copyright &copy; EDF 2002 - 2010</b></p>
</HTML>
<html>
<p><b>ThermoSysPro Version 2.0</b></p>
</HTML>
", revisions="<html>
<u><p><b>Authors</u> : </p></b>
<ul style='margin-top:0cm' type=disc>
<li>
    Baligh El Hefni</li>
<li>
    Daniel Bouskela</li>
</ul>
</html>
"));
end Sink;
