﻿within BIL100_Demo.BIL100_Modules.Utilities;
model Splitter8 "Splitter with eight inlets"
  parameter Integer fluid=1 "1: water/steam - 2: C3H3F5";
  parameter Integer mode=0
    "IF97 region. 1:liquid - 2:steam - 4:saturation line - 0:automatic";

public
  Modelica.SIunits.Pressure P(start=10e5) "Fluid pressure";
  Modelica.SIunits.SpecificEnthalpy h(start=10e5) "Fluid specific enthalpy";
  Modelica.SIunits.Temperature T "Fluid temperature";

  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs5
    annotation (                             layer="icon", Placement(
        transformation(extent={{90,-50},{110,-30}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs6
    annotation (                              layer="icon", Placement(
        transformation(extent={{90,-109},{110,-89}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs8
    annotation (                             layer="icon", Placement(
        transformation(extent={{-40,-109},{-20,-89}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs3
                           annotation (                            layer="icon",
      Placement(transformation(extent={{90,90},{110,110}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs1
                           annotation (                           layer="icon",
      Placement(transformation(extent={{-40,90},{-20,110}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs2
                           annotation (                          layer="icon",
      Placement(transformation(extent={{20,92},{40,112}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInlet Ce
                           annotation (                           layer="icon",
      Placement(transformation(extent={{-110,-10},{-90,10}}, rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs7
                           annotation (                            layer="icon",
      Placement(transformation(extent={{20,-109},{40,-89}}, rotation=0)));

  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs4
    annotation (                             layer="icon", Placement(
        transformation(extent={{90,30},{110,50}}, rotation=0)));
  ThermoSysPro.Properties.WaterSteam.Common.ThermoProperties_ph pro
    "Propriétés de l'eau"
    annotation (Placement(transformation(extent={{-80,80},{-60,100}},
          rotation=0)));
equation
  /* Unconnected connectors */
  if (cardinality(Cs1) == 0) then
    Cs1.Q = 0;
    Cs1.h = 1.e5;
    Cs1.b = true;
  end if;

  if (cardinality(Cs2) == 0) then
    Cs2.Q = 0;
    Cs2.h = 1.e5;
    Cs2.b = true;
  end if;

  if (cardinality(Cs3) == 0) then
    Cs3.Q = 0;
    Cs3.h = 1.e5;
    Cs3.b = true;
  end if;

  if (cardinality(Cs4) == 0) then
    Cs4.Q = 0;
    Cs4.h = 1.e5;
    Cs4.b = true;
  end if;

  if (cardinality(Cs5) == 0) then
    Cs5.Q = 0;
    Cs5.h = 1.e5;
    Cs5.b = true;
  end if;

  if (cardinality(Cs6) == 0) then
    Cs6.Q = 0;
    Cs6.h = 1.e5;
    Cs6.b = true;
  end if;

  if (cardinality(Cs7) == 0) then
    Cs7.Q = 0;
    Cs7.h = 1.e5;
    Cs7.b = true;
  end if;

  if (cardinality(Cs8) == 0) then
    Cs8.Q = 0;
    Cs8.h = 1.e5;
    Cs8.b = true;
  end if;

  if (cardinality(Ce) == 0) then
    Ce.Q = 0;
    Ce.h = 1.e5;
    Ce.a = true;
  end if;

  /* Fluid pressure */
  P = Ce.P;
  P = Cs1.P;
  P = Cs2.P;
  P = Cs3.P;
  P = Cs4.P;
  P = Cs5.P;
  P = Cs6.P;
  P = Cs7.P;
  P = Cs8.P;

  /* Fluid specific enthalpy (singular if all flows = 0) */
  Ce.h_vol = h;
  Cs1.h_vol = h;
  Cs2.h_vol = h;
  Cs3.h_vol = h;
  Cs4.h_vol = h;
  Cs5.h_vol = h;
  Cs6.h_vol = h;
  Cs7.h_vol = h;
  Cs8.h_vol = h;

  /* Mass balance equation */
  0 = Ce.Q - Cs1.Q - Cs2.Q - Cs3.Q - Cs4.Q - Cs5.Q - Cs6.Q - Cs7.Q - Cs8.Q;

  /* Energy balance equation */
  0 = Ce.Q*Ce.h - Cs1.Q*Cs1.h - Cs2.Q*Cs2.h - Cs3.Q*Cs3.h - Cs4.Q*Cs4.h - Cs5.Q*Cs5.h - Cs6.Q*Cs6.h - Cs7.Q*Cs7.h - Cs8.Q*Cs8.h;

  /* Fluid thermodynamic properties */
  pro = ThermoSysPro.Properties.Fluid.Ph(P, h, mode, fluid);

  T = pro.T;

  annotation (
    Diagram(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Line(points={{90,90},{36,52}}, color={0,0,255}),
        Ellipse(
          extent={{-40,80},{40,0}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Ellipse(
          extent={{-40,2},{40,-80}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Rectangle(
          extent={{-40,40},{40,-40}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Line(points={{-92,0},{-40,0}}),
        Line(points={{40,-40},{92,-40}}),
        Line(points={{-30,90},{-30,66}}, color={0,0,255}),
        Line(points={{30,92},{30,66}}, color={0,0,255}),
        Line(points={{-30,-66},{-30,-90}}, color={0,0,255}),
        Line(points={{30,-66},{30,-90}}, color={0,0,255}),
        Line(points={{38,40},{90,40}}),
        Line(points={{92,-90},{38,-54}}, color={0,0,255})}),
    Icon(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Line(points={{90,-89},{36,-53}}, color={0,0,255}),
        Ellipse(
          extent={{-40,80},{40,0}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Ellipse(
          extent={{-40,0},{40,-80}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Rectangle(
          extent={{-40,40},{40,-40}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Line(points={{-30,90},{-30,66}}, color={0,0,255}),
        Line(points={{-30,-66},{-30,-90}}, color={0,0,255}),
        Line(points={{30,92},{30,66}}, color={0,0,255}),
        Line(points={{30,-66},{30,-90}}, color={0,0,255}),
        Line(points={{40,40},{92,40}}),
        Line(points={{40,-40},{92,-40}}),
        Line(points={{-92,0},{-40,0}}),
        Line(points={{92,92},{38,54}}, color={0,0,255})}),
    Window(
      x=0.05,
      y=0.07,
      width=0.74,
      height=0.85),
    Documentation(info="<html>
<p><b>Copyright &copy; EDF 2002 - 2010</b></p>
</HTML>
<html>
<p><b>ThermoSysPro Version 2.0</b></p>
</HTML>
", revisions="<html>
<u><p><b>Authors</u> : </p></b>
<ul style='margin-top:0cm' type=disc>
<li>
    Baligh El Hefni</li>
<li>
    Daniel Bouskela</li>
</ul>
</html>
"));
end Splitter8;
