within BIL100_Demo;
model SG_Unit_Propagation
  /* WARNING: This model illustrates parts of an industrial use-case but the associated numerical values do not correspond to the reality of the industrial process */
  /* Distributions parameters */
  parameter Distribution distributionQARE0=Distribution("Normal", {2142.972222,8.5},{"mu","sigma"});
  parameter Distribution distributionPARE0=Distribution("Normal", {7032392.1,20700},{"mu","sigma"});
  parameter Distribution distributionTARE0=Distribution("Normal", {500.2497543,3},{"mu","sigma"});
  parameter Distribution distributionQGSS0=Distribution("Normal", {183.713226,0.75},{"mu","sigma"});
  parameter Distribution distributionTGRE0=Distribution("Normal", {552.6833333,3.2},{"mu","sigma"});
  parameter Distribution distributionQGRE0=Distribution("Normal", {1922.331218,8.5},{"mu","sigma"});

  GV_Unit  SG_Unit(
   sourcePQARE(
     Q0(start=2142.972222,fixed=true,uncertain=Uncertainty.given, distribution=distributionQARE0),
     P0(start=7032392.1,fixed=true,uncertain=Uncertainty.given, distribution=distributionPARE0),
     T0(start=500.2497543,fixed=true,uncertain=Uncertainty.given, distribution=distributionTARE0)),
   sinkQPUR1(
     T0(start=500.2497543,fixed=true,uncertain=Uncertainty.given, distribution=distributionTARE0)),
   sinkQPUR2(
     T0(start=500.2497543,fixed=true,uncertain=Uncertainty.given, distribution=distributionTARE0)),
   sinkQPUR3(
     T0(start=500.2497543,fixed=true,uncertain=Uncertainty.given, distribution=distributionTARE0)),
   sinkQPUR4(
     T0(start=500.2497543,fixed=true,uncertain=Uncertainty.given, distribution=distributionTARE0)),
   sinkQGSS(
     Q0(start=183.713226,fixed=true,uncertain=Uncertainty.given, distribution=distributionQGSS0),
     T0(start=552.6833333,fixed=true,uncertain=Uncertainty.given, distribution=distributionTGRE0)),
   sinkQGRE(
     Q0(start=1922.331218,fixed=true,uncertain=Uncertainty.given, distribution=distributionQGRE0),
     T0(start=552.6833333,fixed=true,uncertain=Uncertainty.given, distribution=distributionTGRE0)),
   sinkQSTR(
     T0(start=552.6833333,fixed=true,uncertain=Uncertainty.given, distribution=distributionTGRE0)),
   BIL100(W_BIL100(
          signal(         uncertain=Uncertainty.sought))))
    annotation (Placement(transformation(extent={{-72,-18},{44,48}})));
   Correlation correlation[1];
algorithm
    correlation:={Correlation(SG_Unit.sourcePQARE.P0, SG_Unit.sourcePQARE.T0, 0.0)};
end SG_Unit_Propagation;
