within BIL100_Demo.BIL100_Modules;
model GRE70_MP
  parameter Real PGRE=100.4;

  Utilities.SensorSignal N1MP
    annotation (Placement(transformation(extent={{-50,-62},{-30,-42}},
          rotation=0)));
  Utilities.SensorSignal N2MP
    annotation (Placement(transformation(extent={{-10,-62},{10,-42}},
          rotation=0)));
  Utilities.SensorSignal N3MP
    annotation (Placement(transformation(extent={{30,-62},{50,-42}}, rotation=
           0)));
  Utilities.SensorSignal N4MP
    annotation (Placement(transformation(extent={{70,-62},{90,-42}}, rotation=
           0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.OutputReal
    PGREPourcentagePN annotation (Placement(transformation(extent={{-92,-10},
            {-112,10}}, rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Blocks.Sources.Constante GRE701MP(k=PGRE)
    annotation (Placement(transformation(extent={{-80,-70},{-60,-50}},
          rotation=0)));
equation
  connect(N1MP.C2, N2MP.C1)     annotation (Line(points={{-29.8,-60},{-10,-60}},
        color={0,0,255}));
  connect(N2MP.C2, N3MP.C1)     annotation (Line(points={{10.2,-60},{30,-60}},
        color={0,0,255}));
  connect(N3MP.C2, N4MP.C1) annotation (Line(points={{50.2,-60},{70,-60}},
        color={0,0,255}));
  connect(N1MP.Measure, PGREPourcentagePN)
    annotation (Line(points={{-40,-41.8},{-40,0},{-102,0}}));
  connect(GRE701MP.y, N1MP.C1) annotation (Line(points={{-59,-60},{-50,-60}}));
  annotation (Diagram(graphics),
                       Icon(graphics={Rectangle(
          extent={{-100,100},{100,-100}},
          lineColor={0,0,255},
          fillColor={170,85,255},
          fillPattern=FillPattern.Solid), Text(extent={{-76,60},{86,-62}},
            textString =                   "GRE70-MP")}));
end GRE70_MP;
