within BIL100_Demo.BIL100_Modules;
model SensorCND501
  ThermoSysPro.WaterSteam.Connectors.FluidInletI fluidInletI
    annotation (Placement(transformation(extent={{-110,-90},{-90,-70}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutletI fluidOutletI
    annotation (Placement(transformation(extent={{90,-90},{110,-70}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Sensors.SensorT N531MT
    annotation (Placement(transformation(extent={{-40,-2},{-20,18}}, rotation=
           0)));
  ThermoSysPro.WaterSteam.Sensors.SensorT N533YT
    annotation (Placement(transformation(extent={{0,-2},{20,18}}, rotation=0)));
  ThermoSysPro.WaterSteam.Sensors.SensorQ N541MD
    annotation (Placement(transformation(extent={{-40,-82},{-20,-62}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Sensors.SensorQ N543YD
    annotation (Placement(transformation(extent={{0,-82},{20,-62}}, rotation=
            0)));
equation
  connect(N531MT.C2,N533YT. C1)
    annotation (Line(points={{-19.8,0},{0,0}}, color={0,0,255}));
  connect(N533YT.C2,N541MD. C1) annotation (Line(points={{20.2,0},{40,0},{40,
          -20},{-60,-20},{-60,-80},{-40,-80}}, color={0,0,255}));
  connect(N541MD.C2,N543YD. C1) annotation (Line(points={{-19.8,-80},{0,-80}},
        color={0,0,255}));
  connect(N543YD.C2, fluidOutletI) annotation (Line(points={{20.2,-80},{100,
          -80}}, color={0,0,255}));
  connect(N531MT.C1, fluidInletI)
    annotation (Line(points={{-40,0},{-80,0},{-80,-80},{-100,-80}}));
  annotation (Diagram(graphics),
                       Icon(graphics={
        Ellipse(
          extent={{-60,90},{60,-30}},
          lineColor={0,0,255},
          fillColor={170,85,255},
          fillPattern=FillPattern.Solid),
        Line(points={{0,-30},{0,-80}}),
        Line(points={{-100,-80},{100,-80}}),
        Text(extent={{-60,58},{60,-2}}, textString=
                                          "P, ...")}));
end SensorCND501;
