within BIL100_Demo.BIL100_Modules;
model StaticDrumVALI "Staic drum VALI"
  parameter Real x=1 "Vapor separation efficiency at the outlet";

public
  Modelica.SIunits.Temperature T "Fluid temperature";
  Modelica.SIunits.AbsolutePressure P(start=10.e5) "Fluid pressure";
  Modelica.SIunits.SpecificEnthalpy hl(start=100000)
    "Liquid phase specific enthalpy";
  Modelica.SIunits.SpecificEnthalpy hv(start=2800000)
    "Gas phase specific enthalpy";
public
  ThermoSysPro.WaterSteam.Connectors.FluidInlet Ce2
    annotation (Placement(transformation(extent={{-104,-44},{-84,-24}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInlet Ce3
    annotation (Placement(transformation(extent={{-50,-104},{-30,-84}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs1
    annotation (Placement(transformation(extent={{84,24},{104,44}}, rotation=
            0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInlet Ce4
    annotation (Placement(transformation(extent={{30,-104},{50,-84}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet Cs_steam
    annotation (Placement(transformation(extent={{28,84},{48,104}}, rotation=
            0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInlet Ce5
    annotation (Placement(transformation(extent={{84,-44},{104,-24}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInlet Ce_steam
    annotation (Placement(transformation(extent={{-48,84},{-28,104}},
          rotation=0)));
  ThermoSysPro.WaterSteam.Connectors.FluidInlet Ce1
    annotation (Placement(transformation(extent={{-104,26},{-84,46}},
          rotation=0)));
  ThermoSysPro.Properties.WaterSteam.Common.PropThermoSat lsat
    annotation (Placement(transformation(extent={{-104,66},{-78,98}},
          rotation=0)));
  ThermoSysPro.Properties.WaterSteam.Common.PropThermoSat vsat
    annotation (Placement(transformation(extent={{72,68},{100,100}}, rotation=
           0)));
  ThermoSysPro.Thermal.Connectors.ThermalPort Cth
                                     annotation (Placement(transformation(
          extent={{-10,-10},{10,10}}, rotation=0)));
equation
  /* Unconnected connectors */

  /* Steam input */
  if (cardinality(Ce_steam) == 0) then
    Ce_steam.Q = 0;
    Ce_steam.h = 1.e5;
    Ce_steam.b = true;
  end if;

  /* Extra input */
  if (cardinality(Ce1) == 0) then
    Ce1.Q = 0;
    Ce1.h = 1.e5;
    Ce1.b = true;
  end if;

  /* Input from evaporator */
  if (cardinality(Ce2) == 0) then
    Ce2.Q = 0;
    Ce2.h = 1.e5;
    Ce2.b = true;
  end if;

  /* Input from the economizer */
  if (cardinality(Ce3) == 0) then
    Ce3.Q = 0;
    Ce3.h = 1.e5;
    Ce3.b = true;
  end if;

  /* Output to the evaporator  */
  if (cardinality(Ce4) == 0) then
    Ce4.Q = 0;
    Ce4.h = 1.e5;
    Ce4.a = true;
  end if;

  /* Purges du ballon  */
  if (cardinality(Ce5) == 0) then
    Ce5.Q = 0;
    Ce5.h = 1.e5;
    Ce5.a = true;
  end if;

  /* Extra output  */
  if (cardinality(Cs1) == 0) then
    Cs1.Q = 0;
    Cs1.h = 1.e5;
    Cs1.a = true;
  end if;

  /* Output to reheater */
  if (cardinality(Cs_steam) == 0) then
    Cs_steam.Q = 0;
    Cs_steam.h = 1.e5;
    Cs_steam.a = true;
  end if;

  /* Fluid pressure */
  P = Ce_steam.P;
  P = Ce1.P;
  P = Ce2.P;
  P = Ce3.P;
  P = Ce4.P;
  P = Ce5.P;
  P = Cs1.P;
  P = Cs_steam.P;

  /* Fluid specific enthalpies at the inlets and outlets */
  Ce1.h_vol = hl;
  Ce2.h_vol = hl;
  Ce3.h_vol = hl;
  Ce_steam.h_vol = hv;

  Ce5.h_vol = hl;
  Cs1.h_vol = hl;
  Ce4.h_vol = hl;
  Cs_steam.h_vol = (1 - x)*hl + x*hv;

  /* Mass balance equation */
  Ce3.Q + Ce_steam.Q + Ce1.Q + Ce2.Q - Ce4.Q - Cs_steam.Q - Ce5.Q - Cs1.Q = 0;

  /* Energy balance equation */
  Ce3.Q*Ce3.h + Ce_steam.Q*Ce_steam.h + Ce1.Q*Ce1.h + Ce2.Q*Ce2.h - Ce4.Q*Ce4.h
  - Cs_steam.Q*Cs_steam.h - Ce5.Q*Ce5.h - Cs1.Q*Cs1.h + Cth.W = 0;

  /* Fluid thermodynamic properties */
  (lsat,vsat) = ThermoSysPro.Properties.WaterSteam.IF97.Water_sat_P(P);

  hl = lsat.h;
  hv = vsat.h;
  T = lsat.T;

  Cth.T = T;

  annotation (
    Diagram(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Line(points={{0,90},{0,-100}}),
        Ellipse(
          extent={{-98,96},{98,-96}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Line(
          points={{-86,-44},{86,-44}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-44,-86},{44,-86}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-64,-72},{64,-72}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-78,-58},{76,-58}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Text(extent={{-56,94},{-56,92}}, textString=
                                             "Esteam")}),
    Icon(coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Line(points={{0,90},{0,-100}}),
        Ellipse(
          extent={{-98,96},{98,-96}},
          lineColor={0,0,255},
          fillColor={255,255,0},
          fillPattern=FillPattern.Solid),
        Line(
          points={{-86,-44},{86,-44}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-44,-86},{44,-86}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-64,-72},{64,-72}},
          color={0,0,255},
          pattern=LinePattern.Dash),
        Line(
          points={{-78,-58},{76,-58}},
          color={0,0,255},
          pattern=LinePattern.Dash)}),
    Window(
      x=0.33,
      y=0.08,
      width=0.66,
      height=0.69),
    Documentation(info="<html>
<p><b>Copyright &copy; EDF 2002 - 2012</b> </p>
<p><b>ThermoSysPro Version 3.0</b> </p>
</html>",
   revisions="<html>
<u><p><b>Authors</u> : </p></b>
<ul style='margin-top:0cm' type=disc>
<li>
    Baligh El Hefni</li>
<li>
    Daniel Bouskela</li>
</ul>
</html>
"));
end StaticDrumVALI;
