﻿within BIL100_Demo.BIL100_Modules.Utilities;
model SourcePQ "Water/steam source with fixed pressure and mass flow rate"
  Modelica.SIunits.AbsolutePressure P0=300000
    "Fluid pressure (active if IPressure connector is not connected)";
  Modelica.SIunits.MassFlowRate Q0=100
    "Mass flow (active if IMassFlow connector is not connected)";
  Modelica.SIunits.Temperature T0=290
    "Source temperature (active if option_temperature=1)";
  Modelica.SIunits.SpecificEnthalpy h0=100000
    "Source specific enthalpy (active if option_temperature=2)";
  parameter Integer option_temperature=1
    "1:temperature fixed - 2:specific enthalpy fixed";
  parameter Integer mode=1
    "IF97 region. 1:liquid - 2:steam - 4:saturation line - 0:automatic";
  Modelica.SIunits.AbsolutePressure P "Fluid pressure";
  Modelica.SIunits.MassFlowRate Q "Mass flow rate";
  Modelica.SIunits.Temperature T "Fluid temperature";
  Modelica.SIunits.SpecificEnthalpy h "Fluid specific enthalpy";
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal IMassFlow annotation (Placement(
        transformation(
        origin={0,50},
        extent={{-10,-10},{10,10}},
        rotation=270)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal IPressure annotation (Placement(
        transformation(extent={{-60,-10},{-40,10}}, rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal ISpecificEnthalpy annotation (Placement(
        transformation(
        origin={0,-50},
        extent={{10,-10},{-10,10}},
        rotation=270)));
  ThermoSysPro.WaterSteam.Connectors.FluidOutlet C
                           annotation (Placement(transformation(extent={{90,-10},
            {110,10}}, rotation=0)));
  ThermoSysPro.Properties.WaterSteam.Common.ThermoProperties_ph pro
    "Propriétés de l'eau"                                                                 annotation (Placement(
        transformation(extent={{-100,80},{-80,100}}, rotation=0)));
  ThermoSysPro.InstrumentationAndControl.Connectors.InputReal ITemperature annotation (Placement(
        transformation(
        origin={20,-50},
        extent={{-10,-10},{10,10}},
        rotation=90)));
equation
  C.P=P;
  C.Q=Q;
  C.h_vol=h;
  if cardinality(IMassFlow) == 0 then
    IMassFlow.signal=Q0;
  end if;
  Q=IMassFlow.signal;
  if cardinality(IPressure) == 0 then
    IPressure.signal=P0;
  end if;
  P=IPressure.signal;
  if cardinality(ITemperature) == 0 then
    ITemperature.signal=T0;
  end if;
  if cardinality(ISpecificEnthalpy) == 0 then
    ISpecificEnthalpy.signal=h0;
  end if;
  if option_temperature == 1 then
    T=ITemperature.signal;
    h=ThermoSysPro.Properties.WaterSteam.IF97.SpecificEnthalpy_PT(P, T, 0);
  elseif option_temperature == 2 then
    h=ISpecificEnthalpy.signal;
    T=pro.T;
  else
    assert(false, "SourcePressureWaterSteam: incorrect option");
  end if;
  pro=ThermoSysPro.Properties.WaterSteam.IF97.Water_Ph(P, h, mode);
  annotation (                                                                    Diagram(
        coordinateSystem(
        preserveAspectRatio=true,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Rectangle(
          extent={{-40,40},{40,-40}},
          lineColor={0,0,255},
          fillColor={127,255,0},
          fillPattern=FillPattern.Solid),
        Line(points={{40,0},{90,0},{72,10}}),
        Line(points={{90,0},{72,-10}}),
        Text(extent={{-58,30},{-40,10}}, textString =                                                                                                   "P"),
        Text(extent={{-28,60},{-10,40}}, textString =                                                                                                   "Q"),
        Text(extent={{-36,-40},{-6,-60}}, textString="h/T"),
        Text(
          extent={{-22,20},{20,-24}},
          lineColor={0,0,255},
          textString =                                                                                                   "P Q")}),Icon(
        coordinateSystem(
        preserveAspectRatio=false,
        extent={{-100,-100},{100,100}},
        grid={2,2}), graphics={
        Rectangle(
          extent={{-40,40},{40,-40}},
          lineColor={0,0,255},
          fillColor={127,255,0},
          fillPattern=FillPattern.Solid),
        Line(points={{40,0},{90,0},{72,10}}),
        Line(points={{90,0},{72,-10}}),
        Text(extent={{-30,60},{-10,40}}, textString =                                                                                                    "Q"),
        Text(extent={{-60,30},{-40,10}}, textString =                                                                                                    "P"),
        Text(
          extent={{-22,20},{20,-24}},
          lineColor={0,0,255},
          textString =                                                                                                    "P Q"),
        Text(extent={{-40,-40},{-10,-60}}, textString="h/T")}),                                                                    Window(x=0.23, y=0.15, width=0.81, height=0.71), Documentation(info="<html>
<p><b>Copyright &copy; EDF 2002 - 2010</b></p>
</HTML>
<html>
<p><b>ThermoSysPro Version 2.0</b></p>
</HTML>
", revisions="<html>
<u><p><b>Authors</u> : </p></b>
<ul style='margin-top:0cm' type=disc>
<li>
    Baligh El Hefni</li>
<li>
    Daniel Bouskela</li>
</ul>
</html>
"));
end SourcePQ;
