within HVDCcomponents.VSC_station_components;

model Idqref_calc_VSC
  Modelica.Blocks.Interfaces.RealInput Pref annotation(
    Placement(visible = true, transformation(origin = {-120, 40}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 60}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput Qref annotation(
    Placement(visible = true, transformation(origin = {-120, -40}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, -60}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput vgd annotation(
    Placement(visible = true, transformation(origin = {0, 120}, extent = {{-20, -20}, {20, 20}}, rotation = -90), iconTransformation(origin = {0, 120}, extent = {{-20, -20}, {20, 20}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealOutput igdref annotation(
    Placement(visible = true, transformation(origin = {116, 40}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {116, 60}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput igqref annotation(
    Placement(visible = true, transformation(origin = {116, -42}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {116, -60}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
equation
 if vgd == 0 then
  igdref = 0;
  igqref = 0;
 else 
  igdref = Pref / vgd;
  igqref = Qref / vgd;
  end if;

annotation(
    Icon(graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}), Text(origin = {7, 12}, extent = {{-59, 22}, {45, -14}}, textString = "Reference"), Text(origin = {0, -13}, extent = {{-54, 17}, {54, -17}}, textString = "calculation"), Text(origin = {-81, 65}, extent = {{-13, 11}, {29, -19}}, textString = "Pref"),  Text(origin = {-83, -49}, extent = {{-13, 11}, {33, -27}}, textString = "Qref"), Text(origin = {83, 59}, extent = {{-39, 19}, {13, -11}}, textString = "Id_ref"), Text(origin = {85, -69}, extent = {{-37, 27}, {13, -11}}, textString = "Iq_ref"),  Text(origin = {-5, 89}, extent = {{-13, 11}, {25, -21}}, textString = "Vgd")}));
end Idqref_calc_VSC;
