within HVDCcomponents;

model vdc_control

  parameter String controlType = "Droop" "Droop, P_mode, PI, PI+filter or IP";
  parameter Real Cdc = 195E-6 "Capacitance of the DC grid in F";
  parameter Real tr = 20E-3 "response time of the controller in s";
  parameter Real Ksi = 0.7 "damping coefficient";
   parameter Real vdc0 = 230E3 "Reference DC voltage";
   parameter Real g_droop = 195E-6 "droop coefficient";
   
  HVDCcomponents.vdc_controls.vdc_IP_control vdc_IP_control1(Cdc = Cdc, Ksi = Ksi, tr = tr) annotation(
    Placement(visible = true, transformation(origin = {2, 36}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
  HVDCcomponents.vdc_controls.vdc_PI_control vdc_PI_control1(Cdc = Cdc, Ksi = Ksi, tr = tr) annotation(
    Placement(visible = true, transformation(origin = {2, 80}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput vdcref annotation(
    Placement(visible = true, transformation(origin = {-120, 44}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 60}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput vdc annotation(
    Placement(visible = true, transformation(origin = {-120, -20}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, -60}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput Pref annotation(
    Placement(visible = true, transformation(origin = {110, 10}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  HVDCcomponents.vdc_controls.vdc_PI_control_with_filter vdc_PI_control_with_filter1(Cdc = Cdc, Ksi = Ksi, tr = tr, vdc0 = vdc0) annotation(
    Placement(visible = true, transformation(origin = {2, -8}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
  HVDCcomponents.vdc_controls.Vdc_droop vdc_droop1(g_droop = g_droop)  annotation(
    Placement(visible = true, transformation(origin = {2, -54}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
equation

  if controlType == "PI" then
    vdc = vdc_PI_control1.vdc;
    vdcref = vdc_PI_control1.vdcref;
    vdc_PI_control1.Pref = Pref;
vdc_IP_control1.vdc = 0;
vdc_IP_control1.vdcref = 0;
vdc_PI_control_with_filter1.vdc = 0;
vdc_PI_control_with_filter1.vdcref = 0;
vdc_droop1.vdc=0;
vdc_droop1.vdcref=0;
  elseif controlType == "PI+filter" then
    vdc = vdc_PI_control_with_filter1.vdc;
    vdcref = vdc_PI_control_with_filter1.vdcref;
    vdc_PI_control_with_filter1.Pref = Pref;
vdc_IP_control1.vdc = 0;
vdc_IP_control1.vdcref = 0;
vdc_PI_control1.vdc = 0;
vdc_PI_control1.vdcref = 0;
vdc_droop1.vdc=0;
vdc_droop1.vdcref=0;
  elseif controlType == "IP" then
    vdc = vdc_IP_control1.vdc;
    vdcref = vdc_IP_control1.vdcref;
    vdc_IP_control1.Pref = Pref;
vdc_PI_control1.vdc = 0;
vdc_PI_control1.vdcref = 0;
vdc_PI_control_with_filter1.vdc = 0;
vdc_PI_control_with_filter1.vdcref = 0;
vdc_droop1.vdc=0;
vdc_droop1.vdcref=0;
  elseif controlType == "Droop" then
    vdc = vdc_droop1.vdc;
    vdcref = vdc_droop1.vdcref;
    vdc_droop1.Pref = Pref;
vdc_PI_control1.vdc = 0;
vdc_PI_control1.vdcref = 0;
vdc_PI_control_with_filter1.vdc = 0;
vdc_PI_control_with_filter1.vdcref = 0;
vdc_IP_control1.vdc = 0;
vdc_IP_control1.vdcref = 0;
  elseif controlType == "P_mode" then
    vdc = vdc_droop1.vdc;
    vdcref = vdc_droop1.vdcref;
    0 = Pref;
vdc_PI_control1.vdc = 0;
vdc_PI_control1.vdcref = 0;
vdc_PI_control_with_filter1.vdc = 0;
vdc_PI_control_with_filter1.vdcref = 0;
vdc_IP_control1.vdc = 0;
vdc_IP_control1.vdcref = 0;
  else
    vdc = vdc_droop1.vdc;
    vdcref = vdc_droop1.vdcref;
    vdc_droop1.Pref = Pref;
vdc_PI_control1.vdc = 0;
vdc_PI_control1.vdcref = 0;
vdc_PI_control_with_filter1.vdc = 0;
vdc_PI_control_with_filter1.vdcref = 0;
vdc_IP_control1.vdc = 0;
vdc_IP_control1.vdcref = 0;
  end if;
annotation(
    Icon(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}), Text(origin = {140, -61}, extent = {{-132, 29}, {-58, -7}}, textString = "Vdc"), Text(origin = {60, -86}, extent = {{-58, 30}, {36, -16}}, textString = "Control"), Text(origin = {-43, 60}, extent = {{-51, 18}, {51, -18}}, textString = "Vdc_ref"), Text(origin = {-67, -50}, extent = {{-23, 10}, {29, -28}}, textString = "Vdc"), Text(origin = {61, 7}, extent = {{-17, 27}, {29, -37}}, textString = "D_P")}),
    Diagram);

end vdc_control;
