within OpenIPSL.Electrical.Buses;

model Bus_with_controllable_voltage
  outer OpenIPSL.Electrical.SystemBase SysData;
//  parameter OpenIPSL.Types.ApparentPowerMega S_b=SysData.S_b;
  Real V "Bus voltage magnitude (pu)";
//  Real P "Active Power absorbed by the bus (MW)";
//  Real Q "Reactive Power absorbed by the bus (MVAr)";
  Modelica.SIunits.Conversions.NonSIunits.Angle_deg angle;
  parameter Boolean displayPF=true "Display voltage values:" annotation (Dialog(
      group="Visualisation",
      __Dymola_compact=true,
      __Dymola_descriptionLabel=true), choices(checkBox=true));
  Modelica.Blocks.Interfaces.RealInput viref annotation(
    Placement(visible = true, transformation(origin = {-120, 74}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-22, 42}, extent = {{-12, -12}, {12, 12}}, rotation = 0)));
  OpenIPSL.Interfaces.PwPin p annotation(
    Placement(visible = true, transformation(origin = {24, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput vrref annotation(
    Placement(visible = true, transformation(origin = {-120, 36}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-22, 82}, extent = {{-12, -12}, {12, 12}}, rotation = 0)));
equation
  p.vi = viref;
  p.vr = vrref;
  V = sqrt(p.vr^2 + p.vi^2);
  angle = atan2(p.vi, p.vr)*180/Modelica.Constants.pi;

  annotation(
    Icon(graphics = {Rectangle(fillPattern = FillPattern.Solid, extent = {{-10, -100}, {10, 100}}), Text(origin = {-0.02605, 120.133}, fillPattern = FillPattern.Solid, extent = {{-100, -20}, {100, 20}}, textString = "%name"), Text(visible = false, origin = {0, -120}, lineColor = {170, 0, 0}, extent = {{-60, -20}, {60, 20}}, textString = "Vpu"), Text(visible = false, origin = {0, -160}, lineColor = {170, 0, 0}, extent = {{-60, -20}, {60, 20}}, textString = "Angle")}, coordinateSystem(initialScale = 0.1)),
    Documentation);
end Bus_with_controllable_voltage;
