within OpenIPSL.Electrical.Sensors;

class pwCurrent
  OpenIPSL.Interfaces.PwPin p
    annotation (Placement(transformation(extent={{-110,-10},{-90,10}})));
  Modelica.Blocks.Interfaces.RealOutput ir
    annotation (Placement(transformation(extent={{100,50},{120,70}})));
  Modelica.Blocks.Interfaces.RealOutput ii
    annotation (Placement(transformation(extent={{100,-10},{120,10}})));
  Modelica.Blocks.Interfaces.RealOutput I
    annotation (Placement(transformation(extent={{100,-70},{120,-50}})));
equation
  p.vr = 0;
  p.vi = 0;
  p.ir = ir;
  p.vi = ii;
  I = sqrt(p.ir*p.ir + p.ii*p.ii);
  annotation (Icon(graphics = {Rectangle(lineColor = {0, 0, 255}, extent = {{-100, 100}, {100, -100}}), Rectangle(lineColor = {0, 0, 255}, extent = {{-80, 80}, {80, -80}}), Rectangle(lineColor = {0, 0, 255}, extent = {{-60, 60}, {60, 0}}), Text(lineColor = {0, 0, 255}, extent = {{-20, -20}, {20, -60}}, textString = "I", textStyle = {TextStyle.Bold, TextStyle.Bold}), Line(points = {{0, 0}, {40, 40}}, color = {0, 0, 255}), Text(lineColor = {0, 0, 255}, extent = {{80, 70}, {100, 50}}, textString = "ir"), Text(lineColor = {0, 0, 255}, extent = {{80, 10}, {100, -10}}, textString = "ii"), Text(lineColor = {0, 0, 255}, extent = {{80, -50}, {100, -70}}, textString = "I"), Text(lineColor = {0, 0, 255}, extent = {{-100, -100}, {100, -160}}, textString = "%name")}, coordinateSystem(initialScale = 0.1)), Documentation);
end pwCurrent;
