within HVDCcomponents.VSC_station_components;

model voltage_lim
  //Limitation of the voltage module in dq reference frame
  //Voltage limit depends on the input DC voltage
  //The angle between vd and vq component is conserved
  parameter Real m_max "pu";
  Real Vmod;
  Real Vmod_max;
  Real teta;
  import PI = Modelica.Constants.pi;
  Modelica.Blocks.Interfaces.RealInput vmd_in annotation(
    Placement(visible = true, transformation(origin = {-120, 54}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, 54}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput vmq_in annotation(
    Placement(visible = true, transformation(origin = {-120, -34}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-120, -40}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput vmd_out annotation(
    Placement(visible = true, transformation(origin = {116, 50}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {116, 50}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput vmq_out annotation(
    Placement(visible = true, transformation(origin = {116, -30}, extent = {{-18, -18}, {18, 18}}, rotation = 0), iconTransformation(origin = {118, -40}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput Vdc annotation(
    Placement(visible = true, transformation(origin = {-2, -120}, extent = {{20, -20}, {-20, 20}}, rotation = -90), iconTransformation(origin = {-2, -120}, extent = {{20, -20}, {-20, 20}}, rotation = -90)));
equation

  Vmod = sqrt(vmd_in * vmd_in + vmq_in * vmq_in);
  Vmod_max = m_max*Vdc;
 if vmd_in == 0 then
  teta = PI/2;
 else
  teta = atan2(vmq_in,vmd_in);
 end if;
  
 if Vmod > m_max*Vdc then
      vmd_out = m_max*Vdc*cos(teta);
      vmq_out = m_max*Vdc*sin(teta);
 else
      vmq_out = vmq_in;
      vmd_out = vmd_in;
 end if;

annotation(
    Icon(graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}), Text(origin = {3, 12}, extent = {{-61, 40}, {57, -40}}, textString = "Overmodulation"), Text(origin = {15, -20}, extent = {{-49, 32}, {17, -10}}, textString = "limitation"), Text(origin = {-13, -75}, extent = {{-19, 11}, {35, -23}}, textString = "Vdc"), Text(origin = {-79, -31}, extent = {{-19, 11}, {35, -23}}, textString = "Vq"), Text(origin = {-87, 61}, extent = {{-19, 11}, {35, -23}}, textString = "Vd"), Text(origin = {59, 61}, extent = {{-19, 11}, {35, -23}}, textString = "Vmd"), Text(origin = {61, -31}, extent = {{-19, 11}, {35, -23}}, textString = "Vmq")}, coordinateSystem(initialScale = 0.1)));
end voltage_lim;
