within HVDCcomponents.Examples;

model Test_VSC

  OpenIPSL.Electrical.Buses.Bus bus1(S_b = 1000, V_b = 230, displayPF = true, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {116, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus1(S_b = 1000, V_b = 230, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {108, -34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  HVDCcomponents.PQ_sensor pQ_sensor1(S_b = 1000) annotation(
    Placement(visible = true, transformation(origin = {84.4, 2}, extent = {{-6, -5}, {6, 5}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Ground ground1 annotation(
    Placement(visible = true, transformation(origin = {-55, -27}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  HVDCcomponents.PQ_sensor pQ_sensor2(S_b = 1000) annotation(
    Placement(visible = true, transformation(origin = {-231.6, 0}, extent = {{6, -5}, {-6, 5}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus2(S_b = 1000, V_b = 230, displayPF = true, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-264, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.InfiniteBus infiniteBus2(S_b = 1000, V_b = 230, fn = 50) annotation(
    Placement(visible = true, transformation(origin = {-272, -36}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.Step step5(height = 10E6, startTime = 10) annotation(
    Placement(visible = true, transformation(origin = {-172, 50}, extent = {{4, -4}, {-4, 4}}, rotation = 0)));
  Modelica.Blocks.Sources.Step step4(height = 0, offset = 0, startTime = 2) annotation(
    Placement(visible = true, transformation(origin = {42, 34}, extent = {{4, -4}, {-4, 4}}, rotation = 0)));
  Modelica.Blocks.Sources.Step step1(height = 0, startTime = 0) annotation(
    Placement(visible = true, transformation(origin = {30, 66}, extent = {{4, -4}, {-4, 4}}, rotation = 0)));
  HVDCcomponents.VSC_station_final vSC_station_final(MVAb = 1000, P_ref = 0, Q_ref = 0, S_b = 1000, Vb = 230, Vdcb = 640, Vgd = 230)  annotation(
    Placement(visible = true, transformation(origin = {-194, 2}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  HVDCcomponents.DC_cable_PI_section dC_cable_PI_section(Vinit = 640E3, length = 100)  annotation(
    Placement(visible = true, transformation(origin = {-90, 2}, extent = {{-15, -5}, {15, 5}}, rotation = 0)));
  Modelica.Blocks.Sources.Step step(height = 10E6, offset = 0, startTime = 5) annotation(
    Placement(visible = true, transformation(origin = {-152, 26}, extent = {{4, -4}, {-4, 4}}, rotation = 0)));
  HVDCcomponents.VSC_station_final vSC_station_final1(MVAb = 1000, P_ref = 0, Q_ref = 0, S_b = 1000, Vb = 230, Vdc_Control_Type = "PI+filter", Vdcb = 640, Vgd = 230) annotation(
    Placement(visible = true, transformation(origin = {0, 8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sensors.CurrentSensor Sensor annotation(
    Placement(visible = true, transformation(origin = {-52, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(pQ_sensor1.n, bus1.p) annotation(
    Line(points = {{90, 2}, {116.4, 2}}, color = {0, 0, 255}));
  connect(bus1.p, infiniteBus1.p) annotation(
    Line(points = {{116, 2}, {132, 2}, {132, -34}, {125, -34}, {125, -34}, {123.5, -34}, {123.5, -34}, {118, -34}}, color = {0, 0, 255}));
  connect(bus2.p, infiniteBus2.p) annotation(
    Line(points = {{-264, 0}, {-290, 0}, {-290, -36}, {-282, -36}, {-282, -36}}, color = {0, 0, 255}));
  connect(pQ_sensor2.n, bus2.p) annotation(
    Line(points = {{-238, 0}, {-264, 0}, {-264, 0}, {-264, 0}}, color = {0, 0, 255}));
  connect(pQ_sensor2.p, vSC_station_final.p) annotation(
    Line(points = {{-226, 0}, {-216, 0}, {-216, 2}, {-205, 2}}, color = {0, 0, 255}));
  connect(dC_cable_PI_section.pin_p, vSC_station_final.pin_p) annotation(
    Line(points = {{-105, 5}, {-144, 5}, {-144, 7}, {-183, 7}}, color = {0, 0, 255}));
  connect(vSC_station_final.pin_n, dC_cable_PI_section.pin_n) annotation(
    Line(points = {{-183, -3}, {-104, -3}, {-104, -1}, {-105, -1}}, color = {0, 0, 255}));
  connect(ground1.p, dC_cable_PI_section.pin_n1) annotation(
    Line(points = {{-54, -20}, {-54, -1}, {-75, -1}}, color = {0, 0, 255}));
  connect(vSC_station_final1.p, pQ_sensor1.p) annotation(
    Line(points = {{12, 8}, {70, 8}, {70, 2}, {78, 2}, {78, 2}}, color = {0, 0, 255}));
  connect(vSC_station_final1.pin_n, dC_cable_PI_section.pin_n1) annotation(
    Line(points = {{-10, 2}, {-54, 2}, {-54, 0}, {-75, 0}, {-75, -1}}, color = {0, 0, 255}));
  connect(step5.y, vSC_station_final.Qref) annotation(
    Line(points = {{-176, 50}, {-198, 50}, {-198, 14}, {-198, 14}}, color = {0, 0, 127}));
  connect(step.y, vSC_station_final.Pref) annotation(
    Line(points = {{-156, 26}, {-190, 26}, {-190, 14}, {-190, 14}}, color = {0, 0, 127}));
  connect(vSC_station_final1.Pref, step1.y) annotation(
    Line(points = {{-4, 20}, {-8, 20}, {-8, 66}, {26, 66}}, color = {0, 0, 127}));
  connect(step4.y, vSC_station_final1.Qref) annotation(
    Line(points = {{38, 34}, {4, 34}, {4, 20}, {4, 20}}, color = {0, 0, 127}));
  connect(Sensor.p, dC_cable_PI_section.pin_p1) annotation(
    Line(points = {{-62, 42}, {-74, 42}, {-74, 6}, {-74, 6}}, color = {0, 0, 255}));
  connect(Sensor.n, vSC_station_final1.pin_p) annotation(
    Line(points = {{-42, 42}, {-22, 42}, {-22, 12}, {-10, 12}, {-10, 14}}, color = {0, 0, 255}));
  annotation(
    Diagram(graphics = {Line(origin = {0, 8}, points = {{0, 0}})}, coordinateSystem(extent = {{-300, -100}, {150, 100}}, initialScale = 0.1)),
    Icon(coordinateSystem(extent = {{-300, -100}, {150, 100}})),
    __OpenModelica_commandLineOptions = "", experiment(
      StopTime=20,
      Interval=0.002,
      Tolerance=1e-006,
      __OpenModelica_Algorithm="dassl"));



end Test_VSC;
