within HVDCcomponents;

model VSC_station_final
  outer OpenIPSL.Electrical.SystemBase SysData;
  parameter Real Rr = 0.002 "Connection resistance (pu)" annotation(
    Dialog(group = "Physical parameters"));
  parameter String Vdc_Control_Type = "P_mode" "Droop, P_mode, PI, PI+filter or IP" annotation(
    Dialog(group = "Control"));
  parameter String PLL_Type = "PI" "Ideal, PI" annotation(
    Dialog(group = "Control"));
  parameter Real Xr = 100E-3 " Connection reactance or inductance (pu)" annotation(
    Dialog(group = "Physical parameters"));
  parameter Real C_dc = 195E-6 "DC capacitor (F)" annotation(
    Dialog(group = "Physical parameters"));
  parameter Real S_b = SysData.S_b "System base power (MVA)" annotation(
    Dialog(group = "Base values"));
  parameter Real MVAb = 1000 "Converter rated power (MVA)" annotation(
    Dialog(group = "Base values"));
  parameter Real fb = SysData.fn "System frequency (Hz)" annotation(
    Dialog(group = "Base values"));
  parameter Real Q_max = 0.5 "Maximum reactive power injection (pu)" annotation(
    Dialog(group = "Control"));
  parameter Real Q_min = -0.5 "Minimum reactive power injection (pu)" annotation(
    Dialog(group = "Control"));
  parameter Real m_max = 1.1 "Maximum modulation index (pu)" annotation(
    Dialog(group = "Control"));
  parameter Real tr = 3E-3 "response time of the current loop (s)" annotation(
    Dialog(group = "Control"));
  parameter Real I_max = 1.1 "Maximum current (pu)" annotation(
    Dialog(group = "Control"));
  parameter String Priority = "q" "d, q - Axis priority" annotation(
    Dialog(group = "Control"));
  parameter Real k_droop = 10 "Voltage droop (MW/kV)" annotation(
    Dialog(group = "Control"));
  parameter Real Vb = 400 "Base voltage (kV)" annotation(
    Dialog(group = "Base values"));
  parameter Real Vdcb = 230 "Base DC voltage (kV)" annotation(
    Dialog(group = "Base values"));
  parameter Real teta_bus = 0 "connection bus angle (rad)" annotation(
    Dialog(group = "Power flow data"));
  parameter Real Vgd "connection bus voltage magnitude (V)" annotation(
    Dialog(group = "Power flow data"));
  parameter Real Vdc0 = 1 "DC voltage reference (pu)" annotation(
    Dialog(group = "Control"));
  parameter Real tr_dc = 40E-3 "response time of the DC voltage loop (s)" annotation(
    Dialog(group = "Control"));
  parameter Real P_ref "=Pref initial (W)" annotation(
    Dialog(group = "Power flow data"));
  parameter Real Q_ref "=-Qref initial (VAr)" annotation(
    Dialog(group = "Power flow data"));
  OpenIPSL.Interfaces.PwPin p annotation(
    Placement(visible = true, transformation(origin = {166, 78}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, -2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
    Placement(visible = true, transformation(origin = {-232, 102}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-110, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
    Placement(visible = true, transformation(origin = {-234, 56}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-110, -52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput Pref annotation(
    Placement(visible = true, transformation(origin = {253, -115}, extent = {{15, -15}, {-15, 15}}, rotation = 0), iconTransformation(origin = {-35, 115}, extent = {{-15, -15}, {15, 15}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealInput Qref annotation(
    Placement(visible = true, transformation(origin = {253, -149}, extent = {{15, -15}, {-15, 15}}, rotation = 0), iconTransformation(origin = {39, 115}, extent = {{-15, -15}, {15, 15}}, rotation = -90)));
  Modelica.Blocks.Sources.Constant Vdc_ref(k = Vdc0 * 1000 * Vdcb) annotation(
    Placement(visible = true, transformation(origin = {105, 39}, extent = {{-9, -9}, {9, 9}}, rotation = 0)));
  HVDCcomponents.VSC_station_components.PLL2 pll_PI(kipll = -3600, kppll = -120, teta_bus = teta_bus, w_base = 2 * Modelica.Constants.pi * fb, wcpll = 200) annotation(
    Placement(visible = true, transformation(origin = {65, -5.5}, extent = {{-21, -10.5}, {21, 10.5}}, rotation = -90)));
  HVDCcomponents.VSC_station_components.ri_to_dq ri_to_dq_i annotation(
    Placement(visible = true, transformation(origin = {-16, -80}, extent = {{12, 12}, {-12, -12}}, rotation = 90)));
  HVDCcomponents.VSC_station_components.ri_to_dq ri_to_dq_v annotation(
    Placement(visible = true, transformation(origin = {18, -80}, extent = {{12, 12}, {-12, -12}}, rotation = 90)));
  Modelica.Blocks.Nonlinear.Limiter Qref_limiter(limitsAtInit = true, uMax = MVAb * Q_max * 1000000, uMin = MVAb * Q_min * 1000000) annotation(
    Placement(visible = true, transformation(origin = {157, -149}, extent = {{11, -11}, {-11, 11}}, rotation = 0)));
  Modelica.Blocks.Nonlinear.Limiter Pref_limiter(limitsAtInit = true, uMax = MVAb * 1000000, uMin = -MVAb * 1000000) annotation(
    Placement(visible = true, transformation(origin = {157, -111}, extent = {{11, -11}, {-11, 11}}, rotation = 0)));
  HVDCcomponents.vdc_control vdcControl(Cdc = C_dc, Ksi = 0.7, controlType = Vdc_Control_Type, g_droop = k_droop * 1000, tr = tr_dc, vdc0 = Vdc0 * 1000 * Vdcb) annotation(
    Placement(visible = true, transformation(origin = {170, 28}, extent = {{-18, -18}, {18, 18}}, rotation = 0)));
  HVDCcomponents.VSC_station_components.PLL_ideal pLL_ideal annotation(
    Placement(visible = true, transformation(origin = {102, -6}, extent = {{-22, -11}, {22, 11}}, rotation = -90)));
  HVDCcomponents.VSC_station_components.voltage_lim voltage_mod_lim(m_max = m_max) annotation(
    Placement(visible = true, transformation(origin = {-127, -39}, extent = {{-23, -23}, {23, 23}}, rotation = 90)));
  HVDCcomponents.VSC_station_components.Inner_control_I_limitation inner_control_I_limitation1(I_base = MVAb * 1000 / Vb, Lr = Xr * Vb * Vb / (2 * MVAb * fb * Modelica.Constants.pi), MVAb = MVAb, Pref = P_ref, Priority = Priority, Qref = Q_ref, Rr = Rr * Vb * Vb / MVAb, Vb = Vb, Vgd = Vgd, i_max = I_max, tr = tr) annotation(
    Placement(visible = true, transformation(origin = {-1.20924, -127.846}, extent = {{29.8955, -29.8955}, {-29.8955, 14.9478}}, rotation = 0)));
  HVDCcomponents.VSC_station_components.Physical_Layer physical_Layer(C_dc = C_dc, MVAb = MVAb, P_ref = P_ref, Q_ref = Q_ref, Rr = Rr, S_b = S_b, Vb = Vb, Vdc0 = Vdc0, Vdcb = Vdcb, Vgd = Vgd, Xr = Xr, fb = fb) annotation(
    Placement(visible = true, transformation(origin = {-58, 78}, extent = {{-88, -44}, {88, 44}}, rotation = 0)));
  HVDCcomponents.VSC_station_components.Idqref_calc_VSC idqref_calc_VSC annotation(
    Placement(visible = true, transformation(origin = {78, -136}, extent = {{20, -20}, {-20, 20}}, rotation = 0)));
  Modelica.Blocks.Math.Add add(k1 = +1, k2 = +1) annotation(
    Placement(visible = true, transformation(origin = {204, -110}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Math.Gain gain3(k = S_b * 1000 /Vb) annotation(
    Placement(visible = true, transformation(origin = {-22, -54}, extent = {{4, -4}, {-4, 4}}, rotation = 90)));
  Modelica.Blocks.Math.Gain gain(k = S_b * 1000 / Vb) annotation(
    Placement(visible = true, transformation(origin = {-10, -54}, extent = {{4, -4}, {-4, 4}}, rotation = 90)));
  Modelica.Blocks.Math.Gain gain1(k = Vb * 1000) annotation(
    Placement(visible = true, transformation(origin = {12, -54}, extent = {{4, -4}, {-4, 4}}, rotation = 90)));
  Modelica.Blocks.Math.Gain gain2(k = Vb * 1000) annotation(
    Placement(visible = true, transformation(origin = {24, -54}, extent = {{4, -4}, {-4, 4}}, rotation = 90)));
equation
//  if Vdc_Control_Type == "Droop" then
//    add.u1 = vdcControl.Pref;
//    add.u2 = Pref;
//  elseif Vdc_Control_Type == "P_mode" then
//    add.u1 = 0;
//    add.u2 = Pref;
//  else
//    add.u1 = 0;
//    add.u2 = vdcControl.Pref;
//  end if;
  if PLL_Type == "Ideal" then
    ri_to_dq_v.angle = pLL_ideal.teta_pll;
    ri_to_dq_i.angle = pLL_ideal.teta_pll;
//    dq_to_ri.angle = pLL_ideal.teta_pll;
//    ri_to_dq.angle = pLL_ideal.teta_pll;
    physical_Layer.theta_pll = pLL_ideal.teta_pll;
    inner_control_I_limitation1.wpll = 2 * Modelica.Constants.pi * fb;
  elseif PLL_Type == "PI" then
    ri_to_dq_v.angle = pll_PI.teta_pll;
    ri_to_dq_i.angle = pll_PI.teta_pll;
//    dq_to_ri.angle = pll2.teta_pll;
//    ri_to_dq.angle = pll2.teta_pll;
    physical_Layer.theta_pll = pll_PI.teta_pll;
    inner_control_I_limitation1.wpll = pll_PI.w_pll;
  end if;
  connect(pin_p, physical_Layer.pin_p) annotation(
    Line(points = {{-232, 102}, {-150, 102}}, color = {0, 0, 255}));
  connect(voltage_mod_lim.Vdc, physical_Layer.Vdc) annotation(
    Line(points = {{-99, -39}, {-40, -39}, {-40, 30}}, color = {0, 0, 127}));
  connect(physical_Layer.pin_n, pin_n) annotation(
    Line(points = {{-150, 56}, {-234, 56}}, color = {0, 0, 255}));
  connect(voltage_mod_lim.vmq_out, physical_Layer.Vmq) annotation(
    Line(points = {{-118, -12}, {-118, 31}}, color = {0, 0, 127}));
  connect(inner_control_I_limitation1.vmd, voltage_mod_lim.vmd_in) annotation(
    Line(points = {{-33, -133}, {-139, -133}, {-139, -67}}, color = {0, 0, 127}));
  connect(inner_control_I_limitation1.vmq, voltage_mod_lim.vmq_in) annotation(
    Line(points = {{-33, -148}, {-118, -148}, {-118, -67}}, color = {0, 0, 127}));
  connect(inner_control_I_limitation1.vgq, ri_to_dq_v.xq) annotation(
    Line(points = {{8, -115}, {8, -94}, {15, -94}}, color = {0, 0, 127}));
  connect(vdcControl.vdc, physical_Layer.Vdc) annotation(
    Line(points = {{148, 17}, {-40, 17}, {-40, 30}}, color = {0, 0, 127}));
  connect(Qref, Qref_limiter.u) annotation(
    Line(points = {{253, -149}, {170, -149}}, color = {0, 0, 127}));
  connect(pll_PI.Vi, physical_Layer.Vi_PCC) annotation(
    Line(points = {{52, -10}, {10, -10}, {10, 30}}, color = {0, 0, 127}));
  connect(pLL_ideal.Vi, pll_PI.Vi) annotation(
    Line(points = {{89, -10}, {52, -10}}, color = {0, 0, 127}));
  connect(pll_PI.Vr, physical_Layer.Vr_PCC) annotation(
    Line(points = {{52, 1}, {20, 1}, {20, 30}}, color = {0, 0, 127}));
  connect(idqref_calc_VSC.igdref, inner_control_I_limitation1.igdref) annotation(
    Line(points = {{55, -124}, {42, -124}, {42, -133}, {29, -133}}, color = {0, 0, 127}));
  connect(idqref_calc_VSC.igqref, inner_control_I_limitation1.igqref) annotation(
    Line(points = {{55, -148}, {29, -148}}, color = {0, 0, 127}));
  connect(idqref_calc_VSC.Pref, Pref_limiter.y) annotation(
    Line(points = {{102, -124}, {122, -124}, {122, -112}, {144, -112}, {144, -111}, {145, -111}}, color = {0, 0, 127}));
  connect(Qref_limiter.y, idqref_calc_VSC.Qref) annotation(
    Line(points = {{145, -149}, {145, -148}, {102, -148}}, color = {0, 0, 127}));
  connect(voltage_mod_lim.vmd_out, physical_Layer.Vmd) annotation(
    Line(points = {{-138.5, -12}, {-138, -12}, {-138, 31}, {-137, 31}}, color = {0, 0, 127}));
  connect(physical_Layer.p, p) annotation(
    Line(points = {{32, 78}, {166, 78}}, color = {0, 0, 255}));
  connect(ri_to_dq_i.xd, inner_control_I_limitation1.igd) annotation(
    Line(points = {{-12, -94}, {-12, -94}, {-12, -114}, {-12, -114}}, color = {0, 0, 127}));
  connect(ri_to_dq_i.xq, inner_control_I_limitation1.igq) annotation(
    Line(points = {{-18, -94}, {-22, -94}, {-22, -114}}, color = {0, 0, 127}));
  connect(inner_control_I_limitation1.vgd, ri_to_dq_v.xd) annotation(
    Line(points = {{20, -114}, {20, -114}, {20, -94}, {22, -94}}, color = {0, 0, 127}));
  connect(idqref_calc_VSC.vgd, ri_to_dq_v.xd) annotation(
    Line(points = {{78, -112}, {66, -112}, {66, -100}, {20, -100}, {20, -94}, {22, -94}}, color = {0, 0, 127}));
  connect(pLL_ideal.Vr, pll_PI.Vr) annotation(
    Line(points = {{89, 0}, {70, 0}, {70, 1}, {52, 1}}, color = {0, 0, 127}));
  connect(Pref_limiter.u, add.y) annotation(
    Line(points = {{170, -110}, {193, -110}}, color = {0, 0, 127}));
  connect(add.u2, Pref) annotation(
    Line(points = {{216, -116}, {244, -116}, {244, -115}, {253, -115}}, color = {0, 0, 127}));
  connect(vdcControl.Pref, add.u1) annotation(
    Line(points = {{190, 28}, {228, 28}, {228, -104}, {216, -104}}, color = {0, 0, 127}));
  connect(Vdc_ref.y, vdcControl.vdcref) annotation(
    Line(points = {{115, 39}, {148, 39}}, color = {0, 0, 127}));
  connect(physical_Layer.Ii, gain3.u) annotation(
    Line(points = {{-20, 30}, {-22, 30}, {-22, -50}, {-22, -50}}, color = {0, 0, 127}));
  connect(gain.u, physical_Layer.Ir) annotation(
    Line(points = {{-10, -50}, {-10, -50}, {-10, 30}, {-10, 30}}, color = {0, 0, 127}));
  connect(gain3.y, ri_to_dq_i.xi) annotation(
    Line(points = {{-22, -58}, {-20, -58}, {-20, -66}, {-20, -66}}, color = {0, 0, 127}));
  connect(gain.y, ri_to_dq_i.xr) annotation(
    Line(points = {{-10, -58}, {-12, -58}, {-12, -66}, {-12, -66}}, color = {0, 0, 127}));
  connect(gain1.y, ri_to_dq_v.xi) annotation(
    Line(points = {{12, -58}, {14, -58}, {14, -66}, {14, -66}}, color = {0, 0, 127}));
  connect(gain2.y, ri_to_dq_v.xr) annotation(
    Line(points = {{24, -58}, {22, -58}, {22, -66}, {22, -66}}, color = {0, 0, 127}));
  connect(gain1.u, physical_Layer.Vi_PCC) annotation(
    Line(points = {{12, -50}, {10, -50}, {10, 30}, {10, 30}}, color = {0, 0, 127}));
  connect(gain2.u, physical_Layer.Vr_PCC) annotation(
    Line(points = {{24, -50}, {20, -50}, {20, 30}, {20, 30}}, color = {0, 0, 127}));
  annotation(
    Diagram(coordinateSystem(extent = {{-250, -200}, {250, 200}})),
    Icon(coordinateSystem(initialScale = 0.1), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}), Line(points = {{-100, 100}, {100, -100}, {100, -100}}), Line(origin = {-45.75, -39.37}, points = {{-22, 0}, {36, 0}, {36, 0}}), Line(origin = {-46.08, -51.25}, points = {{-22, 0}, {36, 0}, {36, 0}}), Line(origin = {38.2546, 38.7668}, points = {{-39.999, 0}, {-19.999, 20}, {22.001, -20}, {40.001, 0}}), Text(origin = {-43, 101}, extent = {{-3, 3}, {19, -35}}, textString = "P"), Text(origin = {33, 101}, extent = {{-3, 3}, {19, -35}}, textString = "Q"), Text(origin = {-92, 58}, extent = {{-10, 6}, {10, -14}}, textString = "+"), Text(origin = {-96, -42}, extent = {{-10, 6}, {16, -22}}, textString = "-")}),
    __OpenModelica_commandLineOptions = "",
    Documentation(info = "<html><head></head><body>2-level VSC converter station complete model (including controls, PLL and limiters) based on&nbsp;<span class=\"fontstyle0\">Samy Akkari. Control of a multi-terminal HVDC (MTDC) system and study of the interactions&nbsp;between the MTDC and the AC grids. Université Paris-Saclay, 2016.</span>&nbsp;&nbsp;</body></html>"));
end VSC_station_final;
