within HVDCcomponents.VSC_station_components;

model Inner_control_I_limitation

parameter Real Lr;
parameter Real Rr;
parameter Real tr;
parameter Real Pref;
parameter Real Qref;
parameter Real Vgd;
parameter Real i_max;
parameter Real I_base;
parameter Real Vb;
parameter Real MVAb;
parameter String Priority;
Modelica.Blocks.Interfaces.RealInput igd annotation(
    Placement(visible = true, transformation(origin = {-117, 19}, extent = {{-17, -17}, {17, 17}}, rotation = 0), iconTransformation(origin = {77, 105}, extent = {{-17, -17}, {17, 17}}, rotation = -90)));
Modelica.Blocks.Interfaces.RealInput igq annotation(
    Placement(visible = true, transformation(origin = {-117, -153}, extent = {{-17, -17}, {17, 17}}, rotation = 0), iconTransformation(origin = {141, 105}, extent = {{-17, -17}, {17, 17}}, rotation = -90)));
Modelica.Blocks.Interfaces.RealInput vgd annotation(
    Placement(visible = true, transformation(origin = {107, 119}, extent = {{-17, -17}, {17, 17}}, rotation = -90), iconTransformation(origin = {-139, 103}, extent = {{-17, -17}, {17, 17}}, rotation = -90)));
Modelica.Blocks.Interfaces.RealInput vgq annotation(
    Placement(visible = true, transformation(origin = {109, -217}, extent = {{-17, -17}, {17, 17}}, rotation = 90), iconTransformation(origin = {-63, 103}, extent = {{17, -17}, {-17, 17}}, rotation = 90)));
Modelica.Blocks.Interfaces.RealInput igdref annotation(
    Placement(visible = true, transformation(origin = {-301, 75}, extent = {{-17, -17}, {17, 17}}, rotation = 0), iconTransformation(origin = {-203, -21}, extent = {{-17, -17}, {17, 17}}, rotation = 0)));
Modelica.Blocks.Interfaces.RealInput igqref annotation(
    Placement(visible = true, transformation(origin = {-295, -103}, extent = {{-17, -17}, {17, 17}}, rotation = 0), iconTransformation(origin = {-203, -119}, extent = {{-17, -17}, {17, 17}}, rotation = 0)));
Modelica.Blocks.Interfaces.RealOutput vmd annotation(
    Placement(visible = true, transformation(origin = {300, 22}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {216, -20}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
Modelica.Blocks.Interfaces.RealOutput vmq annotation(
    Placement(visible = true, transformation(origin = {300, -102}, extent = {{-16, -16}, {16, 16}}, rotation = 0), iconTransformation(origin = {216, -120}, extent = {{-16, -16}, {16, 16}}, rotation = 0)));
Modelica.Blocks.Math.Add add1(k1 = +1, k2 = -1)  annotation(
    Placement(visible = true, transformation(origin = {-48, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Continuous.Integrator integrator1(k = Rr / tr, y_start = Rr * Pref / Vgd)  annotation(
    Placement(visible = true, transformation(origin = {18, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Gain gain1(k = Lr / tr)  annotation(
    Placement(visible = true, transformation(origin = {18, 78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Add add2(k2 = +1) annotation(
    Placement(visible = true, transformation(origin = {78, 48}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Add3 add31(k3 = -1)  annotation(
    Placement(visible = true, transformation(origin = {144, 48}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Product product1 annotation(
    Placement(visible = true, transformation(origin = {-32, -12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Sources.Constant const(k =  Lr)  annotation(
    Placement(visible = true, transformation(origin = {-110, -22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Product product2 annotation(
    Placement(visible = true, transformation(origin = {-32, -78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Add add3(k1 = +1, k2 = -1) annotation(
    Placement(visible = true, transformation(origin = {-34, -132}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Continuous.Integrator integrator2(k = Rr / tr, y_start = Rr * Vb * MVAb * 0.5 * 1000 / (Vb * Vb)) annotation(
    Placement(visible = true, transformation(origin = {22, -106}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Gain gain2(k = Lr / tr) annotation(
    Placement(visible = true, transformation(origin = {24, -156}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Add add4(k2 = +1) annotation(
    Placement(visible = true, transformation(origin = {74, -130}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
Modelica.Blocks.Math.Add3 add32(k1 = +1, k3 = +1) annotation(
    Placement(visible = true, transformation(origin = {142, -130}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput wpll annotation(
    Placement(visible = true, transformation(origin = {-117, -61}, extent = {{-17, -17}, {17, 17}}, rotation = 0), iconTransformation(origin = {19, -217}, extent = {{-17, -17}, {17, 17}}, rotation = 90)));
  Modelica.Blocks.Math.Product product3 annotation(
    Placement(visible = true, transformation(origin = {-85, -45}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  HVDCcomponents.VSC_station_components.current_lim current_lim2(Ib = I_base, Priority = Priority, i_max = i_max)  annotation(
    Placement(visible = true, transformation(origin = {-242, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
  HVDCcomponents.VSC_station_components.Module_calc module_calc annotation(
    Placement(visible = true, transformation(origin = {-154, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.Constant constant1(k = 1) annotation(
    Placement(visible = true, transformation(origin = {-194, -12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Nonlinear.Limiter limiter1(limitsAtInit = true, uMax = i_max * I_base, uMin = -i_max * I_base) annotation(
    Placement(visible = true, transformation(origin = {-196, -84}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Nonlinear.Limiter limiter(limitsAtInit = true, uMax = i_max * I_base, uMin = -i_max * I_base) annotation(
    Placement(visible = true, transformation(origin = {-188, 48}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
initial equation
  igdref - igd = 0;
  igqref - igq = 0;
equation
  connect(add32.y, vmq) annotation(
    Line(points = {{154, -130}, {230, -130}, {230, -102}, {300, -102}, {300, -102}}, color = {0, 0, 127}));
  connect(add31.y, vmd) annotation(
    Line(points = {{156, 48}, {222, 48}, {222, 20}, {300, 20}, {300, 22}}, color = {0, 0, 127}));
  connect(product3.u1, const.y) annotation(
    Line(points = {{-94, -40}, {-96, -40}, {-96, -22}, {-98, -22}, {-98, -22}}, color = {0, 0, 127}));
  connect(product3.u2, wpll) annotation(
    Line(points = {{-94, -50}, {-98, -50}, {-98, -60}, {-116, -60}, {-116, -60}}, color = {0, 0, 127}));
  connect(product3.y, product2.u1) annotation(
    Line(points = {{-78, -44}, {-60, -44}, {-60, -72}, {-44, -72}, {-44, -72}}, color = {0, 0, 127}));
  connect(product3.y, product1.u2) annotation(
    Line(points = {{-78, -44}, {-66, -44}, {-66, -18}, {-44, -18}, {-44, -18}}, color = {0, 0, 127}));
  connect(igq, product2.u2) annotation(
    Line(points = {{-116, -152}, {-66, -152}, {-66, -84}, {-44, -84}, {-44, -84}}, color = {0, 0, 127}));
  connect(product1.y, add32.u1) annotation(
    Line(points = {{-20, -12}, {104, -12}, {104, -122}, {130, -122}, {130, -122}}, color = {0, 0, 127}));
  connect(add31.u1, vgd) annotation(
    Line(points = {{132, 56}, {108, 56}, {108, 120}, {108, 120}}, color = {0, 0, 127}));
  connect(add32.u3, vgq) annotation(
    Line(points = {{130, -138}, {108, -138}, {108, -216}, {110, -216}}, color = {0, 0, 127}));
  connect(add4.y, add32.u2) annotation(
    Line(points = {{86, -130}, {130, -130}}, color = {0, 0, 127}));
  connect(gain2.y, add4.u2) annotation(
    Line(points = {{35, -156}, {46, -156}, {46, -136}, {62, -136}}, color = {0, 0, 127}));
  connect(integrator2.y, add4.u1) annotation(
    Line(points = {{34, -106}, {48, -106}, {48, -124}, {62, -124}, {62, -124}}, color = {0, 0, 127}));
  connect(add3.y, gain2.u) annotation(
    Line(points = {{-22, -132}, {-4, -132}, {-4, -156}, {12, -156}}, color = {0, 0, 127}));
  connect(add3.y, integrator2.u) annotation(
    Line(points = {{-22, -132}, {-6, -132}, {-6, -108}, {8, -108}, {8, -106}, {10, -106}}, color = {0, 0, 127}));
  connect(add3.u2, igq) annotation(
    Line(points = {{-46, -138}, {-74, -138}, {-74, -152}, {-116, -152}, {-116, -152}}, color = {0, 0, 127}));
  connect(product2.y, add31.u3) annotation(
    Line(points = {{-20, -78}, {74, -78}, {74, 12}, {120, 12}, {120, 40}, {132, 40}, {132, 40}}, color = {0, 0, 127}));
  connect(add2.y, add31.u2) annotation(
    Line(points = {{90, 48}, {132, 48}}, color = {0, 0, 127}));
  connect(igd, product1.u1) annotation(
    Line(points = {{-116, 20}, {-68, 20}, {-68, -6}, {-44, -6}, {-44, -6}}, color = {0, 0, 127}));
  connect(gain1.y, add2.u1) annotation(
    Line(points = {{30, 78}, {52, 78}, {52, 54}, {66, 54}, {66, 54}}, color = {0, 0, 127}));
  connect(integrator1.y, add2.u2) annotation(
    Line(points = {{29, 40}, {64, 40}, {64, 42}, {66, 42}}, color = {0, 0, 127}));
  connect(gain1.u, add1.y) annotation(
    Line(points = {{6, 78}, {-32, 78}, {-32, 40}, {-36, 40}, {-36, 40}}, color = {0, 0, 127}));
  connect(add1.y, integrator1.u) annotation(
    Line(points = {{-36, 40}, {6, 40}}, color = {0, 0, 127}));
  connect(igd, add1.u2) annotation(
    Line(points = {{-116, 20}, {-80, 20}, {-80, 34}, {-60, 34}, {-60, 34}}, color = {0, 0, 127}));
  connect(constant1.y, module_calc.Vb) annotation(
    Line(points = {{-182, -12}, {-168, -12}, {-168, -14}, {-166, -14}}, color = {0, 0, 127}));
  connect(module_calc.ui, limiter1.y) annotation(
    Line(points = {{-166, -23}, {-176, -23}, {-176, -84}, {-184, -84}}, color = {0, 0, 127}));
  connect(limiter1.y, add3.u1) annotation(
    Line(points = {{-185, -84}, {-104, -84}, {-104, -126}, {-46, -126}}, color = {0, 0, 127}));
  connect(module_calc.ur, limiter.y) annotation(
    Line(points = {{-166, -18}, {-172, -18}, {-172, 48}, {-176, 48}}, color = {0, 0, 127}));
  connect(limiter.y, add1.u1) annotation(
    Line(points = {{-177, 48}, {-106.5, 48}, {-106.5, 46}, {-60, 46}}, color = {0, 0, 127}));
  connect(current_lim2.id_y, limiter.u) annotation(
    Line(points = {{-232, 6}, {-218, 6}, {-218, 46}, {-200, 46}, {-200, 48}}, color = {0, 0, 127}));
  connect(current_lim2.id_u, igdref) annotation(
    Line(points = {{-252, 6}, {-264, 6}, {-264, 74}, {-300, 74}, {-300, 76}}, color = {0, 0, 127}));
  connect(current_lim2.iq_u, igqref) annotation(
    Line(points = {{-252, -6}, {-262, -6}, {-262, -104}, {-294, -104}, {-294, -102}}, color = {0, 0, 127}));
  connect(current_lim2.iq_y, limiter1.u) annotation(
    Line(points = {{-231, -6}, {-220, -6}, {-220, -84}, {-208, -84}}, color = {0, 0, 127}));
protected
  annotation(
    Diagram(coordinateSystem(extent = {{-400, -200}, {400, 100}}, initialScale = 0.1)),
    Icon(graphics = {Rectangle(origin = {5, -50}, extent = {{195, 150}, {-205, -150}}), Text(origin = {17, -49}, extent = {{-75, 31}, {73, -15}}, textString = "Current"), Text(origin = {-134, 57}, extent = {{-40, 27}, {28, -15}}, textString = "Vgd"), Text(origin = {-50, 59}, extent = {{-40, 27}, {28, -19}}, textString = "Vgq"), Text(origin = {86, 57}, extent = {{-40, 27}, {28, -15}}, textString = "Igd"), Text(origin = {156, 57}, extent = {{-40, 27}, {28, -15}}, textString = "Igq"), Text(origin = {-142, -21}, extent = {{-40, 27}, {42, -25}}, textString = "Id_ref"), Text(origin = {-140, -121}, extent = {{-40, 27}, {42, -25}}, textString = "Iq_ref"), Text(origin = {17, -83}, extent = {{-75, 31}, {73, -15}}, textString = "Control"), Text(origin = {174, -23}, extent = {{-40, 27}, {38, -19}}, textString = "Vd"), Text(origin = {180, -119}, extent = {{-40, 27}, {30, -17}}, textString = "Vq"), Text(origin = {20, -173}, extent = {{-40, 27}, {30, -17}}, textString = "wg")}, coordinateSystem(extent = {{-200, -200}, {200, 100}}, initialScale = 0.1)),
    __OpenModelica_commandLineOptions = "");




end Inner_control_I_limitation;
