within HVDCcomponents.VSC_station_components;

model Physical_Layer
  //  outer OpenIPSL.Electrical.SystemBase SysData;
  parameter Real Rr = Rr "Connection resistance (pu)" annotation(
    Dialog(group = "Physical parameters"));
  //  parameter String Control_Type = "Droop" "Droop, P_mode, PI, PI+filter or IP"  annotation(
  //    Dialog(group = "Control"));
  //  parameter String PLL_Type = "PI" "Ideal, PI"  annotation(
  //    Dialog(group = "Control"));
  parameter Real Xr = Xr " Connection inductance L (pu)" annotation(
    Dialog(group = "Physical parameters"));
  parameter Real C_dc = C_dc "DC capacitor (F)" annotation(
    Dialog(group = "Physical parameters"));
  parameter Real S_b = S_b "System base power (MVA)" annotation(
    Dialog(group = "Base values"));
  parameter Real MVAb = MVAb "Converter rated power (MVA)" annotation(
    Dialog(group = "Base values"));
  parameter Real fb = fb "System frequency (Hz)" annotation(
    Dialog(group = "Base values"));
  //  parameter Real Q_max = 0.5 "Maximum reactive power injection (pu)" annotation(
  //    Dialog(group = "Control"));
  //  parameter Real Q_min = -0.5 "Minimum reactive power injection (pu)" annotation(
  //    Dialog(group = "Control"));
  //  parameter Real V_max = 1.1 "Maximum voltage (pu)" annotation(
  //    Dialog(group = "Control"));
  //  parameter Real tr = 3E-3 "response time of the current loop (s)" annotation(
  //    Dialog(group = "Control"));
  //  parameter Real I_max = 1.1 "Maximum current (pu)" annotation(
  //    Dialog(group = "Control"));
  //  parameter String Priority = "q" "d, q - Axis priority" annotation(
  //    Dialog(group = "Control"));
  //  parameter Real k_droop = 10 "Voltage droop (MW/kV)" annotation( Dialog(group = "Control"));
  parameter Real Vb = Vb "Base voltage (kV)" annotation(
    Dialog(group = "Base values"));
  parameter Real Vdcb = Vdcb "Base DC voltage (kV)" annotation(
    Dialog(group = "Base values"));
  //  parameter Real teta_bus = 0 "connection bus angle (rad)" annotation(
  //    Dialog(group = "Power flow data"));
  parameter Real Vgd = Vgd "connection bus voltage magnitude (V)" annotation(
    Dialog(group = "Power flow data"));
  parameter Real Vdc0 = Vdc0 "DC voltage reference (pu)" annotation(
    Dialog(group = "Control"));
  //  parameter Real tr_dc = 40E-3 "response time of the DC voltage loop (s)" annotation(
  //    Dialog(group = "Control"));
  parameter Real P_ref = P_ref "=Pref initial (W)" annotation(
    Dialog(group = "Power flow data"));
  parameter Real Q_ref = Q_ref "=-Qref initial (VAr)" annotation(
    Dialog(group = "Power flow data"));
  Modelica.Electrical.Analog.Sources.SignalCurrent modulated_d_current annotation(
    Placement(visible = true, transformation(origin = {-196, -2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalCurrent modulated_q_current annotation(
    Placement(visible = true, transformation(origin = {-200, -62}, extent = {{10, 10}, {-10, -10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalVoltage modulated_d_voltage annotation(
    Placement(visible = true, transformation(origin = {-24, 40}, extent = {{10, 10}, {-10, -10}}, rotation = -90)));
  Modelica.Electrical.Analog.Sources.SignalVoltage modulated_q_voltage annotation(
    Placement(visible = true, transformation(origin = {-24, -86}, extent = {{-10, 10}, {10, -10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Resistor resistor1(R = Rr * Vb * Vb / MVAb) annotation(
    Placement(visible = true, transformation(origin = {68, 16}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Resistor resistor2(R = Rr * Vb * Vb / MVAb) annotation(
    Placement(visible = true, transformation(origin = {70, -68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Inductor inductor1(L = Xr * Vb * Vb / (2 * MVAb * fb * Modelica.Constants.pi), i(start = P_ref / Vgd)) annotation(
    Placement(visible = true, transformation(origin = {42, 16}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Inductor inductor2(L = Xr * Vb * Vb / (2 * MVAb * fb * Modelica.Constants.pi), i(start = -Q_ref / Vgd)) annotation(
    Placement(visible = true, transformation(origin = {38, -68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalVoltage VoltageSource1 annotation(
    Placement(visible = true, transformation(origin = {-4, 16}, extent = {{10, 10}, {-10, -10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalVoltage VoltageSource2 annotation(
    Placement(visible = true, transformation(origin = {-8, -68}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.ComplexBlocks.ComplexMath.RealToComplex realToComplex1 annotation(
    Placement(visible = true, transformation(origin = {436, -34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor_id annotation(
    Placement(visible = true, transformation(origin = {14, 50}, extent = {{10, 10}, {-10, -10}}, rotation = 0)));
  HVDCcomponents.SignalCurrent_phasor signalCurrent_phasor1 annotation(
    Placement(visible = true, transformation(origin = {450, -52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  HVDCcomponents.Ground_phasor ground_phasor1 annotation(
    Placement(visible = true, transformation(origin = {440, -88}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Interfaces.PwPin p annotation(
    Placement(visible = true, transformation(origin = {484, -52}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {204, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sensors.CurrentSensor currentSensor_iq annotation(
    Placement(visible = true, transformation(origin = {38, -102}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Math.Product product1 annotation(
    Placement(visible = true, transformation(origin = {-199, -97}, extent = {{-9, -9}, {9, 9}}, rotation = 90)));
  Modelica.Blocks.Math.Product product2 annotation(
    Placement(visible = true, transformation(origin = {-196, 24}, extent = {{-6, -6}, {6, 6}}, rotation = 270)));
  Modelica.Electrical.Analog.Sensors.VoltageSensor voltageSensor_vdc annotation(
    Placement(visible = true, transformation(origin = {-310, -30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Sources.Constant wL(k = 2 * Modelica.Constants.pi * fb *Xr * Vb * Vb / (2 * MVAb * fb * Modelica.Constants.pi)) annotation(
    Placement(visible = true, transformation(origin = {-84, -28}, extent = {{-8, -8}, {8, 8}}, rotation = 0)));
  Modelica.Blocks.Math.MultiProduct multiProduct1(nu = 2) annotation(
    Placement(visible = true, transformation(origin = {-33, -11}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  Modelica.Blocks.Math.MultiProduct multiProduct2(nu = 2) annotation(
    Placement(visible = true, transformation(origin = {-33, -43}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Ground ground4 annotation(
    Placement(visible = true, transformation(origin = {88, -112}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Interfaces.PositivePin pin_p annotation(
    Placement(visible = true, transformation(origin = {-308, -10}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-208, 54}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Interfaces.NegativePin pin_n annotation(
    Placement(visible = true, transformation(origin = {-310, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-208, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Electrical.Analog.Sources.SignalVoltage vd annotation(
    Placement(visible = true, transformation(origin = {86, 34}, extent = {{10, -10}, {-10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Sources.SignalVoltage vq annotation(
    Placement(visible = true, transformation(origin = {90, -86}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Electrical.Analog.Basic.Ground ground2 annotation(
    Placement(visible = true, transformation(origin = {56, 60}, extent = {{-10, 10}, {10, -10}}, rotation = 0)));
  Modelica.Blocks.Math.Division division4 annotation(
    Placement(visible = true, transformation(origin = {-204, -124}, extent = {{6, -6}, {-6, 6}}, rotation = -90)));
  Modelica.Blocks.Math.Division division5 annotation(
    Placement(visible = true, transformation(origin = {-200, 48}, extent = {{8, 8}, {-8, -8}}, rotation = 90)));
  OpenIPSL.Electrical.Sensors.PwVoltage pwVoltage annotation(
    Placement(visible = true, transformation(origin = {454, 28}, extent = {{14, -14}, {-14, 14}}, rotation = 0)));
  Modelica.Electrical.Analog.Basic.Capacitor capacitor2(C = C_dc, v(fixed = true, start = Vdc0 * 1000 * Vdcb)) annotation(
    Placement(visible = true, transformation(origin = {-258, -30}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Math.Gain gain2(k = Vb / (S_b * 1000)) annotation(
    Placement(visible = true, transformation(origin = {349, -43}, extent = {{-5, -5}, {5, 5}}, rotation = 0)));
  Modelica.Blocks.Math.Gain gain3(k = Vb / (S_b * 1000)) annotation(
    Placement(visible = true, transformation(origin = {349, -27}, extent = {{5, -5}, {-5, 5}}, rotation = 180)));
  HVDCcomponents.VSC_station_components.dq_to_ri dq_to_ri1 annotation(
    Placement(visible = true, transformation(origin = {283, -37}, extent = {{-15, -15}, {15, 15}}, rotation = 0)));
  HVDCcomponents.VSC_station_components.ri_to_dq ri_to_dq1 annotation(
    Placement(visible = true, transformation(origin = {229, 31}, extent = {{15, -15}, {-15, 15}}, rotation = 0)));
  Modelica.Blocks.Math.Gain gain5(k = Vb * 1000) annotation(
    Placement(visible = true, transformation(origin = {120, 36}, extent = {{-6, -6}, {6, 6}}, rotation = 180)));
  Modelica.Blocks.Math.Gain gain6(k = Vb * 1000) annotation(
    Placement(visible = true, transformation(origin = {122, -86}, extent = {{-6, -6}, {6, 6}}, rotation = 180)));
  Modelica.Blocks.Interfaces.RealInput Vmd annotation(
    Placement(visible = true, transformation(origin = {-176, 118}, extent = {{-20, -20}, {20, 20}}, rotation = -90), iconTransformation(origin = {-180, -106}, extent = {{-14, -14}, {14, 14}}, rotation = 90)));
  Modelica.Blocks.Interfaces.RealInput Vmq annotation(
    Placement(visible = true, transformation(origin = {-168, -190}, extent = {{-20, -20}, {20, 20}}, rotation = 90), iconTransformation(origin = {-136, -106}, extent = {{-14, -14}, {14, 14}}, rotation = 90)));
  Modelica.Blocks.Interfaces.RealInput theta_pll annotation(
    Placement(visible = true, transformation(origin = {302, 94}, extent = {{-20, -20}, {20, 20}}, rotation = -90), iconTransformation(origin = {-38, -110}, extent = {{-14, -14}, {14, 14}}, rotation = 90)));
  Modelica.Blocks.Interfaces.RealOutput Vr_PCC annotation(
    Placement(visible = true, transformation(origin = {408, 60}, extent = {{-10, -10}, {10, 10}}, rotation = 90), iconTransformation(origin = {178, -108}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealOutput Vi_PCC annotation(
    Placement(visible = true, transformation(origin = {408, 10}, extent = {{-10, -10}, {10, 10}}, rotation = -90), iconTransformation(origin = {154, -108}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealOutput Vdc annotation(
    Placement(visible = true, transformation(origin = {-366, -30}, extent = {{-10, -10}, {10, 10}}, rotation = 180), iconTransformation(origin = {42, -108}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealOutput Ii annotation(
    Placement(visible = true, transformation(origin = {390, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {86, -108}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  Modelica.Blocks.Interfaces.RealOutput Ir annotation(
    Placement(visible = true, transformation(origin = {390, -8}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, -108}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
equation
  connect(capacitor2.p, pin_p) annotation(
    Line(points = {{-258, -20}, {-258, -10}, {-308, -10}}, color = {0, 0, 255}));
  connect(modulated_d_current.p, pin_p) annotation(
    Line(points = {{-206, -2}, {-241.5, -2}, {-241.5, -10}, {-308, -10}}, color = {0, 0, 255}));
  connect(capacitor2.n, pin_n) annotation(
    Line(points = {{-258, -40}, {-258, -54}, {-310, -54}}, color = {0, 0, 255}));
  connect(ground4.p, vq.n) annotation(
    Line(points = {{88, -102}, {88, -99}, {90, -99}, {90, -96}}, color = {0, 0, 255}));
  connect(currentSensor_iq.p, ground4.p) annotation(
    Line(points = {{48, -102}, {88, -102}}, color = {0, 0, 255}));
  connect(currentSensor_iq.i, multiProduct1.u[2]) annotation(
    Line(points = {{38, -113}, {38.5, -113}, {38.5, -125}, {-60, -125}, {-60, -10}, {-40, -10}, {-40, -11}}, color = {0, 0, 127}));
  connect(multiProduct1.y, VoltageSource1.v) annotation(
    Line(points = {{-25, -11}, {-4, -11}, {-4, 4}}, color = {0, 0, 127}));
  connect(dq_to_ri1.xq, currentSensor_iq.i) annotation(
    Line(points = {{265, -41}, {254, -41}, {254, -124}, {38, -124}, {38, -113}}, color = {0, 0, 127}));
  connect(multiProduct2.y, VoltageSource2.v) annotation(
    Line(points = {{-25, -43}, {-8, -43}, {-8, -56}}, color = {0, 0, 127}));
  connect(VoltageSource2.n, inductor2.p) annotation(
    Line(points = {{2, -68}, {28, -68}}, color = {0, 0, 255}));
  connect(modulated_q_voltage.p, VoltageSource2.p) annotation(
    Line(points = {{-24, -76}, {-23, -76}, {-23, -68}, {-18, -68}}, color = {0, 0, 255}));
  connect(division5.u2, voltageSensor_vdc.v) annotation(
    Line(points = {{-205, 58}, {-204, 58}, {-204, 70}, {-336, 70}, {-336, -30}, {-321, -30}}, color = {0, 0, 127}));
  connect(division4.y, product1.u1) annotation(
    Line(points = {{-204, -117}, {-203.5, -117}, {-203.5, -108}, {-204, -108}}, color = {0, 0, 127}));
  connect(modulated_q_current.n, pin_n) annotation(
    Line(points = {{-210, -62}, {-240, -62}, {-240, -54}, {-310, -54}}, color = {0, 0, 255}));
  connect(division5.y, product2.u2) annotation(
    Line(points = {{-200, 39}, {-200, 31}}, color = {0, 0, 127}));
  connect(currentSensor_iq.n, modulated_q_voltage.n) annotation(
    Line(points = {{28, -102}, {-24, -102}, {-24, -96}}, color = {0, 0, 255}));
  connect(currentSensor_id.n, modulated_d_voltage.n) annotation(
    Line(points = {{4, 50}, {-24, 50}}, color = {0, 0, 255}));
  connect(currentSensor_id.p, ground2.p) annotation(
    Line(points = {{24, 50}, {56, 50}}, color = {0, 0, 255}));
  connect(currentSensor_id.i, product2.u1) annotation(
    Line(points = {{14, 61}, {-99, 61}, {-99, 31}, {-192, 31}}, color = {0, 0, 127}));
  connect(currentSensor_id.i, multiProduct2.u[2]) annotation(
    Line(points = {{14, 61}, {14, 74}, {-60, 74}, {-60, -43}, {-40, -43}}, color = {0, 0, 127}));
  connect(ground2.p, vd.n) annotation(
    Line(points = {{56, 50}, {71, 50}, {71, 44}, {86, 44}}, color = {0, 0, 255}));
  connect(resistor2.n, vq.p) annotation(
    Line(points = {{80, -68}, {90, -68}, {90, -76}}, color = {0, 0, 255}));
  connect(resistor1.n, vd.p) annotation(
    Line(points = {{78, 16}, {86, 16}, {86, 24}}, color = {0, 0, 255}));
  connect(p, signalCurrent_phasor1.n) annotation(
    Line(points = {{484, -52}, {460, -52}}, color = {0, 0, 255}));
  connect(wL.y, multiProduct2.u[1]) annotation(
    Line(points = {{-75, -28}, {-40, -28}, {-40, -43}}, color = {0, 0, 127}));
  connect(wL.y, multiProduct1.u[1]) annotation(
    Line(points = {{-75, -28}, {-40, -28}, {-40, -11}}, color = {0, 0, 127}));
  connect(VoltageSource1.p, inductor1.p) annotation(
    Line(points = {{6, 16}, {32, 16}}, color = {0, 0, 255}));
  connect(modulated_d_voltage.p, VoltageSource1.n) annotation(
    Line(points = {{-24, 30}, {-24, 16}, {-14, 16}}, color = {0, 0, 255}));
  connect(inductor1.n, resistor1.p) annotation(
    Line(points = {{52, 16}, {58, 16}}, color = {0, 0, 255}));
  connect(inductor2.n, resistor2.p) annotation(
    Line(points = {{48, -68}, {60, -68}}, color = {0, 0, 255}));
  connect(p, pwVoltage.p) annotation(
    Line(points = {{484, -52}, {484, -6}, {478, -6}, {478, 28}, {468, 28}}, color = {0, 0, 255}));
  connect(dq_to_ri1.xd, currentSensor_id.i) annotation(
    Line(points = {{265, -32}, {252, -32}, {252, 74}, {14, 74}, {14, 61}}, color = {0, 0, 127}));
  connect(ri_to_dq1.xr, pwVoltage.vr) annotation(
    Line(points = {{247, 36}, {439, 36}}, color = {0, 0, 127}));
  connect(pwVoltage.vi, ri_to_dq1.xi) annotation(
    Line(points = {{439, 28}, {343, 28}, {343, 27}, {247, 27}}, color = {0, 0, 127}));
  connect(ri_to_dq1.xd, gain5.u) annotation(
    Line(points = {{211, 36}, {127, 36}}, color = {0, 0, 127}));
  connect(gain5.y, vd.v) annotation(
    Line(points = {{113, 36}, {105.5, 36}, {105.5, 34}, {98, 34}}, color = {0, 0, 127}));
  connect(ri_to_dq1.xq, gain6.u) annotation(
    Line(points = {{211, 28}, {160, 28}, {160, -84}, {161.5, -84}, {161.5, -86}, {129, -86}}, color = {0, 0, 127}));
  connect(vq.v, gain6.y) annotation(
    Line(points = {{102, -86}, {115, -86}}, color = {0, 0, 127}));
  connect(voltageSensor_vdc.p, pin_p) annotation(
    Line(points = {{-310, -20}, {-310, -20}, {-310, -10}, {-308, -10}}, color = {0, 0, 255}));
  connect(voltageSensor_vdc.n, pin_n) annotation(
    Line(points = {{-310, -40}, {-310, -40}, {-310, -54}, {-310, -54}}, color = {0, 0, 255}));
  connect(product2.y, modulated_d_current.i) annotation(
    Line(points = {{-196, 17}, {-196, 10}}, color = {0, 0, 127}));
  connect(division4.u2, voltageSensor_vdc.v) annotation(
    Line(points = {{-208, -131}, {-336, -131}, {-336, -30}, {-320, -30}}, color = {0, 0, 127}));
  connect(modulated_q_current.i, product1.y) annotation(
    Line(points = {{-200, -74}, {-200, -74}, {-200, -88}, {-198, -88}}, color = {0, 0, 127}));
  connect(modulated_d_current.n, pin_n) annotation(
    Line(points = {{-186, -2}, {-164, -2}, {-164, -54}, {-310, -54}}, color = {0, 0, 255}));
  connect(modulated_q_current.p, pin_p) annotation(
    Line(points = {{-190, -62}, {-174, -62}, {-174, -10}, {-308, -10}, {-308, -10}}, color = {0, 0, 255}));
  connect(Vmd, division5.u1) annotation(
    Line(points = {{-176, 118}, {-178, 118}, {-178, 74}, {-196, 74}, {-196, 58}, {-196, 58}}, color = {0, 0, 127}));
  connect(modulated_d_voltage.v, Vmd) annotation(
    Line(points = {{-36, 40}, {-148, 40}, {-148, 74}, {-178, 74}, {-178, 118}, {-176, 118}}, color = {0, 0, 127}));
  connect(division4.u1, Vmq) annotation(
    Line(points = {{-200, -132}, {-200, -132}, {-200, -162}, {-166, -162}, {-166, -190}, {-168, -190}}, color = {0, 0, 127}));
  connect(modulated_q_voltage.v, Vmq) annotation(
    Line(points = {{-36, -86}, {-134, -86}, {-134, -162}, {-166, -162}, {-166, -190}, {-168, -190}}, color = {0, 0, 127}));
  connect(signalCurrent_phasor1.p, ground_phasor1.p) annotation(
    Line(points = {{440, -52}, {440, -78}}, color = {0, 0, 255}));
  connect(realToComplex1.y, signalCurrent_phasor1.i) annotation(
    Line(points = {{447, -34}, {450, -34}, {450, -44}}, color = {85, 170, 255}));
  connect(ri_to_dq1.angle, theta_pll) annotation(
    Line(points = {{234, 49}, {234, 60}, {302, 60}, {302, 94}}, color = {0, 0, 127}));
  connect(dq_to_ri1.angle, theta_pll) annotation(
    Line(points = {{278, -19}, {278, 52}, {302, 52}, {302, 94}}, color = {0, 0, 127}));
  connect(Vdc, voltageSensor_vdc.v) annotation(
    Line(points = {{-366, -30}, {-320, -30}, {-320, -30}, {-320, -30}}, color = {0, 0, 127}));
  connect(pwVoltage.vr, Vr_PCC) annotation(
    Line(points = {{439, 36}, {408, 36}, {408, 60}}, color = {0, 0, 127}));
  connect(Vi_PCC, pwVoltage.vi) annotation(
    Line(points = {{408, 10}, {408, 28}, {439, 28}}, color = {0, 0, 127}));
  connect(currentSensor_iq.i, product1.u2) annotation(
    Line(points = {{38, -113}, {38, -144}, {-194, -144}, {-194, -108}}, color = {0, 0, 127}));
  connect(gain3.y, realToComplex1.re) annotation(
    Line(points = {{354, -26}, {424, -26}, {424, -28}, {424, -28}}, color = {0, 0, 127}));
  connect(gain2.y, realToComplex1.im) annotation(
    Line(points = {{354, -42}, {424, -42}, {424, -40}, {424, -40}}, color = {0, 0, 127}));
  connect(gain3.u, dq_to_ri1.xr) annotation(
    Line(points = {{344, -26}, {320, -26}, {320, -32}, {300, -32}, {300, -32}}, color = {0, 0, 127}));
  connect(gain2.u, dq_to_ri1.xi) annotation(
    Line(points = {{344, -42}, {320, -42}, {320, -40}, {300, -40}, {300, -40}, {300, -40}}, color = {0, 0, 127}));
  connect(gain3.y, Ir) annotation(
    Line(points = {{354, -26}, {370, -26}, {370, -8}, {390, -8}}, color = {0, 0, 127}));
  connect(gain2.y, Ii) annotation(
    Line(points = {{354, -42}, {370, -42}, {370, -58}, {390, -58}}, color = {0, 0, 127}));
  annotation(
    Diagram(coordinateSystem(extent = {{-400, -200}, {500, 180}}, initialScale = 0.1), graphics = {Text(origin = {-267, 128}, extent = {{-41, 14}, {41, -14}}, textString = "DC circuit"), Text(origin = {-7, 140}, extent = {{-41, 14}, {93, -34}}, textString = "AC circuit in dq"), Text(origin = {255, 144}, extent = {{-63, -22}, {45, 10}}, textString = "Coordinates"), Text(origin = {247, 116}, extent = {{-89, -12}, {89, 12}}, textString = "transformation"), Text(origin = {438, 145}, extent = {{-56, -1}, {46, -21}}, textString = "Interface with"), Text(origin = {412, 148}, extent = {{-20, -26}, {56, -44}}, textString = "the AC grid")}),
    Icon(coordinateSystem(extent = {{-200, -100}, {200, 100}}, initialScale = 0.1), graphics = {Rectangle(extent = {{-200, 100}, {200, -100}}), Text(origin = {-3, 87}, extent = {{-67, 7}, {67, -7}}, textString = "VSC Physical Layer"), Text(origin = {-179, -81}, extent = {{-15, -9}, {15, 9}}, textString = "vmd"), Text(origin = {-45, -87}, extent = {{-15, -9}, {35, 17}}, textString = "theta_pll"), Text(origin = {-137, -81}, extent = {{-15, -9}, {15, 9}}, textString = "vmq"), Text(origin = {183, -83}, extent = {{-15, -9}, {15, 9}}, textString = "Vgr"), Text(origin = {87, -83}, extent = {{-15, -9}, {15, 9}}, textString = "Igi"), Text(origin = {153, -83}, extent = {{-15, -9}, {15, 9}}, textString = "Vgi"), Text(origin = {111, -83}, extent = {{-15, -9}, {15, 9}}, textString = "Igr"), Text(origin = {43, -85}, extent = {{-15, -9}, {15, 9}}, textString = "Vdc"), Ellipse(origin = {-10, -10}, lineThickness = 0.5, extent = {{-26, 26}, {6, -6}}, endAngle = 360), Ellipse(origin = {30, -10}, lineThickness = 0.5, extent = {{-26, 26}, {6, -6}}, endAngle = 360), Line(origin = {-20.2913, -35.0115}, points = {{0, 28}, {0, 38}}), Polygon(origin = {-20, 6}, points = {{-2, -2}, {2, -2}, {0, 2}, {0, 2}, {-2, -2}}), Rectangle(lineThickness = 0.5, extent = {{-44, 24}, {44, -34}}), Line(origin = {16, 2.68273}, points = {{4, -2.68273}, {2, 1.31727}, {-2, 3.31727}, {-6, 1.31727}, {-8, -2.68273}}), Line(origin = {26, -2.77639}, points = {{-6, 2.77639}, {-4, -1.22361}, {-3.55271e-15, -3.22361}, {4, -1.22361}, {6, 2.77639}, {6, 2.77639}}), Line(origin = {20, -28}, points = {{0, 12}, {0, -20}}, thickness = 0.5), Rectangle(origin = {94, 40}, lineThickness = 0.5, extent = {{-12, 2}, {38, -4}}), Line(origin = {51, 28}, points = {{-31, -12}, {-31, 12}, {31, 12}, {31, 12}}, thickness = 0.5), Line(origin = {164, 40}, points = {{-32, 0}, {32, 0}}, thickness = 0.5), Rectangle(origin = {195, 3}, lineColor = {0, 0, 255}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, extent = {{-1, 59}, {1, -59}}), Text(origin = {183, 63}, extent = {{-29, 9}, {29, -9}}, textString = "Vg"), Line(origin = {63.6921, 51.6843}, points = {{59, 0}, {25, 0}}, arrow = {Arrow.Filled, Arrow.None}), Text(origin = {105, 63}, extent = {{-29, 9}, {29, -9}}, textString = "Ig"), Line(origin = {-20.15, -28.9}, points = {{0, 12}, {0, -22}}, thickness = 0.5), Line(origin = {21.39, -47.55}, points = {{-9, 0}, {7, 0}}, thickness = 0.5), Line(origin = {-19.96, 36.64}, points = {{0, 18}, {0, -20}}, thickness = 0.5), Line(origin = {-100.61, 4.86}, points = {{-13, 0}, {13, 0}}, thickness = 0.5), Line(origin = {-100.61, -5.09}, points = {{-13, 0}, {13, 0}}, thickness = 0.5), Line(origin = {-109, 54}, points = {{-89, 0}, {89, 0}}, thickness = 0.5), Line(origin = {-108.61, -50.36}, points = {{-89, 0}, {89, 0}}, thickness = 0.5), Line(origin = {-100, 30}, points = {{0, -24}, {0, 24}}, thickness = 0.5), Line(origin = {-100, -28}, points = {{0, 22}, {0, -22}}, thickness = 0.5), Line(origin = {-158, 3}, points = {{0, -47}, {0, 47}}, arrow = { Arrow.None,Arrow.Filled}), Text(origin = {-175, 3}, extent = {{-29, 9}, {29, -9}}, textString = "Vdc"), Text(origin = {5, -29}, extent = {{-29, 9}, {21, -3}}, textString = "Pdc=Pac"), Text(origin = {1, 49}, extent = {{-29, 9}, {29, -9}}, textString = "Vm"), Line(origin = {0, 32.4}, points = {{0, 8}, {0, -8}}, arrow = {Arrow.None, Arrow.Filled})}),
    __OpenModelica_commandLineOptions = "",
    Documentation(info = "<html><head></head><body>2-level VSC converter station complete model (including controls, PLL and limiters) based on&nbsp;<span class=\"fontstyle0\">Samy Akkari. Control of a multi-terminal HVDC (MTDC) system and study of the interactions&nbsp;between the MTDC and the AC grids. Université Paris-Saclay, 2016.</span>&nbsp;&nbsp;</body></html>"));
end Physical_Layer;
