within OpenPBS.VehicleModels;
partial model Longitudinal

  replaceable parameter VehicleParameters.Vehicles.NordicCombination paramSet
    constrainedby VehicleParameters.Base.VehicleModelRollDynamicsNonLinTyre
    annotation (Placement(transformation(extent={{-100,80},{-80,100}})));
    
   OpenPBS.VehicleModels.VerticalForcesRollDynamicsNonLinTyre verticalForcesRollDynamicsNonLinTyre(nu=nu,na=na,paramSet=paramSet);

   parameter Integer mode=2
    "1: Normal, 2: Quasistatic"
        annotation(choices(choice=1 "Normal", choice=2 "Quasi-static"));
  parameter Modelica.SIunits.Velocity vx0=70/3.6;
  parameter Modelica.SIunits.Angle inclination_angle "Inclination angle, positive for uphill driving";

  parameter Integer nu=paramSet.nu;
  parameter Integer na=paramSet.na;
  parameter Modelica.SIunits.Length[nu,na] L=paramSet.L
    "Axle positions relative first axle of each unit";
  parameter Modelica.SIunits.Length[nu] A=paramSet.A
    "Front coupling position relative first axle";
  parameter Modelica.SIunits.Length[nu] B=paramSet.B
    "Rear coupling position relative first axle";
  parameter Integer[nu,na] axlegroups=paramSet.axlegroups;
  parameter Boolean[nu,na] driven=paramSet.driven;
  parameter Real drag_coefficient=paramSet.drag_coefficient;
  parameter Modelica.SIunits.Area frontal_area=paramSet.frontal_area;
  parameter Real rolling_resistance_coefficient=paramSet.rolling_resistance_coefficient "Rolling resistance force as a function of vertical force";
  parameter Modelica.SIunits.Force max_thrust_force_vx0=paramSet.max_thrust_force_vx0;
  parameter Modelica.SIunits.Power max_engine_power=paramSet.max_engine_power ;
  parameter Modelica.SIunits.Density air_density=1.3/*1.204*/;
  
  Modelica.SIunits.Mass[nu] m=verticalForcesRollDynamicsNonLinTyre.m;
  Modelica.SIunits.Length[nu] X=verticalForcesRollDynamicsNonLinTyre.X
    "C.g. position relative first axle";
  Modelica.SIunits.Length[nu,na] Lcog = L-matrix(X)*ones(1,na)
    "Axle positions relative c.g.";
  Modelica.SIunits.Length[nu] Bcog = B-X;
  Modelica.SIunits.Length[nu] Acog = A-X;

  final parameter Modelica.SIunits.Position[nu,na] rx0=TM*[0;matrix(B[1:nu-1]-A[2:nu])]*ones(1,na)+L;
  final parameter Integer TM[nu,nu]=Functions.tril(nu);
  parameter Integer n_driven=Modelica.Math.BooleanVectors.countTrue(driven[1,:]); 

  parameter Modelica.SIunits.Force[nu,na] Fz=paramSet.Fz;
  Modelica.SIunits.Acceleration ax[nu];
  Modelica.SIunits.Velocity vx[nu];

  /* Tire forces */
  Modelica.SIunits.Force Fx[nu,na] "Vehicle longitudinal force per axle";
  Modelica.SIunits.Force Fxd "Drive force (applied to each driven axle)";

  /* Coupling forces */
  Modelica.SIunits.Force Fcx[nu-1] "Longitudinal coupling forces";

  /* Chassis forces */
  Modelica.SIunits.Force Fxa "Aerodynamic force";

  /* Derivative variables */
  //Modelica.SIunits.Acceleration[nu] d_vx;
  //Modelica.SIunits.Velocity[nu] d_rx;

  Modelica.SIunits.Position[nu,na] rx(start=rx0);
  constant Modelica.SIunits.Force F_eps=Modelica.Constants.eps "Used to avoid division by zero";
  Real[nu,na] friction_usage/*=Fx./max(Fz,Modelica.Constants.eps*ones(nu,na))*/;


initial equation
   vx=vx0*ones(nu);
equation
// Friction usage
  for i in 1:nu loop
    for j in 1:na loop
      friction_usage[i,j]=Fx[i,j]./(max(Fz[i,j],F_eps));
    end for;
  end for;

  if mode==1 then
    der(vx)=ax;
  else
    der(vx)=zeros(nu);
  end if;

//   d_vx=ax;

  Fxa = 0.5*air_density*vx[1]^2*drag_coefficient*frontal_area "Aerodynamic drag";

  /* Tire force */
  for i in 1:nu loop
    for j in 1:na loop
      if driven[i,j]==true then
        Fx[i,j]=Fxd-Fz[i,j]*sin(inclination_angle)-Fz[i,j]*rolling_resistance_coefficient*cos(inclination_angle);
      else
        Fx[i,j]=-Fz[i,j]*sin(inclination_angle)-Fz[i,j]*rolling_resistance_coefficient*cos(inclination_angle);
      end if;
    end for;
  end for;


  /* Kinematic constraints in couplings */
   for i in 1:nu-1 loop
     ax[i+1] = ax[i];
   end for;

  m.*ax=vector(-[matrix(Fxa);zeros(nu-1,1)]+Fx*ones(na,1)-[matrix(Fcx);0]+[0;matrix(Fcx)]);

  /* Axle global positions */
  der(rx)=if mode==1 then matrix(vx)*ones(1,na) else zeros(nu,na);
  annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)));
end Longitudinal;
