within OpenPBS.VehicleModels;
model Roll
replaceable parameter VehicleParameters.Vehicles.Adouble6x4_RollDynamics_NonLinTyre paramSet
    constrainedby VehicleParameters.Base.VehicleModelRollDynamicsNonLinTyre
    annotation (Placement(transformation(extent={{-100,80},{-80,100}})));
  constant Modelica.SIunits.Acceleration g=Modelica.Constants.g_n;

  OpenPBS.VehicleModels.VerticalForcesRollDynamicsNonLinTyre verticalForcesRollDynamicsNonLinTyre(nu=nu,na=na,paramSet=paramSet);

  Modelica.Blocks.Interfaces.RealOutput SRT_out1=SRT[1]
    annotation (Placement(visible = true, transformation(extent = {{100, 28}, {120, 48}}, rotation = 0), iconTransformation(extent = {{100, 28}, {120, 48}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput SRT_out2=SRT[2]
    annotation (Placement(visible = true, transformation(extent = {{100, 6}, {120, 26}}, rotation = 0), iconTransformation(extent = {{100, 6}, {120, 26}}, rotation = 0)));
    Modelica.Blocks.Interfaces.RealOutput SRT_out3=SRT[3]
      annotation (Placement(visible = true, transformation(extent = {{100, -14}, {120, 6}}, rotation = 0), iconTransformation(extent = {{100, -14}, {120, 6}}, rotation = 0)));

//  Parameters
  parameter Integer nu =  paramSet.nu;
  parameter Integer na =  paramSet.na;
  parameter Modelica.SIunits.Force[nu,na] Fz =  paramSet.Fz;
  parameter Integer[nu,na] axlegroups =  paramSet.axlegroups;
  parameter Modelica.SIunits.Position[nu] h = paramSet.h;
  parameter Modelica.SIunits.Position[nu] hRC = paramSet.hRC;
  parameter Modelica.SIunits.Length[nu] FOH = paramSet.FOH;
  parameter Modelica.SIunits.Length[nu] ROH = paramSet.ROH;
  parameter Modelica.SIunits.TranslationalSpringConstant[nu, na] ks = paramSet.ks;
  parameter Real[nu-1] Kcr = paramSet.Kcr;
  parameter Boolean[nu,na] driven=paramSet.driven;
  Modelica.SIunits.Force[nu-1] Fcz=verticalForcesRollDynamicsNonLinTyre.Fcz;
  Modelica.SIunits.Mass[nu] m=verticalForcesRollDynamicsNonLinTyre.m;
  Modelica.SIunits.Mass[nu] ml=verticalForcesRollDynamicsNonLinTyre.ml;

//  Added parameters for SRT

  parameter Modelica.SIunits.TranslationalSpringConstant[nu, na] CZT=paramSet.CZT " Tyre vertical stiffness ";
  parameter Modelica.SIunits.TranslationalSpringConstant[nu, na] CYT=paramSet.CYT " Tyre lateral stiffness ";
  parameter Modelica.SIunits.Length[nu,na] We =  paramSet.We "Effective track width";
  parameter Boolean[nu-1] rfc = paramSet.rfc "Defines roll-rigid couplings";

  parameter Integer nrc=1+Modelica.Math.BooleanVectors.countTrue(rfc) "Number of roll-free coupled units";

//  Variables
  Modelica.SIunits.TranslationalSpringConstant[nu, na] kes " Equivalent suspension roll stiffness per axle ";
  Modelica.SIunits.TranslationalSpringConstant[nu, na] kt " The roll stiffness from the tyre normal stiffness ";
  Modelica.SIunits.TranslationalSpringConstant[nu, na] k "The roll stiffness of axle ";
  Modelica.SIunits.TranslationalSpringConstant[nrc] kv "The vehicle roll stiffness";
  Modelica.SIunits.TranslationalSpringConstant[nrc] CYTe " The vehicle effective tyre lateral stiffness";
  Modelica.SIunits.Position[nrc] Wev "The effective track width";
  Modelica.SIunits.TranslationalSpringConstant[nu-1] kfw "The roll stiffness of the 5th wheel ";
  Modelica.SIunits.Acceleration[nu, na] ayl " Lateral acceleration at which the first wheel lift off happens ";
  Modelica.SIunits.Acceleration[nrc] aym " Maximum theoretical lateral acceleration ";
  Modelica.SIunits.Acceleration[nu, na] aSRT " Steady-state rollover threshold ";
  Modelica.SIunits.Acceleration[nu-1] SRT;
  Real[nu, na] DK "The distribution of the vehicle roll stiffness ";
  Modelica.SIunits.Position[nrc] hCG "CoG height for roll-free units";
  Modelica.SIunits.Position[nrc] hS "Sprung mass CoG height for roll-free units";
  Integer[nu, na] axles "Number of axles, used for Wev calculations";
  Integer dbl "Defines which coupling is a drawbar coupling";
  Modelica.SIunits.Position[nu] hs " Sprung mass CoG height ";
  Modelica.SIunits.Force[nu] Fu "Unsprung masses*g for each unit";
  Modelica.SIunits.Force[nu,na] ma "Unsprung masses for each axle";

equation

  kfw=4*Fcz;
  dbl=Modelica.Math.Vectors.find(0.0,Kcr,eps=0.001);
  hs=(h.*m-Fu./g.*hRC)./(m-Fu./g);

  // DoubleCAT, each unit calculated separately
  if nrc==3 then
    for i in 1:nrc loop
      SRT[i]=min(aSRT[i,:]);
      kv[i]=sum(k[i,:]);
      CYTe[i]=sum(CYT[i,:]);
      Wev[i]=sum(We[i,:].*Fz[i,:])/sum(Fz[i,:]);
      hS[i]=hs[i];
      hCG[i]=h[i];
      Fu[i]=sum(ma[i,:])*g;
      aym[i]=0.5*sum(Fz[i,:]).*Wev[i]./((sum(Fz[i,:]).*hCG[i])+(((sum(Fz[i,:])-Fu[i]).*hS[i]).^2 ./(kv[i]-(sum(Fz[i,:]).*hS[i])))+sum(Fz[i,:]).^2 ./CYTe[i]);
      for j in 1:na loop
        kes[i,j]=ks[i,j].*(hS[i]./(hS[i]-hRC[i]))^2;
        kt[i,j]=CZT[i,j].*(We[i,j].^2)/2;
        k[i,j]=(kes[i,j].*kt[i,j])./(kes[i,j]+kt[i,j]);
        DK[i,j]=k[i,j]./kv[i];
        ayl[i,j]=0.5*Fz[i,j].*We[i,j]./((DK[i,j].*sum(Fz[i,:]).*hCG[i])+(((sum(Fz[i,:])-Fu[i]).*DK[i,j].*hS[i]).^2 ./(k[i,j]-(sum(Fz[i,:]).*DK[i,j].*hS[i])))+Fz[i,j].^2 ./(CYT[i,j]));
        aSRT[i,j]=(aym[i]-(aym[i]-ayl[i,j]).*(Fz[i,j]./sum(Fz[i,:])))*Modelica.Constants.g_n;
      end for;
    end for;

  // Nordic, 5th wheel roll stiffness neglegted
  elseif nrc==2 and rfc[1]==true then
    SRT={min(aSRT[1:dbl,:]),min(aSRT[dbl+1:nu,:]),1e-9};
    kv={sum(k[1:dbl,:]),sum(k[dbl+1:nu,:])};
    CYTe={sum(CYT[1:dbl,:]),sum(CYT[dbl+1:nu,:])};
    Wev={sum(We[1:dbl,:].*Fz[1:dbl,:])./sum(Fz[1:dbl,:]),  sum(We[dbl+1:nu,:].*Fz[dbl+1:nu,:])./sum(Fz[dbl+1:nu,:])};
    hCG={sum(h[1:dbl].*m[1:dbl])./sum(m[1:dbl]),sum(h[dbl+1:nu].*m[dbl+1:nu])/sum(m[dbl+1:nu])};
    hS={sum(hs[1:dbl].*m[1:dbl])./sum(m[1:dbl]),sum(hs[dbl+1:nu].*m[dbl+1:nu])/sum(m[dbl+1:nu])};
    aym={0.5*sum(Fz[1:dbl,:]).*Wev[1]./((sum(Fz[1:dbl,:]).*hCG[1])+(((sum(Fz[1:dbl,:])-sum(Fu[1:dbl])).*hS[1])^2/(kv[1]-(sum(Fz[1:dbl,:]).*hS[1])))+sum(Fz[1:dbl,:])^2/CYTe[1]),  0.5*sum(Fz[dbl+1:nu,:]).*Wev[2]./((sum(Fz[dbl+1:nu,:]).*hCG[2])+(((sum(Fz[dbl+1:nu,:])-sum(Fu[dbl+1:nu])).*hS[2])^2/(kv[2]-(sum(Fz[dbl+1:nu,:]).*hS[2])))+sum(Fz[dbl+1:nu,:])^2/CYTe[2])};
    for i in 1:nu loop
      Fu[i]=sum(ma[i,:])*g;
      for j in 1:na loop
        if i<=dbl then
          kes[i,j]=ks[i,j].*(hS[1]./(hS[1]-hRC[i]))^2;
          kt[i,j]=CZT[i,j].*(We[i,j].^2)/2;
          k[i,j]=(kes[i,j].*kt[i,j])./(kes[i,j]+kt[i,j]);
          DK[i,j]=k[i,j]./kv[1];
          ayl[i,j]=0.5*Fz[i,j].*We[i,j]./((DK[i,j].*sum(Fz[1:dbl,:]).*hCG[1])+(((sum(Fz[1:dbl,:])-sum(Fu[1:dbl])).*DK[i,j].*hS[1]).^2 ./(k[i,j]-(sum(Fz[1:dbl,:]).*DK[i,j].*hS[1])))+Fz[i,j].^2 ./(CYT[i,j]));
          aSRT[i,j]=(aym[1]-(aym[1]-ayl[i,j]).*(Fz[i,j]./sum(Fz[1:dbl,:])))*Modelica.Constants.g_n;
        else
          kes[i,j]=ks[i,j].*(hS[nrc]./(hS[nrc]-hRC[i]))^2;
          kt[i,j]=CZT[i,j].*(We[i,j]^2)/2;
          k[i,j]=(kes[i,j].*kt[i,j])./(kes[i,j]+kt[i,j]);
          DK[i,j]=k[i,j]./kv[nrc];
          ayl[i,j]=0.5*Fz[i,j].*We[i,j]./((DK[i,j].*sum(Fz[dbl+1:nu,:]).*hCG[nrc])+(((sum(Fz[dbl+1:nu,:])-sum(Fu[dbl+1:nu])).*DK[i,j].*hS[nrc]).^2/(k[i,j]-(sum(Fz[dbl+1:nu,:]).*DK[i,j].*hS[nrc])))+Fz[i,j].^2/(CYT[i,j]));
          aSRT[i,j]=(aym[nrc]-(aym[nrc]-ayl[i,j]).*(Fz[i,j]./sum(Fz[dbl+1:nu,:])))*Modelica.Constants.g_n;
        end if;
      end for;
    end for;

  // Adouble and Tractor-Semi-CAT
  elseif nrc==2 and rfc[1]==false then
    SRT={min(aSRT[2,:]),min(aSRT[dbl+1:nu,:]),1e-9};
    kv={sum(k[2,:])+(kfw[1]),sum(k[dbl+1:nu,:])};
    CYTe={sum(CYT[2,:]),sum(CYT[dbl+1:nu,:])};
    Wev={(sum(We[2,:].*Fz[2,:])+sum(We[1,:])./sum(axles[1,:]).*(Fcz[1]))./(sum(Fz[2,:])+(Fcz[1])),  sum(We[dbl+1:nu,:].*Fz[dbl+1:nu,:])./sum(Fz[dbl+1:nu,:])};
    hCG={h[2],sum(h[dbl+1:nu].*m[dbl+1:nu])/sum(m[dbl+1:nu])};
    hS={hs[2],sum(hs[dbl+1:nu].*m[dbl+1:nu])/sum(m[dbl+1:nu])};
    aym={0.5*sum(Fz[2,:]).*Wev[1]./((sum(Fz[2,:]).*hCG[1])+(((sum(Fz[2,:])-Fu[2]).*hS[1])^2/(kv[1]-(sum(Fz[2,:]).*hS[1])))+sum(Fz[2,:])^2/CYTe[1]),  0.5*sum(Fz[dbl+1:nu,:]).*Wev[2]./((sum(Fz[dbl+1:nu,:]).*hCG[2])+(((sum(Fz[dbl+1:nu,:])-sum(Fu[dbl+1:nu])).*hS[2])^2/(kv[2]-(sum(Fz[dbl+1:nu,:]).*hS[2])))+sum(Fz[dbl+1:nu,:])^2/CYTe[2])};
    for i in 1:nu loop
      Fu[i]=sum(ma[i,:])*g;
      for j in 1:na loop
        if i<=dbl then
          kes[i,j]=ks[i,j].*(hS[1]./(hS[1]-hRC[i]))^2;
          kt[i,j]=CZT[i,j].*(We[i,j].^2)/2;
          DK[i,j]=k[i,j]./kv[1];
          ayl[i,j]=0.5*Fz[i,j].*We[i,j]./((DK[i,j].*sum(Fz[2,:]).*hCG[1])+(((sum(Fz[2,:])-Fu[2]).*DK[i,j].*hS[1]).^2 ./(k[i,j]-(sum(Fz[2,:]).*DK[i,j].*hS[1])))+Fz[i,j].^2 ./(CYT[i,j]));
          aSRT[i,j]=(aym[1]-(aym[1]-ayl[i,j]).*(Fz[i,j]./sum(Fz[2,:])))*Modelica.Constants.g_n;
          if i==1 then
            k[i,j]=kfw[1]/sum(axles[1,:]);
          else
            k[i,j]=(kes[i,j].*kt[i,j])./(kes[i,j]+kt[i,j]);
          end if;
        else
          kes[i,j]=ks[i,j].*(hS[nrc]./(hS[nrc]-hRC[i]))^2;
          kt[i,j]=CZT[i,j].*(We[i,j]^2)/2;
          k[i,j]=(kes[i,j].*kt[i,j])./(kes[i,j]+kt[i,j]);
          DK[i,j]=k[i,j]./kv[nrc];
          ayl[i,j]=0.5*Fz[i,j].*We[i,j]./((DK[i,j].*sum(Fz[dbl+1:nu,:]).*hCG[nrc])+(((sum(Fz[dbl+1:nu,:])-sum(Fu[dbl+1:nu])).*DK[i,j].*hS[nrc]).^2/(k[i,j]-(sum(Fz[dbl+1:nu,:]).*DK[i,j].*hS[nrc])))+Fz[i,j].^2/(CYT[i,j]));
          aSRT[i,j]=(aym[nrc]-(aym[nrc]-ayl[i,j]).*(Fz[i,j]./sum(Fz[dbl+1:nu,:])))*Modelica.Constants.g_n;
        end if;
      end for;
    end for;


  // B-double, considered link-semi as a one unit and tractor replaced with a 5th wheel roll stiffness, also tractor-semi
  elseif nrc==1 then
    SRT[1]=min(aSRT[2:nu]);
    SRT[2]=1e-9;
    SRT[3]=1e-9;
    kv[1]=sum(k[2:nu,:])+kfw[1];
    CYTe[1]=sum(CYT[2:nu,:]);
    aym=0.5*sum(Fz[2:nu,:]).*Wev./((sum(Fz[2:nu,:]).*hCG)+(((sum(Fz[2:nu,:])-sum(Fu[2:nu])).*hS).^2 ./(kv-(sum(Fz[2:nu,:]).*hS)))+sum(Fz[2:nu,:]).^2 ./CYTe);
    Wev[1]=(sum(We[2:nu,:].*Fz[2:nu,:])+sum(We[1])./sum(axles[1]).*(Fcz[1]))./(sum(Fz[2:nu,:])+Fcz[1]);
    hCG[1]=sum(h[2:nu].*m[2:nu])/sum(m[2:nu]);
    hS[1]=sum(hs[2:nu].*m[2:nu])/sum(m[2:nu]);
    for i in 1:nu loop
     Fu[i]=sum(ma[i,:])*g;
      for j in 1:na loop
        kes[i,j]=ks[i,j].*(hS[1]./(hS[1]-hRC[i]))^2;
        kt[i,j]=CZT[i,j].*(We[i,j]^2)/2;
        DK[i,j]=k[i,j]./kv[nrc];
        ayl[i,j]=0.5*Fz[i,j].*We[i,j]./((DK[i,j].*sum(Fz[2:nu,:]).*hCG[nrc])+(((sum(Fz[2:nu,:])-sum(Fu[2:nu])).*DK[i,j].*hS[nrc]).^2/(k[i,j]-(sum(Fz[2:nu,:]).*DK[i,j].*hS[nrc])))+Fz[i,j].^2/(CYT[i,j]));
        aSRT[i,j]=(aym[1]-(aym[1]-ayl[i,j]).*(Fz[i,j]./sum(Fz[2:nu,:])))*Modelica.Constants.g_n;
        k[i,j]=(kes[i,j].*kt[i,j])./(kes[i,j]+kt[i,j]);
      end for;
    end for;
  end if;

  for i in 1:nu loop
    for j in 1:na loop
      if axlegroups[i,j]==0 then
        axles[i,j]=0;
      else
        axles[i,j]=1;
      end if;
    end for;
  end for;

  for i in 1:nu loop
    for j in 1:na loop
      if driven[i,j]==true then
        ma[i,j]=1300;
      elseif i==1 and CZT[i,j]>1300000 and driven[i,j]==false then
        ma[i,j]=900;
      else
        if CZT[i,j]>1300000 then
          ma[i,j]=800;
        elseif 0<CZT[i,j] and CZT[i,j]<=1300000 then
          ma[i,j]=700;
        else
          ma[i,j]=0;
        end if;
      end if;
    end for;
  end for;

  annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)),
    Documentation(info="<html>
<p>This is a test. a = b/c </p>
</html>"));
end Roll;
